/*
**  Scanner para o Descritor de Arquivos Cobol
**	analisador de pictures
**	Rildo Pragana - 1991
*/

letter [A-Z-]
digit [0-9]
white [\r\t ]
sdelim \"
any [!-~]
eos \.(white|'\n')white*

%{
	 /*#define DEBUG_SCANNER 1*/
#define LEXSKIP 99999

#include <stdlib.h>
#include <string.h>

#include "htcoboly.h"
#include "htcobol.h"	/* definitions from YACC */

#define YY_INPUT(buf,result,max_size) \
	{ \
		int c = fgetc(yyin); \
		result = (c == EOF) ? YY_NULL : (buf[0] = c, 1); \
	}

extern int coblex(void);	/* scanner principal */
extern char toktext[100];
extern char *tp;
extern int lineno;
void inc_line( void );

/* flex bug */
int picwrap(void) { return 1; }


%}

%%

eos	{       gettoken(toktext,sizeof(toktext));
		if (toktext[1]=='\n') inc_line();
		lexswitch(coblex);
#ifdef DEBUG_SCANNER
			printf("\nSCAN: <EOS>\n");
#endif
		return(EOS);
	}

\n	{ 
		inc_line(); return(LEXSKIP); 
	}

{white}	{ 
	lexswitch(coblex); return(LEXSKIP); 
	}

{any}	{ 
	gettoken(toktext, sizeof(toktext));
#ifdef DEBUG_SCANNER
			printf("\nSCAN <any char>: %c\n",
					toktext[0]);
#endif
		yylval.ival=(int)toktext[0];
		return(CHAR); }

\({digit}({digit})*\) {	
		{ char *s;
		gettoken(toktext, sizeof(toktext));
		yylval.ival = 0;
		s = toktext+1; /* bypass lpar */
		while (*s!=')')
			yylval.ival = 10 * yylval.ival + *s++ - '0';
#ifdef DEBUG_SCANNER
			printf("\nSCAN <MULTIPLIER>: %d\n",
					yylval.ival);
#endif
		return(MULTIPLIER); } 
	}

%%

