/*
**  Scanner para o Compilador Cobol
**	Rildo Pragana - 1991
*/

%{
	/*#define DEBUG_SCANNER 1*/
#define LEXSKIP 99999
void copy_switch( char *filename );
#define lexchar input

extern FILE *app_in;
extern int lexgetc(void);

#define YY_INPUT(buf,result,max_size) \
	{ \
		int c = lexgetc(); \
		result = (c == EOF) ? YY_NULL : (buf[0] = c, 1); \
	}

%}

letter [A-Z]
exletter {letter}|-|[a-z]
digit [0-9]
pic_ch [9XVSBZAP.,-+*/$]
relop [<>=]
white [\r\t ]
lpar \(
rpar \)
sdelim \"
ldelim \'
any [!-~]
eos \.{white}*
int {digit}({digit})*

%{
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include "htcoboly.h"
#include "htcobol.h"	/* definitions from YACC */

void inc_line( void );
int hash( char *s );
char *savename( char *s );
struct sym *install( char *name, int lit_flag );
void chg_underline( char *s );
int reserved( char *s );
extern int piclex(void); 	/* scanner separado para pictures */
extern short list_flag;
char toktext[100];		/* communication with YACC actions */
char *tp;
unsigned int varnumber;
int reserved_token;
int lineno=0;			/* source line */
int middle_of_line=0;

void gettoken(char *p, size_t s)
{
	strncpy(p, yytext, s);
	printf(">%s<\n",p);
}

struct {
	char *name;
	int token;
	unsigned minor;
} reserved_symbols[] = {
	{"GLOBAL",GLOBAL,0},{"EXTERNAL",EXTERNAL,0},
	{"ASCENDING",DIRECTION,ASCENDING},{"DESCENDING",DIRECTION,DESCENDING},
	{"OR",OR,0},{"AND",AND,0},{"UPDATE",UPDATE,0},{"SORT",SORT,0},
	{"DATE",DATE_TIME,DATE},{"TIME",DATE_TIME,TIME},
	{"INKEY",DATE_TIME,INKEY},{"RUNNING-TERMINALS",RUNNING_TERMINALS,0},
	{"ESCAPE",ESCAPE,0},{"MOVE",MOVE,0},{"ACCEPT",ACCEPT,0},
	{"FD",FD,0},{"SD",SD,0},{"ECHO",ECHO,0},{"REDEFINES",REDEFINES,0},
	{"FILLER",FILLER,0},{"OCCURS",OCCURS,0},{"TIMES",TIMES,0},
	{"GIVING",GIVING,0},{"ERASE",ERASE,0},{"COMP",USAGENUM,COMP},
	{"INDEX",USAGENUM,INDEX},{"DISPLAY",DISPLAY,0},
	{"COMP-3",USAGENUM,COMP3},{"PROGRAM",PROGRAM,0},
	{"PROGRAM-ID",PROGRAM_ID,0},{"ENVIRONMENT",DIVISNUM,ENVIRONMENT},
	{"DATA",DIVISNUM,DATA},{"DIVISION",DIVISION,0},{"SECTION",SECTION,0},
	{"TO",CONNECTIVE,TO},{"EXIT",EXIT,0},{"OF",CONNECTIVE,OF},
	{"PROCEDURE",DIVISNUM,PROCEDURE},{"ON",CONNECTIVE,ON},
	{"IDENTIFICATION",DIVISNUM,IDENTIFICATION},
	{"AUTHOR",COMMENTING,AUTHOR},{"CONFIGURATION",CONFIGURATION,0},
	{"SAME",SAME,0},{"WHEN",CONNECTIVE,WHEN},{"FOR",CONNECTIVE,FOR},
	{"INPUT-OUTPUT",INPUT_OUTPUT,0},{"SPECIAL-NAMES",SPECIAL_NAMES,0},
	{"FILE-CONTROL",FILE_CONTROL,0},{"I-O-CONTROL",I_O_CONTROL,0},
	{"IS",CONNECTIVE,IS},{"ARE",CONNECTIVE,ARE},{"START",START,0},
	{"THROUGH",CONNECTIVE,THRU},{"THRU",CONNECTIVE,THRU},
	{"WORKING-STORAGE",WORKING_STORAGE,0},{"AREA",AREA,0},
	{"LINKAGE",LINKAGE,0},{"COMMA",COMMA,0},{"INVALID",INVALID,0},
	{"DECIMAL-POINT",DECIMAL_POINT,0},{"FILE",FILEN,0},{"BY",CONNECTIVE,BY},
	{"GO",GO,0},{"USAGE",USAGE,0},{"BLANK",BLANK,0},{"SIGN",SIGN,0},
	{"VALUE",VALUE,0},{"TO",CONNECTIVE,TO},{"FILE-NAME",FILE_NAME,0},
	{"LABEL",LABEL,0},{"RECORD",RECORD,0},{"OMITTED",OMITTED,0},
	{"STANDARD",STANDARD,0},{"RECORDS",RECORDS,0},{"BLOCK",BLOCK,0},
	{"CONTAINS",CONTAINS,0},{"CHARACTERS",CHARACTERS,0},
	{"ADD",ADD,0},{"SUBTRACT",SUBTRACT,0},{"DELETE",DELETE,0},
	{"MULTIPLY",MULTIPLY,0},{"DIVIDE",DIVIDE,0},
	{"COMPUTE",COMPUTE,0},{"STOP",STOP,0},{"RUN",RUN,0},
	{"PERFORM",PERFORM,0},{"VARYING",VARYING,0},{"FROM",FROM,0},
    {"UNTIL",UNTIL,0},{"IF",IF,0},
    {"NEXT",NEXT,1},{"PREV",NEXT,2},{"PREVIOUS",NEXT,2},
    {"ELSE",ELSE,0},{"LINE",LINE,0},{"LINES",LINE,0},{"PAGE",PAGE,0},
	{"SELECT",SELECT,0},{"ASSIGN",ASSIGN,0},{"SENTENCE",SENTENCE,0},
	{"EQUAL",CONDITIONAL,EQUAL},{"LESS",CONDITIONAL,LESS},{"THAN",CONNECTIVE,THAN},
	{"=",CONDITIONAL,EQUAL},{"<",CONDITIONAL,LESS},{">",CONDITIONAL,GREATER},
	{"<=",CONDITIONAL,LEQ},{">=",CONDITIONAL,GEQ},{"<>",CONDITIONAL,NEQ},
	{"GREATER",CONDITIONAL,GREATER},{"OPEN",OPEN,0},{"CLOSE",CLOSE,0},
	{"READ",READ,0},{"RETURN",READ,1},
	{"WRITE",WRITE,0},{"RELEASE",WRITE,1},{"REWRITE",REWRITE,0},
	{"AFTER",BEFORE_AFTER,2},{"BEFORE",BEFORE_AFTER,1},
	{"ADVANCING",ADVANCING,0},
	{"INTO",INTO,0},{"AT",AT,0},{"END",END,0},{"NEGATIVE",NEGATIVE,0},
	{"ZERO",ZERONUM,ZERO},{"ZEROS",ZERONUM,ZEROS},
	{"ZEROES",ZERONUM,ZEROES},{"NO",CONNECTIVE,NO},
	{"POSITIVE",POSITIVE,0},{"NOT",NOT,0},
	{"INPUT",OPENMD,INPUT},{"I-O",OPENMD,I_O},
	{"OUTPUT",OPENMD,OUTPUT},{"EXTEND",OPENMD,EXTEND},
	{"CALL",CALL,0},{"USING",USING,0},{"WITH",CONNECTIVE,WITH},
	{"DARK",DARK,0},
	{"SOURCE-COMPUTER",COMMENTING,SOURCE_COMPUTER},
	{"OBJECT-COMPUTER",COMMENTING,OBJECT_COMPUTER},
	{"DATE-WRITTEN",COMMENTING,DATE_WRITTEN},
	{"ORGANIZATION",ORGANIZATION,0},{"ACCESS",ACCESS,0},{"MODE",MODE,0},
	{"KEY",KEY,0},{"STATUS",STATUS,0},{"SEQUENTIAL",SEQUENTIAL,0},
	{"INDEXED",INDEXED,0},{"DYNAMIC",DYNAMIC,0},
	{"RANDOM",RANDOM,0},{"RELATIVE",RELATIVE,0},{"SPACES",SPACES,0},
	{"COM1",PORTNUM,8},{"COM2",PORTNUM,1},{"COM3",PORTNUM,2},
	{"COM4",PORTNUM,3},{"LPT1",PORTNUM,4},{"LPT2",PORTNUM,5},
	{"LPT3",PORTNUM,6},{"LPT4",PORTNUM,7},
	{"DISK",PORTNUM,0},{"PRINTER",PORTNUM,4},
	{"",0,0}
};
struct reserved_sym {
	char *name;
	struct reserved_sym *next;
	int i; /* index on reserved symbol table */
};
#define HASHLEN 100
static struct reserved_sym *reserved_tab[ HASHLEN ]={NULL};

/* flex bug */
int cobwrap(void) { return 1; }
%}

%%

{eos}	{
#ifdef DEBUG_SCANNER
		printf("\nSCAN: eos\n");
#endif
		return(EOS); 
	}

COPY{white}{white}*{letter}({exletter}|{digit})*{eos} {
	{
		char *tp;
		char filename[65];
		gettoken(toktext,sizeof(toktext));
		tp=toktext+4;
		while (!isalpha(*tp)) tp++;
		strcpy(filename,tp);
		strcat(filename,"COB"); /* 'dot' is include in the pattern */
		copy_switch( filename );
		return(LEXSKIP);
	}
	}

("PIC"|"PICTURE"){white}* {
	lexswitch(piclex);
#ifdef DEBUG_SCANNER
	printf("\nSCAN <PIC>: %s\n", toktext);
#endif
	return(PIC); 
	}

"*"	{
	if (!middle_of_line) {
		//comment("\n");
		inc_line();
		return(LEXSKIP);
	}
	else
		return  '*';
	}

{letter}({exletter}|{digit})* {
	{
	 	gettoken(toktext, sizeof(toktext));
		if (!middle_of_line)
			middle_of_line++;
		if ((reserved_token=reserved(toktext))!=0) 
		{
#ifdef DEBUG_SCANNER
			printf("\nSCAN <reserved>: %s\n",
					toktext);
#endif
			return reserved_token;
		}
#ifdef DEBUG_SCANNER
		printf("\nSCAN <STRING>: %s\n",toktext);
#endif
		chg_underline(toktext);
		yylval.sval=install(toktext,0);
		return(STRING);
	}
	}


{sdelim}	{
	{	/*struct lit *d;*/
		tp=toktext;
		while((*tp=lexchar())!='"') tp++;
		*tp=0;
#ifdef DEBUG_SCANNER
		printf("\nSCAN <CLITERAL>: %s\n",toktext);
#endif
		yylval.lval = (struct lit *)install(toktext,1);
		return(CLITERAL);
	}
	}

X{sdelim}	{
	{
		unsigned char hnum[2];
		tp = toktext;
		hnum[0]=hnum[1]=0;
		while((*tp=toupper(lexchar()))!='"') {
			hnum[0] *= 0x10;
			hnum[0] += (*tp > '9') ?
				(*tp - 'A' + 0x0a) : (*tp - '0');
			tp++;
		}
		yylval.lval = (struct lit *)install(hnum,1);
		return(CLITERAL);
	}
	}

{ldelim}	{
	{
		tp=toktext;
		while((*tp=lexchar())!='\'') tp++;
		*tp=0;
#ifdef DEBUG_SCANNER
		printf("\nSCAN <CLITERAL>: %s\n",toktext);
#endif
		yylval.lval = (struct lit *)install(toktext,1);
		return(CLITERAL);
	}
	}

{int}	{
	{
		gettoken(toktext, sizeof(toktext));
#ifdef DEBUG_SCANNER
			printf("\nSCAN <NLITERAL>: %s\n",
					toktext);
#endif
		yylval.lval = (struct lit *)install(toktext,1);
		return(NLITERAL);
	}
	}

{int}{white}*","{white}*{int}	{ 
	{
		gettoken(toktext, sizeof(toktext));
#ifdef DEBUG_SCANNER
		printf("\nSCAN <NLITERAL>: %s\n",toktext);
#endif
		yylval.lval = (struct lit *)install(toktext,1);
		return(NLITERAL);
	}
	}

{digit}({exletter}|{digit})* { 
	gettoken(toktext, sizeof(toktext));
#ifdef DEBUG_SCANNER
	printf("\nSCAN <LABELSTR>: %s\n", toktext);
#endif
	chg_underline(toktext);
	yylval.sval=install(toktext,0);
	return(LABELSTR); 
	}

"\n"	{
	inc_line(); 
	return(LEXSKIP); 
	}

{white}*		{ return(LEXSKIP); }

{relop}{relop}* {
	{	gettoken(toktext,sizeof(toktext));
		if ((reserved_token=reserved(toktext))!=0) {
#ifdef DEBUG_SCANNER
			printf("\nSCAN <reserved>: %s\n",
					toktext);
#endif
			return reserved_token;
		}
		yyerror("relational operator unknown");
	}
	}

{any}	{
		gettoken(toktext, sizeof(toktext));
#ifdef DEBUG_SCANNER
		printf("\nSCAN: %s\n",toktext);
#endif
		return(toktext[0]); 
	}

%%

static struct {
	FILE *stream;
	int line;
} file_stack[10];
static int fsp;

extern FILE *o_lst;

int _getc( FILE *stream ) {
	static char linebuffer[129]="";
	static char *s=linebuffer;
	if (*s)
		return *s++;
	if (fgets( linebuffer,128,stream )==NULL)
		return EOF;
if (list_flag)
	fprintf( o_lst,"%04d:%s",++lineno,linebuffer );
else
	++lineno;
	s=linebuffer;
	return *s++;
}

int lexgetc( void ) { /* redefined for COPY (include file) control */
	int c;
	if ((c=_getc(app_in))!=EOF) return c;
	if (!fsp) return EOF;
	printf("\rLines in include file: %4d\n",lineno);
	fclose(app_in);
	app_in = file_stack[ --fsp ].stream;
	lineno = file_stack[ fsp  ].line;
	return lexgetc();
}

void copy_switch( char *filename ) {
	if (fsp>=10) {
		yyerror("Impossible to redirect input!");
		exit(1);
	}
	file_stack[ fsp ].stream = app_in;
	file_stack[ fsp++ ].line = lineno;
	printf("\rIncluding: %-20s\n",filename);
	if ((app_in = fopen( filename,"r" ))==NULL) {
		yyerror("Fatal error at file input switching");
		exit(1);
	}
	lineno = 0;
	printf("\rLines compiled: %4d",lineno);
}

char *savename( char *name );
int hash( char *name );

struct reserved_sym *lookup_reserved( char *s ) {
	struct reserved_sym *as;
	for ( as = reserved_tab[ hash(s) ] ; as != NULL ; as = as->next )
		if ( strcmp( s, as->name ) == 0 )
			return( as );
	return( NULL );
}

void install_reserved( void ) {
	struct reserved_sym *as;
	int val,i;
	for (i=0;strcmp(reserved_symbols[i].name,"");i++) {
		as = (struct reserved_sym *)
			malloc( sizeof(struct reserved_sym) );
		as->name = savename( reserved_symbols[i].name );
		val = hash( as->name );
		as->next = reserved_tab[ val ];
		reserved_tab[ val ] = as;
		as->i=i;
	}
}

int reserved( char *s ) {
	struct reserved_sym *r;
	if ((r=lookup_reserved(s))!=NULL) {
			yylval.ival=reserved_symbols[r->i].minor;
			return reserved_symbols[r->i].token;
	}
	return 0;
}

void chg_underline( char *s ) {
	char *s1;
	while ((s1=strchr(s,'-'))!=NULL) *s1='_';
}

void inc_line( void ) {
	static int doc_cnt=0;
	middle_of_line=0;
	/*lineno++;*/
	doc_cnt++;
	if (doc_cnt >= 16) {
		doc_cnt=0;
		printf("\rLines compiled: %4d",lineno);
	}
}

/* end of MCOBSCAN.LXI */
