#ifndef __HTCOBOL_H
#define __HTCOBOL_H

/*
**  Rildo Pragana
**
**  Include File for mcobol.y/.c
**
*/

struct lit {
	char litflag;		/* 1 for literals */
	char *name;		/* name (value) of literal */
	struct lit *next;	/* next in literals list */
	char type;
	int  decimals;
	unsigned location;	/* data area for literal @lit+n */
	unsigned descriptor;	/* descriptor @lit+n */
};

#define organization decimals
#define var_fd pic
#define fdesc location
#define direction access_mode
#define sort_data value2

struct sym {
	char litflag;		/* 1 for literals */
	char *name;		/* symbol (variable) name */
	struct sym *next;	/* pointer to next symbol with same hash */
	char type;              /* label or elementary item or group item */
				/* 9,A,X=elem; G=group; F=file; R=record */
	int decimals;		/* decimal places */
				/* or organization (files ) */
	unsigned location;	/* offset of variable in stack area */
				/* or offset file descriptor in data area */
	unsigned descriptor;	/* field descriptor offset in data seg */
				/* or index field descriptor (files) */
	int times;		/* occurs times */
	char *picstr;		/* pointer to picture string saved */
	struct sym *parent;	/* pointer to parent node (level)
				   pointer to STATUS var (files) */
	struct sym *son;
	struct sym *brother;
	struct sym *ix_desc;	/* key variable (in file descriptor)
				   pointer to fdesc (in record) */
	struct sym *index;	/* index variable in occurs */
				/* or variable port (PRINTER) */
	struct lit *value;	/* pointer to literal with initial value */
				/* or pointer to filename literal (files) */
	struct lit *value2;
				/* pointer to first/next key (sort files) */
	int level;		/* level of field */
				/* or ASSIGN TO DISK/PRINTER (files) */
	int access_mode;	/* access mode (files) */
				/* or direction (sort files data ) */
	int sign;		/* signal type (0=no signal,1=trailing) */
	int len;		/* length of item */
	char defined;		/* first time defined? */
	unsigned pic;		/* picture offset in data segment */
				/* or var_fd offset in stack (files) */
	int tablen;		/* length of group item or OCCURS */
	int occurs_flg;
	int linkage_flg;
	struct sym *redefines;  /* points to a redefined field */
};

struct list {
	struct list *next;
	void *var;
};

struct coord_pair {
	int lin;
	int col;
};

union label_def {
	struct {
		unsigned n:15;
		unsigned defined:1;
		unsigned off;
	}l;
	unsigned long x;
};

/* minor token numbers */

/* CONNECTIVES */

#define IS 0
#define ARE 1
#define WHEN 2
#define TO 3
/*#define FROM 4*/
#define	BY 5
#define	THAN 6
#define OF 7
#define NO 8
#define FOR 9
#define THRU 10
#define ON 11
#define WITH 12

/* USAGETOK */

#define COMP 0
#define INDEX 1
#define COMP3 2
/*  DISPLAY  e' um token independente deste grupo */

/* DATE-TIME */
#define DATE 0
#define TIME 1
#define INKEY 2

/* OPENMD */

#define INPUT 	1
#define I_O 	2
#define OUTPUT 	3
#define EXTEND  4

/* ZERONUM */

#define ZERO 0
#define ZEROS 1
#define ZEROES 2

/* DIVISNUM */

#define IDENTIFICATION 0
#define ENVIRONMENT 1
#define DATA 2
#define PROCEDURE 3

/* CONDITIONAL */

#define EQUAL 	1
#define LESS  	2
#define GREATER	4
#define GEQ 	5
#define LEQ 	3
#define NEQ 	6

/* COMMENTING */

#define SOURCE_COMPUTER 1
#define OBJECT_COMPUTER 2
#define AUTHOR		3
#define DATE_WRITTEN	4

/* DIRECTION */

#define ASCENDING  1
#define DESCENDING 2

/* function prototipes */

void chg_underline( char *s );
int reserved( char *s );
void yyerror(char *s,...);
int yyparse( void );
void open_section( struct sym *sect );
void close_section( void );
void open_paragr( struct sym *paragr );
void close_paragr( void );
void pgm_header( struct sym *pgm_id );
void proc_header( void );
void proc_trail( void );
void data_trail( void );
void gen_fdesc( struct sym *f, struct sym *r );
void gen_gotoxy( int lin, int col );
void gen_displaylit( struct lit *lit, int nl );
void gen_accept( struct sym *sy, int echo );
void gen_accept_from_time( struct sym *sy );
void gen_accept_from_date( struct sym *sy );
void gen_move( struct sym *sy_src, struct sym *sy_dst );
void gen_add( struct sym *s1, struct sym *s2 );
void gen_subtract( struct sym *s1, struct sym *s2 );
void gen_multiply( struct sym *s1, struct sym *s2, struct sym *s3 );
void gen_goto( struct sym *sy );
void close_fields( void );
void update_fields( void );
void alloc_file_entry( struct sym *f );
void gen_movelit( struct lit *v, struct sym *sy );
void save_literal( struct lit *v, int type );
void gen_perform_thru( struct sym *s1, struct sym *s2 );
void gen_exit( int code );
void gen_stoprun( void );
void gen_compare( struct sym *s1, int value, struct sym *s2 );
unsigned long gen_at_end( int status );
unsigned long gen_testif( void );
unsigned long gen_passlabel( void );
unsigned long gen_marklabel( void );
void gen_jmplabel( unsigned long label );
void gen_dstlabel( unsigned long label );
void gen_loadvar( struct sym *sy );
void gen_open( int mode, struct sym *f );
void gen_close( struct sym *f );
void gen_read( struct sym *f, struct sym *into );
void gen_read_next( struct sym *f, struct sym *into, int next_prev );
void gen_return( struct sym *f, struct sym *into );
void gen_write( struct sym *r, int opt, struct sym *from );
void gen_rewrite( struct sym *r, struct sym *from );
void gen_release( struct sym *r, struct sym *from );
void gen_start( struct sym *file,struct sym *from );
void gen_delete( struct sym *f );
void start_terminals( int n1, int n2 );
struct sym *define_filler( int level );
void define_field( int level, struct sym *sy );
void gen_open_prn( struct sym *sy );
void gen_close_prn( struct sym *sy );
void mark_actives( int first, int last );
void gen_not( void );
unsigned long gen_andstart( void );
unsigned long gen_orstart( void );

/* end of include file */
#endif
