%{
/*
**  Parser for Cobol Compiler
**
**  by Rildo Pragana -- 1991
**  P.O. Box 7440 - Recife PE Brazil 50000
**
**  Revision history:
**	2-Oct-91 Code implementation
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>

#include "htcoboly.h"
#include "htcoblib.h"
#include "lex.h"

void gen_call( struct lit *v,int stack_size );
void gen_save_using( struct sym *sy );
void gen_push_using( struct sym *sy );
void gen_display( int nl );
void put_disp_list( struct sym *sy );
struct sym *install( char *name,int lit_flag );
void gen_divide( struct sym *s1, struct sym *s2, struct sym *s3 );
void assign_expr( struct sym *sy );
void push_expr( struct sym *sy );
void add_expr( void );
void subtract_expr( void );
void multiply_expr( void );
void divide_expr( void );
void line_info( int,... );
void mark_line( void );

extern int subrot_flag;
extern int lineno;
extern FILE *lexin;
extern FILE *o_src;
extern struct sym *curr_paragr,*curr_section;
extern struct sym *curr_field;
extern struct sym *pgm_id;
extern unsigned stack_offset;	/* offset das variaveis na pilha */
extern unsigned global_offset;	/* offset das variaveis globais (DATA) */
extern int paragr_num;
extern int loc_label;
extern char picture[];
extern int picix,piccnt,decimals,sign,v_flag;
extern int at_linkage,stack_plus;
extern short list_flag;

extern int yylex(void);

struct sym *curr_file;

struct sym *alloc_filler( void );
%}

%union {
	struct sym *sval;   	/* symbol */
	int ival;		/* int */
	struct coord_pair pval;	/* lin,col */
	struct lit *lval;	/* literal */
	unsigned long dval;  	/* label definition, compacted */
}

%token <sval> STRING
%token <sval> LABELSTR
%token <ival> CHAR,MULTIPLIER
%token <ival> USAGENUM,ZERONUM,DIVISNUM,CONNECTIVE,CONDITIONAL
%token <ival> COMMENTING,DIRECTION,READ,WRITE,INPUT_OUTPUT
%token <lval> NLITERAL,CLITERAL
%token <ival> PORTNUM,OPENMD,BEFORE_AFTER,DATE_TIME

%token EOS

%left	'+','-'
%left	'*','/'

%left  OR
%left  AND
%nonassoc EOS

%token START,DELETE,DATE_TIME,PROGRAM,GLOBAL,EXTERNAL
%token FILE_NAME,GIVING,ERASE,RUNNING_TERMINALS
%token ADD,SUBTRACT,MULTIPLY,DIVIDE
%token FD,SD,REDEFINES,PIC,FILLER,OCCURS,TIMES
%token PROGRAM_ID,DIVISION,CONFIGURATION,SPECIAL_NAMES
%token FILE_CONTROL,I_O_CONTROL
%token SAME,AREA,ESCAPE
%token ECHO,FROM,UPDATE
%token WORKING_STORAGE,LINKAGE,DECIMAL_POINT,COMMA
%token FILEN,USAGE,BLANK
%token SIGN,VALUE,MOVE,LABEL,DARK
%token RECORD,OMITTED,STANDARD,RECORDS,BLOCK
%token CONTAINS,CHARACTERS,COMPUTE,GO,STOP,RUN
%token ACCEPT,PERFORM,VARYING,UNTIL,EXIT
%token IF,ELSE,NEXT,SENTENCE,LINE,PAGE
%token OPEN,CLOSE,REWRITE
%token ADVANCING,INTO,AT,END,NEGATIVE,POSITIVE,SPACES,NOT
%token CALL,USING,INVALID
%token SELECT,ASSIGN,DISPLAY
%token ORGANIZATION,ACCESS,MODE,KEY,STATUS
%token SEQUENTIAL,INDEXED,DYNAMIC,RANDOM,RELATIVE
%token SECTION,SORT

%type <ival> organization_options,access_options,open_mode
%type <ival> integer,opt_int,cond_op,assign_option
%type <ival> IF,ELSE,usage,write_options,opt_next,echo_options
%type <ival> division_id,pic_char,opt_program,using_options,using_parameters
%type <dval> if_part
%type <sval> anystring,name,gname,def_name,procedure_section,paragraph
%type <sval> field_description,def_label,label,index_part
%type <lval> literal,gliteral
%type <pval> coordinates
%type <sval> accept_part,sort_keys,perform_range
%type <sval> read_into,write_from,key_option

%%

%{
void yyunion( YYSTYPE *to, YYSTYPE *from );
%}
/************ 	Parser for Cobol Source  **************/

program:
	division_id DIVISION EOS {
		if ($1!=IDENTIFICATION)
			yyerror("IDENTIFICATION DIVISION expected");
		}
		identification_division { }
	division_id DIVISION EOS {
		if ($7!=ENVIRONMENT)
			yyerror("ENVIRONMENT DIVISION expected");
		}
		environment_division
	division_id DIVISION EOS {
		if ($12!=DATA)
			yyerror("DATA DIVISION expected");
		}
		data_division		{ data_trail(); }
	division_id DIVISION using_parameters EOS {
		if ($18!=PROCEDURE)
			yyerror("PROCEDURE DIVISION expected");
		proc_header();
		}
		procedure_division	{
			/* close procedure_division sections & paragraphs */
			close_section(); /* this also closes paragraph */
			proc_trail(); }
	;
division_id:
	DIVISNUM
	;
identification_division:
	PROGRAM_ID EOS def_name EOS { pgm_header($3); }
	| identification_division
        COMMENTING EOS anystring EOS { $4->type = ';'; }
	| error { yyerror("missing paragraph at identification division"); }
	;
environment_division:
	CONFIGURATION SECTION EOS
		configuration_section	{ }
	INPUT_OUTPUT SECTION EOS
		input_output_section    { }
	| error { yyerror("unknown section at ENVIRONMENT DIVISION"); }
	;
configuration_section:
	configuration_section configuration_option	{ }
	| /* nothing */					{ }
	;
configuration_option:
	COMMENTING EOS anystring EOS { }
	| SPECIAL_NAMES EOS special_name
	| error { yyerror("invalid format in CONFIGURATION SECTION"); }
	;
special_name:
	special_name
	DECIMAL_POINT CONNECTIVE COMMA EOS {
				if($3!=IS)
					yyerror("IS expected"); }
	| special_name
	RUNNING_TERMINALS opt_is_are
		run_coord opt_int EOS { /* start terminals */
                subrot_flag++;
                stack_plus = $5;
				printf ("Stack plus = %d\n",$5); }
	| /* nothing */
	| error { yyerror("unknown SPECIAL NAME"); }
	;
run_coord:
	coordinates		{ mark_actives($1.lin,$1.col); }
	| run_coord coordinates { mark_actives($2.lin,$2.col); }
	;
input_output_section:
	input_output_section i_o_option { }
	| /* nothing */		{ }
	;
i_o_option:
	FILE_CONTROL EOS file_control { }
	| I_O_CONTROL EOS io_control { }
	| error { yyerror("I-O SECTION format wrong"); }
	;
file_control:
	file_control file_select { }
	| /* nothing */
	;
file_select:
	SELECT def_name ASSIGN opt_to assign_option {
			$2->type='F';	/* mark as file variable */
			curr_file=$2;
			$2->pic=0;	/* suppose not indexed yet */
			$2->defined=1;
			$2->parent=NULL; /* assume no STATUS yet */
			$2->level=$5; 	 /* save assign option */
			$2->organization = 2;
			$2->access_mode = 1;
			$2->times=-1;
		 }
	  select_clauses EOS
	| error { yyerror("invalid format"); yyerrok; }
	;
assign_option:
	PORTNUM		{ $$=$1; }
	| STRING	{ $<sval>-2->index = $1; $$=-1; }
	| error  	{ yyerror("invalid option in select"); }
	;
select_clauses:
	select_clauses select_clause
	| /* nothing */
	;
select_clause:
	ORGANIZATION opt_is organization_options
				{ curr_file->organization=$3; }
	| ACCESS MODE opt_is access_options
				{ curr_file->access_mode=$4; }
	| FILEN STATUS opt_is STRING
				{ curr_file->parent=$4; }
	| rec_or_rel KEY opt_is STRING
				{ curr_file->ix_desc=$4; }
	| anystring 		{ yyerror("invalid clause, %s",$1->name); }
	;
rec_or_rel:
	RECORD
	| RELATIVE
	;
opt_is:
	CONNECTIVE	{ if ($1!=IS) yyerror("IS expected"); }
	| /* nothing */
	;
organization_options:
	INDEXED 	{ $$=1; }
	| SEQUENTIAL 	{ $$=2; }
	| RELATIVE 	{ $$=3; }
	| LINE SEQUENTIAL { $$=4; }
	| anystring { yyerror("invalid option, %s",
			$1->name); }
	;
access_options:
	SEQUENTIAL 	{ $$=1; }
	| DYNAMIC 	{ $$=2; }
	| RANDOM 	{ $$=3; }
	| anystring { yyerror("invalid access option, %s",
			$1->name); }
	;
io_control:
	io_control io_ctrl
	| /* nothing */
	;
io_ctrl:
	SAME AREA CONNECTIVE name_list EOS {
			if ($3!=FOR) yyerror("FOR expected");
		}
	| error { yyerror("input/output format option forbidden"); }
	;
name_list:
	STRING
	| name_list STRING
	| error { yyerror("variable expected"); }
	;
data_division:
	FILEN SECTION EOS               { curr_field=NULL; }
		file_section		{ close_fields();  }
	WORKING_STORAGE SECTION EOS	{ curr_field=NULL; }
		working_storage_section	{ close_fields(); }
	| data_division
	LINKAGE SECTION EOS             { at_linkage=1; curr_field=NULL; }
		linkage_section		{ close_fields(); at_linkage=0; }
	| error { yyerror("wrong format in DATA DIVISION"); }
	;
file_section:
	file_section FD name file_attrib EOS
			{
				if (!$3->defined)
					yyerror("file not selected, %s",
						$3->name);
                                /* save literal filename */
				$3->value=$<lval>4;
				curr_field=NULL;
			}
	file_description        { 	close_fields();
					alloc_file_entry($3);
					gen_fdesc($3,$<sval>7); }
	| file_section SD name sort_attrib EOS
			{
				if (!$3->defined)
					yyerror("file not selected, %s",
						$3->name);
				$3->organization=1;
				curr_field=NULL;
			}
	file_description	{	close_fields();
					alloc_file_entry($3);
					gen_fdesc($3,$<sval>7);
				}
	| /* nothing */
	;
file_description:
	field_description		{ $<sval>$=$1; }
	| file_description field_description
	;
field_description:
	integer def_name 		{ define_field($1,$2); }
		data_clauses EOS	{ $$=$2; update_field(); }
	;
data_clauses:
	/* nothing */
	| data_clauses REDEFINES name	{ $<sval>-1->redefines = $3; }
	| data_clauses OCCURS integer opt_TIMES
					{ curr_field->times = $3;
					  curr_field->occurs_flg++; }
	| data_clauses opt_USAGE usage	{ if ($3==COMP3) {
						curr_field->len = (piccnt/2)+1;
						curr_field->type='C';
					  }
					}
	| data_clauses VALUE value
	| data_clauses PIC 		{ picix=piccnt=
						v_flag=decimals=0;
						picture[picix]=0;
						/* marca primeiro ch */ }
		picture 		{ picture[picix+2]=0;
						/* marca fina da picture */
					  curr_field->len=piccnt;
					  curr_field->decimals=decimals;
					}
	;
value:
	gliteral			{ curr_field->value=$1;
					  curr_field->value2=$1; }
	| gliteral CONNECTIVE gliteral  { if ($2!=THRU)
						yyerror("THRU expected");
					  curr_field->value=$1;
					  curr_field->value2=$3;
					}
	;
picture: /* nothing */
	| picture pic_elem
	;
pic_elem:
	pic_char
	| pic_char MULTIPLIER {
			picture[picix+1] += $2-1;
			piccnt += $2-1;
		}
	;
pic_char:
	CHAR	{       if (picture[picix]==0) { /* primeiro caracter? */
				picture[picix]=(char)$1;
				picture[picix+1]=0;
			}
			switch((char)$1) {
			case 'A':
				if (picture[picix]==(char)$1) /* mesmo char? */
					picture[picix+1]++;
				else {
					picix+=2;
					picture[picix]=(char)$1;
					picture[picix+1]=1;
				}
				piccnt++;
				if (curr_field->type!='X')
					curr_field->type='A';
				break;
			case 'X':
				if (picture[picix]==(char)$1) /* mesmo char? */
					picture[picix+1]++;
				else {
					picix+=2;
					picture[picix]=(char)$1;
					picture[picix+1]=1;
				}
				piccnt++;
				if (curr_field->type=='9')
					curr_field->type='X';
				break;
			case 'Z':
				curr_field->type='E';
			case '9':
				if (picture[picix]==(char)$1) /* mesmo char? */
					picture[picix+1]++;
				else {
					picix+=2;
					picture[picix]=(char)$1;
					picture[picix+1]=1;
				}
				piccnt++;
				if (v_flag) decimals++;
				break;
			case ',':
				curr_field->type='E';
				piccnt++;
			case 'V':
				if (picture[picix]==(char)$1) /* mesmo char? */
					picture[picix+1]++;
				else {
					picix+=2;
					picture[picix]=(char)$1;
					picture[picix+1]=1;
				}
				v_flag=1;
				break;
			case 'P':
				if (picture[picix]==(char)$1) /* mesmo char? */
					picture[picix+1]++;
				else {
					picix+=2;
					picture[picix]=(char)$1;
					picture[picix+1]=1;
				}
				if (v_flag) decimals++;
				else decimals--;
			case 'S':
				if (picture[picix]==(char)$1) /* mesmo char? */
					picture[picix+1]++;
				else {
					picix+=2;
					picture[picix]=(char)$1;
					picture[picix+1]=1;
				}
				sign=1;
				break;
			case '0':
			case 'B':
			case '/':
			case '.':
			case '+':
			case '-':
			case '*':
			case '$':
				curr_field->type='E';
				if (picture[picix]==(char)$1) /* mesmo char? */
					picture[picix+1]++;
				else {
					picix+=2;
					picture[picix]=(char)$1;
					picture[picix+1]=1;
				}
				piccnt++;
				break;
			default:
				yyerror("invalid char in picture");
				YYERROR;
			}
		}
	;
file_attrib:
	/* nothing */
	| file_attrib opt_is GLOBAL 	{ $<sval>0->type = 'J';	}
	| file_attrib opt_is EXTERNAL   { $<sval>0->type = 'K'; }
	| file_attrib LABEL rec_or_recs opt_is_are std_or_omitt
	| file_attrib VALUE CONNECTIVE
		FILE_NAME opt_is
			literal 	{ if ($3!=OF) yyerror("OF expected");
					  $<lval>$=$6; }
	;
sort_attrib:
	/* nothing */
	| file_attrib DIVISNUM RECORD opt_is STRING
		{ if ($2!=DATA) { yyerror("DATA expected"); YYABORT; } }
	;
rec_or_recs:
	RECORD
	| RECORDS
	;
std_or_omitt:
	STANDARD
	| OMITTED
	;
opt_int: /* nothing */  { $$=0; }
	| integer	{ $$=$1; }
	;
opt_USAGE:
	/* nothing */
	| USAGE
	;
opt_TIMES:
	/* nothing */
	| TIMES
	;
opt_is_are:
	/* nothing */
	| CONNECTIVE 	{ if ($1!=IS && $1!=ARE) {
				yyerror("IS/ARE expected"); YYERROR; } }
	;
opt_no:
	/* nothing */
	| CONNECTIVE	{ if ($1!=NO) { yyerror("NO expected"); YYERROR;} }
	;
usage:	USAGENUM	{ $$=$1; }
	| DISPLAY	{ $$=9; }
	;
working_storage_section:
	/* nothing */
	| working_storage_section
		field_description
	;
linkage_section:
	/* nothing */
	| linkage_section
		field_description
	;
procedure_division:
	/* nothing */
	| procedure_division procedure_decl
	| error { yyerror("procedure SECTION or paragraph expected"); }
	;
procedure_decl:
	procedure_section { close_section(); open_section($1); }
	| paragraph	{ close_paragr(); open_paragr($1); }
	| statements
	;
procedure_section:
	def_label SECTION EOS
	;
paragraph:
	def_label EOS
	;
statements:
	statements statement opt_EOS
	| /* nothing */
	;
sentence:
	sentence statement
	| /* nothing */
	;
statement:
	MOVE { line_info(0); }
		gname req_to 		{ $<ival>$=MOVE; }
		var_list
	| ADD { line_info(0); }
		gname req_to 		{ $<ival>$=ADD; }
		var_list
	| SUBTRACT { line_info(0); }
		gname FROM name	{ gen_subtract($3,$5); }
	| MULTIPLY { line_info(0); }
		gname req_by gname GIVING name
		{
			gen_multiply($3,$5,$7);
		}
	| DIVIDE { line_info(0); }
		gname req_by gname GIVING name
		{
			gen_divide($3,$5,$7);
		}
	| COMPUTE { line_info(0); }
		name CONDITIONAL expr
		{ if ($4!=EQUAL) yyerror("= expected");
			assign_expr($3); }
	| accept_part
		accept_options
	| DISPLAY { line_info(0); }
		disp_at_xy
		disp_stat
	| OPEN { line_info(0); }
		open_mode name   {
				   if ($4->level == 0) /* disk? */
					gen_open($3,$4);
				   else
					gen_open_prn($4);
				}
	| CLOSE { line_info(0); }
		name		{ if ($3->level == 0)	/* disk? */
					gen_close($3);
				  else
					gen_close_prn($3);
				}
	| READ { line_info(0); }
		name opt_next
		read_into
		{
			if ($1==1)
				gen_return($3,$5);
            else if ($4>=1 && $3->organization==1 &&
				$3->access_mode==2)
                    gen_read_next($3,$5,$4); /* modificado para NEXT/PREV */
			else gen_read($3,$5);
		}
		read_clauses
	| WRITE	{ line_info(0); }
		name write_from write_options
			{
				if ($3->level != 1)
					yyerror("variable %s could not be used for WRITE",
						$3->name);
				if ($1==1)
					gen_release($3,$4);
				else
					gen_write($3,$5,$4);
			}
	| REWRITE { line_info(0); }
		name write_from
			{
				if ($3->level != 1)
					yyerror("variable %s could not be used for REWRITE",
						$3->name);
				gen_rewrite($3,$4);
			}
	| DELETE { line_info(0); }
		name opt_record	{ gen_delete($3); }
	| START { line_info(0); }
        name
        key_option           { gen_start($3,$4); }
	| PERFORM { mark_line(); }
		perform_range		{ line_info(3,$3->name); }
	| GO  opt_to label   		{ gen_goto($3); }
	| EXIT	{ line_info(0); }
		opt_program		{ gen_exit($3); }
	| STOP RUN 			{ line_info(0); gen_stoprun(); }
	| if_part
	  ELSE				{ line_info(4);
					  $<dval>$=gen_passlabel();
					  gen_dstlabel($1); }
		sentence 		{ gen_dstlabel($<dval>3); }
	| if_part 			{ gen_dstlabel($1); }
	| NEXT SENTENCE 	/* do not generate code for this */
	| CALL  { line_info(0); }
		CLITERAL
		using_options		{ gen_call($3,$4); }
	| SORT  { mark_line(); }
		name
		sort_keys	{ gen_sort($3); }
		OPENMD DIVISNUM opt_is perform_range
		OPENMD DIVISNUM opt_is perform_range
		{
			line_info(6,$9->name,$13->name);
			if (($7!=PROCEDURE) || ($11!=PROCEDURE)
				|| ($6!=INPUT) || ($10!=OUTPUT)) {
				yyerror("INPUT or OUTPUT PROCEDURE expected");
				YYABORT;
			}
			gen_close_sort($3);
		}
	| error	 			{ yyerror("unknown or wrong statement");
						YYABORT; }
	;
sort_keys:
	/* nothing */	{ $$ = NULL; }
	| sort_keys DIRECTION KEY name
		{
			$4->direction = $2;
			(struct sym *)$4->sort_data =
				(struct sym *)($<sval>0->sort_data);
			(struct sym *)($<sval>0->sort_data) = $4;
			$$ = $4;
		}
	;
expr:
	gname			{ push_expr($1); }
	| expr '*' expr		{ multiply_expr(); }
	| expr '/' expr		{ divide_expr(); }
	| expr '+' expr         { add_expr(); }
	| expr '-' expr		{ subtract_expr(); }
	| '(' expr ')'
	;
using_options:
	/* nothing */	{ $$=0; }
	| USING 	{ $<ival>$=0; /* to save how many parameters */ }
	  dummy 	{ $<ival>$=CALL; }
	  var_list 	{ $$=$<ival>2; } /* modified to signal calling pgm */
	;
dummy: /* nothing */ ;
using_parameters:	/* defined at procedure division */
	/* nothing */   	{ $$=0; }
	| USING 		{ $<ival>$=USING; }
		var_list	{ $$=1; }
	;
accept_part:
	ACCEPT  { line_info(0); }
		coordinates name 	{ gen_gotoxy($3.lin,$3.col);
						$<sval>$=$4; }
	| ACCEPT  { line_info(0); }
		name			{ $<sval>$=$3; }
	;
accept_options:
	/* nothing */			{ gen_accept($<sval>0,1);  }
	| echo_options			{ gen_accept($<sval>0,$1); }
	| req_on ESCAPE			{ gen_accept($<sval>0,1);
					  line_info(1);
					  $<dval>$=gen_at_end(-1); }
		sentence		{ gen_dstlabel($<dval>3); }
	| echo_options
		req_on ESCAPE		{ gen_accept($<sval>0,$1);
					  line_info(1);
					  $<dval>$=gen_at_end(-1); }
		sentence		{ gen_dstlabel($<dval>4); }
	| FROM DATE_TIME      { if ($2==DATE)
					gen_accept_from_date($<sval>0);
				else if ($2==TIME)
					gen_accept_from_time($<sval>0);
				else if ($2==INKEY)
					gen_accept_from_inkey($<sval>0); }
	;
echo_options:
	opt_no ECHO		{ $$=0; }
	| opt_with FILLER	{ $$=2; }
	| opt_with UPDATE	{ $$=8; }
	| DARK			{ $$=4; }
	;
var_list:
	/* nothing */
	| var_list gname
		{ 	if ($<ival>0 == MOVE)
				gen_move($<sval>-2,$<sval>2);
			else if ($<ival>0 == ADD)
				gen_add($<sval>-2,$<sval>2);
			else if ($<ival>0 == USING)
				gen_save_using($<sval>2);
			else if ($<ival>0 == CALL) {
				gen_push_using($<sval>2);
				$<ival>-2 += 4; /* stack used */
			}
		}
	;
disp_stat:
	disp_var_list disp_options	{ gen_display($<ival>2); }
	;
disp_var_list:
	/* nothing */
	| disp_var_list gname           { put_disp_list($2); }
	;
perform_range:
	label				{ gen_perform_thru($1,$1);
					  $$=$1; }
	| label CONNECTIVE label 	{
				if ($2!=THRU) yyerror("THRU expected");
				gen_perform_thru($1,$3);
				$$=$1;
			}
	| label UNTIL		{ $<dval>$=gen_marklabel(); }
		condition       { unsigned long lbl;
				  lbl = gen_orstart();
				  gen_perform_thru($1,$1);
				  gen_jmplabel($<dval>3);
				  gen_dstlabel( lbl );
				  $$=$1; }
	| label CONNECTIVE
		label UNTIL  	{ $<dval>$=gen_marklabel(); }
		condition  	{ unsigned long lbl;
				  if ($2!=THRU) yyerror("THRU expected");
				  lbl=gen_orstart();
				  gen_perform_thru($1,$3);
				  gen_jmplabel($<dval>5);
				  gen_dstlabel(lbl);
				  $$=$1; }
	;
disp_options:
	/* nothing */			{ $<ival>$=0; }
	| disp_options
	   CONNECTIVE ADVANCING		{ if ($2!=NO)
						yyerror("NO expected");
					  $<ival>$|=1;
					}
	| disp_options ERASE		{ $<ival>$|=2; }
	;
disp_at_xy:
	/* nothing */
	| coordinates			{ gen_gotoxy($1.lin,$1.col); }
	;
key_option:
    /* nothing */       { $$ = NULL; }
    | KEY name          { $$ = $2; }
    ;
read_into:
	/* nothing */		{ $$ = NULL; }
	| INTO name		{ $$ = $2; }
	;
write_from:
	/* nothing */		{ $$ = NULL; }
	| FROM gname		{ $$ = $2; }
	;
write_options:
	/* nothing */                   { $$=0; }
	| BEFORE_AFTER opt_advancing
		gname opt_line		{ gen_loadvar($3); $$=$1; }
	| BEFORE_AFTER
		opt_advancing PAGE	{ $$=-$1; }
	;
read_clauses:
	/* nothing */
	| opt_at END			{ line_info(1);
					  $<dval>$=gen_at_end(10); }
		sentence		{ gen_dstlabel($<dval>3); }
	| INVALID KEY   		{ line_info(1);
					  $<dval>$=gen_at_end(23); }
		sentence		{ gen_dstlabel($<dval>3); }
	;
if_part:
	IF { mark_line(); }
	   condition 	 		{ line_info(5);
					  $<dval>$=gen_testif(); }
		sentence		{ $<dval>$=$<dval>4; }
	;
condition:
	gname  cond_op gname		{ gen_compare($1,$2,$3); }
	| NOT condition			{ gen_not(); }
	| condition AND            	{ $<dval>$=gen_andstart(); }
		condition		{ gen_dstlabel($<dval>3); }
	| condition OR			{ $<dval>$=gen_orstart(); }
		condition		{ gen_dstlabel($<dval>3); }
	| '(' condition ')'		{ $<dval>$ = $<dval>2; }
	| name				{ if ($1->level != 88)
						yyerror("condition unknown");
						gen_condition($1);
					}
	;
cond_op:
	CONDITIONAL opt_than_to			{ $$ = $1; }
	| NOT CONDITIONAL opt_than_to		{ $$ = $2 ^ 7; }
	| CONDITIONAL OR CONDITIONAL opt_than_to
						{ $$ = $1 | $3; }
	;
opt_EOS:
	/* nothing */
	| EOS
	;
opt_next:
	/* nothing */	{ $$=0; }
    | NEXT      { $$=$<ival>1; }  /* NEXT/PREV */
	;
opt_line:
	/* nothing */
	| LINE
	;
opt_advancing:
	/* nothing */
	| ADVANCING
	;
opt_than_to:
	/* nothing */
	| CONNECTIVE	{ if ($1!=TO && $1!=THAN)
				yyerror("THAN or TO expected");
			}
	;
opt_program:
	/* nothing */	{ $$=0; }
	| PROGRAM	{ $$=1; }
	;
opt_record:
	/* nothing */
	| RECORD
	;
opt_at: /* nothing */
	| AT
	;
opt_with:
	/* nothing */
	| CONNECTIVE	{ if ($1!=WITH) yyerror("WITH expected"); }
	;
opt_to:	/* nothing */
	| CONNECTIVE	{ if ($1!=TO) yyerror("TO expected"); }
	;
req_on:   CONNECTIVE	{ if ($1!=ON) yyerror("ON required"); }
	;
req_by:	  CONNECTIVE	{ if ($1!=BY) yyerror("BY required"); }
	;
req_to: CONNECTIVE	{ if ($1!=TO) yyerror("TO required"); }
	;
coordinates:
	'(' NLITERAL ')'	{
			  char *s;
			  $$.lin=0;
			  s=$2->name;
			  while (isdigit(*s) || *s==' ')
				if (*s==' ') { s++; continue; }
				else
					$$.lin = $$.lin * 10 + *s++ - '0';
			  if (*s++!=',')
				yyerror("must have a comma here");
			  $$.col=0;
			  while (isdigit(*s) || *s==' ')
				if (*s==' ') { s++; continue; }
				else
					$$.col = $$.col * 10 + *s++ - '0';
			  if (*s && *s!=' ')
				yyerror("wrong format for pair");
		}
	;
open_mode:
	OPENMD			       { $$=$1; }
	| error  { yyerror("unknown OPEN mode"); }
	;
gname:  name			{ $$ = $1; }
	| gliteral		{ $$ = (struct sym *)$1; }
	;
gliteral:
	literal			{ $$=$1; }
	| SPACES		{ 	struct lit *v;
					v=(struct lit *)install(" ",1);
					save_literal(v,'X');
					$$=v;
				}
	| ZERONUM		{ 	struct lit *v;
					v=(struct lit *)install("0",1);
					save_literal(v,'9');
					$$=v;
				}
	;
literal:
	NLITERAL		{ save_literal($1,'9'); $$=$1; }
	| CLITERAL		{ save_literal($1,'X'); $$=$1; }
	;
def_name:
	STRING		{ if ($1->defined)
				yyerror("variable redefined, %s",$1->name);
			  $1->defined=1;
			  $$=$1;
			}
	| FILLER	{ $<sval>$=alloc_filler(); }
	;
name:
	STRING index_part	{ $$ = $1;
				  if ($1->times<=0) {
					yyerror("%s must NOT be indexed",
							$1->name);
					/* YYABORT; */
				  }
        			  $1->index = $2; }
	| STRING		{ if (!$1->defined)
				    yyerror("variable not defined, %s",
					$1->name);
				  if ($1->times>0) {
					yyerror("%s must be indexed",$1->name);
					/* YYABORT; */
				  }
				    $<sval>$=$1;
				}
	;
index_part:
	'(' gname ')'	{ $$ = $2; }
	;
integer:
	NLITERAL	{
			  char *s;
			  $$=0;
			  s=$1->name;
			  while (isdigit(*s))
				$$ = $$ * 10 + *s++ - '0';
			  if (*s)
				yyerror("only integers accepted here");
			}
	;
def_label:
	LABELSTR	{ if ($1->defined)
				yyerror("paragraph redefined, %s",$1->name);
			  $1->defined=1;
			  $$=$1;
			}
	| STRING        { if ($1->defined)
				yyerror("paragraph redefined, %s",$1->name);
			  $1->defined=1;
			  $$=$1;
			}
	;
label:
	LABELSTR
	| STRING
	;
anystring:
	STRING
	| LABELSTR
	;
%%

/*
**	Yacc auxiliary routines
*/
extern FILE *o_lst;

void yyerror(char *s,...) {
  va_list argptr;
  va_start( argptr, s);
  fprintf( stderr,"\n*** ERROR line %d: ",lineno );
  vfprintf( stderr, s, argptr );
  fprintf( stderr," ***\n");
if (list_flag) {
  fprintf( o_lst,"\n*** ERROR line %d: ",lineno );
  vfprintf( o_lst, s, argptr );
  fprintf( o_lst," ***\n");
 }
  va_end( argptr );
}

void yyunion( YYSTYPE *to, YYSTYPE *from ) {
	memcpy( to, from, sizeof( *from ) );
}

