/*
**  Header file for Cobol Compiler Library
**
**  by Rildo Pragana -- 1991
**  P.O. Box 7440 - Recife PE Brazil 50000
**
**  Revision history:
**	28-oct-91 Code implementation
**
*/

#include <bplus.h>

#define MICROSOFT 0	       /* 2=versao 2.2   4=versao 4.0 */
/* #define MICROBASE 1 */
#define NUMERIC_KBD 1   /* 0=phone, 1=numeric organization */

struct fld_desc {
	unsigned len;
	char type;
	unsigned char decimals;
	unsigned char times;
	char *pic;
};

struct file_desc {
	char *filename;
	unsigned reclen;	/* length of record */
	unsigned char organization;
				/* 1=INDEXED,2=SEQUENTIAL,3=RELATIVE */
	unsigned char access_mode;
				/* 1=SEQUENTIAL,2=DYNAMIC,3=RANDOM */
	int handle;		/* where to put file handle (global) */
	int users;		/* number or active users
					or printer port */
		/* second part: exists only if INDEXED file */
	unsigned rec_index; 	/* offset of index field in record */
	struct fld_desc
		*ixd_desc;	/* offset (DGROUP) index field descriptor */
	IX_DESC index;
	char sortkeys[1];
};

#define releasing splrec

/* before the 'entry' (below) is the 'record' array */

struct var_fd {
	long filepos;
	int splrec;
	ENTRY e;
	char record[1];
};
/*#define RECORD ((char *)(v->e.key)+\
	((f->organization==1)?f->ixd_desc->len+1:1))*/
/*#define RECORD ((char *)(v->record))*/

/* function prototipes */

void goxy( int,int );
void display( char *,int );
int accept( char *,struct fld_desc *,int );
void move( struct fld_desc *, char *,
	   struct fld_desc *, char * );
void add( struct fld_desc *, char *,
	  struct fld_desc *, char * );
void subtract( struct fld_desc *, char *,
	       struct fld_desc *, char * );
void multiply( struct fld_desc *, char *,
	       struct fld_desc *, char *,
	       struct fld_desc *, char * );
void stop_run( void );
int compare( struct fld_desc *, char *,
	      struct fld_desc *, char * );
int mc_open( struct file_desc *, struct var_fd *, int );

#ifdef MICROBASE
	int mc_close( struct file_desc *, struct var_fd * );
#else
	int mc_close( struct file_desc * );
#endif

int mc_read( struct file_desc *, struct var_fd *, ... );
int mc_write( struct file_desc *, struct var_fd * );
int mc_rewrite( struct file_desc *, struct var_fd * );
int get_index( struct fld_desc *, char * );
unsigned char mgetkey( void );
void submit_print( char * );
void init_spooler( void );

/* end of header file */

