/*
**  Code Generator for Cobol Compiler
**
**  by Rildo Pragana -- 1991
**  P.O. Box 7440 - Recife PE Brazil 50000
**
**  Revision history:
**	27-oct-91 Code implementation
**
*/

/*#define DEBUG_COMPILER 1*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/time.h>

#include "htcoboly.h"
#include "bplus.h"

struct var_fd {
	long filepos;
	int splrec;
	struct {
		RECPOS idxptr;
		RECPOS recptr;
		char key[MAXKEY];		/* uses minimum key space */
	}e;
	/* after the 'var_fd' (above) is the 'record' array */
};

extern int lineno;
extern struct lextab literal;
FILE *app_in;

FILE *o_src,*o_lst,*o_deb;
struct sym *curr_paragr=NULL,*curr_section=NULL;
struct sym *curr_field;
struct sym *pgm_id;
unsigned stack_offset=0;	/* offset das variaveis na pilha */
unsigned stack_plus=0;
unsigned global_offset=0;	/* offset das variaveis globais (DATA) */
unsigned literal_offset=0;
unsigned linkage_offset=0;
int subrot_flag=0;
unsigned using_offset=6;
unsigned ip_offset = 0;
unsigned last_ip_offset = 0;
unsigned last_lineno = 0;
short debug_flag = 0;
short list_flag = 0;
short overlay_flag = 0;
short at_procedure = 0;
struct list *disp_list=NULL;
struct list *call_list=NULL;
struct list *parameter_list=NULL;
struct list *fields_list=NULL;
struct list *last_field=NULL;
int paragr_num=1;
int loc_label=1;
char picture[64];
int picix,piccnt,decimals,sign,v_flag,digits;
int filler_num=1;
int active[37];
int at_linkage=0;

/* function prototypes */
void asm_call( char *s );
void line_info( int t, char *label, char *label2 );
void label_info( char *label );
int yyparse( void );
struct sym *install( char *name, int lit_flag );
struct sym *lookup( char *name, int tab );
int hash( char *s );
char *savename( char *name );
void open_section( struct sym *sect );
void close_section( void );
void open_paragr( struct sym *paragr );
void close_paragr( void );
void pgm_header( struct sym *pgm_id );
void proc_header( void );
void proc_trail( void );
void data_trail( void );
void gen_gotoxy( int lin, int col );
void gen_move( struct sym *sy_src, struct sym *sy_dst );
void gen_goto( struct sym *sy );
void close_fields( void );
void save_literal( struct lit *s, int type );
void gen_loadloc( struct sym *sy );
void gen_link_extrn( void );
void install_reserved( void );

/*
**	Symbol table management routines
*/

#define HASHLEN 100
static struct sym *symtab[ HASHLEN ]={NULL};
static struct lit *littab[ HASHLEN ]={NULL};

int hash( char *s ) {
	int val;
	for ( val = 0 ; *s != '\0'; )
		val += *s++;
	return( val % HASHLEN );
}

char *savename( s )
char *s; {
	char *ap;
	if ((ap = (char *) malloc( strlen(s) + 1 )) != NULL)
		strcpy(ap,s);
	return( ap );
}

struct sym *lookup( char *s, int tab ) {
	if (tab) { /* literals tab */
		struct lit *as;
		for ( as = littab[ hash(s) ] ; as != NULL ; as = as->next )
			if ( strcmp( s, as->name ) == 0 )
				return( (struct sym *)as );
		return( NULL );
	}
	else {
		struct sym *as;
		for ( as = symtab[ hash(s) ] ; as != NULL ; as = as->next )
			if ( strcmp( s, as->name ) == 0 )
				return( as );
			return( NULL );
	}
}

struct sym *install( char *name, int lit_flag ) {
    if (lit_flag) {
	struct lit *as;
	int val;
	if ( ( as = (struct lit *)lookup(name,lit_flag) ) == NULL ) {
		as = (struct lit *) malloc( sizeof(struct lit) );
		if (as==NULL)
			return NULL;
		if ( (as->name = savename( name ) )  == NULL )
			return NULL;
		val = hash( as->name );
		as->next = littab[ val ];
		littab[ val ] = as;
		as->type = 0;
		as->litflag=lit_flag;
	}
	return( (struct sym *)as );
    }
    else {
	struct sym *as;
	int val;
	if ( ( as = lookup(name,lit_flag) ) == NULL ) {
		as = (struct sym *) malloc( sizeof(struct sym) );
		if (as==NULL)
			return NULL;
		if ( (as->name = savename( name ) )  == NULL )
			return NULL;
		val = hash( as->name );
		as->next = symtab[ val ];
		symtab[ val ] = as;
		as->type = 0;
		as->defined = 0;
		as->value = as->sort_data = NULL;
		as->linkage_flg = 0;
		as->litflag=lit_flag;
	}
	return( as );
    }
}

/*
**	Code Generating Routines
*/

void pgm_header( struct sym *sy ) {
	time_t tick;
	time(&tick);
	pgm_id=sy;
	fprintf(o_src,"#\n#\tProgram %s\n#\tGenerated by",pgm_id->name);
	fprintf(o_src," Micro Cobol Compiler\n#\t(C) Rildo Pragana, 1993\n");
	fprintf(o_src,"#\t\tDate compiled: %s", ctime(&tick));
	fprintf(o_src,"#\tVersion 3.2(Linux)\n#\n\n");
//	fprintf(o_src,"%s_TEXT\tsegment\tbyte public 'CODE'\n",pgm_id->name);
//	fprintf(o_src,"DGROUP\tgroup _DATA,_BSS\n");
//	fprintf(o_src,"\tassume\tcs:%s_TEXT,ds:DGROUP\n",pgm_id->name);
//	fprintf(o_src,"%s_TEXT\tends\n\n",pgm_id->name);
//	fprintf(o_src,"_DATA	segment word public 'DATA'\n");
//	fprintf(o_src,"d@\tlabel\tbyte\n");
//	fprintf(o_src,"d@w\tlabel\tword\n");
//	data_trail();
//	fprintf(o_src,"_BSS\tsegment word public 'BSS'\n");
//	fprintf(o_src,"b@\tlabel\tbyte\n");
//	fprintf(o_src,"b@w\tlabel\tword\n");
//	fprintf(o_src,"_BSS\tends\n");
//	fprintf(o_src,"_DATA	segment word public 'DATA'\n");
//	fprintf(o_src,"s@\tlabel\tbyte\n");
}

void data_trail( void ) {
//	fprintf(o_src,"_DATA	ends\n\n");
}

void proc_header( void ) {
	struct sym *sy;
	int i;
	fprintf(o_src,"\n\t.text\n%s_TEXT:\n", pgm_id->name);
	fprintf(o_src,"_%s:\n",pgm_id->name);
	fprintf(o_src,"\tpushl\t%%ebp\n\tmovl\t%%esp, %%ebp\n");
	if (stack_offset & 1) stack_offset++;
	fprintf(o_src,"\tsubl\t$%u, %%esp\n",stack_offset);
	ip_offset = 6;		/* valor inicial */
	if (stack_offset>128) ip_offset++;
    if (subrot_flag) {
        asm_call("init_terminal");
        ip_offset += 5;
    }
    /********** initialize all VALUES of fields **********/
	for (i=0;i<HASHLEN;i++)
		for (sy=symtab[i];sy!=NULL;sy=sy->next)
			if (sy->value!=NULL && sy->type!='F' &&
			    sy->type!='8' && sy->type!='K' &&
			    sy->type!='J' )
				gen_move( (struct sym *)sy->value,sy );
    fprintf(o_src,"\tleal\t_%s, %%eax\n",pgm_id->name);
	fprintf(o_src,"\tpushl\t%%eax\n");
	fprintf(o_src,"\tleal\t__end_pgm, %%eax\n");
	fprintf(o_src,"\tpushl\t%%eax\n");
	ip_offset += 10;
	at_procedure++;
}

void proc_trail( void ) {
	int i;
	struct lit *v;
	struct list *list;
	struct sym *sy;
	char s[9];
	fprintf(o_src,"__end_pgm:\n");
	asm_call("stop_run");
//	fprintf(o_src,"_%s\tendp\n\n",pgm_id->name);

	/********** generate data for literals & fields ************/
//	fprintf(o_src,"_DATA	segment word public 'DATA'\n");
	fprintf(o_src,"\t.data\n");
	fprintf(o_src,"v_base:\n");
	/**************** generate data for fields *****************/
    pgm_id->type='&';
for (list=fields_list;list!=NULL;list=list->next) {
	if ( ((struct sym *)list->var)->type=='F' ) { /* sort files */
		char sl[21];	/* para inverter a lista */
		char *s;
		s=sl;
		*s++=0;	/* final da lista invertida */
		sy=(struct sym *)list->var;
		sy=(struct sym *)sy->sort_data;
		while (sy!=NULL) {
			*s++ = (unsigned char)sy->direction;
			*s++ = (unsigned char)sy->len;
			sy = (struct sym *)(sy->sort_data);
		}
		s--;
		while (*s) {
			fprintf(o_src,"\t.byte\t%uh,%uh\n",*s--,*s--);
		}
		fprintf(o_src,"\t.long\t0\n");
	}
	else if (((struct sym *)list->var)->litflag) { /* it is a literal */
		v=(struct lit *)list->var;
#ifdef DEBUG_COMPILER
		fprintf(o_src,"; Literal: %s, Data loc: v_base+%d, Desc: v_base+%d\n",
			v->name,v->location,v->descriptor );
#endif
		if (!v->decimals)
			{       /* print literal string, w/special chars */
				int bcnt;
				char *s;
				s=v->name;
				while (*s) {
					bcnt=0;
					fprintf(o_src,"\t.byte\t%d",*s++);
					while (*s && (bcnt++ < 8))
						fprintf(o_src,",%d",*s++);
					if (*s)
						putc('\n',o_src);
					else
						fprintf(o_src,",0\n");
				}
			}
		else {
			char *s;
			s=v->name;
			fprintf(o_src,"\t.byte\t\'");
			while (*s!=',')
				putc(*s++,o_src);
			s++;
			while (*s)
				putc(*s++,o_src);
			fprintf(o_src,"\',0\n");
		}
		fprintf(o_src,"\t.word\t%d\n",
			(v->decimals) ? strlen(v->name)-1
				      :	strlen(v->name));
		fprintf(o_src,"\t.byte\t'%c',%d,%d\n",
			v->type,v->decimals,0);
/*		fprintf(o_src,"\t.word\toffset v_base+%d,DGROUP\n",
			v->descriptor+9); // pointer to picture //
*/
		fprintf(o_src,"\t.long\tv_base+%d\n",
			v->descriptor+9);
		if (v->decimals) {
			fprintf(o_src,"\t.byte\t'9',%d,'V',1,'9',%d,0\n",
				strlen(v->name)-v->decimals-1,
				v->decimals);
		}
		else
			fprintf(o_src,"\t.byte\t\'%c\',%d,0\n",
				v->type,strlen(v->name));
	}
	else {  /* it is a normal field */
		sy=(struct sym *)list->var;
#ifdef DEBUG_COMPILER
		fprintf(o_src,"; Field: %s, Stack loc: [bp-%d], Desc: v_base+%d\n",
			sy->name,sy->location,sy->descriptor );
#endif
		if (sy->redefines != NULL)
			sy->location = sy->redefines->location;
		fprintf(o_src,"\t.word\t%d\n",sy->len);
		fprintf(o_src,"\t.byte\t'%c',%d,%d\n",
			sy->type,sy->decimals,sy->times);
		if (sy->type!='G') {
/*			fprintf(o_src,"\t.word\tv_base+%d,DGROUP\n",
				sy->pic); // pointer to picture
*/
			fprintf(o_src,"\t.long\tv_base+%d\n",sy->pic);
			for (i=0;i<strlen(sy->picstr);i+=2)
				fprintf(o_src,"\t.byte\t\'%c\',%d\n",
                    *(sy->picstr+i),*((unsigned char *)sy->picstr+i+1));
			fprintf(o_src,"\t.byte\t0\n");
		}
	}
}
	data_trail();
	/************* generate common data for processes **********/
	if (using_offset==6) {
		if (strlen(pgm_id->name)>=8)
			memmove(s,pgm_id->name,8);
		else {
			strcpy(s,pgm_id->name);
			memmove(s+strlen(pgm_id->name),"        ",
				8-strlen(pgm_id->name));
		}
		s[8]=0;
//		fprintf(o_src,"\n_TBL\tsegment word common 'TBL'\n");
		fprintf(o_src,"\n\t.data # .common really!!\n");
		for (i=0;i<37;i++) {
			if (active[i]) {
				fprintf(o_src,"\t.long\t_%s\n",
					pgm_id->name);
				fprintf(o_src,"\t.word\t%d\n",stack_offset/2 +
		                    stack_plus + 0x300);
                    /****** 0x300 words plus for security ******/
				fprintf(o_src,"\t.asciz\t\"%s\"\n",s);
				fprintf(o_src,"\t.byte\t%d\n",i);
			}
			else
				fprintf(o_src,"\t.fill\t16, 1, '?'\n");
		}
//		fprintf(o_src,"_TBL\tends\n\n");
	}
	/* generate externals and publics */
	gen_link_extrn();
	fprintf(o_src,"\t.global\t_%s\n",pgm_id->name);
}

void save_field_in_list( struct sym *sy ) {
	struct list *list;
	if (fields_list==NULL) {
		list = (struct list *)malloc(sizeof(struct list));
		last_field = fields_list = list;
		list->next = NULL;
		list->var = sy;
	}
	else {
		list = (struct list *)malloc(sizeof(struct list));
		list->var = sy;
		list->next = NULL;
		last_field->next = list;
		last_field = list;
	}
}

void save_literal( struct lit *v, int type ) {
	char *s;
	char *dp;
	int piclen;
	if (v->type) return; /* already saved */
	s=v->name;
	piclen=3; /* assume 'X'-only literal */
	if (type!='X' && (dp=strchr(s,','))!=NULL) {
		piclen += 4; /* reserve space for 'V' and decimal part */
		v->decimals=strlen(s)-(int)(dp-s)-1;
	}
	else v->decimals=0;
	v->type = type;
	/****** save literal in fields list for later *******/
	save_field_in_list( (struct sym *)v );
	/******** save address of const string ************/
	v->location = literal_offset;
	if (v->decimals)
		literal_offset += strlen(s);
			/* it's already one chr plus (decimal point) */
	else
		literal_offset += strlen(s)+1;
	/******** save address of field descriptor ********/
	v->descriptor = literal_offset;
	literal_offset += 9+piclen;
}

void put_disp_list( struct sym *sy ) {
	struct list *list,*tmp;
	list = (struct list *)malloc(sizeof(struct list));
	list->var = sy;
	list->next=NULL;
	if (disp_list==NULL)
		disp_list = list;
	else {
		tmp=disp_list;
		while (tmp->next != NULL) tmp=tmp->next;
		tmp->next = list;
	}
}

void asm_call( char *s ) {
	struct list *list;
	/******* verifica se funcao ja' nao foi chamada antes *******/
	list = call_list;
	for ( list=call_list ; list!=NULL ; list=list->next ) {
		if (list->var==s)
			break;
	}
	/******** salva se nao encontrada na lista de call's ********/
	if (list==NULL) {
		list = (struct list *)malloc(sizeof(struct list));
		list->var = s;
		list->next = call_list;
		call_list = list;
	}
	fprintf(o_src,"\tcall\t%s\n",s);
}

void gen_display( int nl ) {
	struct list *tmp;
	int len;
	struct sym *sy;
	if (nl & 2) {
		asm_call("display_erase");
		ip_offset += 5;
	}
	while (disp_list) {
		sy=disp_list->var;
		if (sy->litflag)
			len = strlen(sy->name);
		else
			len = sy->len;
		fprintf(o_src,"\tmovl\t$%d, %%eax\n",len);
		fprintf(o_src,"\tpushl\t%%eax\n");
		gen_loadloc( sy );
		asm_call("display");
		fprintf(o_src,"\taddl\t$6, %%esp\n");
		ip_offset += 12;
		tmp=disp_list;
		disp_list=disp_list->next;
		free(tmp);
	}
	if (!(nl & 1)) {
		asm_call("newline");
		ip_offset += 5;
	}
}

void gen_gotoxy( int lin, int col ) {
	fprintf(o_src,"\tmovl\t$%d, %%eax\n",lin);
	fprintf(o_src,"\tpushl\t%%eax\n");
	fprintf(o_src,"\tmovl\t$%d, %%eax\n",col);
	fprintf(o_src,"\tpushl\t%%eax\n");
	asm_call("goxy");
	fprintf(o_src,"\tpopl\t%%ecx\n\tpopl\t%%ecx\n");
	ip_offset += 15;
}

void gen_accept( struct sym *sy, int echo ) {
	fprintf(o_src,"\tmovl\t$%d, %%eax\n\tpushl\t%%eax\n",echo);
	fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",sy->descriptor);
	fprintf(o_src,"\tpushl\t%%eax\n");
	gen_loadloc( sy );
	asm_call("htaccept");
	fprintf(o_src,"\taddl\t$10, %%esp\n");
	ip_offset += 17;
}

void gen_accept_from_time( struct sym *sy ) {
	gen_loadloc( sy );
	asm_call("accept_time");
	fprintf(o_src,"\taddl\t$4, %%esp\n");
	ip_offset += 8;
}

void gen_accept_from_date( struct sym *sy ) {
	gen_loadloc( sy );
	asm_call("accept_date");
	fprintf(o_src,"\taddl\t$4, %%esp\n");
	ip_offset += 8;
}

void gen_accept_from_inkey( struct sym *sy ) {
	gen_loadloc( sy );
	asm_call("accept_inkey");
	fprintf(o_src,"\taddl\t$4, %%esp\n");
	ip_offset += 8;
}

void gen_loaddesc( struct sym *var ) {
	fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",var->descriptor);
	fprintf(o_src,"\tpushl\t%%eax\n");
	ip_offset += 5;
}

/* load location for normal (file/working-storage) or linkage variable */
void load_location( struct sym *var ) {
	unsigned base,locoff;
	struct sym *tmp;
	if (!var->litflag && var->linkage_flg) {
		tmp=var;
		while (tmp->linkage_flg==1) tmp=tmp->parent;
		if (tmp==0)
			yyerror("linkage section broken");
		base = tmp->linkage_flg;
		locoff = tmp->location - var->location;
		fprintf(o_src,"\tmovl %d(%%ebp), %%ebx\n",base);
		if (locoff) {
			fprintf(o_src,"\taddl\t$%d, %%ebx\n",locoff);
			ip_offset += 3;
		}
		fprintf(o_src,"\tpushl\t%%ebx\n");
		ip_offset += 5;
		if (base > 128)
			ip_offset++;
	}
	else if (!var->litflag) {
		fprintf(o_src,"\tleal\t-%u(%%ebp), %%eax\n",var->location);
		fprintf(o_src,"\tpushl\t%%eax\n");
		ip_offset += 5;
		if (var->location > 128)
			ip_offset++;
	}
	else {
		fprintf(o_src,"\tmovl\t$v_base+%d, %%eax\n",var->location);
		fprintf(o_src,"\tpushl\t%%eax\n");
		ip_offset += 5;
	}
}

void gen_loadloc( struct sym *var ) {
	unsigned base,locoff;
	struct sym *tmp;
	if (!var->litflag && var->times) {
		gen_loadloc( var->index ); /* index first */
		fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",
			var->index->descriptor);
		fprintf(o_src,"\tpushl\t%%eax\n");
		asm_call("get_index");
		fprintf(o_src,"\taddl\t$8, %%esp\n");
			/* toma retorno c/valor do indice
				calcula offset (negativo) e salva em dx */
		fprintf(o_src,"\tdecl\t%%eax\n");
		fprintf(o_src,"\tmovl\t$%d, %%edx\n",var->tablen);
		fprintf(o_src,"\timull\t%%dx\n");
		fprintf(o_src,"\tmovl\t%%eax,%%edx\n");
		ip_offset += 21;
		if (var->linkage_flg) {
			tmp=var;
			while (tmp->linkage_flg==1) tmp=tmp->parent;
			if (tmp==0)
				yyerror("linkage section broken");
			base = tmp->linkage_flg;
			locoff = tmp->location - var->location;
			fprintf(o_src,"\tmovl %d(%%ebp), %%ebx\n",base);
			if (locoff) {
				fprintf(o_src,"\taddl\t$%d, %%ebx\n",locoff);
				ip_offset += 3;
			}
			fprintf(o_src,"\taddl\t%%edx, %%ebx\n");
			fprintf(o_src,"\tpushl\t%%ebx\n");
			ip_offset += 8;
		}
		else {
			fprintf(o_src,"\tleal\t-%u(%%ebp), %%eax\n", var->location);
			fprintf(o_src,"\taddl\t%%edx,%%eax\n");
			fprintf(o_src,"\tpushl\t%%eax\n");
			ip_offset += 7;
			if (var->location > 128)
				ip_offset++;
		}
	}
	else
		load_location( var );
}

void gen_loadvar( struct sym *var ) {
	gen_loadloc( var );
	fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",var->descriptor);
	fprintf(o_src,"\tpushl\t%%eax\n");
	ip_offset += 5;
}

void gen_move( struct sym *sy_src, struct sym *sy_dst ) {
#ifdef DEBUG_COMPILER
    fprintf(o_src,"; MOVE %s --> %s\n",sy_src->name,sy_dst->name);
#endif
    gen_loadvar( sy_dst );
	gen_loadvar( sy_src );
	asm_call("move");
	fprintf(o_src,"\taddl\t$16, %%esp\n");
	ip_offset += 8;
}

void gen_add( struct sym *s1, struct sym *s2 ) {
	gen_loadvar( s2 );
	gen_loadvar( s1 );
	asm_call("add");
	fprintf(o_src,"\taddl\t$16, %%esp\n");
	ip_offset += 8;
}

void gen_subtract( struct sym *s1, struct sym *s2 ) {
	gen_loadvar( s2 );
	gen_loadvar( s1 );
	asm_call("subtract");
	fprintf(o_src,"\taddl\t$16, %%esp\n");
	ip_offset += 8;
}

void gen_multiply( struct sym *s1, struct sym *s2, struct sym *s3 ) {
	gen_loadvar( s3 );
	gen_loadvar( s2 );
	gen_loadvar( s1 );
	asm_call("multiply");
	fprintf(o_src,"\taddl\t$24, %%esp\n");
	ip_offset += 8;
}

void gen_divide( struct sym *s1, struct sym *s2, struct sym *s3 ) {
	gen_loadvar( s3 );
	gen_loadvar( s2 );
	gen_loadvar( s1 );
	asm_call("divide");
	fprintf(o_src,"\taddl\t$24, %%esp\n");
	ip_offset += 8;
}

void gen_goto( struct sym *sy ) {
	line_info(2,sy->name,"");
	fprintf(o_src,"\tjmp\tB_%s\n",sy->name);
	ip_offset += 3;
	if ( ((sy->type == 'S') || (sy->type == 'P')) /* already located */
		&& ((ip_offset - sy->location) <= 128))
			ip_offset--;
}

unsigned long gen_at_end( int status ) {
	int i,j;
	union label_def label;
	i=loc_label++;
	j=loc_label++;
	fprintf(o_src,"\tcmp\t$%d, %%eax\n",status);
	fprintf(o_src,"\tjz\t%d\n",j);
	fprintf(o_src,"\tjmp\t%d\n",i);
	fprintf(o_src,"%d:\n",j);
	ip_offset += 8;
	label.l.n = i;
	label.l.off = label.l.defined = 0;
	return label.x;
}

unsigned long gen_testif( void ) {
	int i,j;
	union label_def label;
	i=loc_label++;
	j=loc_label++;
	fprintf(o_src,"\tjz\t%d\n",j);
	fprintf(o_src,"\tjmp\t%d\n",i);
	fprintf(o_src,"%d:\n",j);
	ip_offset += 5;
	label.l.n = i;
	label.l.off = label.l.defined = 0;
	return label.x;
}

void gen_not( void ) {
	int i,j;
	i=loc_label++;
	j=loc_label++;
	fprintf(o_src,"\tjz\tshort %d\n",i);
	fprintf(o_src,"\txorl\t%%eax,%%eax\n");
	fprintf(o_src,"\tjmp\tshort %d\n",j);
	fprintf(o_src,"%d:\tincl\t%%eax\n",i);
	fprintf(o_src,"%d:\n",j);
	ip_offset += 7;
}

unsigned long gen_andstart( void ) {
	int i;
	union label_def label;
	i=loc_label++;
	fprintf(o_src,"\tjnz\tshort %d\n",i);
	ip_offset += 2;
	label.l.n = i;
	label.l.off = label.l.defined = 0;
	return label.x;
}

unsigned long gen_orstart( void ) {
	int i;
	union label_def label;
	i=loc_label++;
	fprintf(o_src,"\tjz\tshort %d\n",i);
	ip_offset += 2;
	label.l.n = i;
	label.l.off = label.l.defined = 0;
	return label.x;
}

void gen_dstlabel( unsigned long lbl ) {
	char slab[32];
	union label_def label;
	label.x = lbl;
	sprintf( slab,"%d",label.l.n );
	label_info( slab );
	fprintf(o_src,"%d:\n",label.l.n);
	/*label.l.defined++;
	label.l.offset = ip_offset;*/
}

unsigned long gen_passlabel( void ) {
	int i;
	union label_def label;
	i=loc_label++;
	fprintf(o_src,"\tjmp\t%d\n",i);
	ip_offset += 3;
	label.l.off = label.l.defined = 0;
	label.l.n = i;
	return label.x;
}

unsigned long gen_marklabel( void ) {
	int i;
	union label_def label;
	i=loc_label++;
	fprintf(o_src,"%d:\n",i);
	label.l.off = ip_offset;
	label.l.defined = 1;
	label.l.n = i;
	return label.x;
}

void gen_jmplabel( unsigned long lbl ) {
	union label_def label;
	label.x = lbl;
	fprintf(o_src,"\tjmp\t%d\n",label.l.n);
	if (label.l.defined) {
		if ((ip_offset - label.l.off) <= 128)
			ip_offset += 2;
	}
	else
		ip_offset += 3;
}

void gen_perform_thru( struct sym *s1, struct sym *s2 ) {
	fprintf(o_src,"\tleal\t%d, %%eax\n",loc_label);
	fprintf(o_src,"\tpushl\t%%eax\n");
	fprintf(o_src,"\tleal\tB_%s, %%eax\n",s1->name);
	fprintf(o_src,"\tpushl\t%%eax\n");
	fprintf(o_src,"\tleal\tE_%s, %%eax\n",s2->name);
	fprintf(o_src,"\tpushl\t%%ax\n");
	fprintf(o_src,"\tjmp\tB_%s\n",s1->name);
	fprintf(o_src,"%d:\n",loc_label++);
	ip_offset += 19;
}

void gen_perform( struct sym *sy ) {
	gen_perform_thru( sy, sy );
}

void gen_picture( void ) {
	if (curr_field->type!='G') {
		curr_field->picstr = (char *)malloc(strlen(picture)+1);
		strcpy(curr_field->picstr,picture);
	}
}

void define_field( int level, struct sym *sy ) {
	struct sym *tmp;
	if (level == 88) {
		sy->type='8';
		sy->defined=1;
		sy->len=sy->tablen=0;
		sy->decimals=0;
		sy->level=level;
		sy->linkage_flg=at_linkage;
		sy->times=0;
		sy->occurs_flg=0;
		sy->son=sy->brother=NULL;
		if (curr_field->level==88) {
			curr_field->brother=sy;
			sy->parent=curr_field->parent;
		}
		else
			sy->parent=curr_field;
		curr_field=sy;
		return;
	}
	sy->len=sy->tablen=0;
	sy->decimals=-1; /* suppose no decimals yet */
	sy->level=level;
	sy->type='9'; /* assume numeric (elementary) item */
	sy->redefines = NULL;
	sy->linkage_flg=at_linkage;
	sy->times=0;
	sy->occurs_flg=0;
	sy->son = sy->brother = NULL;
	tmp=curr_field;
	if (tmp!=NULL && level == 1)
		close_fields();
	while (tmp != NULL && tmp->level > level)
		tmp=tmp->parent;
	if (tmp == NULL)
		sy->parent = NULL;
	else if (tmp->level < level) {
		sy->parent=tmp;
		if (tmp->son == NULL)
			tmp->son = sy;
		else
			yyerror("malformed data hierarchy");
	}
	else {
		tmp->brother = sy;
		sy->parent = tmp->parent;
	}
	curr_field=sy;
}

struct sym *alloc_filler( void ) {
	char s[15];
	struct sym *sy;
	sprintf(s,"FIL$%05d",filler_num++);
	sy = install(s,0);
	sy->defined=1;
	return sy;
}

void set_field_tablen( struct sym *sy, int tablen ) {
	struct sym *tmp;
	sy->tablen = tablen;
	for (tmp=sy->son;tmp!=NULL;tmp=tmp->brother)
		set_field_tablen( tmp,tablen );
}

int set_field_length( struct sym *sy, int times ) {
	struct sym *tmp;
	int len,tmplen;
	len = sy->len;
	if (sy->son != NULL)
		sy->type = 'G';
	if (sy->occurs_flg)
		times = sy->times;
	else if (times)
		sy->times = times;
	for (tmp=sy->son;tmp!=NULL;tmp=tmp->brother) {
		tmplen = set_field_length( tmp,times );
		if (tmp->redefines == NULL)
			if (tmp->occurs_flg)
				len += tmplen * tmp->times;
			else
				len += tmplen;
	}
	sy->len = len;
	if (sy->occurs_flg)
		set_field_tablen( sy, len );
	return sy->len;
}

void set_field_location( struct sym *sy, unsigned location ) {
	struct sym *tmp;
	/********* allocate field descriptor *************/
	sy->descriptor = literal_offset;
	literal_offset += (sy->type=='G' ? 5 : 9);
	/********* generate picture for field ************/
	if (sy->type!='G') {
		sy->pic = literal_offset;
		literal_offset += (strlen(sy->picstr)+1);
	}
	else
		sy->decimals = sy->pic = 0;
	save_field_in_list( sy );
	if (sy->redefines != NULL)
		location = sy->redefines->location;
	sy->location = location;
	for (tmp=sy->son;tmp!=NULL;tmp=tmp->brother) {
		set_field_location( tmp,location );
		if (tmp->redefines == NULL)
			location -= tmp->len;	/* negative for it's at the stack */
	}
}

void update_field( void ) {
	if (curr_field->level != 88)
		gen_picture();
}

void close_fields( void ) {
	struct sym *sy;
	if (curr_field == NULL) return;
	/********** locate level 01 field   **************/
	for (sy=curr_field;sy->parent!=NULL;sy=sy->parent);
	/********** update length of fields  *************/
	if (sy->linkage_flg) {
		linkage_offset += set_field_length( sy,0 );
		set_field_location( sy,linkage_offset );
	}
	else {
		stack_offset += set_field_length( sy,0 );
		set_field_location( sy,stack_offset );
	}
	curr_field=NULL;
}

void open_section( struct sym *sect ) {
	sect->type='S';
	sect->location=ip_offset;
	label_info( sect->name );
	fprintf(o_src,"B_%s:\n",sect->name);
	curr_section=sect;
}

void close_section( void ) {
	if (curr_section)
		fprintf(o_src,"E_%s:\n",curr_section->name);
	close_paragr();
}

void close_paragr( void ) {
	if (curr_paragr) {
		fprintf(o_src,"E_%s:\n",curr_paragr->name);
		gen_exit(0);
		curr_paragr=NULL;
	}
}

void open_paragr( struct sym *paragr ) {
	paragr->type='P';
	paragr->location=ip_offset;
	curr_paragr=paragr;
	label_info( paragr->name );
	fprintf(o_src,"B_%s:\n",paragr->name);
}

void gen_stoprun( void ) {
	asm_call("stop_run");
	ip_offset += 5;
}

void gen_exit( int code ) {
	if (code) {
		fprintf(o_src,"\tmov\t%%esp,%%ebp\n");
		fprintf(o_src,"\tpop\t%%ebp\n");
		fprintf(o_src,"\tret\n");
		ip_offset += 4;
	}
	else {
		fprintf(o_src,"\tleal\tE_%s, %%eax\n",curr_paragr->name);
		fprintf(o_src,"\tpushl\t%%eax\n");
		asm_call("exit_paragraph");
		fprintf(o_src,"\tpopl\t%%ecx\n");
		ip_offset += 11;
	}
}

void gen_condition( struct sym *sy ) {
	gen_loadvar((struct sym *)sy->value2);
	gen_loadvar((struct sym *)sy->value);
	gen_loadvar(sy->parent);
	asm_call("check_condition");
	fprintf(o_src,"\taddl\t$24, %%esp\n");
	fprintf(o_src,"\tand\t%%eax,%%eax\n");
	ip_offset += 10;
}

void gen_compare( struct sym *s1, int value, struct sym *s2 ) {
	gen_loadloc(s2);
	fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",s2->descriptor);
	fprintf(o_src,"\tpushl\t%%eax\n");
	gen_loadloc(s1);
	fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",s1->descriptor);
	fprintf(o_src,"\tpushl\t%%eax\n");
	asm_call("compare");
	fprintf(o_src,"\taddl\t$16, %%esp\n");
	ip_offset += 18;
	switch (value) {
	case 0: fprintf(o_src,"\txor\t%%eax,%%eax\n\tinc\t%%eax\n"); /* false */
		ip_offset += 3;
		break;
	case 1: fprintf(o_src,"\tand\t%%eax,%%eax\n"); /* equal */
		ip_offset += 2;
		break;
	case 2: fprintf(o_src,"\tinc\t%%eax\n"); /* less */
		ip_offset++;
		break;
	case 3: fprintf(o_src,"\tdec\t%%eax\n"); /* less or equal */
		ip_offset++;
		gen_not();
		break;
	case 4:	fprintf(o_src,"\tdec\t%%eax\n"); /* greater */
		ip_offset++;
		break;
	case 5: fprintf(o_src,"\tinc\t%%eax\n"); /* greater or equal */
		ip_offset++;
		gen_not();
		break;
	case 6: fprintf(o_src,"\tand\t%%eax,%%eax\n"); /* not equal */
		ip_offset += 2;
		gen_not();
		break;
	case 7:	fprintf(o_src,"\txor\t%%eax,%%eax\n"); /* true */
		ip_offset += 2;
		break;
	}
}

void assign_expr( struct sym *sy ) {
	gen_loadvar( sy );
	asm_call("assign_double");
	fprintf(o_src,"\taddl\t$16, %%esp\n"); /* pop expr also */
	ip_offset += 8;
}

void push_expr( struct sym *sy ) {
	fprintf(o_src,"\tsubl\t$8, %%esp\n");
	gen_loadvar( sy );
	asm_call("push_double");
	fprintf(o_src,"\taddl\t$8, %%esp\n");
	ip_offset += 11;
}

void add_expr( void ) {
	asm_call("add_double");
	fprintf(o_src,"\taddl\t$8, %%esp\n");
	ip_offset += 8;
}

void subtract_expr( void ) {
	asm_call("subtract_double");
	fprintf(o_src,"\taddl\tsp,8\n");
	ip_offset += 8;
}

void multiply_expr( void ) {
	asm_call("multiply_double");
	fprintf(o_src,"\taddl\tsp,8\n");
	ip_offset += 8;
}

void divide_expr( void ) {
	asm_call("divide_double");
	fprintf(o_src,"\taddl\tsp,8\n");
	ip_offset += 8;
}

static void gen_save_filevar( struct sym *f, struct sym *buf ) {
	if (buf!=NULL)
		gen_loadloc( buf );
	fprintf(o_src,"\tleal\t-%u(%%ebp), %%eax\n",f->var_fd);
	fprintf(o_src,"\tpushl\t%%eax\n");
	if (f->type=='K')
		fprintf(o_src,"\tmovl\t$_%s, %%eax\n",f->name);
	else
		fprintf(o_src,"\tmov\t$s@+%u, %%eax\n",f->location);
	fprintf(o_src,"\tpushl\t%%eax\n");
	ip_offset += 10;
	if (f->var_fd > 128)
		ip_offset++;
}

static void gen_prtvar( struct sym *r, struct sym *buf ) {
	struct sym *f;
	f=r->ix_desc;
	if (buf!=NULL)
		gen_loadloc( buf );
	fprintf(o_src,"\tleal\t-%u(%%ebp), %%eax\n",f->var_fd);
	fprintf(o_src,"\tpushl\t%%eax\n");
	if (buf != NULL)
		fprintf(o_src,"\tmovl\t$%d, %%eax\n",buf->len);
	else
		fprintf(o_src,"\tmovl\t$%d, %%eax\n",r->len);
	fprintf(o_src,"\tpushl\t%%eax\n");
	ip_offset += 10;
	if (f->var_fd > 128)
		ip_offset++;
}

static int gen_save_sort_fields( struct sym *f, struct sym *buf ) {
	struct sym *datafld;
	int stkadd=4;
	datafld = (struct sym *)f->sort_data;
	while (datafld!=NULL) {
		gen_loadloc( datafld );
		stkadd += 4;
		datafld=(struct sym *)(datafld->sort_data);
	}
	fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",f->descriptor);
	fprintf(o_src,"\tpushl\t%%eax\n");
	gen_save_filevar( f,buf );
	ip_offset += 5;
	if (buf!=NULL)
		stkadd+=2;
	return stkadd;
	/* returns number of stack levels used in storing fields */
}

void alloc_file_entry( struct sym *f ) {
	stack_offset += sizeof( struct var_fd );
	f->var_fd = stack_offset;
#ifdef DEBUG_COMPILER
	fprintf(o_src,"; Alloc space for file ENTRY, Stack Addr: %d\n",
			stack_offset);
#endif
}

void gen_fdesc( struct sym *f, struct sym *r ) {
	int len;
	r->ix_desc=f;
	if (f->type=='K') {
		fprintf(o_src,"\t.extern\t_%s:far\n",f->name);
		return;
	}
	if (f->type=='J') {
		fprintf(o_src,"\tpublic\t_%s\n",f->name);
		fprintf(o_src,"_%s\tlabel\tbyte\n",f->name);
	}
	fprintf(o_src,"\t.long\t$v_base+%u\n\t.word\t%u\n",
		f->value->location,r->len);
	fprintf(o_src,"\t.byte\t%d,%d\n",f->organization,f->access_mode);
	fprintf(o_src,"\t.word\t0,0\n");  /* handle & users */
	len=12; /* suppose without indexes */
	if (f->organization==1) { /* indexed file */
		len += (6+sizeof( IX_DESC )); /* from Bplus header */
		fprintf(o_src,"\t.word\t%d\n\t.long\t$v_base+%d\n",
			r->location - f->ix_desc->location,
			f->ix_desc->descriptor );
		fprintf(o_src,"\t.fill\t%d, 1, '?'\n",sizeof( IX_DESC ));
	}
	f->fdesc = global_offset;
	global_offset += len;
#ifdef DEBUG_COMPILER
	fprintf(o_src,"\t\t; FILE DESCRIPTOR, File: %s, Record: %s, Data Loc: %d, DescLen: %d\n",
		f->name,r->name,global_offset,len);
#endif
/*	if (f->organization==1)
		stack_offset += sizeof( struct var_fd ) + f->ix_desc->len;
	else
		stack_offset += sizeof( struct var_fd );
	f->var_fd = stack_offset;
*/
}

void gen_status( struct sym *f ) {
	if (f->parent) {
		fprintf(o_src,"\tpushl\t%%eax\n");
		gen_loadloc( f->parent );
		asm_call("save_status");
		fprintf(o_src,"\taddl\t$6,%%esp\n");
		ip_offset += 9;
	}
}

void gen_open_prn( struct sym *f ) {
	gen_save_filevar( f,NULL );
	if (f->level==-1) {
		gen_loadvar( f->index );
		asm_call("get_index");
		fprintf(o_src,"\taddl\t$8, %%sp\n");
		fprintf(o_src,"\tpushl\t%%eax\n");
		ip_offset += 9;
	}
	else {
		fprintf(o_src,"\tmov\t$%d, %%eax\n",f->level & 7);
		fprintf(o_src,"\tpushl\t%%eax\n");
		ip_offset += 4;
	}
	asm_call("open_prn");
	fprintf(o_src,"\taddl\t$10, %%esp\n");
	gen_status(f);
	ip_offset += 8;
}

void gen_close_prn( struct sym *f ) {
	gen_save_filevar( f,NULL );
	asm_call("close_prn");
	fprintf(o_src,"\taddl\t$8, %%esp\n");
	gen_status(f);
	ip_offset += 8;
}

void gen_sort( struct sym *f ) {
	gen_save_filevar( f,NULL );
	asm_call("sort_open");
	fprintf(o_src,"\taddl\t$8, %%esp\n");
	ip_offset += 8;
}

void gen_open( int mode, struct sym *f ) {
	fprintf(o_src,"\tmovl\t$%d, %%eax\n",mode);
	fprintf(o_src,"\tpushl\t%%eax\n");
	gen_save_filevar( f,NULL );
	asm_call("mc_open");
	fprintf(o_src,"\taddl\t$10, %%esp\n");
	gen_status(f);
	ip_offset += 12;
}

void gen_close_sort( struct sym *f ) {
	struct sym *sortf;
	/********** allocate memory for SORT descriptor ***********/
	save_field_in_list( f );
	f->descriptor = literal_offset;
	sortf=(struct sym *)(f->sort_data);
	while (sortf!=NULL) {
		literal_offset += 2;
		sortf = (struct sym *)(sortf->sort_data);
	}
	literal_offset++;
}

void gen_close( struct sym *f ) {
	gen_save_filevar( f,NULL );
	asm_call("mc_close");
	fprintf(o_src,"\taddl\t$8, %%esp\n");
	gen_status(f);
	ip_offset += 8;
}

void gen_return( struct sym *f, struct sym *buf ) {
	gen_save_filevar( f,buf );
	if (buf==NULL)
		asm_call("sort_return");
	else
		asm_call("return_into");
	if (buf!=NULL)
		fprintf(o_src,"\taddl\t$12, %%esp\n");
	else
		fprintf(o_src,"\taddl\t$8, %%esp\n");
	gen_status(f);
	ip_offset += 8;
}

void gen_read( struct sym *f, struct sym *buf ) {
	if (f->organization==3 && f->access_mode!=1) {
		gen_loadloc( f->ix_desc );
		fprintf(o_src,"\tmovl $v_base+%u, %%eax\n",
			f->ix_desc->descriptor);
		fprintf(o_src,"\tpushl\t%%eax\n");
		asm_call("get_index");
		fprintf(o_src,"\taddl\t$8, %%esp\n");
		fprintf(o_src,"\tpushl\t%%eax\n");
		ip_offset += 14;
	}
	gen_save_filevar( f,buf );
	if (buf==NULL)
		asm_call("mc_read");
	else
		asm_call("read_into");
	if (f->organization==3 && f->access_mode!=1)
		if (buf==NULL)
			fprintf(o_src,"\taddl\t$10, %%esp\n");
		else
			fprintf(o_src,"\tadd\t$14, %%esp\n");
	else
		if (buf==NULL)
			fprintf(o_src,"\taddl\t$8, %%esp\n");
		else
			fprintf(o_src,"\taddl\t$12, %%esp\n");
	gen_status(f);
	ip_offset += 8;
}

void gen_read_next( struct sym *f, struct sym *buf, int next_prev ) {
	gen_save_filevar( f,buf );
    if (buf==NULL) {
        if (next_prev == 1)
            asm_call("mc_read_next");
        else
            asm_call("mc_read_prev");
    }
    else {
        if (next_prev == 1)
            asm_call("read_next_into");
        else
            asm_call("read_prev_into");
    }
	if (buf==NULL)
		fprintf(o_src,"\taddl\t$8, %%esp\n");
	else
		fprintf(o_src,"\taddl\t$12, %%esp\n");
	gen_status(f);
	ip_offset += 8;
}

void gen_release( struct sym *r, struct sym *buf ) {
	struct sym *f;
	int stkadd;
	f=r->ix_desc;
	stkadd = gen_save_sort_fields( f,buf );
	if (buf==NULL)
		asm_call("sort_release");
	else
		asm_call("release_from");
	fprintf(o_src,"\taddl\t$%d, %%esp\n",stkadd+8);
	ip_offset += 8;
	gen_status(f);
}

void gen_write( struct sym *r, int opt, struct sym *buf ) {
	struct sym *f;
	f=r->ix_desc;
	if (opt) {
		fprintf(o_src,"\tmovl\t$%d, %%eax\n",opt);
		fprintf(o_src,"\tpushl\t%%eax\n");
		ip_offset += 4;
	}
	if (opt) {
		gen_prtvar( r,buf );
		if (buf==NULL)
			asm_call("write_adv");
		else
			asm_call("write_adv_from");
	}
	else if (f->level) {	/* assign option != DISK */
		gen_prtvar( r,buf );
		if (buf==NULL)
			asm_call("write_prt");
		else
			asm_call("write_prt_from");
	}
	else {
		gen_save_filevar( f,buf );
		if (buf==NULL)
			asm_call("mc_write");
		else
			asm_call("write_from");
	}
	if (opt>0)
		if (buf==NULL)
			fprintf(o_src,"\taddl\t$16, %%esp\n");
		else
			fprintf(o_src,"\taddl\t$20, %%esp\n");
	else if (opt)
		if (buf==NULL)
			fprintf(o_src,"\taddl\t$8, %%esp\n");
		else
			fprintf(o_src,"\taddl\t$12, %%esp\n");
	else if (f->level)
		if (buf==NULL)
			fprintf(o_src,"\taddl\t$6, %%esp\n");
		else
			fprintf(o_src,"\taddl\t$10, %%esp\n");
	else
		if (buf==NULL)
			fprintf(o_src,"\taddl\t$8, %%esp\n");
		else
			fprintf(o_src,"\taddl\t$12, %%esp\n");
	gen_status(f);
	ip_offset += 8;
}

void gen_rewrite( struct sym *r, struct sym *buf ) {
	struct sym *f;
	f=r->ix_desc;
	gen_save_filevar( f,buf );
	if (buf==NULL)
		asm_call("mc_rewrite");
	else
		asm_call("rewrite_from");
	if (buf==NULL)
		fprintf(o_src,"\taddl\t$8, %%esp\n");
	else
		fprintf(o_src,"\taddl\t$12, %%esp\n");
	gen_status(f);
	ip_offset += 8;
}

void gen_start( struct sym *file, struct sym *buf ) {
	gen_save_filevar( file,buf );
	if (buf == NULL)
		asm_call("mc_start");
	else
		asm_call("mc_start_from");
	if (buf!=NULL)
		fprintf(o_src,"\taddl\t$12, %%esp\n");
	else
        	fprintf(o_src,"\taddl\t$8, %%esp\n");
	gen_status(file);
	ip_offset += 8;
}

void gen_delete( struct sym *file ) {
	gen_save_filevar( file,NULL );
	asm_call("mc_delete");
	fprintf(o_src,"\taddl\t$8, %%esp\n");
	gen_status(file);
	ip_offset += 8;
}

void gen_push_using( struct sym *sy ) {
	struct list *list;
	if (sy->type=='F')
		yyerror("file could not be used as parameter in a CALL");
	list = (struct list *)malloc(sizeof(struct list));
	list->var = (void *)sy;
	list->next = parameter_list;
	parameter_list = list;
}

void gen_save_using( struct sym *sy ) {
	sy->linkage_flg = using_offset;
	using_offset += 4;
}

void gen_call( struct lit *v, int stack_size ) {
	struct list *list,*tmp;
	/******** get the parameters from the parameter list ********/
	for (list=parameter_list;list!=NULL;) {
		gen_loadloc((struct sym *)list->var);
		tmp=list;
		list=list->next;
		free(tmp);
	}
	parameter_list=NULL;
	asm_call(v->name);
	fprintf(o_src,"\taddl\t$%d, %%esp\n",stack_size);
	ip_offset += 8;
	if (stack_size>128) ip_offset++;
}

void gen_link_extrn( void ) {
	struct list *list;
	for (list=call_list;list!=NULL;list=list->next)
		fprintf(o_src,"\t.extern\t_%s:far\n",(char *)list->var);
}

void mark_actives( int first, int last ) {
	int i;
	if (last<first) last=first;
	if (first<0 || first>36) first=0;
	if (last<0 || last>36) last=0;
	for (i=first;i<=last;i++) active[i]=1;
}

void mark_line( void ) {
	last_lineno = lineno;
	last_ip_offset = ip_offset;
}

void line_info( int t, char *label, char *label2 ) {
	if (!debug_flag) return;
/*
	if (t==3 || t==5 || t==6)
		fprintf(o_src,"; Line %d %04x\n",last_lineno,last_ip_offset);
	else
		fprintf(o_src,"; Line %d %04x\n",lineno,ip_offset);
*/
	/***** tipos 1,2,4 gerados para limpar breakpoints apos trace ****/
	switch(t) {
	case 1:
		fprintf(o_deb,"$%d 1 %d @%d\n",lineno,ip_offset,loc_label);
		break;
	case 2:
		fprintf(o_deb,"$%d 2 %d %s\n",lineno,ip_offset,label);
		break;
	case 3:
		fprintf(o_deb,"$%d 3 %d %s\n",last_lineno,last_ip_offset,label);
		break;
	case 4:
		fprintf(o_deb,"$%d 4 %d @%d\n",lineno,ip_offset,loc_label);
		break;
	case 5:
		fprintf(o_deb,"$%d 1 %d @%d\n",last_lineno,last_ip_offset,
			loc_label,1); /* tipo 1 -- usado por 'if_part' */
		break;
	case 6:
		fprintf(o_deb,"$%d 6 %d %s %s\n",last_lineno,last_ip_offset,
			label,label2);
		break;
	default:
		fprintf(o_deb,"$%d 0 %d\n",lineno,ip_offset);
	}
}

void label_end( void ) {
	if (!debug_flag) return;
	fprintf(o_deb,"\n");
}

void label_info( char *label ) {
	if (!debug_flag) return;
	fprintf(o_deb,"%%%s %d\n",label,ip_offset);
}

void dump_symbols( short debug_flag ) {
	int i;
	struct sym *sy;
	char t;
if (list_flag) {
	fprintf(o_lst,"--------------------------------------------------------+---------------\n");
	fprintf(o_lst,"Symbol ( Variables )      Type Level Len Dec Mul Tablen | Desc Loc  Pic\n");
	fprintf(o_lst,"--------------------------------------------------------+---------------\n");
}
	for (i=0;i<HASHLEN;i++)
	    for (sy=symtab[i];sy!=NULL;sy=sy->next) {
		t=sy->type;
        if (sy->type == 0) {
            fprintf(stderr,"\n*** Fatal error, variable %s not defined ***\n",
                sy->name);
            exit(1);
        }
		if (t=='9' || t=='X' || t=='G' || t=='E' || t=='C') {
if (list_flag)		fprintf(o_lst,"%26.26s %4c %5d %3d %3d %3d %6d | %04X %04X%c%04X\n",
				sy->name,
				sy->type,
				sy->level,
				sy->len,
				sy->decimals,
				sy->times,
				sy->tablen,
				sy->descriptor,
				sy->location,
				sy->linkage_flg ? '*' : ' ',
				sy->pic );
		if (debug_flag)
			if (sy->type=='C')
				fprintf(o_deb,"%s C %d %d %d\n",
					sy->name,sy->location,sy->len,
					sy->tablen);
			else
				fprintf(o_deb,"%s %d %d %d\n",
					sy->name,sy->location,sy->len,
					sy->tablen);
		}
	    }
if (list_flag) {
	fprintf(o_lst,"\n-----------------------------------------------\n");
	fprintf(o_lst,"Symbol ( 88-condition )       Variable tested");
	fprintf(o_lst,"\n-----------------------------------------------\n");
	for (i=0;i<HASHLEN;i++)
	    for (sy=symtab[i];sy!=NULL;sy=sy->next) {
		t=sy->type;
		if (t=='8')
			fprintf(o_lst,"%22.22s %22.22s\n",
				sy->name,
				sy->parent->name);
	    }
	fprintf(o_lst,"\n------------------------------------------\n");
	fprintf(o_lst,"Symbol ( Paragraphs & Sections ) Type Def \n");
	fprintf(o_lst,"------------------------------------------\n");
	for (i=0;i<HASHLEN;i++)
	    for (sy=symtab[i];sy!=NULL;sy=sy->next) {
		t=sy->type;
		if (t=='P' || t=='S')
			fprintf(o_lst,"%32.32s %4c %3d\n",
				sy->name,
				sy->type,
				sy->defined );
	    }
  }
}

int main(int argc, char *argv[] )
{
	char inputname[64];
	char outputname[64];
	char lstname[64];
	char debname[64];
	char sw;
	char **nargv,**tmpargv,*p;
	int nargc;
	tmpargv=argv;
	nargc=argc;
	for (nargv=++tmpargv;--nargc>0;tmpargv++) {
		if (**tmpargv != '-')
			*nargv++ = *tmpargv;
		else {
			argc--;		/* count down, it's a switch-char */
			p=(*tmpargv)+1;	/* bypass '-' in switches */
			while ((sw=*p++)!=0)
				switch (toupper(sw)) {
				case 'D': debug_flag++; break;
				case 'L': list_flag++; break;
				case 'O': overlay_flag++; break;
				default:
					fprintf(stderr,"\nunknown switch\n");
					fprintf(stderr,"\nvalid switches are:\n");
					fprintf(stderr,"\t-d debug file\n");
					fprintf(stderr,"\t-l listing\n");
					fprintf(stderr,"\t-o overlay compile\n");
					exit(1);
				}
		}
	}
	if (argc<2) {
        fprintf(stderr,"\nusage: htcobol [-dl] <filename>\n");
		exit(1);
	}
    printf("\nHTCobol Compiler -- Version  3.2\n");
	printf("(C) 1993 Rildo Pragana\n\n");
	printf("Processing '%s'.\n", argv[1]);
	strcpy(inputname,argv[1]);
	strcat(inputname,".cob");
	strcpy(outputname,argv[1]);
	strcat(outputname,".asm");
	strcpy(lstname,argv[1]);
	strcat(lstname,".lis");
	strcpy(debname,argv[1]);
	strcat(debname,".dbg");
	printf("bar\n");
	if ((app_in=fopen(inputname,"r"))==NULL) {
		fprintf(stderr,"Input file not found\n");
		exit(1);
	}
	if ((o_src=fopen(outputname,"w"))==NULL) {
		fprintf(stderr,"Output file could not be opened\n");
		exit(1);
	}
	install_reserved();
	if (debug_flag)
		if ((o_deb=fopen(debname,"w"))==NULL) {
			fprintf(stderr,"Debug file could not be opened\n");
			exit(1);
		}
if (list_flag)
	if ((o_lst=fopen(lstname,"w"))==NULL) {
		fprintf(stderr,"Listings file could not be opened\n");
		exit(1);
	}
	printf("\nParsing input file...\n");
	yyparse();
	printf("\rLines compiled: %4d",lineno);
	printf("\nWriting listing tables...");
	dump_symbols(debug_flag);
	printf("\nUsed stack words: %d\n",stack_offset/2);
	if (debug_flag)
		fclose(o_deb);
	if (list_flag)
		fclose(o_lst);
	fclose(o_src);
	fclose(app_in);
	printf("\nCompiling done!\n");
	return 0;
}

/* end of MCOBGEN.C */
