#include    <stdio.h>
#include	<stdlib.h>
#include	<conio.h>

#include	"sbtype.h"
#include	"ptsbinit.h"
#include	"ptconfig.h"

#include	"wp.h"

#define	PT_DATA_PORT		gwPTBaseIO
#define	PT_INDEX_PORT 		(gwPTBaseIO + 0x02)

/* Data table for virtualizing write-only registers */
WORD wIDRRegDataTable[0x1F];

/* Read/Write access for Indexed Data Registers */
BYTE bIDRAccessTable[] = {
                                _RW, _RW, _RW, _RW,
                                _RW, _RW, _WO, _WO,
                                _WO, _WO, _WO, _WO,
                                _WO, _WO, _WO, _WO,
                                _WO, _WO, _RW, _WO,
                                _RO, _RW, _RW, _WO
                                };


/*****************************************************************************/
/* Write IDR Register Index                                                  */
/*                                                                           */
/*****************************************************************************/
void	vWrIDRIndex( WORD _wRegIndex )
	{
	outpw( PT_INDEX_PORT, _wRegIndex );
	}
	
/*****************************************************************************/
/* Read IDR Register Index                                                   */
/*                                                                           */
/*****************************************************************************/
WORD	wRdIDRIndex( void )
	{
	return( (WORD) inpw( PT_INDEX_PORT ) );
	}
	
/*****************************************************************************/
/* Write IDR Register Data                                                   */
/*                                                                           */
/*****************************************************************************/
void	vWrIDRData( WORD _wRegData )
	{
    outpw( PT_DATA_PORT, _wRegData );
	}

/*****************************************************************************/
/* Read IDR Register Data                                                    */
/*                                                                           */
/*****************************************************************************/
WORD	wRdIDRData( void )
	{
	return( (WORD)inpw( PT_DATA_PORT ) );
	}
	
/*****************************************************************************/
/* Write IDR Register                                                        */
/*                                                                           */
/*****************************************************************************/
void	vWrIDR( WORD _wRegIndex, WORD _wRegData )
    {
    vWrIDRIndex( _wRegIndex );

    vWrIDRData( _wRegData );

    wIDRRegDataTable[ _wRegIndex ] = _wRegData;
    }
				
/*****************************************************************************/
/* Read IDR Register                                                         */
/*                                                                           */
/*****************************************************************************/
WORD	wRdIDR( WORD _wRegIndex )
    {
    WORD    wRetVal;

    vWrIDRIndex( _wRegIndex );

    switch( bIDRAccessTable[ _wRegIndex ] )
        {
        case _RW:
        case _RO:
            wRetVal = wRdIDRData( );
            break;

        case _WO:
            wRetVal = wIDRRegDataTable[ _wRegIndex ];
            break;
        }

    return( wRetVal );
    }


/*****************************************************************************/
/* Set IDR Register Bit                                                      */
/*                                                                           */
/*****************************************************************************/
void    vSetIDRBit( WORD _wRegIndex, BYTE _bRegBit )
	{
	vWrIDR( _wRegIndex, WSETBIT( wRdIDR( _wRegIndex ), _bRegBit ) );
	}

/*****************************************************************************/
/* Mask IDR Register Bit                                                     */
/*                                                                           */
/*****************************************************************************/
void    vMskIDRBit( WORD _wRegIndex, BYTE _bRegBit )
	{
	vWrIDR( _wRegIndex, WMSKBIT( wRdIDR( _wRegIndex ), _bRegBit ) );
	}
	
/*****************************************************************************/
/* Test IDR Register Bit                                                     */
/*                                                                           */
/*****************************************************************************/
BYTE    bTstIDRBit( WORD _wRegIndex, BYTE _bRegBit )
    {
    return( (BYTE)( WTSTBIT( wRdIDR( _wRegIndex ), _bRegBit ) ) );
    }


/*****************************************************************************/
/* Write Wave Ram Address                                                    */
/*                                                                           */
/*****************************************************************************/
void	vWrWRamIndex( DWORD _dwWRamAddr )
	{
	vWrIDR( IDR4_WAVE_PTR_LO, LOWORD( _dwWRamAddr ) );
    vWrIDR( IDR5_WAVE_PTR_HI, (WORD)( LOBYTE( HIWORD( _dwWRamAddr ) ) | ( wRdIDR( IDR5_WAVE_PTR_HI ) & 0xFF00 ) ) );
	}

/*****************************************************************************/
/* Read Wave Ram Address                                                     */
/*                                                                           */
/*****************************************************************************/
DWORD	dwRdWRamIndex( void )
	{
	return( MAKEDWORD( wRdIDR( IDR4_WAVE_PTR_LO ), LOBYTE( wRdIDR( IDR5_WAVE_PTR_HI ) ) ) );
	}
	
/*****************************************************************************/
/* Write Wave Ram Data Register                                              */
/*                                                                           */
/*****************************************************************************/
void	vWrWRamData( WORD _wWRamData )
	{
	vWrIDR( IDR3_WAVE_DATA, _wWRamData );
	}
	
/*****************************************************************************/
/* Read Wave Ram Data Register                                               */
/*                                                                           */
/*****************************************************************************/
WORD	wRdWRamData( void )
	{
	return( wRdIDR( IDR3_WAVE_DATA ) );
	}
	
/*****************************************************************************/
/* Write Wave Ram Memory                                                     */
/*                                                                           */
/*****************************************************************************/
void	vWrWRam( DWORD _dwWRamAddr, WORD _wWRamData )
	{
	vWrWRamIndex( _dwWRamAddr );
	vWrWRamData( _wWRamData );
	}
	
/*****************************************************************************/
/* Read Wave Ram Data                                                        */
/*                                                                           */
/*****************************************************************************/
WORD	wRdWRam( DWORD _dwWRamAddr )
	{
	vWrWRamIndex( _dwWRamAddr );
	return( wRdWRamData( ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vPrintBinary( WORD _wData )
	{
	BYTE	bIndex;
	
	for( bIndex=0; bIndex < 16; bIndex++ )
		{
		printf("%c", BTSTBIT( _wData, 15 - bIndex ) + '0' );
		}
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
DWORD   HwDetermineLocalRAMSize( void )
	{
	WORD    wTestWord = 0xAA55;

	DWORD   dwIndex;

    DWORD   dwBase = MAKEDWORD( 0x0000, (WORD)bGetRamSplit() );

    for ( dwIndex=0x000000; dwIndex < 0x400000; dwIndex+=0x100000 )
		{
        vWrWRam( dwBase + dwIndex, wTestWord );
        vWrWRam( 0xFFFFFF, 0x0000 );
        }

    for ( dwIndex=0x000000; dwIndex < 0x400000; dwIndex+=0x100000 )
		{
        if( wRdWRam( dwBase + dwIndex ) != wTestWord )
			{
			break;
			}
		}

    vPTSBInit(1);

    return( dwIndex >> 1 );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetVirtualWaveEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskIDRBit( 0x07, 10 );
            break;

        case ENABLE:
            vSetIDRBit( 0x07, 10 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetVirtualWaveEnable( void )
    {
    return( bTstIDRBit( 0x07, 10 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSet8BitRamEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskIDRBit( 0x07, 9 );
            break;

        case ENABLE:
            vSetIDRBit( 0x07, 9 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGet8BitRamEnable( void )
    {
    return( bTstIDRBit( 0x07, 9 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDRamEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskIDRBit( 0x07, 8 );
            break;

        case ENABLE:
            vSetIDRBit( 0x07, 8 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDRamEnable( void )
    {
    return( bTstIDRBit( 0x07, 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetRamSplit( BYTE _bSplit )
    {
    vWrIDR( 0x07, (WORD)( ( wRdIDR( 0x07 ) & 0xFF00 ) | _bSplit ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetRamSplit( void )
    {
    return( LOBYTE( wRdIDR( 0x07 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetParallelInBase( BYTE _bBase )
    {
    vWrIDR( 0x0C, (WORD)( ( wRdIDR( 0x0C ) & 0x0FFF ) | ( (WORD)_bBase << 12 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetParallelInBase( void )
    {
    return( (BYTE)( ( wRdIDR( 0x0C ) & 0xF000 ) >> 12 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetParallelOutBase( BYTE _bBase )
    {
    vWrIDR( 0x0C, (WORD)( ( wRdIDR( 0x0C ) & 0xF0FF ) | ( (WORD)_bBase << 8 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetParallelOutBase( void )
    {
    return( (BYTE)( ( wRdIDR( 0x0C ) & 0x0F00 ) >> 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetSerialBase0( BYTE _bBase )
    {
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetSerialBase0( void )
    {
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetSerialBase1( BYTE _bBase )
    {
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetSerialBase1( void )
    {
    }

