#include	<stdio.h>
#include	<stdlib.h>
#include	<conio.h>

#include	"sbtype.h"
#include	"ptconfig.h"

#include	"wavcache.h"

#define WAVERAM_START  		0x400000


#define WAVE_CACHE_INDEX    (gwPTBaseIO + 0x10)
#define	WAVE_CACHE_DATA		(gwPTBaseIO + 0x12)

#define WAVE_CACHE_CONTROL  (gwPTBaseIO + 0x14)


#define	WC_CH0_BASE		0x01F0
#define	WC_CH1_BASE		0x01F1
#define	WC_CH2_BASE		0x01F2
#define	WC_CH3_BASE		0x01F3
#define	WC_CH4_BASE		0x01F4
#define	WC_CH5_BASE		0x01F5
#define	WC_CH6_BASE		0x01F6
#define	WC_CH7_BASE		0x01F7
#define	WC_CH8_BASE		0x01F8
#define	WC_CH9_BASE		0x01F9
#define	WC_CHA_BASE		0x01FA
#define	WC_CHB_BASE		0x01FB

#define WC_PCM0_BASE	0x01FC
#define	WC_PCM1_BASE	0x01FD
#define	WC_PCM2_BASE	0x01FE
#define	WC_PCM3_BASE	0x01FF

/*

	Timer
*/

/* 
	Wave Cache Control Registers:
				0x0000 - Channel 0 Control Registers
				0x0008 - Channel 1 Control Registers
				0x0010 - Channel 2 Control Registers
				0x0018 - Channel 3 Control Registers
				      ...
				      ...
				      ...
				0x01E8 - Channel 62 Control Registers
				

	Wave Table Base Address Register 0-7 
				0x01F0 - Base Address Register 0
				0x01F1 - Base Address Register 1
				0x01F2 - Base Address Register 2
				0x01F3 - Base Address Register 3
				0x01F4 - Base Address Register 4
				0x01F5 - Base Address Register 5
				0x01F6 - Base Address Register 6
				0x01F7 - Base Address Register 7
				
	Wave Table Base Address Register 8-11
				0x01F8 - Base Address Register 8
				0x01F9 - Base Address Register 9
				0x01FA - Base Address Register 10
				0x01FB - Base Address Register 11

	PCM/Status FIFO Base Address Register 0-3
				0x01FC - Base Address Register 0
				0x01FD - Base Address Register 1
				0x01FE - Base Address Register 2
				0x01FF - Base Address Register 3


	Writing the WP to read/write from system memory
	
		1 - write the PCM/Status Base register to page aligned base address
		2 - set APU address to the following
		
			( MemoryAddress >> 1 )

			if( stereo )
				MemoryAddress = DWSETBIT( MemoryAddress, 23 );
				
			if( systemram )
				MemoryAddress = DWSETBIT( MemoryAddress, 23 );

*/
								
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetWCBaseAddr( BYTE _bChannel, WORD _wBaseAddr )
	{
	vWrWCReg( 0x01F0 + _bChannel, _wBaseAddr );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wGetWCBaseAddr( BYTE _bChannel )
	{
	return( wRdWCReg( 0x01F0 + _bChannel ) );
	}
		
/*****************************************************************************/
/* Write Wave Cache Address I/O Port                                         */
/*                                                                           */
/*****************************************************************************/
void    vWrWCRegIndex( WORD _wRegIndex )
	{
    outpw( WAVE_CACHE_INDEX, LOWORD( _wRegIndex ) );
	}
	
/*****************************************************************************/
/* Read Wave Cache Address I/O Port                                          */
/*                                                                           */
/*****************************************************************************/
WORD    wRdWCRegIndex( void )
	{
    return( (WORD) inpw( WAVE_CACHE_INDEX ) );
	}

/*****************************************************************************/
/* Write Wave Cache Data I/O Port                                            */
/*                                                                           */
/*****************************************************************************/
void    vWrWCRegData( WORD _wRegData )
	{
    outpw( WAVE_CACHE_DATA, _wRegData );
	}

/*****************************************************************************/
/* Read Wave Cache Data I/O Port                                             */
/*                                                                           */
/*****************************************************************************/
WORD    wRdWCRegData( void )
	{
	return( (WORD)( inpw( WAVE_CACHE_DATA ) ) );
	}

/*****************************************************************************/
/* Write Wave Cache Control I/O Port                                         */
/*                                                                           */
/*****************************************************************************/
void    vWrWCControlReg( WORD _wWCControlRegFlags )
	{
    outpw( WAVE_CACHE_CONTROL, _wWCControlRegFlags );
	}
	
/*****************************************************************************/
/* Read Wave Cache Control I/O Port                                          */
/*                                                                           */
/*****************************************************************************/
WORD    wRdWCControlReg( void )
	{
	return( (WORD)( inpw( WAVE_CACHE_CONTROL ) ) );
	}

/*****************************************************************************/
/* Write Wave Cache Memory                                                   */
/*                                                                           */
/*****************************************************************************/
void    vWrWCReg( WORD _wRegIndex, WORD _wRegData )
	{
    vWrWCRegIndex( _wRegIndex );
    vWrWCRegData( _wRegData );
	}

/*****************************************************************************/
/* Read Wave Cache Memory                                                    */
/*                                                                           */
/*****************************************************************************/
WORD    wRdWCReg( WORD _wRegIndex )
	{
    vWrWCRegIndex( _wRegIndex );
    return( wRdWCRegData() );
	}

/*****************************************************************************/
/* Set Wave Cache Control Bit Flag                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetWCControlRegBit( BYTE _bWCControlRegBit )
	{
    vWrWCControlReg( WSETBIT( wRdWCControlReg(), _bWCControlRegBit ) );
	}

/*****************************************************************************/
/* Mask Wave Cache Control Bit Flag                                          */
/*                                                                           */
/*****************************************************************************/
void    vMskWCControlRegBit( BYTE _bWCControlRegBit )
	{
    vWrWCControlReg( WMSKBIT( wRdWCControlReg(), _bWCControlRegBit ) );
	}

/*****************************************************************************/
/* Test Wave Cache Control Bit Flag                                          */
/*                                                                           */
/*****************************************************************************/
BYTE    bTstWCControlRegBit( BYTE _bWCControlRegBit )
	{
    return( BTSTBIT( wRdWCControlReg(), _bWCControlRegBit ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetWCEnable( BYTE _bState )
	{
    switch( _bState )
        {
        case DISABLE:
            vMskWCControlRegBit( 8 );
            break;

        case ENABLE:
            vSetWCControlRegBit( 8 );
            break;
        }
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetWCEnable( void )
    {
    return( bTstWCControlRegBit( 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetWCConfig( BYTE _bWCConfig )
	{
    vWrWCControlReg( (WORD)( ( wRdWCControlReg() & 0xFFFC ) | _bWCConfig ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetWCConfig( void )
	{
    return( (BYTE)( wRdWCControlReg() & 0x0003 ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetWCSGControl( BYTE _bState )
    {
    vWrWCControlReg( (WORD)( ( wRdWCControlReg() & 0xFE03 ) | _bState ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetWCSGControl( void )
    {
    return( (BYTE)( ( wRdWCControlReg() & 0x001C ) >> 2 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetWCWaveTableSize( BYTE _bWaveTableSize )
    {
    vWrWCControlReg( (WORD)( ( wRdWCControlReg() & 0xFF9F ) | (WORD)(_bWaveTableSize) << 5 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetWCWaveTableSize( void )
    {
    return( (BYTE)( ( wRdWCControlReg() & 0x0060 ) >> 5 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetWCFMSynth( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskWCControlRegBit( 7 );
            break;

        case ENABLE:
            vSetWCControlRegBit( 7 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetWCFMSynth( void )
    {
    return( bTstWCControlRegBit( 7 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetWCWaveTableBaseAddress( BYTE _bChannel, WORD _wAddress )
    {
    vWrWCReg( 0x01F0 + _bChannel, _wAddress );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetWCWaveTableBaseAddress( BYTE _bChannel )
    {
    return( wRdWCReg( 0x01F0 + _bChannel ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetWCPCMBaseAddress( BYTE _bChannel, WORD _wAddress )
    {
    vWrWCReg( 0x01FC + _bChannel, _wAddress );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetWCPCMBaseAddress( BYTE _bChannel )
    {
    return( wRdWCReg( 0x01FC + _bChannel ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetWCControlRegister( BYTE _bChannel, BYTE _bData )
    {
    vWrWCReg( _bChannel << 4, _bData );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetWCControlRegister( BYTE _bChannel )
    {
    return( wRdWCReg( _bChannel << 4 ) );
    }

