#include <stdlib.h>
#include <stdio.h>
#include <graph.h>

#include	"sbtype.h"
#include	"sbconfig.h"

#include    "ptconfig.h"
#include    "mymenu.h"
#include	"menu.h"

/* Board Test Setup Version Number */
#ifdef	_DEBUG
	#define _BS_VERSION     _BS_MAJOR "." _BS_MINOR "." _BS_BUILD
#else
	#define _BS_VERSION     _BS_MAJOR "." _BS_MINOR
#endif	

#define _BS_TITLE   _PT_CHIPNAME" Board Test Program Setup Utility, Version " _BS_VERSION


#define _outtextxy( ach, x, y )   { _settextposition( y, x ); \
                                    _outtext( ach ); }

void exitp(  );


void DisplayHdr( void );

int rowMid, colMid;

struct videoconfig vc;

enum SwapAudioChannelChoices
	{
	SWAP_DISABLE, SWAP_ENABLE, SWAP_EXIT
	};
		
ITEM BaseIOTestMenu[] =
    {                                                                          /* Highlight Char  Pos */
    {16, "Audio I/O Base 220"},                                                /* O     0  */
    {16, "Audio I/O Base 240"},                                                /* 4     4  */
    {1, "Exit the Program"},                                                   /* N     4  */
    {0, ""}
    };

enum BaseIOTestChoices
    {
    IO220, IO230, IO240, IO250, IOEXIT
    };


ITEM mnuPlaybackTestMenu[] =
	{      
    {  0, "Disable Audio Playback Test" 	},  /* O     0  */
    {  0, "Enable Audio Playback Test"  		},  /* 4     4  */
    {  1, "Exit the Program"  		},	/* N     4  */
    {  0, ""             			}
	};

enum PLAYBACK_CHOICES
	{
  	PLAYBACK_DISABLE, PLAYBACK_ENABLE, PLAYBACK_EXIT
	};

ITEM SwapAudioChannelMenu[] =
	{
    {  0, "Disable Left/Right Channel Swap" 	},  /* O     0  */
    {  0, "Enable Left/Right Channel Swap"  		},  /* 4     4  */
    {  1, "Exit the Program"  		},
    {  0, "" }
	};
	
ITEM mnuRecordingTestMenu[] =
	{
    {  0, "Disable Audio Recording Test"   	},	/* O     0  */
    {  0, "Enable Audio Recording Test"  		},  /* 4     4  */
    {  1, "Exit the Program"  			},  /* N     4  */
    {  0, ""             				}
	};

enum RECORDING_CHOICES
	{
  	RECORDING_DISABLE, RECORDING_ENABLE, RECORDING_EXIT
	};


ITEM JoystickTestMenu[] =
    {                                                                          /* Highlight Char  Pos */
    {0, "Disable Joystick Test"},                                                   /* 4     4  */
    {0, "Enable Joystick Test"},                                                 /* O     0  */
    {1, "Exit the Program"},                                                   /* N     4  */
    {0, ""}
    };

enum JoystickTestOptions
    {
    JOYSTICK_ENABLE, JOYSTICK_DISABLE, JOYSTICK_EXIT
    };


ITEM LineInTestMenu[] =
    {                                                                          /* Highlight Char  Pos */
    {0, "Disable Line-In Test"},                                                 /* O     0  */
    {0, "Enable Line-In Test"},                                                    /* 4     4  */
    {1, "Exit the Program"},                                                   /* N     4  */
    {0, ""}
    };

enum LineInTestOptions
    {
    LINEIN_DISABLE, LINEIN_ENABLE, LINEIN_EXIT
    };

ITEM mnuSynthesizerTestChoices[] =
    {                                                                          /* Highlight Char  Pos */
    {0, "Disable FM Synthesizer Test"},                                                         /* O     0  */
    {0, "Enable FM Synthesizer Test"},                                                            /* 4     4  */
    {1, "Exit the Program"},                                                   /* N     4  */
    {0, ""}
    };

enum SynthesizerChoices
    {
    FMSYNTH_DISABLE, FMSYNTH_ENABLE, FMSYNTH_EXIT
    };

ITEM MIDITestMenu[] =
    {
    {0, "Disable MPU401 Test"},
    {0, "Enable MPU401 Test"},
    {1, "Exit the Program"},
    {0, ""}
    };

enum MIDITestMenu
    {
    MPU401_DISABLE, MPU401_ENABLE, MPU401_EXIT
    };

ITEM DRAMTestMenu[] =
    {
    {0, "Disable OnBoard DRAM Test"},
    {0, "Enable OnBoard DRAM Test"},
    {1, "Exit the Program"},
    {0, ""}
    };

enum DRAMTestMenu
    {
    DRAM_DISABLE, DRAM_ENABLE, DRAM_EXIT
    };

ITEM MPU401TestMenu[] =
    {
    {22, "Use MPU-401 I/O Base 300"},
    {22, "Use MPU-401 I/O Base 320"},
    {22, "Use MPU-401 I/O Base 330"},
    {22, "Use MPU-401 I/O Base 340"},
    {1, "Exit the Program"},
    {0, ""}
    };

enum MPU401TestChoices
    {
    MPU401_300, MPU401_320, MPU401_330, MPU401_340, EXIT_MPU401_TEST
    };


ITEM mnuCDLineIN[] =
	{
    { 0, "Disable CD Line Input Test"   },
    { 0, "Enable CD Line Input Test"    },
    { 1, "Exit the Program"     },
    { 0, ""             		}
	};
enum CD_LINE_CHOICES
	{
    CDLINE_DISABLE, CDLINE_ENABLE, CDLINE_EXIT
	};


ITEM mnuAUXLineIN[] =
	{
    { 0, "Disable AUX Line Input Test"   },
    { 0, "Enable AUX Line Input Test"    },
    { 1, "Exit the Program"     },
    { 0, ""             		}
	};
enum AUX_LINE_CHOICES
	{
    AUXLINE_DISABLE, AUXLINE_ENABLE, AUXLINE_EXIT
	};

ITEM IISTestMenu[] =
    {
    {0, "Disable IIS Output Test"},
    {0, "Enable IIS Output Test"},
    {1, "Exit the Program"},
    {0, ""}
    };
enum IISTestMenu
    {
    IIS_DISABLE, IIS_ENABLE, IIS_EXIT
    };




     /* N     4  */

/* Arrays of video mode menu items and of corresponding mode numbers.
 * Each has a temporary array containing all items, and a pointer version
 * including all except Olivetti.
 */
ITEM mnuModesT[] =
    {                                                                          /* Highlight Char  Pos */
    {0, "ORESCOLOR "},                                                         /* O     0  */
    {4, "MRES4COLOR "},                                                        /* 4     4  */
    {4, "MRESNOCOLOR"},                                                        /* N     4  */
    {4, "HRESBW"},                                                             /* B     4  */
    {0, "MRES16COLOR"},                                                        /* M     0  */
    {0, "HRES16COLOR"},                                                        /* H     0  */
    {0, "ERESCOLOR"},                                                          /* E     0  */
    {4, "VRES2COLOR"},                                                         /* 2     4  */
    {0, "VRES16COLOR"},                                                        /* V     0  */
    {1, "MRES256COLOR"},                                                       /* R     4  */
    {0, ""}
    };

ITEM *mnuModes = &mnuModesT[1];                                                /* Default is no Olivetti mode */
int aModesT[] =
    {
    _ORESCOLOR,
    _MRES4COLOR,
    _MRESNOCOLOR,
    _HRESBW,
    _MRES16COLOR,
    _HRES16COLOR,
    _ERESCOLOR,
    _VRES2COLOR,
    _VRES16COLOR,
    _MRES256COLOR,
    _TEXTMONO,
    _ERESNOCOLOR,
    _HERCMONO
    };

int     *aModes = &aModesT[1];                                                     /* Default is no Olivetti mode */


// ****************************************************************************
// *                                                                          *
// *                                                                          *
// ****************************************************************************
int DisplayChoices( char *_Title, char *_Option, int _HotKey, int *_List, int _Default, int _Format )
	{
	int i;
    ITEM menu[20];
	
    _clearscreen( _GCLEARSCREEN );
    DisplayHdr();
	
	for( i=0; _List[i] != -1; i++ )
		{
        menu[i].iHilite = _HotKey;
        switch( _Format )
        	{
        	case 0:
				sprintf( menu[i].achItem, "%s % 2u\x0", _Option, _List[i] );
				break;
        	case 1:
				sprintf( menu[i].achItem, "%s%2d\x0", _Option, _List[i] );
				break;
        	case 2:
				sprintf( menu[i].achItem, "%s%2X\x0", _Option, _List[i] );
				break;
        	case 3:
				sprintf( menu[i].achItem, "%s%4X\x0", _Option, _List[i] );
				break;
			}
		}
		
	menu[i].iHilite = 1;
	sprintf( menu[i].achItem, "Exit the program\x0" );

	menu[i+1].iHilite = 0;
	sprintf( menu[i+1].achItem, "" );

    i = Menu( rowMid, colMid, menu, _Default, _Title );

	return( _List[i] );
	}


// ****************************************************************************
// *                                                                          *
// *                                                                          *
// ****************************************************************************
void    vSelectPTBaseIO( WORD _gwPTBaseIODefault )
	{
    int i,j;

    for( i=0; _ptio_choices[i] != -1; i++ )
        if( _gwPTBaseIODefault == (WORD)_ptio_choices[i] )
    		break;

    if( _ptio_choices[i] == -1 )
        _gwPTBaseIODefault = DEFAULT_IO_MAESTRO;

    if( (i = DisplayChoices( "Select Maestro Base I/O Address", "BaseIO ", 8, _ptio_choices, i, 3 )) == -1)
		exitp();

    gwPTBaseIO = i;
	}
	

// ****************************************************************************
// *                                                                          *
// *                                                                          *
// ****************************************************************************
void    vSelectPTIRQ( WORD _gbPTIRQDefault )
    {
    int i,j;

    for( i=0; _ptirq_choices[i] != -1; i++ )
        if( gbPTIRQ == _ptirq_choices[i] )
            break;

    if( _ptirq_choices[i] == -1 )
        gbPTIRQ = DEFAULT_IRQ_MAESTRO;

    if( (i = DisplayChoices( "Select Maestro Interrupt", "IRQ", 5, _ptirq_choices, i, 0 )) == -1)
        exitp();

    gbPTIRQ = i;
    }

    

// ****************************************************************************
// *                                                                          *
// *                                                                          *
// ****************************************************************************
void    vSelectSBBaseIO( WORD _gwIOAudioDefault )
	{
    int i,j;

    for( i=0; _sbio_choices[i] != -1; i++ )
        if( _gwIOAudioDefault == (WORD)_sbio_choices[i] )
    		break;

    if( _sbio_choices[i] == -1 )
		_gwIOAudioDefault = DEFAULT_IO_AUDIO;

    if( (i = DisplayChoices( "Select Audio I/O Base Address", "Audio I/O Base", 15, _sbio_choices, i, 3 )) == -1)
		exitp();

	gwIOAudio = i;
	}

// ****************************************************************************
// *                                                                          *
// *                                                                          *
// ****************************************************************************
WORD    vSelectSBIRQ( unsigned _default )
	{     
    int i,j;

    for( i=0; _sbirq_choices[i] != -1; i++ )
        if( gbIRQAudio == _sbirq_choices[i] )
    		break;

    if( _sbirq_choices[i] == -1 )
		gbIRQAudio = DEFAULT_IRQ_AUDIO;

    if( (i = DisplayChoices( "Select an IRQ Number", "IRQ", 5, _sbirq_choices, i, 0 )) == -1)
		exitp();

	gbIRQAudio = i;
	}

// ****************************************************************************
// *                                                                          *
// *                                                                          *
// ****************************************************************************
unsigned vSelectSBDMA( unsigned _default )
	{		
	int i;

    for( i=0; _sbdma_choices[i] != -1; i++ )
        if( gbDMAAudio == _sbdma_choices[i] )
    		break;

    if( _sbdma_choices[i] == -1 )
		gbDMAAudio = DEFAULT_DMA_AUDIO;

    if( (i = DisplayChoices( "Select a DMA Channel", "DMA", 4, _sbdma_choices, i, 1 )) == -1)
		exitp();

	gbDMAAudio = i;
    }

// ****************************************************************************
// *                                                                          *
// *                                                                          *
// ****************************************************************************
unsigned SelectMPU( unsigned _default )
	{
	int i;

    for( i=0; _sbio_mpu401_choices[i] != -1; i++ )
        if( gwIOMPU401 == _sbio_mpu401_choices[i] )
    		break;

    if( _sbio_mpu401_choices[i] == -1 )
		gwIOMPU401 = DEFAULT_IO_MPU401;

    if( (i = DisplayChoices( "Select a MPU401 I/O Port", "Use MPU401 Base", 17, _sbio_mpu401_choices, i, 3 )) == -1)
		exitp();

	gwIOMPU401 = i;
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
int main(  )
    {
	BYTE    bTmpData;

	WORD    wRowIndex,
			wColIndex;
    
    int 	fColor,
    		fFirstTime = TRUE;

    int		iMode,
    		i = 0,
    		iModesCur = 0;

	unsigned 	index1, 
				index2;

	vGetConfigSettings();
	
/*
    if( iResetDSP() != _SB_DSP_RESET_OK )
		{
//    vDisplayDebugMessage("Sound Blaster Device Not Detected\n");
		exit(0);
		}
	
//    vDisplayDebugMessage("Sound Blaster Device Found @ %04X\n", gwIOAudio );
*/
    _displaycursor( _GCURSOROFF );
    _getvideoconfig( &vc );

    rowMid = vc.numtextrows / 2;
    colMid = vc.numtextcols / 2;

    switch ( vc.adapter )
        {
	    case _OCGA:
    	    mnuModes = &mnuModesT[0];
	        aModes = &aModesT[0];

    	case _CGA:
        	mnuModesT[4].achItem[0] = '\0';
        	iMode = _MRES4COLOR;
        	break;

	    case _HGC:
    	    mnuModesT[7].achItem[0] = '\0';
        	iMode = _HERCMONO;
        	break;
    
    	case _OEGA:
        	mnuModes = &mnuModesT[0];
        	aModes = &aModesT[0];
    
    	case _EGA:
        	mnuModesT[7].achItem[0] = '\0';
        	if ( vc.memory > 64 )
	            iMode = _ERESCOLOR;
        	else
	            iMode = _HRES16COLOR;
    	    break;

    	case _OVGA:
	        mnuModes = &mnuModesT[0];
        	aModes = &aModesT[0];

    	case _VGA:
	        iMode = _VRES16COLOR;
        	break;

	    case _MCGA:
    	    iMode = _MRES256COLOR;
	        break;

	    case _MDPA:
        	mnuModesT[7].achItem[0] = '\0';
        	iMode = _HERCMONO;
        	break;

    	default:
	        iMode = _VRES16COLOR;
    	    break;
        }

    switch( vc.mode )
        {
	    case _TEXTBW80:
    	case _TEXTBW40:
        	fColor = FALSE;
        	break;

    	case _TEXTMONO:
    	case _ERESNOCOLOR:
    	case _HERCMONO:
	        fColor = FALSE;
    	    if ( iMode != _HERCMONO )
        	    iMode = _ERESNOCOLOR;
	        break;

    	default:
        	fColor = TRUE;
        	break;
        }

    for( iModesCur = 0; aModes[iModesCur] != iMode; iModesCur++ )
        ;

    _setvideomode( _DEFAULTMODE );

    if( fColor )
        _setbkcolor( ( long ) _TBLUE );


    vSelectPTBaseIO( gwPTBaseIO );
    vSelectPTIRQ( gbPTIRQ );

//    vSelectSBBaseIO( gwIOAudio );
//    vSelectSBIRQ( gbIRQAudio );
//    vSelectSBDMA( gbDMAAudio );

    _clearscreen( _GCLEARSCREEN );												
    DisplayHdr(  );																
	flgTestPlayback = Menu( rowMid, colMid, mnuPlaybackTestMenu, flgTestPlayback, "Select Audio Playback Test Option" );
	if( flgTestPlayback == PLAYBACK_EXIT )
		{
		exitp();
		}
/*

	if( flgTestPlayback == PLAYBACK_ENABLE )
		{
		_clearscreen( _GCLEARSCREEN );
		DisplayHdr();
		flgSwapChannels = Menu( rowMid, colMid, SwapAudioChannelMenu, flgSwapChannels, "Select Left/Right Channel Swap Option" );
		if( flgSwapChannels == SWAP_EXIT )
			{
			exitp();
			}
		}
*/

	_clearscreen( _GCLEARSCREEN );												
    DisplayHdr(  );																
	flgTestRecording = Menu( rowMid, colMid, mnuRecordingTestMenu, flgTestRecording, "Select Audio Recording Test Option" );
	if( flgTestRecording == RECORDING_EXIT )
		{
		exitp();
		}
		

    _clearscreen( _GCLEARSCREEN );
    DisplayHdr(  );																
    flgTestFMSynth = Menu( rowMid, colMid, mnuSynthesizerTestChoices, flgTestFMSynth, "Select FM Synthesizer Test Option" );
    if( flgTestFMSynth == FMSYNTH_EXIT )
        {
        exitp(  );
        }

    _clearscreen( _GCLEARSCREEN );												
    DisplayHdr(  );																
    flgTestLineIn = Menu( rowMid, colMid, LineInTestMenu, flgTestLineIn, "Select Line-In Test Option" );
    if( flgTestLineIn == LINEIN_EXIT )
        {
        exitp(  );
        }



    _clearscreen( _GCLEARSCREEN );
    DisplayHdr();
    if( (flgTestCDLineIn = Menu( rowMid, colMid, mnuCDLineIN, flgTestCDLineIn, "Select CD Line-In Test Option" )) == CDLINE_EXIT )
    	{
       	exitp();
       	}

    _clearscreen( _GCLEARSCREEN );
    DisplayHdr();
    if( (flgTestAUXLineIn = Menu( rowMid, colMid, mnuAUXLineIN, flgTestAUXLineIn, "Select AUX Line-In Test Option" )) == AUXLINE_EXIT )
        {
       	exitp();
       	}

    _clearscreen( _GCLEARSCREEN );
    DisplayHdr(  );																
    flgTestJoystick = Menu( rowMid, colMid, JoystickTestMenu, flgTestJoystick, "Select Joystick Test Option" );
    if( flgTestJoystick == JOYSTICK_EXIT )
        {
        exitp(  );
        }

    _clearscreen( _GCLEARSCREEN );												
    DisplayHdr(  );																
	flgTestMPU401 = Menu( rowMid, colMid, MIDITestMenu, flgTestMPU401, "Select MPU401 Test Option" );
	if( flgTestMPU401 == EXIT_MPU401_TEST )
		{
		exitp();
		}
		
	if( flgTestMPU401 )
		{
        SelectMPU( gwIOMPU401 );
		}

    _clearscreen( _GCLEARSCREEN );												
    DisplayHdr(  );																
	flgTestDRAM = Menu( rowMid, colMid, DRAMTestMenu, flgTestDRAM, "Select OnBoard DRAM Test Option" );
	if( flgTestDRAM == DRAM_EXIT )
		{
		exitp();
		}

    _clearscreen( _GCLEARSCREEN );												
    DisplayHdr(  );																
	flgTestIIS = Menu( rowMid, colMid, IISTestMenu, flgTestIIS, "Select IIS Output Test Option" );
	if( flgTestIIS == IIS_EXIT )
		{
		exitp();
		}

   	_clearscreen( _GCLEARSCREEN );												/* Clear Screen */

    vSetConfigSettings();

    exitp(  );
	}

/*****************************************************************************/
/*                                                                           */
/*****************************************************************************/
void exitp( void )
    {
    _setvideomode( _DEFAULTMODE );
    exit( 0 );
    }

/*****************************************************************************/
/*                                                                           */
/*****************************************************************************/
void DisplayHdr( void )
    {
    short oldfgd;
    long bgColor;
    oldfgd = _settextcolor( HDRFRAMECOLOR );
    bgColor = _getbkcolor(  );

    Box( 1, 1, 2, 78 );

    _settextcolor( HDRTEXTCOLOR );
    _outtextxy( _BS_TITLE, HDRLFT + 2, HDRTOP + 1 );

    _settextcolor( oldfgd );
    _setbkcolor( bgColor );
    }

