/**/
#define INT3    _asm    { int 3 }

/*****************************************************************************/
/* Global Constant Definitions                                               */
/*****************************************************************************/
#define DISABLE         0
#define ENABLE          1

#define FALSE           0
#define TRUE            1

#define OFF             0
#define ON              1

#define _RW             0   /* Read/Write */
#define _WO             1   /* Write Only */
#define _RO             2   /* Read Only */

/******* Common definitions and typedefs ***********************************/

#define VOID		    	void

#define	HUGE                _huge
#define FAR             	_far
#define NEAR		    	_near
#define PASCAL		    	_pascal
#define CDECL		    	_cdecl

/****** Simple types & common helper macros *********************************/

typedef unsigned int		BOOL;

typedef unsigned char	    BYTE;
typedef unsigned short      WORD;
typedef unsigned long       DWORD;

typedef unsigned char		UCHAR;
typedef unsigned int		UINT;
typedef unsigned long		ULONG;

typedef signed char			CHAR;
typedef signed int			INT;
typedef signed long			LONG;

#ifdef	STRICT
typedef signed long	    	LONG;
#else
#define LONG long
#endif

#define LOBYTE(w)			((BYTE)(w))
#define HIBYTE(w)			((BYTE)(((UINT)(w) >> 8) & 0xFF))

#define LOWORD(l)           ((WORD)(DWORD)(l))
#define HIWORD(l)           ((WORD)((((DWORD)(l)) >> 16) & 0xFFFF))

#define MAKELONG(low, high) ((LONG)(((WORD)(low)) | (((DWORD)((WORD)(high))) << 16)))

#define MAKEDWORD(low, high) ((DWORD)(((WORD)(low)) | (((DWORD)((WORD)(high))) << 16)))

#ifndef NOMINMAX
#ifndef max
#define max(a,b)            (((a) > (b)) ? (a) : (b))
#endif
#ifndef min
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif
#endif  /* NOMINMAX */

/* Types use for passing & returning polymorphic values */
typedef UINT WPARAM;
typedef LONG LPARAM;
typedef LONG LRESULT;

#define MAKELPARAM(low, high)	((LPARAM)MAKELONG(low, high))
#define MAKELRESULT(low, high)	((LRESULT)MAKELONG(low, high))

/****** Common pointer types ************************************************/

#ifndef NULL
#define NULL		    0
#endif

typedef char NEAR*          PSTR;
typedef char NEAR*          NPSTR;

typedef char FAR*           LPSTR;
typedef const char FAR*     LPCSTR;

typedef BYTE NEAR*			PBYTE;
typedef BYTE FAR*	    	LPBYTE;
typedef BYTE HUGE*          HPBYTE;

typedef int NEAR*	    	PINT;
typedef int FAR*	    	LPINT;

typedef WORD NEAR*			PWORD;
typedef WORD FAR*			LPWORD;

typedef long NEAR*			PLONG;
typedef long FAR*			LPLONG;

//typedef DWORD NEAR*         PDWORD;
typedef DWORD *         PDWORD;
typedef DWORD FAR*			LPDWORD;

typedef void FAR*           LPVOID;

#define MAKELP(sel, off)    ((void FAR*)MAKELONG((off), (sel)))
#define SELECTOROF(lp)      HIWORD(lp)
#define OFFSETOF(lp)        LOWORD(lp)

#define FIELDOFFSET(type, field)    ((int)(&((type NEAR*)1)->field)-1)

/****** Bit Manipulation Macros  ********************************************/
#define	DWMSKBIT(a,b)	(DWORD)( a & (DWORD)( ~( 1L << b ) ) )
#define	DWSETBIT(a,b)	(DWORD)( a | (DWORD)( 1L << b ) )
#define	DWTSTBIT(a,b)	( ( ( a & (DWORD)( 1L << b ) ) == 0 ) ? FALSE : TRUE )
	
#define WMSKBIT(a,b)    (WORD)( ((WORD)a) & ( ( ((WORD)1) << b ) ^ 0xFFFF ) )
#define WSETBIT(a,b)    (WORD)( ((WORD)a) | ( ((WORD)1) << b ) )
#define WTSTBIT(a,b)    (WORD)( ( ( ((WORD)a) & ( ((WORD)1) << b ) ) == 0 ) ? FALSE : TRUE )

#define BMSKBIT(a,b)    (BYTE)( ((BYTE)a) & ( ( 1 << b ) ^ 0xFF ) )
#define BSETBIT(a,b)    (BYTE)( ((BYTE)a) | ( 1 << b ) )
#define BTSTBIT(a,b)    (BYTE)( ( ( ((BYTE)a) & ( 1 << b ) ) == 0 ) ? FALSE : TRUE )

/* These macros will get a bitmask from A starting at bit B thru bit C */
#define DWGETMSK(a,b,c)  ( ( a << ( 31 - b ) ) >> ( ( 31 - b ) + c ) )
#define WGETMSK(a,b,c)   ( ( a << ( 15 - b ) ) >> ( ( 15 - b ) + c ) )
#define BGETMSK(a,b,c)   ( ( a << (  7 - b ) ) >> ( (  7 - b ) + c ) )

#define	DWSETMSK(a,b,c)	 

 
 

#define WORDMAX         17
#define FIELDMAX        50
#define LINEMAX         78
#define LINEMAX1       132
#define FNMAX           40
#define CMDMAX          32
#define STATMAX         20
#define MAX_LINES       24
#define LINE_LEN        79
#define MAX_PHRASE      600
#define TESTMAX         13
#define MAXUPEADDR      14

#define BUF_SIZE 32000
#define SBUF_SIZE 4000
#define KILL_BUF_SIZE 4*79

