#define _TXT_BLACK          ((BYTE)0x00)
#define _TXT_BLUE           ((BYTE)0x01)
#define _TXT_GREEN          ((BYTE)0x02)
#define _TXT_CYAN           ((BYTE)0x03)
#define _TXT_RED            ((BYTE)0x04)
#define _TXT_MAGENTA        ((BYTE)0x05)
#define _TXT_BROWN          ((BYTE)0x06)
#define _TXT_WHITE          ((BYTE)0x07)

#define _TXT_GRAY           ((BYTE)0x08)
#define _TXT_BRIGHT_BLUE    ((BYTE)0x09)
#define _TXT_BRIGHT_GREEN   ((BYTE)0x0A)
#define _TXT_BRIGHT_CYAN    ((BYTE)0x0B)
#define _TXT_BRIGHT_RED     ((BYTE)0x0C)
#define _TXT_BRIGHT_MAGENTA ((BYTE)0x0D)
#define _TXT_YELLOW         ((BYTE)0x0E)
#define _TXT_BRIGHT_WHITE   ((BYTE)0x0F)


/* Define constants for title display line */
#define	_SCR_TITLE_LINE			2
#define _SCR_TITLE_COL          24
#define	_SCR_TITLE_FGCOLOR		_TXT_YELLOW
#define	_SCR_TITLE_BGCOLOR		_TXT_BLUE

/* Define constants for menu display line */
#define	_SCR_USRMNU_LINE		4
#define	_SCR_USRMNU_FGCOLOR		_TXT_BRIGHT_WHITE
#define	_SCR_USRMNU_BGCOLOR		_TXT_BLACK

/* Define constants for time display line */
#define	_SCR_CURTIM_LINE		2
#define	_SCR_CURTIM_FGCOLOR		_TXT_BRIGHT_WHITE
#define	_SCR_CURTIM_BGCOLOR		_TXT_BLUE

/* Define constants for status line  display line */
#define	_SCR_STATUS_LINE		3
#define	_SCR_STATUS_FGCOLOR		_TXT_BLACK
#define	_SCR_STATUS_BGCOLOR		_TXT_WHITE

/* Define constants for config display line */
#define	_SCR_CONFIG_LINE		( bGetMaxY() - 9 )
#define	_SCR_CONFIG_FGCOLOR		_TXT_BRIGHT_CYAN
#define	_SCR_CONFIG_BGCOLOR		_TXT_BLUE

/* Define constants for user options line display line */
#define	_SCR_OPTION_LINE		(_SCR_CONFIG_LINE - 1)
#define	_SCR_OPTION_FGCOLOR		_TXT_BRIGHT_WHITE
#define	_SCR_OPTION_BGCOLOR		_TXT_CYAN

/* Define constants for error message display line */
#define	_SCR_ERRMSG_LINE		14
#define	_SCR_ERRMSG_FGCOLOR		_TXT_YELLOW
#define	_SCR_ERRMSG_BGCOLOR		_TXT_RED



typedef struct	_WINDOW	{
	BYTE	bHeight,
			bWidth;
			
	BYTE	bXPosition,
			bYPosition;
			
	BYTE	bBorderStyle,
			bBorderColor;
			
	BYTE	bWindowColor;
	
	BYTE	bCursorX,
			bCursorY;
			
	}WINDOW, *PWINDOW, LPWINDOW;



BYTE    bGetVideoMode( void );
void    SetVideoMode( BYTE _bVideoMode );
void    vSetVideoPage( BYTE _bVideoPage );
BYTE    bGetVideoPage( void );
void    vSetCursorStartLine( BYTE _bCursorStartLine );
BYTE    bGetCursorStartLine( void );
void    vSetCursorEndLine( BYTE _bCursorEndLine );
BYTE    bGetCursorEndLine( void );
WORD    wGetCursorSize( void );
void    vSetCursorSize( BYTE _bBeginScanLine, BYTE _bEndScanLine );
void    vDisableCursor( void );
void    vEnableCursor( void );
WORD    wGetCursorPosition( void );
void    vSetCursorPosition( BYTE _bCursorX, BYTE _bCursorY );
BYTE    bGetCursorX( void );
void    vSetCursorY( BYTE _bCursorY );
BYTE    bGetCursorY( void );
void    vSetCursorX( BYTE _bCursorX );
BYTE    bGetChar( void );
void    vPutChar( BYTE _bChar );
BYTE    bGetColor( void );
void    vPutColor( BYTE _bColor );
BYTE    bGetMaxX( void );
BYTE    bGetMaxY( void );
void    vClearScreen( void );
BYTE    bGetCharXY( BYTE _bCursorX, BYTE _bCursorY );
void    vPutCharXY( BYTE _bCursorX, BYTE _bCursorY, const char _bChar, BYTE _bFGColor, BYTE _bBGColor );
void    vSetTextColor( BYTE _bFGColor, BYTE _bBGColor );
BYTE    bGetTextColor( void );
void    vPrintChar( char _bChar );
void    vPrintString( const char * _lpString );
void    vPrintCharXY( BYTE _bCursorX, BYTE _bCursorY, BYTE _bChar, BYTE _bFGColor, BYTE _bBGColor );
void    vPrintStringXY( BYTE _bCursorX, BYTE _bCursorY, const char *_lpString, BYTE _bFGColor, BYTE _bBGColor );
void    vDisplayCenteredString( BYTE _bCursorY, const char *_lpString, BYTE _bFgColor, BYTE _bBgColor );
void    vDisplayOptionMessage( const char *_lpOptionMessage );
void    vDisplayErrorMessage( const char *_lpErrorMessage );
void    vDisplayTestMessage( const char *_lpErrorMessage );
void    vDisplayStatusMessage( const char *_lpStatusMessage );
void    vDisplayTitleMessage( const char *_lpTitleMessage );
void    vDrawBorder( BYTE _top, BYTE _left, BYTE _bottom, BYTE _right, BYTE _fgColor, BYTE _bgColor );


void    vDisplayDebugMessage( const char *_lpDebugString, ... );
