#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<dos.h>

#include	<graph.h>
#include	<conio.h>

#include	"sbtype.h"
#include	"sbscreen.h"

BYTE	gbScreenTextColor;

BYTE	gbScreenFGColor,
		gbScreenBGColor;
		
BYTE	gbCursorStartLine,
		gbCursorEndLine;
		
BYTE	gbCursorX,
		gbCursorY;
		
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetVideoMode( void )
	{
	union REGS inregs;
	
	inregs.h.ah = 0x0F;
	
	int86( 0x10, &inregs, &inregs );
	
	return( inregs.h.al );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	SetVideoMode( BYTE _bVideoMode )
	{
	union REGS inregs;
	
	inregs.h.ah = 0x00;
	inregs.h.al = _bVideoMode;
	
	int86( 0x10, &inregs, &inregs );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetVideoPage( BYTE _bVideoPage )
	{
	union REGS x86Regs;
	
	x86Regs.h.ah = 0x05;
	x86Regs.h.al = _bVideoPage;
	
	int86( 0x10, &x86Regs, &x86Regs );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetVideoPage( void )
	{
	union REGS x86Regs;
	
	x86Regs.h.ah = 0x0F;

	int86( 0x10, &x86Regs, &x86Regs );
	
	return( (BYTE)x86Regs.h.bh );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetCursorStartLine( BYTE _bCursorStartLine )
	{
	union REGS x86Regs;
	
	x86Regs.h.ah = 0x01;
	x86Regs.h.ch = _bCursorStartLine;
	x86Regs.h.cl = bGetCursorEndLine();
	
	int86( 0x10, &x86Regs, &x86Regs );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetCursorStartLine( void )
	{
	union REGS x86Regs;
	
	x86Regs.h.ah = 0x03;
	x86Regs.h.bh = bGetVideoPage();
	
	int86( 0x10, &x86Regs, &x86Regs );
	
	return( (BYTE)x86Regs.h.ch );
	}
		
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetCursorEndLine( BYTE _bCursorEndLine )
	{
	union REGS x86Regs;
	
	x86Regs.h.ah = 0x01;
	x86Regs.h.ch = bGetCursorStartLine();
	x86Regs.h.cl = _bCursorEndLine;
	
	int86( 0x10, &x86Regs, &x86Regs );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetCursorEndLine( void )
	{
	union REGS x86Regs;
	
	x86Regs.h.ah = 0x03;
	x86Regs.h.bh = bGetVideoPage();
	
	int86( 0x10, &x86Regs, &x86Regs );
	
	return( (BYTE)x86Regs.h.cl );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wGetCursorSize( void )
	{
	return( (WORD)( ( bGetCursorStartLine() << 8 ) | bGetCursorEndLine() ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetCursorSize( BYTE _bBeginScanLine, BYTE _bEndScanLine )
	{
    vSetCursorStartLine( _bBeginScanLine );
    vSetCursorEndLine( _bEndScanLine );
	}
	
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vDisableCursor( void )
	{
	gbCursorStartLine = bGetCursorStartLine();
	gbCursorEndLine = bGetCursorEndLine();

	vSetCursorStartLine( 0x20 );
	vSetCursorEndLine( 0x20 );	
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vEnableCursor( void )
	{
	vSetCursorStartLine( gbCursorStartLine );
	vSetCursorEndLine( gbCursorEndLine );
	}                                 

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wGetCursorPosition( void )
	{
	union REGS inregs;
	
	inregs.h.ah = 0x03;
	inregs.h.bh = 0;

	int86( 0x10, &inregs, &inregs );
	
	return( (WORD) ( inregs.h.dl << 8 ) | inregs.h.dh );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetCursorPosition( BYTE _bCursorX, BYTE _bCursorY )
	{
	union REGS inregs;
	
	inregs.h.ah = 0x02;
	inregs.h.bh = bGetVideoPage();
	inregs.h.dl = _bCursorX;
	inregs.h.dh = _bCursorY;

	int86( 0x10, &inregs, &inregs );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetCursorX( void )
	{
	return( (BYTE) HIBYTE( wGetCursorPosition() ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetCursorY( BYTE _bCursorY )
	{
	vSetCursorPosition( bGetCursorX(), _bCursorY );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetCursorY( void )
	{
	return( (BYTE) LOBYTE( wGetCursorPosition() ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetCursorX( BYTE _bCursorX )
	{
	vSetCursorPosition( _bCursorX, bGetCursorY() );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetChar( void )
	{
	union REGS inregs;
	
	inregs.h.ah = 0x08;
	inregs.h.bh = 0x00;
	
	int86( 0x10, &inregs, &inregs );
	
	return( inregs.h.al );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vPutChar( BYTE _bChar )
	{
	union REGS inregs;
	
	inregs.h.ah = 0x0A;
	inregs.h.al = _bChar;
	inregs.h.bh = 0x00;
	inregs.x.cx = 1;
	
	int86( 0x10, &inregs, &inregs );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetColor( void )
	{
	union REGS inregs;
	
	inregs.h.ah = 0x08;
	inregs.h.bh = 0x00;
	
	int86( 0x10, &inregs, &inregs );
	
	return( inregs.h.bh );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vPutColor( BYTE _bColor )
	{
	union REGS inregs;
	
	inregs.h.ah = 0x09;
	inregs.h.al = bGetChar();
	inregs.h.bl = _bColor;
	inregs.h.bh = 0x00;
	inregs.x.cx = 1;
	
	int86( 0x10, &inregs, &inregs );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetMaxX( void )
	{
	union REGS x86Regs;
	
	x86Regs.h.ah = 0x0F;
	
	int86( 0x10, &x86Regs, &x86Regs );
	
	return( x86Regs.h.ah );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetMaxY( void )
	{
	return( 25 );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vClearScreen( void )
	{
	union REGS x86Regs;
	
	x86Regs.h.ah = 0x06;
	x86Regs.h.al = 0x00;
	
	x86Regs.h.bh = 0x07;
	
	x86Regs.h.cl = 0x00;
	x86Regs.h.ch = 0x00;
	
	x86Regs.h.dl = bGetMaxX();
	x86Regs.h.dh = bGetMaxY();
	
	int86( 0x10, &x86Regs, &x86Regs );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetCharXY( BYTE _bCursorX, BYTE _bCursorY )
	{
	vSetCursorPosition( _bCursorX, _bCursorY );
	return( bGetChar() );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vPutCharXY( BYTE _bCursorX, BYTE _bCursorY, const char _bChar, BYTE _bFGColor, BYTE _bBGColor )
	{
	vSetCursorPosition( _bCursorX, _bCursorY );
	vPutColor( (BYTE)( ( _bFGColor & 0x0F ) | ( _bBGColor & 0x0F ) << 4 ) );
	vPutChar( _bChar );
	}
	
/*****************************************************************************/
/*                                                                           */
/*****************************************************************************/
void	vSetTextColor( BYTE _bFGColor, BYTE _bBGColor )
	{
	gbScreenTextColor = (BYTE) ( ( _bBGColor << 4 ) | _bFGColor );
	}
	
/*****************************************************************************/
/*                                                                           */
/*****************************************************************************/
BYTE	bGetTextColor( void )
	{
	return( gbScreenTextColor );
	}
	
/*****************************************************************************/
/*                                                                           */
/*****************************************************************************/
void    vPrintChar( char _bChar )
	{
	vPutColor( gbScreenTextColor );
	vPutChar( _bChar );
	vSetCursorPosition( (BYTE) (bGetCursorX() + 1), bGetCursorY() );
	}
	
/*****************************************************************************/
/*                                                                           */
/*****************************************************************************/
void    vPrintString( const char * _lpString )
	{
	BYTE	bIndex;

	for( bIndex=0; bIndex < strlen( _lpString ); ++bIndex )
		{
		vPrintChar( _lpString[ bIndex ] );
		}
	}

/*****************************************************************************/
/*                                                                           */
/*****************************************************************************/
void    vPrintCharXY( BYTE _bCursorX, BYTE _bCursorY, BYTE _bChar, BYTE _bFGColor, BYTE _bBGColor )
	{
	vSetCursorPosition( _bCursorX, _bCursorY );
	vSetTextColor( _bFGColor, _bBGColor );

	vPrintChar( _bChar );
	}
	
/*****************************************************************************/
/*                                                                           */
/*****************************************************************************/
void    vPrintStringXY( BYTE _bCursorX, BYTE _bCursorY, const char *_lpString, BYTE _bFGColor, BYTE _bBGColor )
    {
	vSetCursorPosition( _bCursorX, _bCursorY );
	vSetTextColor( _bFGColor, _bBGColor );

	vPrintString( _lpString );
	}
	

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vDisplayCenteredString( BYTE _bCursorY, const char *_lpString, BYTE _bFgColor, BYTE _bBgColor )
	{
	BYTE    bStringLength = (BYTE)strlen( _lpString );

	vPrintStringXY( (BYTE)( ( bGetMaxX(  ) >> 1 ) - ( bStringLength >> 1 ) ), _bCursorY, _lpString, _bFgColor, _bBgColor );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vDisplayOptionMessage( const char *_lpOptionMessage )
	{
	BYTE	bTmpCol,
			bTmpMaxCol = bGetMaxX();
	
	for( bTmpCol=0; bTmpCol < bTmpMaxCol; bTmpCol++ )
		vPutCharXY( (BYTE)bTmpCol, (BYTE)_SCR_OPTION_LINE, (char)' ', (BYTE)_SCR_OPTION_FGCOLOR, (BYTE)_SCR_OPTION_BGCOLOR );
		
	vDisplayCenteredString( (BYTE)_SCR_OPTION_LINE, _lpOptionMessage, (BYTE)_SCR_OPTION_FGCOLOR, (BYTE)_SCR_OPTION_BGCOLOR );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vDisplayDebugMessage( const char *_lpDebugString, va_list marker )
	{
#ifdef	_DEBUG
	FILE	*fStream;

    if( ( fStream = fopen( "MON", "wt" ) ) != NULL )
		{
        fprintf( fStream, _lpDebugString, marker );
	}
	fclose( fStream );
#endif
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vDisplayErrorMessage( const char *_lpErrorMessage )
	{
	vPrintStringXY( 0, _SCR_ERRMSG_LINE, "                                                                                ", _SCR_ERRMSG_FGCOLOR, _SCR_ERRMSG_BGCOLOR );
	vDisplayCenteredString( _SCR_ERRMSG_LINE, _lpErrorMessage, _SCR_ERRMSG_FGCOLOR, _SCR_ERRMSG_BGCOLOR );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vDisplayTestMessage( const char *_lpErrorMessage )
	{
	vPrintStringXY( 0, _SCR_ERRMSG_LINE, "                                                                                ", _SCR_TITLE_FGCOLOR, _SCR_TITLE_BGCOLOR );
	vDisplayCenteredString( _SCR_ERRMSG_LINE, _lpErrorMessage, _SCR_TITLE_FGCOLOR, _SCR_TITLE_BGCOLOR );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vDisplayStatusMessage( const char *_lpStatusMessage )
	{
	vDisplayCenteredString( _SCR_STATUS_LINE, _lpStatusMessage, _SCR_STATUS_FGCOLOR, _SCR_STATUS_BGCOLOR );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vDisplayTitleMessage( const char *_lpTitleMessage )
	{
	vDisplayCenteredString( _SCR_TITLE_LINE, _lpTitleMessage, _SCR_TITLE_FGCOLOR, _SCR_TITLE_BGCOLOR );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vDrawBorder( BYTE _top, BYTE _left, BYTE _bottom, BYTE _right, BYTE _fgColor, BYTE _bgColor )
	{
	BYTE	bRow,
			bCol;
			
	for( bRow = _top; bRow < _bottom; bRow++ )
		{
		vPrintCharXY( _left, bRow, 0xBA, _fgColor, _bgColor );
		vPrintCharXY( _right, bRow, 0xBA, _fgColor, _bgColor );
		}

	for( bCol = _left; bCol < _right; bCol++ )
		{
		vPrintCharXY( bCol, _top, 0xCD, _fgColor, _bgColor );
		vPrintCharXY( bCol, _bottom, 0xCD, _fgColor, _bgColor );
		}
		
	vPrintCharXY( _left, _top, 0xC9, _fgColor, _bgColor );
	vPrintCharXY( _right, _top, 0xBB, _fgColor, _bgColor );
	vPrintCharXY( _left, _bottom, 0xC8, _fgColor, _bgColor );
	vPrintCharXY( _right, _bottom, 0xBC, _fgColor, _bgColor );
	}
	
