#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<conio.h>
#include	<dos.h>
#include	<io.h>
#include	<fcntl.h>
#include	<sys\stat.h>

#include	"sbtype.h"
#include	"sbconfig.h"
#include	"sbdsp.h"
#include	"sbmix.h"
#include	"sbmem.h"

#include	"ic8237.h"
#include	"ic8259.h"

#include	"sbplay.h"

extern BYTE gbScreenRow;

int     iRecFileHandle;

LPBYTE  lpRecDmaBuffer[MAXDMABUFFERS],
        lpRecDskBuffer[MAXDSKBUFFERS];

WORD    wCurrentRecDmaBuffer,
        wRecDmaBufferIndex;

LONG    lRecFileSize;

int     iRecNumberOfBuffers;

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSaveDmaBuffer( void )
	{
	BYTE	*lpTmpBuffer = malloc( DMABUFFERSIZE );
	
	_fmemmove( lpTmpBuffer, lpRecDmaBuffer[ wCurrentRecDmaBuffer ], DMABUFFERSIZE );

	lRecFileSize += write( iRecFileHandle, lpTmpBuffer, DMABUFFERSIZE );

	_fmemset( lpRecDmaBuffer[wCurrentRecDmaBuffer], 0x80, DMABUFFERSIZE );

	++wCurrentRecDmaBuffer;
	if ( wCurrentRecDmaBuffer == MAXDMABUFFERS )
		{
		wCurrentRecDmaBuffer = 0;
		}
    
    free( lpTmpBuffer );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vRecordHalfDuplex( const char *_lpInFileName, BYTE _bStereoFlag )
	{
	BYTE    bDspModeFlags = _SB_AI | _SB_SINGLE;

	BYTE    bDspTypeFlags = _SB_8BIT | _SB_UNSIGNED;

	UINT    nSamplesPerSec = 11025;

	BYTE    bInKey = 0;

	WORD    wIndex;

	BYTE    bTimeout = 5;

	WORD    wRecordTimeout = 25;

	if ( ( iRecFileHandle = _open( _lpInFileName, _O_CREAT | _O_TRUNC | _O_RDWR | _O_BINARY, _S_IFREG | _S_IREAD | _S_IWRITE ) ) != -1 )
		{
		if ( lpAllocateDMABuffer( MAXDMABUFFERS, DMABUFFERSIZE, &lpRecDmaBuffer[0] ) != NULL )
			{
			wCurrentRecDmaBuffer = 0;

			for ( wIndex = 0; wIndex < MAXDMABUFFERS; wIndex++ )
				{
				lpRecDmaBuffer[wIndex] = _MK_FP( _FP_SEG( lpRecDmaBuffer[0] ), wIndex * DMABUFFERSIZE );
				}

			for ( wIndex = 0; wIndex < MAXDSKBUFFERS; wIndex++ )
				{
				lpRecDskBuffer[wIndex] = _MK_FP( _FP_SEG( lpRecDskBuffer[0] ), wIndex * DMABUFFERSIZE );
				}

			iResetDSP(  );

			vInstallISR( gbIRQAudio, aiAudioISR );

			iDisableDAC(  );

			if ( _bStereoFlag )
				{
				vEnableStereoMode(  );
				iSetDSPSampleRate( (WORD)nSamplesPerSec );
				iWrDSP( 0xA8 );
				}
			else
				{
				vEnableMonoMode(  );
				iSetDSPSampleRate( (WORD)nSamplesPerSec );
				iWrDSP( 0xA0 );
				}

			bIRQTestFlag[0] = 0;

			iWrDSP( 0x14 );
			iWrDSP( 0x00 );
			iWrDSP( 0x00 );

			vSetDMATransfer( gbDMAAudio, (LPBYTE)0x00000000, 1, _DMA_NON_AI | _DMA_READ | _DMA_SINGLE );

			while ( bIRQTestFlag[0] != TRUE );

			iSetADCTransfer( lpRecDmaBuffer[0], MAXDMABUFFERS, DMABUFFERSIZE, (WORD)nSamplesPerSec, bDspModeFlags );

			vEnableOutputFilter(  );
			vEnableInputFilter(  );

			iStartADCTransfer(  );

			iEnableDAC(  );

			bIRQTestFlag[0] = 0;

			do
				{
				if ( bIRQTestFlag[0] == TRUE )
					{
					bIRQTestFlag[0] = FALSE;

					vSaveDmaBuffer(  );

					if ( _kbhit(  ) )
						bInKey = ( BYTE ) getch(  );

					if ( flgAutoMode == TRUE )
						--wRecordTimeout;
					}
				}

			while ( ( bInKey == 0x00 ) && ( wRecordTimeout != 0 ) );

			vSaveDmaBuffer(  );

			iStopDSPTransfer(  );

			vMskDMAChannel( gbDMAAudio );

			vRemoveISR( gbIRQAudio );

			vFreeDMABuffer( lpRecDmaBuffer[0] );
			}
		else
			{
            vDisplayDebugMessage( "Error allocating record dma buffer\n" );
			}

		close( iRecFileHandle );
		}
	else
		{
        vDisplayDebugMessage( "Error creating record file\n" );
		}
	iResetDSP(  );
	}
