#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<conio.h>
#include	<dos.h>
#include	<io.h>
#include	<fcntl.h>
#include	<sys\stat.h>

#include	"sbtype.h"
#include	"sbconfig.h"
#include	"sbdsp.h"
#include	"sbmix.h"
#include	"sbmem.h"
#include	"sbscreen.h"

#include	"sbplay.h"

#include	"ic8237.h"
#include	"ic8259.h"

int     iNumberOfBuffers;

int		iFileHandle;

LONG	lFileSize;

DWORD   dwSBDskBufferSize = ( DWORD ) ( (WORD)MAXDSKBUFFERS * (WORD)DSKBUFFERSIZE ),
        dwSBDmaBufferSize = ( DWORD ) ( (WORD)MAXDMABUFFERS * (WORD)DMABUFFERSIZE );

WORD    wCurrentDmaBuffer,
        wDmaBufferIndex;

WORD    wCurrentDskBuffer,
        wDskBufferIndex;

LPBYTE	lpDskBuffer[MAXDSKBUFFERS],
        lpDmaBuffer[MAXDMABUFFERS];

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void _interrupt _far aiAudioISR( void )
	{
	BYTE	bIndex;
	
#ifdef	_DEBUG
	LPBYTE lpTmpPtr = ( (LPBYTE) 0xB8000000L );
		
	for( bIndex=4; bIndex > 0; bIndex-- )
		{
		if( ( lpTmpPtr[bIndex<<1] < 0x30 ) || ( lpTmpPtr[bIndex<<1] > 0x39 ) )
			{
			lpTmpPtr[bIndex<<1] = 0x30;
			}
		else
			{
			if( lpTmpPtr[bIndex<<1] == 0x39 )
				{
				lpTmpPtr[bIndex<<1] = 0x30;
				}
			else 
				{
				++lpTmpPtr[bIndex<<1];
				break;
				}
			}
		}
#endif

	bIRQTestFlag[0] = 1;

    inp( gwIOAudio + 0x0E );

 /* Send Non-Specific EOI to controller #1 */
	outp( 0x20, 0x20 );

 /* Send Non-Specific EOI to controller #2 */
	outp( 0xA0, 0x20 );

	_enable(  );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vLoadDskBuffer( void )
	{
    _fmemset( lpDskBuffer[wCurrentDskBuffer], 0x80, ( WORD ) dwSBDskBufferSize );
    
    read( iFileHandle, lpDskBuffer[ wCurrentDskBuffer ], ( WORD ) dwSBDskBufferSize );

    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vLoadDmaBuffer( void )
	{
	_fmemcpy( lpDmaBuffer[ wCurrentDmaBuffer ], lpDskBuffer[ wCurrentDskBuffer ], DMABUFFERSIZE );

	++wCurrentDmaBuffer;

    if( wCurrentDmaBuffer == MAXDMABUFFERS )
		{
		wCurrentDmaBuffer = 0;
		}
		
	++wCurrentDskBuffer;

    if ( wCurrentDskBuffer == MAXDSKBUFFERS )
		{
		wCurrentDskBuffer = 0;
		
		vLoadDskBuffer( );
		}

	lFileSize -= DMABUFFERSIZE;
	
	--iNumberOfBuffers;
	}

/*****************************************************************************/
/* vPlayAudioChannel - Play Raw Digital Audio File                           */
/*                                                                           */
/*****************************************************************************/
void    vPlayAudioChannel( const char *_lpFileName, BYTE _bStereoFlag )
	{
	BYTE    bDspModeFlags = _SB_AI | _SB_SINGLE;

	BYTE	bDspTypeFlags = _SB_8BIT | _SB_UNSIGNED;
	
	UINT	nSamplesPerSec = 11000;
	
	BYTE    bInKey = 0;

	WORD    wIndex;

	if( ( iFileHandle = open( _lpFileName, O_RDONLY | O_BINARY ) ) != -1 )
		{
		if ( lpAllocateDMABuffer( MAXDMABUFFERS, DMABUFFERSIZE, &lpDmaBuffer[0] ) != NULL )
			{
			if ( lpAllocateDiskBuffer( MAXDSKBUFFERS, DSKBUFFERSIZE, &lpDskBuffer[0] ) != NULL )
				{
				for ( wIndex = 0; wIndex != MAXDMABUFFERS; wIndex++ )
					{
					lpDmaBuffer[wIndex] = _MK_FP( _FP_SEG( lpDmaBuffer[0] ), wIndex * DMABUFFERSIZE );
					}

				for ( wIndex = 0; wIndex != MAXDSKBUFFERS; wIndex++ )
					{
					lpDskBuffer[wIndex] = _MK_FP( _FP_SEG( lpDskBuffer[0] ), wIndex * DSKBUFFERSIZE );
					}
                
				lFileSize = filelength( iFileHandle );

				iNumberOfBuffers = LOWORD( ( lFileSize / (DWORD)DMABUFFERSIZE ) ) + 1;

				wCurrentDskBuffer = 0;
				wDskBufferIndex = 0;

				wCurrentDmaBuffer = 0;
				wDmaBufferIndex = 0;

				vLoadDskBuffer( );

				for ( wIndex = 0; wIndex < MAXDMABUFFERS; wIndex++ )
					{
					vLoadDmaBuffer( );
					}

				iResetDSP();

				iDisableDAC();

				vInstallISR( gbIRQAudio, aiAudioISR );

                if( _bStereoFlag )
					{
					vEnableStereoMode();
					iSetDSPSampleRate( (WORD)nSamplesPerSec << 1 );
					}
				else
					{
					vEnableMonoMode();
					iSetDSPSampleRate( (WORD)nSamplesPerSec );
					}

				iWrDSP( 0x14 );
				iWrDSP( 0x00 );
				iWrDSP( 0x00 );
                
				bIRQTestFlag[0] = 0;

				vSetDMATransfer( gbDMAAudio, (LPBYTE)0x00000000, 1, _DMA_NON_AI | _DMA_READ | _DMA_SINGLE );
				
				while( bIRQTestFlag[0] != TRUE );

				iSetDACTransfer( lpDmaBuffer[0], MAXDMABUFFERS, DMABUFFERSIZE, (WORD)nSamplesPerSec, bDspModeFlags );

				vEnableOutputFilter(  );

				iEnableDAC(  );

				iStartDACTransfer( );

				bIRQTestFlag[0] = 0;

				do
					{
					if( bIRQTestFlag[ 0 ] == 1 )
						{
						bIRQTestFlag[ 0 ] = 0;

						vLoadDmaBuffer( );
						}
						
					if ( kbhit(  ) )
						{
						bInKey = ( BYTE ) getch(  ); 
						}
					}
				while ( ( bInKey == 0x00 ) && ( lFileSize > -1 ) );

				iDisableDAC(  );

				iStopDSPTransfer( );

				vMskDMAChannel( gbDMAAudio );
				
                vRemoveISR( gbIRQAudio );
                
				vFreeDMABuffer( lpDmaBuffer[0] );
				}
			else
				{
                vDisplayDebugMessage( "Error allocating playback disk buffer\n" );
				}
			vFreeDiskBuffer( lpDskBuffer[0] );
			}
		else
			{
            vDisplayDebugMessage( "Error allocating playback DMA buffer\n" );
			}
		close( iFileHandle );
		}
	else
		{
        vDisplayDebugMessage( "Error opening playback audio file\n" );
		}

	iResetDSP();
	}
