/*****************************************************************************/
/*                                                                           */
/*  ****                      ESS Technology                            **** */
/*                                                                           */
/*                                                                           */
/*                        MPU401 Interface Library                           */
/*                                                                           */
/*                                06/17/96                                   */
/*                                                                           */
/*  ****                                                                **** */
/*                                                                           */
/*****************************************************************************/
#include	<stdio.h>
#include	<stdlib.h>
#include	<conio.h>
#include	<dos.h>

#include	"sbtype.h"
#include    "sbmpu401.h"
#include	"sbdelay.h"

int     aiIOMPU401Choices[] = {0x330, 0x320, 0x310, 0x300, -1};

/*****************************************************************************/
/* bGetMPU401Status - Return MPU401 I/O Port Status                          */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetMPU401Status( void )
	{
	return ( ( BYTE ) inp( _SB_MPU401_STATUS ) );
	}

/*****************************************************************************/
/* bGetMPU401RdStatus - Return MPU401 I/O Port Read Status                   */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetMPU401RdStatus( void )
	{
	return ( ( BYTE ) ( ( ( bGetMPU401Status(  ) & _SB_MPU401_RD_MSK ) == ( BYTE ) _SB_MPU401_RD_RDY ) ? 1 : 0 ) );
	}

/*****************************************************************************/
/* bGetMPU401WrStatus - Return MPU401 I/O Port Write Status                  */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetMPU401WrStatus( void )
	{
	return ( ( BYTE ) ( ( ( bGetMPU401Status(  ) & _SB_MPU401_WR_MSK ) == ( BYTE ) _SB_MPU401_WR_RDY ) ? 1 : 0 ) );
	}

/*****************************************************************************/
/* iWrMPU401Cmd - Write Command to MPU401 I/O Port                           */
/*                                                                           */
/*****************************************************************************/
int     iWrMPU401Cmd( BYTE _bMPU401Cmd )
	{
    int     iRetVal = _SB_MPU401_ERROR;

    BYTE    bTimeoutFlag = FALSE;

    vSetEventWait( _SB_MPU401_TIMEOUT, &bTimeoutFlag );

    while ( bTimeoutFlag == FALSE )
		if ( bGetMPU401WrStatus(  ) )
			{
			iRetVal = outp( _SB_MPU401_CMD, _bMPU401Cmd );
			break;
			}

    vClearEventWait();

    return ( iRetVal );
	}

/*****************************************************************************/
/* iWrMPU401Data - Write Data to MPU401 I/O Port                             */
/*                                                                           */
/*****************************************************************************/
int     iWrMPU401Data( BYTE _bMPU401Data )
	{
    int     iRetVal = _SB_MPU401_ERROR;

    BYTE    bTimeoutFlag = FALSE;

    vSetEventWait( _SB_MPU401_TIMEOUT, &bTimeoutFlag );

    while ( bTimeoutFlag == FALSE )
        {
		if ( bGetMPU401WrStatus(  ) )
			{
			iRetVal = outp( _SB_MPU401_DATA, _bMPU401Data );
			break;
			}
		}

    vClearEventWait();

    return ( iRetVal );
	}

/*****************************************************************************/
/* iRdMPU401Data - Read Data from MPU401 I/O Port                            */
/*                                                                           */
/*****************************************************************************/
int     iRdMPU401Data( void )
	{
    int     iRetVal = _SB_MPU401_ERROR;

    BYTE    bTimeoutFlag = FALSE;

    vSetEventWait( _SB_MPU401_TIMEOUT, &bTimeoutFlag );

    while ( bTimeoutFlag == FALSE )
        {
		if ( bGetMPU401RdStatus(  ) )
			{
			iRetVal = inp( _SB_MPU401_DATA );
			break;
			}
		}

    vClearEventWait();

    return ( iRetVal );
	}

/*****************************************************************************/
/* iResetMPU401 - Reset MPU401 I/O Port                                      */
/*                                                                           */
/*****************************************************************************/
int     iResetMPU401( void )
	{
    int     iRetVal = _SB_MPU401_ERROR;

    BYTE    bTimeoutFlag = FALSE;

    if ( iWrMPU401Cmd( _SB_MPU401_RESET ) != _SB_MPU401_ERROR )
        {
        if ( iWrMPU401Cmd( _SB_MPU401_RESET ) != _SB_MPU401_ERROR )
            {
            if ( iRdMPU401Data(  ) == _SB_MPU401_SMART_RDY )
                {
                iRetVal = _SB_MPU401_OK;
                }
            }
        }

    return ( iRetVal );
	}

/*****************************************************************************/
/* iEnableSmartMode - Enable MPU401 Smart Mode                               */
/*                                                                           */
/*****************************************************************************/
int     iEnableSmartMode( void )
	{
    int     iRetVal = _SB_MPU401_ERROR;

    BYTE    bTimeoutFlag = FALSE;

//    vSetEventWait( _SB_MPU401_TIMEOUT, &bTimeoutFlag );

//    while ( bTimeoutFlag == FALSE )
        {
		iWrMPU401Cmd( _SB_MPU401_SMART_MODE );
//        if ( iRdMPU401Data(  ) == _SB_MPU401_SMART_RDY )
			{
			iRetVal = _SB_MPU401_OK;
//            break;
			}
		}

//    vClearEventWait();

    return ( iRetVal );
	}

/*****************************************************************************/
/* iEnableMPU401UartMode - Enable MPU401 UART Mode                           */
/*                                                                           */
/*****************************************************************************/
int     iEnableUartMode( void )
	{
    int     iRetVal = _SB_MPU401_ERROR;

    BYTE    bTimeoutFlag = FALSE;

//    vSetEventWait( _SB_MPU401_TIMEOUT, &bTimeoutFlag );

//    while ( bTimeoutFlag == FALSE )
        {
		if ( iWrMPU401Cmd( _SB_MPU401_UART_MODE ) != _SB_MPU401_ERROR )
			if ( iRdMPU401Data(  ) == _SB_MPU401_UART_RDY )
				{
				iRetVal = _SB_MPU401_OK;
//                break;
				}
		}

//    vClearEventWait();

    return ( iRetVal );
	}

/*****************************************************************************/
/* iSendSysExMessage - Send System Exclusive Message to MPU401 I/O Port      */
/*                                                                           */
/*****************************************************************************/
int     iSendSysExMessage( LPBYTE _pbSysExMsg )
	{
	BYTE    bIndex = 0;

	do
		{
		if ( iWrMPU401Data( _pbSysExMsg[bIndex] ) == _SB_MPU401_ERROR )
			{
			return ( _SB_MPU401_ERROR );
			}
		}

	while ( _pbSysExMsg[bIndex++] != 0xF7 );

	return ( _SB_MPU401_OK );
	}

/*****************************************************************************/
/* iReadSysExMessage - Read System Exclusive Message from MPU401 I/O Port    */
/*                                                                           */
/*****************************************************************************/
int     iReadSysExMessage( LPBYTE _pbSysExMsg )
	{
	int     iTmpData;

	BYTE    bIndex = 0;

	do
		{
		if ( ( iTmpData = iRdMPU401Data(  ) ) == _SB_MPU401_ERROR )
			{
			return ( _SB_MPU401_ERROR );
			}

		_pbSysExMsg[bIndex] = ( BYTE ) iTmpData;
		}

	while ( _pbSysExMsg[bIndex++] != 0xF7 );

	return ( _SB_MPU401_OK );
	}

/*****************************************************************************/
/* iFindMPU401IO - Find MPU401 I/O Port Base Address                         */
/*                                                                           */
/*****************************************************************************/
int     iFindMPU401IO( void )
	{
	BYTE    bIndex;

	for ( bIndex = 0; aiIOMPU401Choices[bIndex] != -1; bIndex++ )
		{
		gwIOMPU401 = ( WORD ) aiIOMPU401Choices[bIndex];

		if ( iResetMPU401(  ) == _SB_MPU401_OK )
			{
			return ( aiIOMPU401Choices[bIndex] );
			}
		}
	return ( _SB_MPU401_ERROR );
	}
