#include	<stdio.h>
#include	<stdlib.h>
#include	<dos.h>
#include	<conio.h>

#include	"sbtype.h"
#include	"sbconfig.h"
#include    "sbmix.h"

BYTE	gbMixerTable[0xFF];

/*****************************************************************************/
/* bWrMReg - Write Mixer Register                                            */
/*****************************************************************************/
BYTE	bWrMReg( BYTE _bMixerReg, BYTE _bMixerRegData )
    {
    BYTE	bRetVal;

	_disable();
    
	outp( _SB_MIX_REG_SELECT, _bMixerReg );
	bRetVal = (BYTE)outp( _SB_MIX_REG_DATA, _bMixerRegData );

	_enable();
	
    return( _bMixerRegData );
    }

/*****************************************************************************/
/* bRdMReg - Read Mixer Register                                             */
/*****************************************************************************/
BYTE	bRdMReg( BYTE _bMixerReg )
    {
    BYTE	bRetVal;
    
	_disable();
	
	outp( _SB_MIX_REG_SELECT, _bMixerReg );
	bRetVal = (BYTE)inp( _SB_MIX_REG_DATA );
	
	_enable();
    
    return( bRetVal );
    }
	
/*****************************************************************************/
/* bSetMRegBit - Set Single Bit in Mixer Register                            */
/*****************************************************************************/
BYTE	bSetMRegBit( BYTE _bMixerReg, BYTE _bBit )
    {
    return( bWrMReg( _bMixerReg, (BYTE)BSETBIT( bRdMReg( _bMixerReg ), _bBit ) ) );
    }

/*****************************************************************************/
/* bMskMRegBit - Clear Single Bit in Mixer Register                          */
/*****************************************************************************/
BYTE	bMskMRegBit( BYTE _bMixerReg, BYTE _bBit )
    {
    return( bWrMReg( _bMixerReg, BMSKBIT( bRdMReg( _bMixerReg ), _bBit ) ) );
    }

/*****************************************************************************/
/* bTstMRegBit - Test Single Bit State in Mixer Register                     */
/*****************************************************************************/
BYTE	bTstMRegBit( BYTE _bMixerReg, BYTE _bBit )
    {
    return( BTSTBIT( bRdMReg( _bMixerReg ), _bBit ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vEnableStereoMode( void )
	{
    vDisplayDebugMessage("vEnableStereoModen");

    bSetMRegBit( 0x0E, 1 );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vEnableMonoMode( void )
	{
    vDisplayDebugMessage("vEnableMonoMode\n");

	bMskMRegBit( 0x0E, 1 );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vEnableOutputFilter( void )
	{
    vDisplayDebugMessage("vEnableOutputFilter\n");

	bMskMRegBit( 0x0E, 5 );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vDisableOutputFilter( void )
	{
    vDisplayDebugMessage("vDisableOutputFilter\n");
	
	bSetMRegBit( 0x0E, 5 );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vEnableInputFilter( void )
	{
    vDisplayDebugMessage("vEnableInputFilter\n");

	bMskMRegBit( 0x0C, 5 );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vDisableInputFilter( void )
	{
    vDisplayDebugMessage("vDisableInputFilter\n");

	bSetMRegBit( 0x0C, 5 );	
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetMicrophoneVolume( BYTE _bVolume )
	{
    vDisplayDebugMessage("vSetMicrophoneVolume\n");

	bWrMReg( _SB_MIX_MIC_VOLUME, _bVolume );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetMasterVolume( BYTE _bVolume )
	{
    vDisplayDebugMessage("vSetMasterVolume\n");
	
	bWrMReg( _SB_MIX_MASTER_VOLUME, _bVolume );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSelectInputSource( BYTE _bSource )
	{
    vDisplayDebugMessage("vSelectInputSource\n");

	switch( _bSource )
		{
		case 0:	/* Microphone */
			bMskMRegBit( 0x0C, 1 );
			bMskMRegBit( 0x0C, 2 );
			break;

		case 1: /* CD Audio */
			bSetMRegBit( 0x0C, 1 );
			bMskMRegBit( 0x0C, 2 );
			break;

		case 2: /* Line-In Audio */
			bSetMRegBit( 0x0C, 1 );
			bSetMRegBit( 0x0C, 2 );
			break;
		}
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSaveMixerRegisters( void )
	{
    vDisplayDebugMessage("vSaveMixerRegisters\n");

	gbMixerTable[_SB_MIX_MASTER_VOLUME]	= bRdMReg( _SB_MIX_MASTER_VOLUME );
	gbMixerTable[_SB_MIX_VOICE_VOLUME]	= bRdMReg( _SB_MIX_VOICE_VOLUME );
	gbMixerTable[_SB_MIX_FMSYNTH_VOLUME]	= bRdMReg( _SB_MIX_FMSYNTH_VOLUME );
	gbMixerTable[_SB_MIX_LINE_IN_VOLUME] = bRdMReg( _SB_MIX_LINE_IN_VOLUME );
	gbMixerTable[_SB_MIX_CD_LINE_VOLUME] = bRdMReg( _SB_MIX_CD_LINE_VOLUME );
	gbMixerTable[_SB_MIX_ADC_SRC_SELECT] = bRdMReg( _SB_MIX_ADC_SRC_SELECT );
	gbMixerTable[_SB_MIX_MIC_VOLUME]		= bRdMReg( _SB_MIX_MIC_VOLUME );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vRestoreMixerRegisters( void )
	{
    vDisplayDebugMessage("vRestoreMixerRegisters\n");

	bWrMReg( _SB_MIX_MASTER_VOLUME, 	gbMixerTable[_SB_MIX_MASTER_VOLUME] );
	bWrMReg( _SB_MIX_VOICE_VOLUME, 		gbMixerTable[_SB_MIX_VOICE_VOLUME] );
	bWrMReg( _SB_MIX_FMSYNTH_VOLUME,	gbMixerTable[_SB_MIX_FMSYNTH_VOLUME] );
	bWrMReg( _SB_MIX_LINE_IN_VOLUME, 	gbMixerTable[_SB_MIX_LINE_IN_VOLUME] );
	bWrMReg( _SB_MIX_CD_LINE_VOLUME, 	gbMixerTable[_SB_MIX_CD_LINE_VOLUME] );
	bWrMReg( _SB_MIX_ADC_SRC_SELECT, 	gbMixerTable[_SB_MIX_ADC_SRC_SELECT] );
	bWrMReg( _SB_MIX_MIC_VOLUME, 		gbMixerTable[_SB_MIX_MIC_VOLUME] );
	}
	
