#include	<stdio.h>
#include	<stdlib.h>
#include	<malloc.h>
#include	<conio.h>
#include	<dos.h>

#include	"sbtype.h"
#include	"sbmem.h"


/******************************************************************************/
/*                                                                            */
/******************************************************************************/
LPBYTE	lpAllocMem( LPBYTE *_lpBufferPtr, unsigned int _wBufferSize, unsigned int _wBufferCount )
	{
	union _REGS x86Regs;

	x86Regs.h.ah = 0x48;
	x86Regs.x.bx = wNumberOfParagraphs( _wBufferSize * _wBufferCount ) ;

	_intdos( &x86Regs, &x86Regs );

	if( x86Regs.x.cflag == FALSE )
		{
		*_lpBufferPtr = _MK_FP( x86Regs.x.ax, 0 );
		}
	else
		{
		*_lpBufferPtr = NULL;

    vDisplayDebugMessage("Error Allocating Memory Buffer\n");
		if( x86Regs.h.al == 7 )
			{
    vDisplayDebugMessage("ERROR: Memory control block destroyed\n");
			}
		else 
			{
			if ( x86Regs.h.al == 8 )
				{
    vDisplayDebugMessage("ERROR: Not enough memory to allocate memory block\n");
				}
			else
				{
				}
			}
		}
	
	return( *_lpBufferPtr );
	}

/******************************************************************************/
/*                                                                            */
/******************************************************************************/
void	vFreeMem( LPBYTE _lpBufferPtr )
	{
	union _REGS x86Regs;
	struct _SREGS x86SRegs;
	
	x86Regs.h.ah = 0x49;
	x86SRegs.es = _FP_SEG( _lpBufferPtr );
	_intdosx( &x86Regs, &x86Regs, &x86SRegs );

	if( x86Regs.x.cflag == FALSE )
		{
		}
	else
		{
        vDisplayDebugMessage("Error Freeing Memory Buffer\n");
		}
	}


/******************************************************************************/
/* Return number of paragraphs in pagesize                                    */
/*                                                                            */
/******************************************************************************/
WORD 	wNumberOfParagraphs( DWORD _dwPageSize )
	{
    vDisplayDebugMessage("dwNumberOfParagraphs = PageSize:%08X\n", _dwPageSize );

	return( (WORD)( ( _dwPageSize >> 4 ) + ( _dwPageSize % 16 ) ) );
	}
	
/******************************************************************************/
/*                                                                            */
/*                                                                            */
/******************************************************************************/
WORD 	wAlignParagraph( WORD _wMemPage )
	{
    vDisplayDebugMessage("wAlignParagraph = MemPage:%04X\n", _wMemPage );

	return( (WORD)( _wMemPage & 0xFFF0 ) + ( ( _wMemPage & 0x000F ) ? 0x10 : 0x00 ) );
	}
	
/******************************************************************************/
/*                                                                            */
/*                                                                            */
/******************************************************************************/
BYTE	bGetPage( LPBYTE _lpBufferPtr )
	{
	BYTE	b64kMemPage;
	
    vDisplayDebugMessage("wGetPage = lpBufferPtr:%04X:%04X\n", _FP_SEG( _lpBufferPtr ), _FP_OFF( _lpBufferPtr ) );

	b64kMemPage = LOBYTE( HIWORD( (DWORD)_lpBufferPtr ) >> 12 );

    vDisplayDebugMessage("MemoryPage:%02X\n", b64kMemPage );

	return( b64kMemPage );
	
	}
	
/******************************************************************************/
/* Convert 32 bit pointer to 16 bit segment                                   */
/*                                                                            */
/******************************************************************************/
WORD 	wNormalizeAddress( LPBYTE _lpBufferPtr )
	{
    vDisplayDebugMessage("wNormalizeAddress = lpBufferPtr:%04X:%04X\n", _FP_SEG( _lpBufferPtr ), _FP_OFF( _lpBufferPtr ) );

	return( (WORD) ( ( _FP_SEG( _lpBufferPtr ) & 0x0FFF ) << 4 ) + _FP_OFF( _lpBufferPtr ) );
	}
	
/******************************************************************************/
/*                                                                            */
/*                                                                            */
/******************************************************************************/
LPBYTE  lpAllocateDiskBuffer( WORD _wBufferCount, WORD _wBufferSize, LPBYTE *_lpBufferPtr )
	{
    vDisplayDebugMessage("lpAllocateDiskBuffer = Count:%02X Size:%02X\n", _wBufferCount, _wBufferSize );
	
	lpAllocMem( _lpBufferPtr, (int)_wBufferCount, _wBufferSize );

	return( *_lpBufferPtr );
	}

/******************************************************************************/
/*                                                                            */
/*                                                                            */
/******************************************************************************/
void	vFreeDiskBuffer( LPBYTE _lpBufferPtr )
	{
    vDisplayDebugMessage("vFreeDiskBuffer:%08lX\n", _lpBufferPtr );

	vFreeMem( _lpBufferPtr );
	}

/******************************************************************************/
/*                                                                            */
/*                                                                            */
/******************************************************************************/
BYTE	bTstRange( LPBYTE _lpBufferPtr, DWORD _wBufferSize )
	{
    BYTE	bRetVal;
	
    vDisplayDebugMessage("bTstRange\n");

	
    vDisplayDebugMessage("SEG1: %08lX\n", ( (DWORD) _lpBufferPtr ) >> 0 );
    vDisplayDebugMessage("SEG2: %08lX\n", ( (DWORD) &_lpBufferPtr[_wBufferSize] ) >> 0 );

	bRetVal = ( (BYTE)( ( bGetPage( _lpBufferPtr ) == bGetPage( &_lpBufferPtr[_wBufferSize] ) ) ? TRUE : TRUE ) );

	return( bRetVal );
	}
	
/******************************************************************************/
/*                                                                            */
/*                                                                            */
/******************************************************************************/
LPBYTE  lpAllocateDMABuffer( WORD _wBufferCount, WORD _wBufferSize, LPBYTE *_lpBufferPtr )
	{
	WORD	wBeginOffset,
			wPageRemaining;
	        
	LPBYTE	lpTmpPtr;
	        
    vDisplayDebugMessage("lpAllocateDMABuffer = Count:%02X Size:%02X\n", _wBufferCount, _wBufferSize );


	if( ( lpAllocMem( &lpTmpPtr, 1, 0x10 ) ) != NULL )
		{
		vFreeMem( lpTmpPtr );

		wBeginOffset = ( ( HIWORD( (DWORD)lpTmpPtr ) & 0x0FFF ) << 4 ) + LOWORD( (DWORD)lpTmpPtr );

		wPageRemaining = (WORD)( 0xFFF0 - wBeginOffset );
		
		if( ( lpAllocMem( &lpTmpPtr, 1, wPageRemaining ) ) != NULL )
			{
			lpAllocMem( _lpBufferPtr, _wBufferSize, _wBufferCount );
			}
		else	
			{
            vDisplayDebugMessage("Unable to allocate discard buffer\n");
			*_lpBufferPtr = NULL;
			}

		vFreeMem( lpTmpPtr );

        vDisplayDebugMessage("lpBufferPtr:%08lX\n", *_lpBufferPtr );
		}
	else
		{
        vDisplayDebugMessage("Unable to allocate dma buffer\n");
		}

	return( *_lpBufferPtr );
	}

/******************************************************************************/
/*                                                                            */
/*                                                                            */
/******************************************************************************/
LPBYTE	lpAllocateDMABufferOld( int _wBufferCount, int _wBufferSize, LPBYTE *_lpBufferPtr )
	{
	WORD	wTmpSeg, 
			wTmpOff,
	        wPageRemaining = 0;
	        
	LPBYTE	lpTmpPtr;
	
    vDisplayDebugMessage("lpAllocateDMABuffer = Count:%02X Size:%02X\n", _wBufferCount, _wBufferSize );

	if( ( lpAllocMem( &lpTmpPtr, _wBufferCount, _wBufferSize ) ) != NULL )
		{
		if( bTstRange( lpTmpPtr, ( _wBufferSize * _wBufferCount ) ) == FALSE )
			{
			*_lpBufferPtr = lpTmpPtr;
			}
		else
			{
			wTmpSeg = (WORD)_FP_SEG( lpTmpPtr );
			wTmpOff = (WORD)_FP_OFF( lpTmpPtr );

			vFreeMem( lpTmpPtr );

			wPageRemaining = (WORD) ( 0x0FF0 - ( wNormalizeAddress( lpTmpPtr ) & 0x0FFF ) );

			if( ( lpAllocMem( &lpTmpPtr, 1, wPageRemaining << 4 ) ) != NULL )
				{
				lpAllocMem( _lpBufferPtr, _wBufferSize, _wBufferCount );
				}
			else	
				{
                vDisplayDebugMessage("Unable to allocate discard buffer\n");
				*_lpBufferPtr = NULL;
				}

			vFreeMem( lpTmpPtr );
			}
		}
	else
		{
        vDisplayDebugMessage("Unable to allocate dma buffer\n");
		}

	return( *_lpBufferPtr );
	}

/******************************************************************************/
/*                                                                            */
/*                                                                            */
/******************************************************************************/
void	vFreeDMABuffer( LPBYTE _lpBufferPtr )
	{

    vDisplayDebugMessage("vFreeDMABuffer = lpBufferPtr:%04X:%04X\n", _FP_SEG( _lpBufferPtr ), _FP_OFF( _lpBufferPtr ) );

	vFreeMem( _lpBufferPtr );
	}
	

