#include        <stdio.h>
#include        <stdlib.h>
#include        <graph.h>
#include        <string.h>
#include        <dos.h>
#include        <bios.h>
#include        <string.h>
#include        <conio.h>
#include        <ctype.h>
#include        <process.h>
#include        <time.h>

#include        "asciictl.h"


#include        "sbtype.h"
#include		"sbconfig.h"
#include        "sbdsp.h"
#include        "sbfm.h"
#include        "sbmix.h"
#include        "sbmem.h"
#include        "sbmpu401.h"
#include        "sbscreen.h"
#include		"sbplay.h"
#include		"sbrec.h"
#include        "sbdelay.h"

#include        "codec.h"
#include		"apu.h"
#include		"wp.h"
#include		"wavcache.h"
#include		"cram.h"
#include        "m2.h"
#include        "ptsbinit.h"
#include        "ic8237.h"
#include        "ic8259.h"
#include        "ptconfig.h"
#include        "codec.h"
#include        "pt101.h"
#include        "ac97.h"
#include        "ptplay.h"

#include        "ic8237.h"
#include        "ic8259.h"

#include        "sbmain.h"

#define FAILMARK    'X'
#define CHECKMARK (unsigned char) 251

/* Board Test Version Number */
#ifdef	_DEBUG
	#define _BT_VERSION     _BT_MAJOR "." _BT_MINOR "." _BT_BUILD
#else
	#define _BT_VERSION     _BT_MAJOR "." _BT_MINOR
#endif	

#define _BT_TITLE   _PT_CHIPNAME " Board Test Program v" _BT_VERSION

/* Define constants for joystick test line */
#define JOYLEN                          999
#define JOYSTICK_ERROR          ( ( JOYLEN * 20 ) / 100 )


/* Special key blocking treatment */
void    ( interrupt _far * org_v5h ) (  );
void    ( interrupt _far * org_v23h ) (  );

/* Prototype statements */
void	vTestI2SPlay( void );

void interrupt _far disb_key( void );
void    disable_key( void );
void    enable_key( void );


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
int     vMainTestLoop( void )
	{
    BYTE    bInKey = 0,
			bDisplayMenu = FALSE;

	disable_key(  );

	vDisplayMenu(  );

	do
		{
		if ( kbhit(  ) )
			{
			bInKey = (BYTE)getch();

			if ( isalpha( bInKey ) )
				bInKey = (BYTE)tolower( bInKey );

			switch ( bInKey )
				{
                case _ESC:
					break;

				case ' ':
					vTestAllOptions(  );
					bDisplayMenu = TRUE;
					break;

				case 'a':
					if( flgTestConfiguration )
						{
                        bTestConfig();
						bDisplayMenu = TRUE;
						}
					break;

				case 'f':
					if ( flgTestFMSynth )
						{
						vTestFMSynth(  );
						bDisplayMenu = TRUE;
						}
					break;

				case 'j':
					if ( flgTestJoystick )
						{
						vTestJoystick(  );
						bDisplayMenu = TRUE;
						}
					break;

				case 'l':
                    if ( flgTestLineIn )
						{
						vTestLineIn(  );
						bDisplayMenu = TRUE;
						}
					break;

				case 'c':
					if ( flgTestCDLineIn )
						{
						vTestCDLineIn(  );
						bDisplayMenu = TRUE;
						}
					break;

                case 't':
                    if ( flgTestAUXLineIn )
						{
                        vTestAUXLineIn(  );
						bDisplayMenu = TRUE;
						}
					break;

                case 'm':
					if ( flgTestMPU401 )
						{
						vTestMPU401(  );
						bDisplayMenu = TRUE;
						}
					break;

				case 'q':
					break;

				case 'r':
					if( flgTestRecording )
						{
						vTestMicRecord(  );
						bDisplayMenu = TRUE;
						}
					break;

				case 's':
					if( flgTestPlayback )
						{
						vTestAudioChannel(  );
						bDisplayMenu = TRUE;
						}
					break;

				case 'd':
					if( flgTestDRAM )
						{
						vTestDRAM(  );
						bDisplayMenu = TRUE;
						}
					break;
				case 'i':
					if( flgTestIIS )
						{
						vTestI2SPlay( );
						bDisplayMenu = TRUE;
						}
					break;

					}

			if( bDisplayMenu == TRUE )
				{
				bDisplayMenu = FALSE;
				vDisplayMenu(  );
				}
			}
		}

	while ( bInKey != 'q' );

	vClearScreen(  );

	enable_key(  );

	return ( TRUE );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vTestAllOptions( void )
	{
	flgAutoMode = TRUE;

	if( flgTestConfiguration )
		{
        if( bTestConfig(  ) == TRUE )
			{
			if( flgTestDRAM )
				{
				vTestDRAM(  );
				}

			if( flgTestPlayback )
				{
				vTestAudioChannel(  );
				}
		
			if( flgTestRecording )
				{
				vTestMicRecord(  );
				}
		
			if ( flgTestFMSynth )
				{
				vTestFMSynth(  );
				}
		
			if ( flgTestLineIn )
				{
				vTestLineIn(  );
				}
		
			if ( flgTestCDLineIn )
				{
				vTestCDLineIn(  );
				}
		
            if ( flgTestAUXLineIn )
				{
                vTestAUXLineIn(  );
				}

            if ( flgTestJoystick )
				{
				vTestJoystick(  );
				}
		
			if ( flgTestMPU401 )
				{
				vTestMPU401(  );
				}

			if ( flgTestIIS )
				{
				vTestI2SPlay(  );
				}


			}
		}
	flgAutoMode = FALSE;
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vCheckAutoMode( void )
	{       
    BYTE    bTimeoutFlag = FALSE;

    if( flgAutoMode == TRUE )
		{
        vSetEventWait( 0x00300000, (LPBYTE)&bTimeoutFlag );

        while( bTimeoutFlag == FALSE )
            {
            if( kbhit() )
                {
                getch();
                break;
                }
            }

        vClearEventWait();
		}
	else
		{
		vDisplayOptionMessage( "Press any key to to continue" );
		getch();
		}
	}               

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void interrupt far disb_key( void )
	{
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    disable_key( void )
	{
	org_v5h = _dos_getvect( 0x5 );
	org_v23h = _dos_getvect( 0x23 );
	_disable(  );
	_dos_setvect( 0x5, disb_key );
	_dos_setvect( 0x23, disb_key );
	_enable(  );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    enable_key( void )
	{
	_disable(  );
	_dos_setvect( 0x5, org_v5h );
	_dos_setvect( 0x23, org_v23h );
	_enable(  );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vDisplayMenu( void )
	{
	BYTE	bScreenRow = _SCR_USRMNU_LINE;
	
	vClearScreen(  );

        vPrintStringXY( 22, _SCR_TITLE_LINE, _BT_TITLE, _SCR_TITLE_FGCOLOR, _SCR_TITLE_BGCOLOR );

        vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "[SPACE] Test All Options         ", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );
    
    if( flgTestConfiguration )
        vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "    [A] Test Configuration           ", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );

	if( flgTestPlayback )
        vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "    [S] Test Digital Audio           ", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );

	if( flgTestRecording )
        vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "    [R] Test Recording from MIC      ", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );

	if ( flgTestFMSynth )
        vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "    [F] Test FM Synthesizer          ", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );

	if ( flgTestLineIn )
        vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "    [L] Test Line-In Audio           ", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );

	if ( flgTestCDLineIn )
        vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "    [C] Test CD Line-In Audio        ", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );

    if ( flgTestAUXLineIn )
        vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "    [T] Test AUX Line-In Audio        ", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );

    if ( flgTestJoystick )
        vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "    [J] Test Joystick Port           ", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );

	if ( flgTestMPU401 )
        vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "    [M] Test MPU401 Port             ", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );

	if ( flgTestDRAM )
        vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "    [D] Test OnBoard DRAM            ", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );
	if ( flgTestIIS)
		vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "    [I] Test IIS Play", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );

        vPrintStringXY( _SCR_TITLE_COL, bScreenRow++, "    [Q] Quit                         ", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );

	bScreenRow++;
        vPrintStringXY( 25, bScreenRow++, " Please Choose Option: ", _SCR_TITLE_FGCOLOR, _SCR_TITLE_BGCOLOR );

	bScreenRow = 6;
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vDisplayTitle( void )
	{
	vClearScreen( );

	vDisplayTestConfig( );

	vDisplayTime( );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vDisplayTime( void )
	{
	static BYTE     abCurrentTimeString[ 0x50 ];

	BYTE    abTmpString[ 0x50 ];

	tzset(  );
	_strtime( (char *)abCurrentTimeString );

	sprintf( (char *)abTmpString, "Current Time: %s", abCurrentTimeString );
	
	vPrintStringXY( 3, _SCR_CURTIM_LINE, (char *)abTmpString, _SCR_CURTIM_FGCOLOR, _SCR_CURTIM_BGCOLOR );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vDisplayTestConfig( void )
	{
	char abTmpString[80];

	BYTE bScreenRow = (BYTE)_SCR_CONFIG_LINE;
	
    sprintf( (char *)abTmpString, (char *)"Audio Base I/O    : %04Xh    ", gwPTBaseIO );
	vPrintStringXY( 3,bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

    sprintf( (char *)abTmpString, (char *)"Audio Channel IRQ : %- 2u       ", gbPTIRQ );
	vPrintStringXY( 3,bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

//    sprintf( (char *)abTmpString, (char *)"Audio Channel DMA : %- 2u       ", gbDMAAudio );
//    vPrintStringXY( 3, bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

    sprintf( (char *)abTmpString, (char *)"FM Synth Base I/O : %Xh     ", gwIOFMSynth );
    vPrintStringXY( 3, bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

	sprintf( (char *)abTmpString, (char *)"Joystick Base I/O : %Xh     ", gwIOJoystick );
	vPrintStringXY( 3, bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

	sprintf( (char *)abTmpString, (char *)"MPU401 I/O        : %Xh     ", gwIOMPU401 );
	vPrintStringXY( 3, bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

	bScreenRow = (BYTE)_SCR_CONFIG_LINE;

	sprintf( (char *)abTmpString, (char *)"Test Audio Playback  : %- 3s       ", ( flgTestPlayback ) ? "YES" : "NO" );
	vPrintStringXY( 43, bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

    sprintf( (char *)abTmpString, (char *)"Test Audio Record    : %- 3s       ", ( flgTestRecording ) ? "YES" : "NO" );
    vPrintStringXY( 43, bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

    sprintf( (char *)abTmpString, (char *)"Test FM Synthesizer  : %- 3s       ", ( flgTestFMSynth ) ? "YES" : "NO" );
    vPrintStringXY( 43, bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

	sprintf( (char *)abTmpString, (char *)"Test Joystick I/O    : %- 3s       ", ( flgTestJoystick ) ? "YES" : "NO" );
	vPrintStringXY( 43, bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

	sprintf( (char *)abTmpString, (char *)"Test MPU401 I/O Port : %- 3s       ", ( flgTestMPU401 ) ? "YES" : "NO" );
	vPrintStringXY( 43, bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

    sprintf( (char *)abTmpString, (char *)"Test Line-In Audio   : %- 3s       ", ( flgTestLineIn ) ? "YES" : "NO" );
    vPrintStringXY( 43, bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

    sprintf( (char *)abTmpString, (char *)"Test CD Line Audio   : %- 3s       ", ( flgTestCDLineIn ) ? "YES" : "NO" );
    vPrintStringXY( 43, bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );

    sprintf( (char *)abTmpString, (char *)"Test AUX Line Audio  : %- 3s       ", ( flgTestAUXLineIn ) ? "YES" : "NO" );
    vPrintStringXY( 43, bScreenRow++, abTmpString, _SCR_CONFIG_FGCOLOR, _SCR_CONFIG_BGCOLOR );
	}


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vTestAudioChannel( void )
	{
	vDisplayTitle();

    vDisplayStatusMessage( "Digital Audio Test: Left Channel Playing .... " );
	vDisplayOptionMessage( "Press any key to stop test" );
    
    vPlayPCIMono16Left( (LPBYTE)"test1.raw", 11025L );

    vDisplayStatusMessage( "Digital Audio Test: Right Channel Playing .... " );
	vDisplayOptionMessage( "Press any key to stop test" );

    vPlayPCIMono16Right( (LPBYTE)"test2.raw", 11025L );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vTestMicRecord( void )
	{
	vDisplayTitle();

	vDisplayStatusMessage( "Microphone Record And Playback Test: Recording ...." );
	vDisplayOptionMessage( "Press any key to stop recording" );

    vRecordPCI( (LPBYTE)"temp.raw", 11025L );

	vDisplayStatusMessage( "Microphone Record And Playback Test: Playing ....  " );
	vDisplayOptionMessage( "Press any key to stop playback " );

    vPlayPCIMono16( (LPBYTE)"temp.raw", 11025L );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vTestFMSynth( void )
	{
	vDisplayTitle();

	vDisplayStatusMessage( "FM Synthesizer Test: Playing ....               " );
	vDisplayOptionMessage( "Press any key to stop test" );

    vPlayFMSynth(  );
	}

/*****************************************************************************/
/*																			 */
/*																			 */
/*****************************************************************************/
void	vTestI2SPlay( void )
	{
	//NOTICE: I don't know, why APU60/61 does not work.
	//		  Use APU58/59
	vPTSBInit(0); // DSP_KERNEL

	vDisplayTitle();

	vDisplayStatusMessage( "I2S Play Test: Press any key to begin .... " );
	vDisplayOptionMessage( "Press any key to begin test" );

	vCheckAutoMode();

	vDisplayStatusMessage( "     I2S Playback Test: Playing ....       " );
	vDisplayOptionMessage( "Press any key to stop test" );

	vPlayIIS();

	vPTSBInit(1); // DSP_FM
}


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vTestCDLineIn( void )
	{
	vDisplayTitle();

    vDisplayStatusMessage( "CD Line-In Test: Press any key to begin .... " );
	vDisplayOptionMessage( "Press any key to begin test" );

	vCheckAutoMode();

    if( gwCodecType == _ID_PT101 )
        {
        vSetAUX1LMute( DISABLE );
        vSetAUX1RMute( ENABLE );
        }
    else
        {
        vWrCReg( 0x12, 0x0A1F );
        }

	vDisplayStatusMessage( "CD Line-In Test: Testing left channel ....   " );
	vDisplayOptionMessage( "Press any key to stop test" );

	vCheckAutoMode();

    if( gwCodecType == _ID_PT101 )
        {
        vSetAUX1LMute( ENABLE );
        vSetAUX1RMute( DISABLE );
        }
    else
        {
        vWrCReg( 0x12, 0x1F0A );
        }

	vDisplayStatusMessage( "CD Line-In Test: Testing right channel ....  " );
	vDisplayOptionMessage( "Press any key to stop test" );

	vCheckAutoMode();

    if( gwCodecType == _ID_PT101 )
        {
        vSetAUX1LMute( ENABLE );
        vSetAUX1RMute( ENABLE );
        }
    else
        {
        vWrCReg( 0x12, 0x9F1F );
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vTestAUXLineIn( void )
	{
	vDisplayTitle();

    vDisplayStatusMessage( "AUX Line-In Test: Press any key to begin .... " );
	vDisplayOptionMessage( "Press any key to begin test" );

	vCheckAutoMode();

    if( gwCodecType == _ID_PT101 )
        {
        vSetAUX2LMute( DISABLE );
        vSetAUX2RMute( ENABLE );
        }
    else
        {
        vWrCReg( 0x16, 0x0A1F );
        }

    vDisplayStatusMessage( "AUX Line-In Test: Testing left channel ....   " );
	vDisplayOptionMessage( "Press any key to stop test" );

	vCheckAutoMode();

    if( gwCodecType == _ID_PT101 )
        {
        vSetAUX2LMute( ENABLE );
        vSetAUX2RMute( DISABLE );
        }
    else
        {
        vWrCReg( 0x16, 0x1F0A );
        }

    vDisplayStatusMessage( "AUX Line-In Test: Testing right channel ....  " );
	vDisplayOptionMessage( "Press any key to stop test" );

	vCheckAutoMode();

    if( gwCodecType == _ID_PT101 )
        {
        vSetAUX2LMute( ENABLE );
        vSetAUX2RMute( ENABLE );
        }
    else
        {
        vWrCReg( 0x16, 0x9F1F );
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vTestLineIn( void )
	{
	vDisplayTitle();

    vDisplayStatusMessage( "Line-In Test: Press any key to begin ...." );
	vDisplayOptionMessage( "Press any key to begin test" );

	vCheckAutoMode();
                      
    if( gwCodecType == _ID_PT101 )
        {
        vSetLineInLMute( DISABLE );
        vSetLineInRMute( ENABLE );
        }
    else
        {
        vWrCReg( 0x10, 0x0A1F );
        }
    
	vDisplayStatusMessage( "Line-In Test: Testing left channel ....  " );
	vDisplayOptionMessage( "Press any key to stop test" );

	vCheckAutoMode();

    if( gwCodecType == _ID_PT101 )
        {
        vSetLineInLMute( ENABLE );
        vSetLineInRMute( DISABLE );
        }
    else
        {
        vWrCReg( 0x10, 0x1F0A );
        }

	vDisplayStatusMessage( "Line-In Test: Testing right channel .... " );
	vDisplayOptionMessage( "Press any key to stop test" );

	vCheckAutoMode();

    if( gwCodecType == _ID_PT101 )
        {
        vSetLineInLMute( ENABLE );
        vSetLineInRMute( ENABLE );
        }
    else
        {
        vWrCReg( 0x10, 0x9F1F );
        }
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bCheckLoopBackPlug( void )
	{
	BYTE    bRetVar = TRUE;

    outp( gwIOJoystick, 0xFF );

    vDelay(0x00001000);

	if ( inp( gwIOJoystick ) != 0x00 )
		bRetVar = FALSE;

	return ( bRetVar );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vTestJoystick( void )
	{
	DWORD   dwTimeout = 500;

	BYTE    bTestArray[JOYLEN];

	WORD    wTestIndex;

	char    sTmpString[5];

	BYTE    bJoystickButtonFlags;

	WORD    wJoystickAX,
            wJoystickAY,
            wJoystickBX,
            wJoystickBY;

    WORD    wJoystickAXDeltaMin = 0,
            wJoystickAXDeltaMax = 0,
            wJoystickAYDeltaMin = 0,
            wJoystickAYDeltaMax = 0,
            wJoystickBXDeltaMin = 0,
            wJoystickBXDeltaMax = 0,
            wJoystickBYDeltaMin = 0,
            wJoystickBYDeltaMax = 0;

	WORD    wJoystickAXDelta,
            wJoystickAYDelta,
            wJoystickBXDelta,
            wJoystickBYDelta;

	WORD    wJoystickAverage;

	BYTE    bFirstPass = TRUE;

	vClearScreen();

	vDisplayTestConfig();
	
	vDisplayStatusMessage( "Joystick Port Test: Running ...." );

	vPrintStringXY( 18,  5, "      JOYSTICK 1     ", _TXT_WHITE, _TXT_BLUE );
	vPrintStringXY( 18,  6, "                     ", _TXT_WHITE, _TXT_BLUE );
	vPrintStringXY( 18,  7, "   Button 1:         ", _TXT_WHITE, _TXT_BLUE );
	vPrintStringXY( 18,  8, "   Button 2:         ", _TXT_WHITE, _TXT_BLUE );
	vPrintStringXY( 18,  9, " Position X:         ", _TXT_WHITE, _TXT_BLUE );
	vPrintStringXY( 18, 10, " Position Y:         ", _TXT_WHITE, _TXT_BLUE );

	vPrintStringXY( 40,  5, "      JOYSTICK 2     ", _TXT_WHITE, _TXT_BLUE );
	vPrintStringXY( 40,  6, "                     ", _TXT_WHITE, _TXT_BLUE );
	vPrintStringXY( 40,  7, "   Button 1:         ", _TXT_WHITE, _TXT_BLUE );
	vPrintStringXY( 40,  8, "   Button 2:         ", _TXT_WHITE, _TXT_BLUE );
	vPrintStringXY( 40,  9, " Position X:         ", _TXT_WHITE, _TXT_BLUE );
	vPrintStringXY( 40, 10, " Position Y:         ", _TXT_WHITE, _TXT_BLUE );


	if ( bCheckLoopBackPlug() == FALSE )
		{
		vDisplayErrorMessage( "ERROR: The loop-back plug is disconnected or bad" );

		vCheckAutoMode();

		return;
		}


	vDisplayOptionMessage( "Press any key to stop test" );
	
	while ( dwTimeout )
		{
		if( flgAutoMode == TRUE )
			--dwTimeout;
			
		if( kbhit() )
			{
			getch();
			break;
			}                       

		bJoystickButtonFlags = (BYTE)inp( gwIOJoystick );

		if ( bJoystickButtonFlags & 0x10 )
			vPrintStringXY( 31,  7, "RELEASE", _TXT_BRIGHT_CYAN, _TXT_BLUE );
		else
			vPrintStringXY( 31,  7, "PRESS  ", _TXT_BRIGHT_CYAN, _TXT_BLUE );


		if ( bJoystickButtonFlags & 0x20 )
			vPrintStringXY( 31,  8, "RELEASE", _TXT_BRIGHT_CYAN, _TXT_BLUE );
		else
			vPrintStringXY( 31,  8, "PRESS  ", _TXT_BRIGHT_CYAN, _TXT_BLUE );


		if ( bJoystickButtonFlags & 0x40 )
			vPrintStringXY( 53,  7, "RELEASE", _TXT_BRIGHT_CYAN, _TXT_BLUE );
		else
			vPrintStringXY( 53,  7, "PRESS  ", _TXT_BRIGHT_CYAN, _TXT_BLUE );


		if ( bJoystickButtonFlags & 0x80 )
			vPrintStringXY( 53,  8, "RELEASE", _TXT_BRIGHT_CYAN, _TXT_BLUE );
		else
			vPrintStringXY( 53,  8, "PRESS  ", _TXT_BRIGHT_CYAN, _TXT_BLUE );


		_asm
			{
			pushf

			push    cx
			push    ax
			push    dx
			push    si

			cld

			cli

			mov     dx, gwIOJoystick
			out     dx, al

			mov     cx, JOYLEN

	_wait:
			in              al, dx
			mov     si, cx
			mov     bTestArray[si], al

			loopnz _wait

			sti

			pop     si
			pop     dx
			pop     ax
			pop     cx

			popf
			}

		wJoystickAX = 0;
		wJoystickAY = 0;
		wJoystickBX = 0;
		wJoystickBY = 0;

		for ( wTestIndex = 0; wTestIndex < JOYLEN; wTestIndex++ )
			{
			if ( bTestArray[wTestIndex] & 0x01 )
				++wJoystickAX;

			if ( bTestArray[wTestIndex] & 0x02 )
				++wJoystickAY;

			if ( bTestArray[wTestIndex] & 0x04 )
				++wJoystickBX;

			if ( bTestArray[wTestIndex] & 0x08 )
				++wJoystickBY;
			}


		wJoystickAverage = ( wJoystickAX + wJoystickAY + wJoystickBX + wJoystickBY ) >> 2;

		if ( wJoystickAX < wJoystickAXDeltaMin || bFirstPass )
			wJoystickAXDeltaMin = wJoystickAX;

		if ( wJoystickAX > wJoystickAXDeltaMax )
			wJoystickAXDeltaMax = wJoystickAX;


		if ( wJoystickAY < wJoystickAYDeltaMin || bFirstPass )
			wJoystickAYDeltaMin = wJoystickAY;

		if ( wJoystickAY > wJoystickAYDeltaMax )
			wJoystickAYDeltaMax = wJoystickAY;



		if ( wJoystickBX < wJoystickBXDeltaMin || bFirstPass )
			wJoystickBXDeltaMin = wJoystickBX;

		if ( wJoystickBX > wJoystickBXDeltaMax )
			wJoystickBXDeltaMax = wJoystickBX;



		if ( wJoystickBY < wJoystickBYDeltaMin || bFirstPass )
			wJoystickBYDeltaMin = wJoystickBY;

		if ( wJoystickBY > wJoystickBYDeltaMax )
			wJoystickBYDeltaMax = wJoystickBY;


		wJoystickAXDelta = (WORD)abs( wJoystickAX - wJoystickAverage );
		wJoystickAYDelta = (WORD)abs( wJoystickAY - wJoystickAverage );

		wJoystickBXDelta = (WORD)abs( wJoystickBX - wJoystickAverage );
		wJoystickBYDelta = (WORD)abs( wJoystickBY - wJoystickAverage );


		sprintf( sTmpString, "%- 4u", wJoystickAX );
		vPrintStringXY( 31,  9, sTmpString, _TXT_BRIGHT_CYAN, _TXT_BLUE );

		sprintf( sTmpString, "%- 4u", wJoystickAY );
		vPrintStringXY( 31, 10, sTmpString, _TXT_BRIGHT_CYAN, _TXT_BLUE );

		sprintf( sTmpString, "%- 4u", wJoystickBX );
		vPrintStringXY( 53,  9, sTmpString, _TXT_BRIGHT_CYAN, _TXT_BLUE );

		sprintf( sTmpString, "%- 4u", wJoystickBY );
		vPrintStringXY( 53, 10, sTmpString, _TXT_BRIGHT_CYAN, _TXT_BLUE );


		if ( bFirstPass )
			bFirstPass = FALSE;

		if ( !bJoystickButtonFlags )
			{
			vPrintStringXY( 25, 12, "   Loop-back Button Test: PASS ", _TXT_WHITE, _TXT_BLUE );
			}
		else
			{
			vPrintStringXY( 25, 12, "   Loop-back Button Test: FAIL ", _TXT_WHITE, _TXT_RED );
			}

		if ( ( wJoystickAXDelta > JOYSTICK_ERROR ) || ( wJoystickAYDelta > JOYSTICK_ERROR ) || ( wJoystickBXDelta > JOYSTICK_ERROR ) || ( wJoystickBYDelta > JOYSTICK_ERROR ) )
			{
			vPrintStringXY( 25, 13, " Loop-back Position Test: FAIL ", _TXT_WHITE, _TXT_RED );
			}
		else
			{
			vPrintStringXY( 25, 13, " Loop-back Position Test: PASS ", _TXT_WHITE, _TXT_BLUE );
			}
		}

	if ( kbhit(  ) )
		getch(  );
		
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vTestMPU401( void )
	{
    vDisplayTitle();

	vDisplayStatusMessage( "MPU401 Port Loop-back Test:                    " );

    if ( bCheckLoopBackPlug(  ) == FALSE )
		{
        vDisplayErrorMessage( "ERROR: The Loop-back plug is disconnected or bad" );
		}
    else
		{
		vDisplayStatusMessage( "MPU401 Port Loop-back Test: In Process Now ...." );

		if ( bTestMPU401(  ) != TRUE )
			{
			vDisplayStatusMessage( "MPU401 Port Loop-back Test: Failed             " );
			vDisplayErrorMessage( "ERROR: Failure testing MPU401 Port" );
			}
		else
			{
			vDisplayStatusMessage( "MPU401 Port Loop-back Test: Passed             " );
			}
		}
		
	vCheckAutoMode();
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bTestControlRam( void )
	{
	BYTE	bRetVal = TRUE;
	
    BYTE    bIndexA,
            bIndexB,
            bColA,
            bColB,
            bBit;

	WORD	wTestWord;
	
	vSetCRamInc( 0 );
    
    for( bIndexA=0; bIndexA < 0x40; bIndexA++ )
		{
        for( bColA=0x00; bColA < 0x10; bColA++ )
			{
            vWrAPUReg( bIndexA, bColA, 0x0000 );
			}
		}   
		
    for( bIndexA=0x00; ( bRetVal == TRUE ) && ( bIndexA < 0x40 ) ; bIndexA++ )
        {
        for( bIndexB=0x00; ( bRetVal == TRUE ) && ( bIndexB < 0x40 ); bIndexB++ )
            {
            if( bIndexA != bIndexB )
                {
                for( bColA=0x01; ( bRetVal == TRUE ) && ( bColA < 0x0B ); bColA++ )
                	{
			        vWrAPUReg( bIndexA, bColA, 0xFFFF );

					for( bColB=0x00; ( bRetVal == TRUE ) && ( bColB < 0x0B ); bColB++ )
						{
						for( bIndexB=0x00; ( bRetVal == TRUE ) && ( bIndexB < 0x40 ); bIndexB++ )
							{
							if( ( bIndexA != bIndexB ) && ( bColA != bColB ) )
								{
								wTestWord = wRdAPUReg( bIndexB, bColB );
								
				                if( wTestWord != 0x0000 )
				                    {
				                    bRetVal = FALSE;
				                    vDisplayDebugMessage("Failed: APU:%02Xh[%02Xh] effected APU:%02Xh[%02Xh]\n", bIndexA, bColA, bIndexB, bColB );
				                    }
				                }    
							}
						}
			        vWrAPUReg( bIndexA, bColA, 0x0000 );

			        if( bRetVal == FALSE )
			            {
			            vWrAPUReg( bIndexB, bColB, 0x0000 );
			            }
	                }
                }
            }
        }

    vPTSBInit(1);
	
	return( bRetVal );
	}


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bTestControlRam2( void )
	{
	BYTE	bRetVal = TRUE;
	
    BYTE    bIndexA,
            bIndexB,
            bRow,
            bCol;

	vSetCRamInc( 0 );

    for( bRow=0; bRow < 0x40; bRow++ )
		{
        for( bCol=0x00; bCol < 0x10; bCol++ )
			{
            vWrAPUReg( (BYTE)bRow, (BYTE)bCol, 0x0000 );
			}
		}   
		
    for( bIndexA=0; bIndexA < 64; bIndexA++ )
        {
        for( bCol=2; bCol < 0x0B; bCol++ )
            {
            vWrAPUReg( bIndexA, bCol, 0xFFFF );

            for( bIndexB=0; bIndexB < 64; bIndexB++ )
                {
                if( bIndexA != bIndexB )
                    {
                    if( wRdAPUReg( bIndexB, bCol ) != 0x0000 )
                        {
                        bRetVal = FALSE;
                        }
                    }
                }
            vWrAPUReg( bIndexA, bCol, 0x0000 );
            }
        }

    vPTSBInit(1);
	
	return( bRetVal );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bTestControlRam3( void )
	{
	BYTE	bRetVal = TRUE;
	
    WORD    wRow,
            wCol;

    WORD    wTestData[64][16];

	vSetCRamInc( 0 );

    for( wRow=0; wRow < 0x40; wRow++ )
		{
        for( wCol=0x00; wCol < 0x10; wCol++ )
			{
            vWrAPUReg( (BYTE)wRow, (BYTE)wCol, 0x0000 );
            wTestData[wRow][wCol] = 0x0000;
			}
		}   
		
	for( wCol=0x01; wCol < 0x0B; wCol++ )
        {
	    for( wRow=0x00; wRow < 0x40; wRow++ )
            {
            wTestData[wRow][wCol] = (WORD)(  ~( ( wRow << 4 ) + wCol ) );
            vWrAPUReg( (BYTE)wRow, (BYTE)wCol, wTestData[wRow][wCol] );
            }
        }
			
    for( wCol=0x01; wCol < 0x0B; wCol++ )
        {
        for( wRow=0x00; wRow < 0x40; wRow++ )
            {
            if( wRdAPUReg( (BYTE)wRow, (BYTE)wCol ) != wTestData[wRow][wCol] )
                {
				vDisplayDebugMessage("Failed Pass 1: %02X %02X\n", wRow, wCol );
                bRetVal = FALSE;
                break;
                }
            }
        }

	for( wCol=0x01; wCol < 0x0B; wCol++ )
        {
	    for( wRow=0x00; wRow < 0x40; wRow++ )
            {
            wTestData[( 0x3F - wRow )][wCol] = (WORD)(  ~( ( ( 0x3F - wRow ) << 4 ) + wCol ) );
            vWrAPUReg( (BYTE)( 0x3F - wRow ), (BYTE)wCol, wTestData[( 0x3F - wRow )][wCol] );
            }
        }
			
    for( wCol=0x01; wCol < 0x0B; wCol++ )
        {
        for( wRow=0x00; wRow < 0x40; wRow++ )
            {
            if( wRdAPUReg( (BYTE)( 0x3F - wRow ), (BYTE)wCol ) != wTestData[( 0x3F - wRow )][wCol] )
                {
				vDisplayDebugMessage("Failed Pass 2: %02X %02X\n", ( 0x3F - wRow ), wCol );
                bRetVal = FALSE;
                break;
                }
            }
        }

    vDisplayDebugMessage("\n");

    vPTSBInit(1);
	
	return( bRetVal );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bTestWavCache( void )
	{
	BYTE	bRetVal = TRUE;
	
	WORD	wRow,
            wCol;
			
    vSetCRamInc( 0 );

    for( wRow=0; wRow < 0x40; wRow++ )
		{
		for( wCol=0; wCol < 0x10; wCol++ )
			{
            vWrAPUReg( (BYTE)wRow, (BYTE)wCol, 0x0000 );
			}
		}   

    for( wRow=0x0000; wRow < 0x0200; wRow++ )
        {
        vWrWCReg( wRow, 0x5555 );
        if( wRdWCReg( wRow ) != 0x5555 )
            {
            bRetVal = FALSE;
            }

        vWrWCReg( wRow, 0xAAAA );
        if( wRdWCReg( wRow ) != 0xAAAA )
            {
            bRetVal = FALSE;
            }
        }

	vPTSBInit(1);
	
	return( bRetVal );
	}


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bTestSigmaRam( void )
	{
	BYTE	bRetVal = TRUE;
	
    BYTE    bRow,
            bCol;
			
    BYTE    bSigmaTestFlag[]    =   {
                                    0,0,1,1,1,1,1,1,
                                    1,1,1,1,1,1,1,1,
                                    1,1,1,1,0,0,1,1,
                                    1,1,1,1,1,1,1,1,
                                    0,0,0,0,0,0,0,0,
                                    0,0,0,0,0,0,0,0,
                                    0,0,0,0,0,0,0,0,
                                    0,0,0,0,0,0,0,0,
                                    };

    vSetCRamInc( 0 );

    for( bRow=0; bRow < 0x40; bRow++ )
		{
        for( bCol=0; bCol < 0x10; bCol++ )
			{
            vWrAPUReg( bRow, bCol, 0x0000 );
			}
		}   

    for( bRow=0x00; bRow < 0x40; bRow++ )
        {
        if( bSigmaTestFlag[bRow] == TRUE )
            {
            vWrAPUReg( bRow, 0x0F, 0x0000 );
            if( wRdAPUReg( bRow, 0x0F ) != 0x0000 )
                {
                bRetVal = FALSE;
				vDisplayDebugMessage("[%02X]:%04X(0000)\n", bRow, wRdAPUReg( bRow, 0x0F ) );
                }

            vWrAPUReg( bRow, 0x0F, 0x5555 );
            if( wRdAPUReg( bRow, 0x0F ) != 0x5555 )
                {
                bRetVal = FALSE;
				vDisplayDebugMessage("[%02X]:%04X(5555)\n", bRow, wRdAPUReg( bRow, 0x0F ) );
                }

            vWrAPUReg( bRow, 0x0F, 0xAAAA );
            if( wRdAPUReg( bRow, 0x0F ) != 0xAAAA )
                {
                bRetVal = FALSE;
				vDisplayDebugMessage("[%02X]:%04X(AAAA)\n", bRow, wRdAPUReg( bRow, 0x0F ) );
                }

            vWrAPUReg( bRow, 0x0F, 0xFFFF );
            if( wRdAPUReg( bRow, 0x0F ) != 0xFFFF )
                {
                bRetVal = FALSE;
				vDisplayDebugMessage("[%02X]:%04X(FFFF)\n", bRow, wRdAPUReg( bRow, 0x0F ) );
                }

            vWrAPUReg( bRow, 0x0F, 0x0000 );
            if( wRdAPUReg( bRow, 0x0F ) != 0x0000 )
                {
                bRetVal = FALSE;
				vDisplayDebugMessage("[%02X]:%04X(0000)\n", bRow, wRdAPUReg( bRow, 0x0F ) );
                }

            }
        }

	vPTSBInit(1);
	
	return( bRetVal );
	}


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bTestConfig( void )
	{
    BYTE    bRetVal = TRUE;
    
    BYTE	bScreenRow = _SCR_STATUS_LINE + 1;

    vClearScreen(  );

	vDisplayTitleMessage( "Testing Configuration ...." );
	vDisplayOptionMessage( "Please Wait ...." );

    vPrintStringXY( 30, bScreenRow++, "Test Interrupt", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );
    vPrintStringXY( 30, bScreenRow++, "Test Timer", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );
    vPrintStringXY( 30, bScreenRow++, "Test WavCache", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );
    vPrintStringXY( 30, bScreenRow++, "Test Sigma RAM", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );
    vPrintStringXY( 30, bScreenRow++, "Test Control RAM", _SCR_USRMNU_FGCOLOR, _SCR_USRMNU_BGCOLOR );

	vDisplayTestConfig(  );

    bScreenRow = _SCR_STATUS_LINE + 1;

    if( bTestIRQChannel( gbPTIRQ ) )
        {
        vPutCharXY( 25, bScreenRow++, CHECKMARK, _TXT_WHITE, _TXT_BLACK );
        }
    else
        {
        vPutCharXY( 25, bScreenRow++, FAILMARK, _TXT_WHITE, _TXT_RED );
        bRetVal = FALSE;
        }

    if( bTestTimer() )
        {
        vPutCharXY( 25, bScreenRow++, CHECKMARK, _TXT_WHITE, _TXT_BLACK );
        }
    else
        {
        vPutCharXY( 25, bScreenRow++, FAILMARK, _TXT_WHITE, _TXT_RED );
        bRetVal = FALSE;
        }

    if( bTestWavCache() )
		{
		vPutCharXY( 25, bScreenRow++, CHECKMARK, _TXT_WHITE, _TXT_BLACK );
		}
	else
		{
		vPutCharXY( 25, bScreenRow++, FAILMARK, _TXT_WHITE, _TXT_RED );
        bRetVal = FALSE;
        }

    if ( bTestSigmaRam() )
		{
        vPutCharXY( 25, bScreenRow++, CHECKMARK, _TXT_WHITE, _TXT_BLACK );
		}
	else
		{
        vPutCharXY( 25, bScreenRow++, FAILMARK, _TXT_WHITE, _TXT_RED );
        bRetVal = FALSE;
		}

    if( bTestControlRam() )
		{
		vPutCharXY( 25, bScreenRow++, CHECKMARK, _TXT_WHITE, _TXT_BLACK );
		}
	else
		{
		vPutCharXY( 25, bScreenRow++, FAILMARK, _TXT_WHITE, _TXT_RED );
        bRetVal = FALSE;
        }

    if( bRetVal == FALSE )
		{
		vDisplayErrorMessage( "ERROR: Failed Configuration test" );
		}

	vCheckAutoMode();
	
    return( bRetVal );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    delay( int dly )
	{
	long    cnt1,
	        cnt2;

	_bios_timeofday( _TIME_GETCLOCK, &cnt1 );
	cnt2 = cnt1;
	while ( ( cnt2 - cnt1 ) != dly )
		{
		_bios_timeofday( _TIME_GETCLOCK, &cnt2 );
		}
	}

/******************************************************************************/
/* iTestDMAChannel - Test Audio DMA Channel                                   */
/*                                                                            */
/******************************************************************************/
int     iTestDMAChannel( BYTE _bDMAChannel )
	{
	WORD    wTransferSize = 4;

	LPBYTE  lpTestPtr = ( LPBYTE ) 0x00000000L;

	iResetDSP(  );

	vSetDMATransfer( _bDMAChannel, lpTestPtr, wTransferSize, _DMA_NON_AI | _DMA_INC | _DMA_SINGLE | _DMA_READ );

	iWrDSP( 0xE2 );
	iWrDSP( 0xAA );
	iWrDSP( 0xE2 );
	iWrDSP( 0xAA );

	vClrDMAFlipFlop( _bDMAChannel );

	lpTestPtr = lpGetDMAAddress( _bDMAChannel, &lpTestPtr );

	iResetDSP(  );

	return ( _FP_OFF( lpTestPtr ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bTestTimer( void )
    {
    BYTE    bTimeoutFlag = FALSE;
    BYTE    bRetVal = FALSE;

    outpw( gwPTBaseIO + 0x04, 0xFFFF );
    outpw( gwPTBaseIO + 0x18, 0x0004 );

	vStopTimer();

	vSetTimer( 23 );
    
    vEnableTimer();

    vSetEventWait( _1_SECOND, &bTimeoutFlag );

    while( bTimeoutFlag == FALSE )
        {
        if( WTSTBIT( inpw( gwPTBaseIO + 0x04 ), 0 ) )
            {
            bRetVal = TRUE;
            break;
            }
        }

    vClearEventWait();

    outpw( gwPTBaseIO + 0x18, 0x0000 );
    outpw( gwPTBaseIO + 0x04, 0xFFFF );

	vStopTimer();

    return( bRetVal );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void _interrupt _far aiTestISR( void )
	{
    bIRQTestFlag[0] = TRUE;

    outpw( gwPTBaseIO + 0x04, inpw( gwPTBaseIO + 0x04 ) | 0x01 );

 /* Send Non-Specific EOI to controller #1 */
	outp( 0x20, 0x20 );

 /* Send Non-Specific EOI to controller #2 */
	outp( 0xA0, 0x20 );

	_enable(  );
	}

/******************************************************************************/
/* iTestIRQChannel - Test Primary Audio IRQ Channel                           */
/*                                                                            */
/******************************************************************************/
BYTE    bTestIRQChannel( BYTE _bInterrupt )
	{
    BYTE    bTimeoutFlag = FALSE;

    BYTE    bRetVal = FALSE;

    outpw( gwPTBaseIO + 0x04, 0xFFFF );
    outpw( gwPTBaseIO + 0x18, 0x0004 );

    vInstallISR( _bInterrupt, aiTestISR );

    bIRQTestFlag[0] = 0;

	vStopTimer();

    vSetTimer( 23 );
	
	vStartTimer();

    vSetEventWait( _1_SECOND, &bTimeoutFlag );

    while( bTimeoutFlag == FALSE )
		{
        if( bIRQTestFlag[0] == TRUE )
            {
            bRetVal = TRUE;
            break;
            }
		}

    vClearEventWait();

    outpw( gwPTBaseIO + 0x18, 0x0000 );
    outpw( gwPTBaseIO + 0x04, 0xFFFF );

    vStopTimer();

    vRemoveISR( _bInterrupt );

    return( bRetVal );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bTestMPU401( void )
	{
	BYTE    bRetVar = TRUE;

	if ( iResetMPU401(  ) != _SB_MPU401_OK )
		bRetVar = FALSE;

	if ( iEnableUartMode(  ) != _SB_MPU401_OK )
		bRetVar = FALSE;

	iWrMPU401Data( 0xAA );
	if ( iRdMPU401Data(  ) != 0xAA )
		{
		bRetVar = FALSE;
		}

	iWrMPU401Data( 0x55 );
	if ( iRdMPU401Data(  ) != 0x55 )
		{
		bRetVar = FALSE;
		}

	iWrMPU401Data( 0x00 );

	if ( iRdMPU401Data(  ) != 0x00 )
		{
		bRetVar = FALSE;
		}

	iWrMPU401Data( 0xFF );

	if ( iRdMPU401Data(  ) != 0xFF )
		{
		bRetVar = FALSE;
		}

	if ( iResetMPU401(  ) != _SB_MPU401_OK )
		{
		bRetVar = FALSE;
		}

	return ( bRetVar );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
DWORD   _filesize( int _iFileHandle )
	{
	union REGS x86Regs;

	DWORD   dwCurrentFilePosition,
	        dwFileSize;

	x86Regs.h.ah = 0x42;
	x86Regs.h.al = 0x01;
	x86Regs.x.bx = _iFileHandle;
	x86Regs.x.cx = 0x00;
	x86Regs.x.dx = 0x00;
	intdos( &x86Regs, &x86Regs );

	dwCurrentFilePosition = ( x86Regs.x.dx << 16 ) + x86Regs.x.ax;

	x86Regs.h.ah = 0x42;
	x86Regs.h.al = 0x02;
	x86Regs.x.bx = _iFileHandle;
	x86Regs.x.cx = 0x00;
	x86Regs.x.dx = 0x00;
	intdos( &x86Regs, &x86Regs );

	dwFileSize = x86Regs.x.dx;
	dwFileSize = dwFileSize << 16;
	dwFileSize += x86Regs.x.ax;

	x86Regs.h.ah = 0x42;
	x86Regs.h.al = 0x00;
	x86Regs.x.bx = _iFileHandle;
	x86Regs.x.dx = LOWORD( dwCurrentFilePosition );
	x86Regs.x.cx = HIWORD( dwCurrentFilePosition );

	intdos( &x86Regs, &x86Regs );

	return ( dwFileSize );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vTestDRAM( void )
	{
    BYTE    bTestStatus = TRUE,
            abTmpString[80];
	
    WORD    wCol,
            wTestWord = 0xAA55;

    DWORD   dwLocalRamSize,
            dwWordAddress;


	vDisplayTitle();

    vSetVirtualWaveEnable( DISABLE );

    vSetCRamInc( 0 );
	
    for( wCol=0; wCol < 0x0400; wCol++ )
        {
        vWrCRam( wCol, 0x0000 );
        }
	
	dwLocalRamSize = HwDetermineLocalRAMSize();
	
    sprintf( (char *)abTmpString, "OnBoard DRAM Test:  Memory Size:% -8lu", dwLocalRamSize );
    vDisplayStatusMessage( (char *)abTmpString );

      if( dwLocalRamSize > 0x100000 )
		{
		vDisplayOptionMessage( "Press any key to stop test" );

        vWrWRamIndex( MAKEDWORD( 0x0000, bGetRamSplit() ) );
		
		for( dwWordAddress=0x0000; dwWordAddress < dwLocalRamSize; dwWordAddress++ )
			{
			if( ( LOWORD( dwWordAddress ) ) == 0x0000 )
				{
				if( kbhit() )
					{
					break;
					}
					
                sprintf( (char *)abTmpString, "Writing: %08lu", dwWordAddress );
                vDisplayCenteredString( 8, (char *)abTmpString, _TXT_BRIGHT_WHITE, _TXT_BLUE );
				}
			vWrWRamData( wTestWord );
			}	
        sprintf( (char *)abTmpString, "Writing: %08lu", dwWordAddress );
        vDisplayCenteredString( 8, (char *)abTmpString, _TXT_BRIGHT_WHITE, _TXT_BLUE );

        vWrWRamIndex( MAKEDWORD( 0x0000, bGetRamSplit() ) );

        bTestStatus = TRUE;

        for( dwWordAddress=0x0000; (bTestStatus != FALSE) && dwWordAddress < dwLocalRamSize; dwWordAddress++ )
			{
			if( ( LOWORD( dwWordAddress ) ) == 0x0000 )
				{
				if( kbhit() )
					{
					break;
					}

                sprintf( (char *)abTmpString, "Reading: %08lu", dwWordAddress );
                vDisplayCenteredString( 8, (char *)abTmpString, _TXT_BRIGHT_WHITE, _TXT_BLUE );
				}

                if( wRdWRamData(  ) != wTestWord )
                    {
                    bTestStatus = FALSE;
                    break;
                    }
			}
	
        sprintf( (char *)abTmpString, "Reading: %08lu", dwWordAddress );
        vDisplayCenteredString( 8, (char *)abTmpString, _TXT_BRIGHT_WHITE, _TXT_BLUE );

		if( bTestStatus == TRUE )
			{
			vDisplayTestMessage( "DRAM Test Passed" );
			}
		else
			{       
            sprintf( (char *)abTmpString, "DRAM Test Failed at Addrress:%08X", dwWordAddress );
            vDisplayErrorMessage( (char *)abTmpString );
			}
		}
		
	vCheckAutoMode();

    vSetVirtualWaveEnable( ENABLE );

	}


