#include	<stdio.h>
#include	<stdlib.h>
#include	<bios.h>
#include	<dos.h>
#include	<conio.h>

#include	"sbtype.h"
#include	"sbconfig.h"
#include	"sbdsp.h"
#include	"sbmix.h"
#include    "sbfm.h"
#include	"sbdelay.h"


#define  DEFAULT_SYNTH  1

#define DIFFPITCH(b,m)    (127+((short)(m)-(short)(b)))
#define CORRFACTOR(b,m,l) ((l)?0L:(dwCorrFactor[DIFFPITCH(b,m)]))
#define CALCPITCH(b,m,l)  (dwPitchTable[DIFFPITCH(b,m)]+(CORRFACTOR(b,m,l)))

#define NOTECOUNT 6

typedef struct fm_op_struct
	{
	unsigned int ksl;
	unsigned int fmult;
	unsigned int fb;
	unsigned int ar;
	unsigned int sl;
	unsigned int ss;
	unsigned int dr;
	unsigned int rr;
	unsigned int tl;
	unsigned int am;
	unsigned int vib;
	unsigned int ksr;
	unsigned int con;
	}       FM_OP;

typedef struct fm_ins_struct
	{
	char    mode;
	char    vnum;
	FM_OP   modulator;
	FM_OP   carrier;
	unsigned int ws_mod;
	unsigned int ws_car;
	}       FM_INS;


 /* c   f   a   c   f   a  */
unsigned int p1[NOTECOUNT] = {48, 53, 57, 60, 65, 69};
unsigned int p2[NOTECOUNT] = {686, 458, 577, 686, 458, 577};
unsigned int p3[NOTECOUNT] = {2, 3, 3, 3, 4, 4};

unsigned int operon[32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

unsigned char fm_ins[56] =
	{0x00, 0x00,

	0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x05, 0x00,
	0x00, 0x00, 0x03, 0x00, 0x06, 0x00, 0x23, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00,

	0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x05, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00,

	0x00, 0x00};

FM_INS *fm_ins_ptr;

/******************************************************************************/
/*                                                                            */
/*                                                                            */
/******************************************************************************/
void    vPlayFMSynth( void )
	{
	int     i;

	for ( i = 0; i < 4; i++ )
		{
		playsynth_sb(  );
		if ( kbhit(  ) )
			{
			getch(  );
			break;
			}
		}																	   /* endwhile */
	}
/******************************************************************************/
/*                                                                            */
/*                                                                            */
/******************************************************************************/
void    playsynth_sb( void )
	{
    short   i;
 /* Set AdLib instrument */
	load_ins_data(  );

 /* Turn on operators  */
	for ( i = 0; i < NOTECOUNT && !kbhit(  ); ++i )
		{

	/* Operator On   */
		fm_write( ( unsigned char ) ( 0xa0 + i ), p2[i] & 0xFF );
		fm_write( ( unsigned char ) ( 0xb0 + i ), ( p2[i] >> 8 ) | ( p3[i] << 2 ) | 0x20 );
		operon[i] = TRUE;

        vDelay( 0x3D090 );
        }


 /* Turn off the operators */
	for ( i = 0; i < NOTECOUNT; ++i )
		{
	/* Operator Off */
		fm_write( ( unsigned char ) ( 0xb0 + i ), ( p2[i] >> 8 ) | ( p3[i] << 2 ) );

		operon[i] = FALSE;
		}
	}

/******************************************************************************/
/*                                                                            */
/*                                                                            */
/******************************************************************************/
void    load_ins_data( void )
	{
	short   i,
	        j,
	        k;
		unsigned char offset[18] = {0x00, 0x03, 0x01, 0x04, 0x02, 0x05,
		0x08, 0x0B, 0x09, 0x0C, 0x0A, 0x0D,
		0x10, 0x13, 0x11, 0x14, 0x12, 0x15};
	fm_ins_ptr = ( FM_INS * ) & fm_ins;

	for ( i = 0; i < 9; ++i )
		{
		j = offset[i * 2];
		k = offset[( i * 2 ) + 1];

		fm_write( ( unsigned char ) ( 0x20 + j ), ( fm_ins_ptr->modulator.am << 7 ) |
			( fm_ins_ptr->modulator.vib << 6 ) |
			( fm_ins_ptr->modulator.ss << 5 ) |
			( fm_ins_ptr->modulator.ksr << 4 ) |
			fm_ins_ptr->modulator.fmult );

		fm_write( ( unsigned char ) ( 0x20 + k ), ( fm_ins_ptr->carrier.am << 7 ) |
			( fm_ins_ptr->carrier.vib << 6 ) |
			( fm_ins_ptr->carrier.ss << 5 ) |
			( fm_ins_ptr->carrier.ksr << 4 ) |
			fm_ins_ptr->carrier.fmult );

		fm_write( ( unsigned char ) ( 0x40 + j ), ( fm_ins_ptr->modulator.ksl << 6 ) |
			( fm_ins_ptr->modulator.tl ) );
		fm_write( ( unsigned char ) ( 0x40 + k ), ( fm_ins_ptr->carrier.ksl << 6 ) |
			( fm_ins_ptr->carrier.tl ) );

		fm_write( ( unsigned char ) ( 0x60 + j ), ( fm_ins_ptr->modulator.ar << 4 ) |
			fm_ins_ptr->modulator.dr );
		fm_write( ( unsigned char ) ( 0x60 + k ), ( fm_ins_ptr->carrier.ar << 4 ) |
			fm_ins_ptr->carrier.dr );

		fm_write( ( unsigned char ) ( 0x80 + j ), ( fm_ins_ptr->modulator.sl << 4 ) |
			fm_ins_ptr->modulator.rr );
		fm_write( ( unsigned char ) ( 0x80 + k ), ( fm_ins_ptr->carrier.sl << 4 ) |
			fm_ins_ptr->carrier.rr );

		fm_write( ( unsigned char ) ( 0xc0 + i ), ( fm_ins_ptr->modulator.fb << 1 ) |
			fm_ins_ptr->modulator.con );

		fm_write( ( unsigned char ) ( 0xe0 + j ), fm_ins_ptr->ws_mod );
		fm_write( ( unsigned char ) ( 0xe0 + k ), fm_ins_ptr->ws_car );

		}
	}
/******************************************************************************/
/*                                                                            */
/*                                                                            */
/******************************************************************************/
void    fm_write( unsigned char addr, unsigned int dat )
	{
	unsigned int i;
	outp( _SB_FM_REG_SELECT, addr );

 /* wait 3.3 us  */
	for ( i = 0; i < 3; ++i )
		inp( _SB_FM_REG_SELECT );

	outp( _SB_FM_REG_DATA, ( unsigned char ) dat );

 /* wait 23 us */
	for ( i = 0; i < 23; ++i )
		inp( _SB_FM_REG_SELECT );
	}
