/*****************************************************************************/
/* DSP Type Definitions                                                      */
/*****************************************************************************/
#define	_SB_NON_AI		0x00
#define	_SB_AI			0x01

#define	_SB_MONO		0x00
#define	_SB_STEREO		0x02

#define	_SB_UNSIGNED	0x00
#define	_SB_SIGNED		0x04

#define	_SB_SINGLE		0x00
#define	_SB_DEMAND		0x08

#define	_SB_8BIT		0x00
#define	_SB_16BIT		0x10


/*****************************************************************************/
/*  I/O Port Declarations                                                    */
/*****************************************************************************/
#define	_SB_DSP_RESET			( gwIOAudio + 0x06 )

#define	_SB_DSP_DATA_IN			( gwIOAudio + 0x0A )
#define	_SB_DSP_DATA_OUT		( gwIOAudio + 0x0C )

/* Sound Blaster Pro Input Status */
#define	_SB_DSP_RD_STATUS   	( gwIOAudio + 0x0E)
#define	_SB_DSP_RD_MSK      	0x80
#define	_SB_DSP_RD_RDY      	0x80

/* Sound Blaster Pro Output Status */
#define	_SB_DSP_WR_STATUS   	( gwIOAudio + 0x0C )
#define	_SB_DSP_WR_MSK			0x80
#define	_SB_DSP_WR_RDY      	0x00

/*****************************************************************************/
/*  DSP Register Bitmask & Status Definitions                                */
/*****************************************************************************/
#define	_SB_DSP_RESET_ON		0x01				/* Enable DSP Reset */
#define	_SB_DSP_RESET_OFF		0x00				/* Disable DSP Reset */

#define	_SB_DSP_RESET_OK		0xAA				/* DSP Reset Response */

/*****************************************************************************/
/*  DSP Error Code Definitions                                               */
/*****************************************************************************/
#define	_SB_DSP_OK				0x00				/* No Error */
#define	_SB_DSP_ERROR			-1					/* General DSP Error */
#define	_SB_DSP_TIMEOUT_ERROR	-2					/* General DSP Timeout Error */
#define	_SB_DSP_RESET_ERROR		-3					/* DSP Reset Timeout Error */
#define	_SB_DSP_RD_ERROR		-4					/* DSP Read Timeout Error */
#define	_SB_DSP_WR_ERROR		-5					/* DSP Write Timeout Error */

/*****************************************************************************/
/*  DSP Timeout Definitions                                                  */
/*****************************************************************************/
#define _SB_DSP_RESET_TIMEOUT   0xF424               /* DSP Reset Timeout Value */
#define _SB_DSP_RD_TIMEOUT      0xF424               /* DSP Read Timeout Value */
#define _SB_DSP_WR_TIMEOUT      0xF424               /* DSP Write Timeout Value */

/*****************************************************************************/
/*  Function Declarations                                                    */
/*****************************************************************************/
BYTE	bGetDSPStatus( void );
BYTE	bGetDSPRdStatus( void );
BYTE	bGetDSPWrStatus( void );

int		iWrDSP( BYTE _bDSPData );
int		iRdDSP( void );

int		iResetDSP( void );

int		iGetDACStatus( void );
int		iEnableDAC( void );
int		iDisableDAC( void );

int		iSetDSPSampleRate( WORD _wSampleRate );
int		iSetDSPTransferSize( WORD _wBufferSize );

int     iSetDACTransfer( LPBYTE _lpBufferPtr, BYTE _bBufferCount, WORD _wBufferSize, WORD _wSampleRate, BYTE _bModeFlags );
int     iSetADCTransfer( LPBYTE _lpBufferPtr, BYTE _bBufferCount, WORD _wBufferSize, WORD _wSampleRate, BYTE _bModeFlags );

int		iStartDACTransfer( void );
int		iStartADCTransfer( void );

int		iStopDSPTransfer( void );
int		iPauseDSPTransfer( void );
int		iResumeDSPTransfer( void );

/*****************************************************************************/
/*  Function Declarations                                                    */
/*****************************************************************************/
