#include	<stdio.h>
#include	<stdlib.h>
#include	<conio.h>
#include	<dos.h>

#include	"sbtype.h"
#include	"sbconfig.h"
#include	"sbdelay.h"
#include    "sbmix.h"
#include    "sbdsp.h"
#include	"ic8237.h"


/*****************************************************************************/
/* bGetDSPRdStatus - Get DSP Read Status                                     */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDSPRdStatus( void )
	{
	return ( ( BYTE ) ( ( ( inp( _SB_DSP_RD_STATUS ) & _SB_DSP_RD_MSK ) == _SB_DSP_RD_RDY ) ? 1 : 0 ) );
	}

/*****************************************************************************/
/* bGetDSPWrStatus - Get DSP Write Status                                    */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDSPWrStatus( void )
	{
	return ( ( BYTE ) ( ( ( inp( _SB_DSP_WR_STATUS ) & _SB_DSP_WR_MSK ) == _SB_DSP_WR_RDY ) ? 1 : 0 ) );
	}

/*****************************************************************************/
/* iWrDSP - Write Data to DSP                                                */
/*                                                                           */
/*****************************************************************************/
int     iWrDSP( BYTE _bDSPData )
	{
	int     iRetVal = _SB_DSP_ERROR;

    BYTE    bTimeoutFlag = FALSE;

    vSetEventWait( _SB_DSP_WR_TIMEOUT, &bTimeoutFlag );

    while( bTimeoutFlag == FALSE )
		if ( bGetDSPWrStatus(  ) )
			{
			outp( _SB_DSP_DATA_OUT, _bDSPData );
			iRetVal = _SB_DSP_OK;
			break;
			}

    vClearEventWait();

	return ( iRetVal );
	}

/*****************************************************************************/
/* iRdDSP - Read Data from DSP                                               */
/*                                                                           */
/*****************************************************************************/
int     iRdDSP( void )
	{
	int     iRetVal = _SB_DSP_ERROR;

    BYTE    bTimeoutFlag = FALSE;

    vSetEventWait( _SB_DSP_RD_TIMEOUT, &bTimeoutFlag );

    while ( bTimeoutFlag == FALSE )
		if ( bGetDSPRdStatus(  ) )
			{
			iRetVal = inp( _SB_DSP_DATA_IN );
			break;
			}

    vClearEventWait();

    return ( iRetVal );
	}

/*****************************************************************************/
/* iResetDSP - Rsbet DSP and Return DSP Status                               */
/*                                                                           */
/*****************************************************************************/
int     iResetDSP( void )
	{
    vDisplayDebugMessage( "iResetDSP\n" );

	outp( _SB_DSP_RESET, _SB_DSP_RESET_ON );
    vDelay( _SB_DSP_RESET_TIMEOUT );

	outp( _SB_DSP_RESET, _SB_DSP_RESET_OFF );
    vDelay( _SB_DSP_RESET_TIMEOUT );

	return ( iRdDSP(  ) );
	}

/*****************************************************************************/
/* iGetDACStatus - Return DAC Speaker Status (0=Off,1=On)                    */
/*                                                                           */
/*****************************************************************************/
int     iGetDACStatus( void )
	{
	iWrDSP( 0xD8 );															   /* Get DAC Speaker Status Command */
	return ( ( iRdDSP(  ) == 0xFF ) ? ON : OFF );
	}

/*****************************************************************************/
/* iEnableDAC - Enable DAC Output (SpeakerOn)                                */
/*                                                                           */
/*****************************************************************************/
int     iEnableDAC( void )
	{
	int     iRetVal = _SB_DSP_ERROR;

    vDisplayDebugMessage( "iEnableDAC\n" );

	if ( iWrDSP( 0xD1 ) != _SB_DSP_ERROR )
		iRetVal = _SB_DSP_OK;

	return ( iRetVal );
	}

/*****************************************************************************/
/* iDisableDAC - Disable DAC Output (SpeakerOff)                             */
/*                                                                           */
/*****************************************************************************/
int     iDisableDAC( void )
	{
	int     iRetVal = _SB_DSP_ERROR;

    vDisplayDebugMessage( "iDisableDAC\n" );

	if ( iWrDSP( 0xD3 ) != _SB_DSP_ERROR )
		iRetVal = _SB_DSP_OK;

	return ( iRetVal );
	}

/*****************************************************************************/
/* iSetDSPSampleRate - Set Playback/Record DSP Samplng Rate                  */
/*                                                                           */
/*****************************************************************************/
int     iSetDSPSampleRate( WORD _wSampleRate )
	{
	int     iRetVal = _SB_DSP_ERROR;

    vDisplayDebugMessage( "iSetDSPSampleRate = SampleRate:%u\n", _wSampleRate );

	if( iWrDSP( 0x40 ) == _SB_DSP_OK )
		{
		if( iWrDSP( HIBYTE( 65536 - ( 256000000 / _wSampleRate ) ) ) == _SB_DSP_OK )
			{
			iRetVal = _SB_DSP_OK;
			}
		}

	return ( iRetVal );
	}

/*****************************************************************************/
/* iSetDSPTransferSize - Set BufferSize for DSP Transfer                     */
/*                                                                           */
/*****************************************************************************/
int		iSetDSPTransferSize( WORD _wBufferSize )
	{
	int	iRetVal = _SB_DSP_ERROR;
	
    vDisplayDebugMessage( "iSetDSPTransferSize = Size:%04X\n", _wBufferSize );

	if( iWrDSP( 0x48 ) == _SB_DSP_OK )
		if( iWrDSP( LOBYTE( _wBufferSize ) ) == _SB_DSP_OK )
			if( iWrDSP( HIBYTE( _wBufferSize ) ) == _SB_DSP_OK )
				{
				iRetVal = _SB_DSP_OK;
				}

    return( iRetVal );
	}

/*****************************************************************************/
/* iStopDSPTransfer - Stop dsp transfer                                      */
/*                                                                           */
/*****************************************************************************/
int     iStartDACTransfer( void )
	{
	int     iRetVal = _SB_DSP_ERROR;

    vDisplayDebugMessage( "iStartDACTransfer\n" );

	return( iWrDSP( 0x90 ) );
	}

/*****************************************************************************/
/* iStopDSPTransfer - Stop dsp transfer                                      */
/*                                                                           */
/*****************************************************************************/
int     iStartADCTransfer( void )
	{
	int     iRetVal = _SB_DSP_ERROR;

    vDisplayDebugMessage( "iStartADCTransfer\n" );


	return( iWrDSP( 0x98 ) );
	}

/*****************************************************************************/
/* iStopDSPTransfer - Stop dsp transfer                                      */
/*                                                                           */
/*****************************************************************************/
int     iStopDSPTransfer( void )
	{
	int     iRetVal = _SB_DSP_ERROR;

    vDisplayDebugMessage( "iStopDSPTransfer\n" );

	return( iWrDSP( 0xD0 ) );
	}

/*****************************************************************************/
/* iPauseDSPTransfer - Pause dsp transfer                                    */
/*                                                                           */
/*****************************************************************************/
int     iPauseDSPTransfer( void )
	{
	int     iRetVal = _SB_DSP_ERROR;

    vDisplayDebugMessage( "iPauseDSPTransfer\n" );

	return( iWrDSP( 0xD0 ) );
	}

/*****************************************************************************/
/* iRsbumeDSPTransfer - Rsbume dsp transfer                                  */
/*                                                                           */
/*****************************************************************************/
int     iResumeDSPTransfer( void )
	{
	int     iRetVal = _SB_DSP_ERROR;

    vDisplayDebugMessage( "iResumeDSPTransfer\n" );

	return( iWrDSP( 0xD4 ) );
	}

/*****************************************************************************/
/* iSetDACTransfer - Setup DSP Transfer for DAC Output (Playback)            */
/*                                                                           */
/*****************************************************************************/
int     iSetDACTransfer( LPBYTE _lpBufferPtr, BYTE _bBufferCount, WORD _wBufferSize, WORD _wSampleRate, BYTE _bDSPModeFlags )
	{
	int     iRetVal = _SB_DSP_ERROR;

	BYTE	bDMAModeFlags = _DMA_READ;
	
    vDisplayDebugMessage( "iSetDACTransfer = SampleRate:% 5u Buffer:%04X:%04X\n", _wSampleRate, _FP_SEG( _lpBufferPtr ), _FP_OFF( _lpBufferPtr ) );

	if( _bDSPModeFlags & _SB_AI )
		{
		bDMAModeFlags |= _DMA_AI;
		}
	else
		{
		bDMAModeFlags |= _DMA_NON_AI;
		}
	
	if( _bDSPModeFlags & _SB_DEMAND )
		{
		bDMAModeFlags |= _DMA_DEMAND;
		}
	else
		{
		bDMAModeFlags |= _DMA_SINGLE;
		}
		
	vSetDMATransfer( gbDMAAudio, _lpBufferPtr, _bBufferCount * _wBufferSize, bDMAModeFlags );

	iSetDSPTransferSize( _wBufferSize );
	
	return ( iRetVal );
	}

/*****************************************************************************/
/* iSetDACTransfer - Setup DSP Transfer for DAC Output (Playback)            */
/*                                                                           */
/*****************************************************************************/
int     iSetADCTransfer( LPBYTE _lpBufferPtr, BYTE _bBufferCount, WORD _wBufferSize, WORD _wSampleRate, BYTE _bDSPModeFlags )
	{
	int     iRetVal = _SB_DSP_ERROR;


	BYTE	bDMAModeFlags = _DMA_WRITE;
	
    vDisplayDebugMessage( "iSetADCTransfer = SampleRate:% 5u Buffer:%04X:%04X\n", _wSampleRate, _FP_SEG( _lpBufferPtr ), _FP_OFF( _lpBufferPtr ) );


	if( _bDSPModeFlags & _SB_AI )
		{
		bDMAModeFlags |= _DMA_AI;
		}
	
	if( _bDSPModeFlags & _SB_DEMAND )
		{
		bDMAModeFlags |= _DMA_DEMAND;
		}
	else
		{
		bDMAModeFlags |= _DMA_SINGLE;
		}
		
	vSetDMATransfer( gbDMAAudio, _lpBufferPtr, _bBufferCount * _wBufferSize, bDMAModeFlags );

	iSetDSPTransferSize( _wBufferSize );
	
	return ( iRetVal );
	}

