#include    <stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<math.h>
#include	<dos.h>
#include	<conio.h>

#include	"sbtype.h"
#include	"sbconfig.h"
#include	"sbdsp.h"
#include    "sbmix.h"

#include	"ptconfig.h"
#include	"io32bit.h"
#include    "pciio.h"
#include    "m2.h"
#include    "cram.h"
#include    "apu.h"
#include    "wp.h"
#include    "pt101.h"
#include    "ac97.h"
#include    "codec.h"
#include    "assp.h"
#include    "wavcache.h"

#include	"kernel.h"
#include    "ptsbinit.h"


#define _APU_MIXER  0x06
//#define _APU_SYNR   0x3C
//#define _APU_SYNL   0x3D
BYTE _APU_SYNR = 0x3C;
BYTE _APU_SYNL = 0x3D;
#define _APU_DIGL   0x3E
#define _APU_DIGR   0x3F
#define _APU_IISL	0x38	//IIS Left
#define _APU_IISR	0x39	//IIS Right

#define DEVICE_ENABLE       0x80000000

WORD FMCode000[256] = {
0x7980, 0x003C, 0x7980, 0x007D, 0xBE3A, 0x8B00, 0xBE3A, 0x8B00, 
0xBE3A, 0x8B00, 0xBE3A, 0x8B00, 0xBE3A, 0x8B00, 0xBE3A, 0x8B00, 
0xBE3A, 0x8B00, 0x7980, 0x0069, 0x7980, 0x0069, 0x8B00, 0x8B00, 
0x8B00, 0x8B00, 0x8B00, 0x8B00, 0x8B00, 0x8B00, 0x8B00, 0x8B00, 
0x8B00, 0x8B00, 0xEF00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
0x0000, 0x0000, 0x0000, 0x0000, 0xBE41, 0xBF80, 0x0101, 0x8806, 
0x8804, 0xB912, 0x8807, 0xBC26, 0xBE40, 0xB92F, 0x9001, 0x9002,
0x003B, 0x0122, 0x7A88, 0x0055, 0x003A, 0x013C, 0x7A88, 0x0055, 
0x4902, 0xE200, 0x0050, 0x7980, 0x0800, 0xB908, 0x8809, 0xBEC6, 
0x0067, 0x4A80, 0xE200, 0x0065, 0x4880, 0xE200, 0x0063, 0xB97F, 
0x6E80, 0x7980, 0x0066, 0x1089, 0x9088, 0xB900, 0x90A9, 0x8BA8,
0xEF00, 0x803D, 0x0003, 0x1007, 0x881F, 0x8B88, 0xBB0F, 0xADA0, 
0x0810, 0x9003, 0x4903, 0xE200, 0x007B, 0x9002, 0x6A05, 0x6D04,
0x9803, 0x9804, 0x9005, 0x003D, 0xBE3A, 0xAF06, 0x0000, 0x803D, 
0x8B88, 0x6906, 0x8810, 0xAF06, 0x0001, 0xBFB0, 0x00FF, 0xBAF5, 
0xE3CC, 0x009A, 0x5E06, 0x003F, 0xBF80, 0x0080, 0x4A06, 0xE200, 
0x0095, 0x6E80, 0x6D06, 0x7980, 0x009B, 0x9080, 0x0810, 0xBA46, 
0x8810, 0x8B00, 0x1006, 0x9080, 0x003D, 0xBE3A, 0x1024, 0x2009, 
0x8810, 0x8B88, 0x8B00, 0x1089, 0xBFB0, 0x000E, 0xBE0A, 0x880D,
0x903E, 0x1038, 0x2008, 0x8810, 0x1037, 0x2008, 0x8811, 0x5F3E, 
0x0000, 0x8B00, 0xF500, 0x5E80, 0xFFFE, 0x1039, 0x2008, 0x8815, 
0x8B8D, 0x0231, 0x0333, 0x108A, 0x90AD, 0x1025, 0x200A, 0x8815, 
0x0605, 0xB91F, 0x8809, 0x4F16, 0x1080, 0xF600, 0xBFB0, 0x0003,
0xBFB0, 0x0007, 0x9089, 0xBE47, 0xBE43, 0xBEC6, 0x00F6, 0x4F8B, 
0x14A8, 0xE500, 0x6380, 0x8B89, 0x4E8A, 0xBFE3, 0xE500, 0x2480,
0xBE46, 0x8B9D, 0xBFE7, 0xBFB0, 0x00FF, 0x288C, 0x2026, 0x8814,
0xBE47, 0x8B00, 0x738F, 0x54AA, 0xBE03, 0xBE0A, 0x2FA8, 0x988A, 
0x8DA9, 0xBE03, 0x4D8E, 0xBFE1, 0xF500, 0x6180, 0x9880, 0x8BA9, 
0xBE03, 0x4C8E, 0xBFE1, 0xF500, 0x6180, 0x9880, 0x8BA9, 0xBE42, 
0x1039, 0x2008, 0x8815, 0x8B8D, 0x8B00, 0x8D8A, 0x7980, 0x0BE3 };

WORD FMCode800[] = {
0x0005, 0xB900, 0x9008, 0x9009, 0x900A, 0xBB3F, 0x90A0, 0x001A, 0x011B, 0x021C, 0x0323, 0x1089, 0x9015, 0x108A, 0x9016, 0x108B,
0x9017, 0x1088, 0x9018, 0x1041, 0xBE20, 0x0137, 0x0524, 0x8B8D, 0x4F16, 0xE200, 0x0829, 0x4F15, 0xE200, 0x0829, 0x7A80, 0x08E8,
0x102C, 0xB802, 0x8813, 0x8B8B, 0xB900, 0x90A0, 0x908D, 0x7980, 0x0835, 0x7A80, 0x0915, 0x7803, 0x7A80, 0x0915, 0x102C, 0xB802,
0x8813, 0x8B8B, 0xB903, 0x90A0, 0x908D, 0x7C02, 0x4F16, 0xE200, 0x0847, 0x4E15, 0xE200, 0x0847, 0x7A80, 0x08E8, 0x102C, 0xB806,
0x8813, 0x8B8B, 0xB901, 0x90A0, 0x908D, 0x7980, 0x0853, 0x7A80, 0x0915, 0x7803, 0x7A80, 0x0915, 0x102C, 0xB806, 0x8813, 0x8B8B,
0xB904, 0x90A0, 0x908D, 0x7C02, 0x4F16, 0xE200, 0x0865, 0x4D15, 0xE200, 0x0865, 0x7A80, 0x08E8, 0x102C, 0xB80A, 0x8813, 0x8B8B,
0xB902, 0x90A0, 0x908D, 0x7980, 0x0871, 0x7A80, 0x0915, 0x7803, 0x7A80, 0x0915, 0x102C, 0xB80A, 0x8813, 0x8B8B, 0xB905, 0x90A0,
0x908D, 0x7801, 0x7A80, 0x0915, 0x7801, 0x7A80, 0x0915, 0x7801, 0x7A80, 0x0915, 0x1024, 0xBF90, 0x0100, 0x8815, 0x4F16, 0xE200,
0x0890, 0x4C15, 0xE200, 0x0890, 0x7A80, 0x08E8, 0x102C, 0xB814, 0x8813, 0x8B8B, 0xBF80, 0x0100, 0x90A0, 0x908D, 0x7980, 0x089D,
0x7A80, 0x0915, 0x7803, 0x7A80, 0x0915, 0x102C, 0xB814, 0x8813, 0x8B8B, 0xBF80, 0x0103, 0x90A0, 0x908D, 0x7C02, 0x4F16, 0xE200,
0x08B0, 0x4B15, 0xE200, 0x08B0, 0x7A80, 0x08E8, 0x102C, 0xB818, 0x8813, 0x8B8B, 0xBF80, 0x0101, 0x90A0, 0x908D, 0x7980, 0x08BD,
0x7A80, 0x0915, 0x7803, 0x7A80, 0x0915, 0x102C, 0xB818, 0x8813, 0x8B8B, 0xBF80, 0x0104, 0x90A0, 0x908D, 0x7C02, 0x4F16, 0xE200,
0x08D0, 0x4A15, 0xE200, 0x08D0, 0x7A80, 0x08E8, 0x102C, 0xB81C, 0x8813, 0x8B8B, 0xBF80, 0x0102, 0x90A0, 0x908D, 0x7980, 0x08DD,
0x7A80, 0x0915, 0x7803, 0x7A80, 0x0915, 0x102C, 0xB81C, 0x8813, 0x8B8B, 0xBF80, 0x0105, 0x90A0, 0x908D, 0x7801, 0x7A80, 0x0915,
0x7801, 0x7A80, 0x0915, 0x7801, 0x7A80, 0x0915, 0x7980, 0x0922, 0x4F80, 0x7803, 0xE100, 0x0900, 0x4F89, 0xE100, 0x08F7, 0xB901,
0x90A0, 0xB902, 0x90A0, 0x90A0, 0xB906, 0x90AD, 0xEF00, 0xB901, 0x90A0, 0xB906, 0x90A0, 0xB900, 0x90A0, 0xB906, 0x90AD, 0xEF00,
0x4F89, 0xE100, 0x090C, 0xB905, 0x90A0, 0xB900, 0x90A0, 0xB902, 0x90A0, 0xB906, 0x90AD, 0xEF00, 0xB905, 0x90A0, 0xB900, 0x90A0,
0xB906, 0x90A0, 0xB904, 0x90AD, 0xEF00, 0x4F89, 0xE100, 0x091D, 0xB901, 0x90A0, 0xB906, 0x90AD, 0xEF00, 0xB905, 0x90A0, 0xB904,
0x90AD, 0xEF00, 0xB91F, 0x8809, 0x0034, 0x8B88, 0xBEC6, 0x0934, 0x1313, 0xBE1E, 0x1014, 0xBE1A, 0xBE01, 0xBFE8, 0xBE17, 0x6A13,
0x6214, 0xBE14, 0x9813, 0x9014, 0x98A0, 0xBE47, 0x5F0F, 0x002E, 0xE200, 0x093F, 0xBF80, 0xFFD2, 0x900F, 0x7980, 0x0942, 0x100F,
0xB801, 0x900F, 0x400F, 0x8B00, 0xE500, 0xBE01, 0xBE09, 0x9010, 0xBE46, 0x5F11, 0x003F, 0xE200, 0x0951, 0xB900, 0x9011, 0x7980,
0x0954, 0x1011, 0xB801, 0x9011, 0x1042, 0xBE20, 0x1001, 0xE388, 0x0BE3, 0x1021, 0x2009, 0x8813, 0x8B8B, 0x8B00, 0x1080, 0xBFE6,
0x7810, 0x8B00, 0x8B00, 0x2180, 0xBFB0, 0x0007, 0x4C11, 0x8B00, 0xE100, 0x0970, 0x4B11, 0x8B00, 0xE600, 0xB900, 0x7980, 0x0971,
0xBE0A, 0x4A11, 0x8B00, 0xE500, 0xBE01, 0x9012, 0x1037, 0x2008, 0x8811, 0x102E, 0x2008, 0x8812, 0x4A89, 0xB901, 0xE500, 0x9019,
0xE100, 0x09CD, 0xB900, 0x9019, 0x4A18, 0xE200, 0x09CD, 0x5F0A, 0x0010, 0xE200, 0x0991, 0x4B18, 0xB901, 0xE500, 0x9019, 0x7980,
0x09CD, 0x5F0A, 0x0013, 0xE200, 0x099B, 0x4B18, 0xB901, 0xE500, 0x9019, 0x7980, 0x09CD, 0x5F0A, 0x0011, 0xE200, 0x09A8, 0x4F18,
0xB905, 0xE500, 0x9080, 0xB901, 0xE500, 0x9019, 0x7980, 0x09CD, 0x5F0A, 0x0014, 0xE200, 0x09B5, 0x4C18, 0xB904, 0xE500, 0x9080,
0xB901, 0xE500, 0x9019, 0x7980, 0x09CD, 0x5F0A, 0x0012, 0xE200, 0x09C2, 0x4D18, 0xB905, 0xE500, 0x9080, 0xB901, 0xE500, 0x9019,
0x7980, 0x09CD, 0x5F0A, 0x0015, 0xE200, 0x09CD, 0x4E18, 0xB904, 0xE500, 0x9080, 0xB901, 0xE500, 0x9019, 0x8B8A, 0x4F19, 0xE200,
0x09D8, 0x4B80, 0xE200, 0x09DA, 0x5D80, 0x0020, 0x7980, 0x09DD, 0x5D80, 0x0010, 0x4A80, 0xE200, 0x0BDE, 0x1043, 0xBE20, 0x1001,
0xBA01, 0x9001, 0x1024, 0x2009, 0x8815, 0x8B89, 0x4D8D, 0xE200, 0x09FE, 0x4F16, 0xE100, 0x09F3, 0x8B89, 0x1080, 0xBFC0, 0x000C,
0x908C, 0x7980, 0x09FE, 0x4B89, 0x108D, 0xF600, 0xBFB0, 0x0003, 0x4A89, 0x8B00, 0xF500, 0xBFC0, 0x0008, 0x908C, 0x1022, 0x2009,
0x8811, 0x102E, 0x2008, 0x8812, 0x102F, 0x2008, 0x8813, 0x1020, 0x200A, 0x8814, 0x101D, 0x200A, 0x8815, 0x8B8A, 0x4F19, 0xE100,
0x0A17, 0x5E80, 0x0020, 0x5D80, 0x0018, 0x7980, 0x0A46, 0x1045, 0xBE20, 0x4F80, 0xE200, 0x0A26, 0x8B8B, 0x108A, 0xBFA0, 0x7FC0,
0x8B00, 0xF704, 0x5C80, 0x0003, 0x7980, 0x0A46, 0x4E80, 0xE200, 0x0A3E, 0x8B8C, 0x178B, 0xBE01, 0xBFB7, 0x00F0, 0x308A, 0xE344,
0x0A46, 0x8B8D, 0x4A8A, 0x8B00, 0xE200, 0x0A3A, 0x5C80, 0x0006, 0x7980, 0x0A46, 0x5C80, 0x000A, 0x7980, 0x0A46, 0x4C80, 0xE200,
0x0A46, 0x4B80, 0x8B00, 0xF500, 0x5C80, 0x0019, 0x1046, 0xBE20, 0x4F80, 0xE200, 0x0A57, 0x101F, 0x200A, 0x8816, 0x8B00, 0x8B00,
0x8B8E, 0x1780, 0xBFB7, 0x00F0, 0x900B, 0x7980, 0x0A6E, 0x4E80, 0xE200, 0x0A66, 0x101F, 0x200A, 0x8816, 0x8B00, 0x8B00, 0x8B8E,
0x1B80, 0xBFBB, 0x000F, 0x900B, 0x7980, 0x0A6E, 0x4C80, 0xE200, 0x0A6E, 0x8B8C, 0x1B80, 0xBFBB, 0x000F, 0x900B, 0x8B89, 0x1880,
0xBFB8, 0x001C, 0x4917, 0xE100, 0x0A78, 0x4F80, 0x7980, 0x0A7A, 0x4E80, 0x8B00, 0xF500, 0xBF98, 0x0002, 0x8B8D, 0x4B89, 0x8B00,
0xE600, 0xBFE1, 0x903E, 0xBE43, 0x6A0B, 0x613E, 0xBFE8, 0x980C, 0xBE42, 0x1049, 0xBE20, 0x7C10, 0x1080, 0xBFE5, 0xBE1E, 0x7810,
0x1280, 0xBFB2, 0x001F, 0xBE11, 0x2027, 0x8811, 0x101E, 0x200A, 0x8816, 0x8B00, 0x128E, 0x4980, 0xE100, 0x0AA7, 0x4880, 0xE100,
0x0AA4, 0xB900, 0x7980, 0x0AAB, 0xBE0A, 0x7980, 0x0AAB, 0x4880, 0xE200, 0x0AAB, 0xBE09, 0xBE1E, 0x104A, 0xBE20, 0x158D, 0xBFB5,
0x003F, 0xBE11, 0x4889, 0xE200, 0x0ABC, 0xBE1E, 0x1010, 0x4818, 0x8B00, 0xE600, 0xBFE1, 0xBE11, 0xBFE1, 0x8811, 0xBE1E, 0xB9FF,
0x8819, 0x8B00, 0x8B00, 0xBF46, 0x8B00, 0xE600, 0xBE1F, 0xBE01, 0xBFB0, 0x00FF, 0x202A, 0x8811, 0x8B00, 0x8B00, 0x108A, 0x900D,
0x104B, 0xBE20, 0xB91F, 0x8809, 0x0732, 0x730D, 0x4F80, 0xE200, 0x0AE8, 0x1028, 0x200C, 0x8815, 0xBE43, 0x8B8B, 0x6A8D, 0xBEC6,
0x0AE4, 0x618B, 0x9880, 0x548F, 0x8DAD, 0xBE42, 0x7980, 0x0B34, 0x4E80, 0xE200, 0x0B09, 0x8B8C, 0x178B, 0xBE01, 0xBFB7, 0x00F0,
0x903E, 0x1029, 0x200C, 0x8815, 0x108D, 0xBEC6, 0x0B06, 0x308B, 0xBE1E, 0x303E, 0x903F, 0x403F, 0xBE1F, 0xE500, 0x103E, 0x9080,
0xBFE6, 0x202A, 0x8811, 0x8B00, 0x1089, 0x548F, 0x8DAD, 0x7980, 0x0B34, 0x4C8B, 0xE200, 0x0B2B, 0x1029, 0x200C, 0x8815, 0xBF80,
0x007F, 0x903E, 0x108D, 0xBEC6, 0x0B24, 0x308B, 0xBE1E, 0x303E, 0x903F, 0x403F, 0xBE1F, 0xE500, 0xB900, 0x9080, 0xBFE6, 0x202A,
0x8811, 0x8B00, 0x1089, 0x548F, 0x8DAD, 0x8B8A, 0xF500, 0x5E80, 0xFFDF, 0x7980, 0x0B34, 0x1089, 0xBFE6, 0x202A, 0x8811, 0x8B00,
0x8B00, 0x548F, 0xBB1F, 0x8DA0, 0x8B8F, 0x1047, 0xBE20, 0x0732, 0x1021, 0x2009, 0x8811, 0x8B89, 0x101D, 0x200A, 0x8812, 0x1080,
0x7810, 0x8B00, 0xBE47, 0x288A, 0xBFB0, 0x03FF, 0x4989, 0xE200, 0x0B50, 0xBE1E, 0x1012, 0x4918, 0x8B00, 0xE600, 0xBE0A, 0xBE11,
0x900E, 0xBE46, 0x108A, 0xBFB0, 0x001C, 0xBFE1, 0x880D, 0x8B00, 0x6B0E, 0xBE0A, 0x880C, 0x1048, 0xBE20, 0x108C, 0xBFB0, 0x000F,
0x202D, 0x8814, 0x8B00, 0x8B00, 0x5589, 0xBF03, 0x8C0E, 0xBF00, 0x1030, 0x2008, 0x8811, 0xB91F, 0x8809, 0x108B, 0x0333, 0xBEC6,
0x0B73, 0x200E, 0x90A0, 0x8B00, 0x8B89, 0x9080, 0x4A18, 0xE200, 0x0B8E, 0x5F0A, 0x0011, 0xE200, 0x0B80, 0x4F18, 0xE900, 0x0B90,
0x5F0A, 0x0014, 0xE200, 0x0B87, 0x4C18, 0xE900, 0x0BAF, 0x5F0A, 0x0015, 0xE200, 0x0B8E, 0x4E18, 0xE900, 0x0BC6, 0x1035, 0xBE20,
0x0034, 0xB91F, 0x8809, 0x0333, 0x8B8B, 0xBEC6, 0x0BAD, 0x1280, 0x6C80, 0xBFEA, 0xBE1E, 0x1580, 0x6C88, 0xBFEC, 0xBE13, 0x903E,
0x6CAB, 0x903F, 0x4F3E, 0xB900, 0xF500, 0xBF80, 0x8000, 0x4F3F, 0xBF90, 0x0D00, 0xF500, 0xBF90, 0x2700, 0x90A0, 0xEF00, 0x0034,
0xB91F, 0x8809, 0x0333, 0x8B88, 0xBEC6, 0x0BC4, 0x1EAB, 0x6C80, 0xBFED, 0x903E, 0x4180, 0xB900, 0xF500, 0xBF80, 0x8000, 0x4F3E,
0x8B00, 0xF500, 0xBF90, 0x4000, 0x90A8, 0xEF00, 0x0034, 0xB91F, 0x8809, 0x0333, 0x8B8B, 0xBEC6, 0x0BDC, 0x1280, 0x6C8B, 0xBFEA,
0xBE1E, 0x1580, 0x6C80, 0xBFEC, 0xBE13, 0x903E, 0x4F3E, 0xBF80, 0x4000, 0xF500, 0xBF90, 0x8000, 0x90A0, 0xEF00, 0x0231, 0x8B8A,
0xB900, 0xBB20, 0x90A0, 0x1044, 0xBE20, 0x5F08, 0x0023, 0xF500, 0x1036, 0xBE20, 0x1008, 0xB801, 0x9008, 0x102B, 0x2008, 0x8812,
0x8B00, 0x8B00, 0x1080, 0x900A, 0x102C, 0x2008, 0x8812, 0x8B00, 0x8B00, 0x1080, 0x9009, 0x7980, 0x0954, 0x8B00, 0x8B00, 0x8B00
};

WORD CCO[36] = {
    0x000, 0x000, 0x003, 0x003, 0x001, 0x001, 0x004, 0x004,
    0x002, 0x002, 0x005, 0x005, 0x006, 0x006, 0x007, 0x007,
    0x008, 0x008, 0x100, 0x100, 0x103, 0x103, 0x101, 0x101,
    0x104, 0x104, 0x102, 0x102, 0x105, 0x105, 0x106, 0x106,
    0x107, 0x107, 0x108, 0x108
    };

WORD DDP[] = {
    0x0000, 0x0000, 0x0000, 0x1200,
    0x1200, 0x1280, 0x0000, 0x05E0,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,

    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x1104, 0x1105,
    0x1008, 0x1020, 0x1040, 0x1060,

    0x1080, 0x10A0, 0x10B0, 0x100D,
    0x1010, 0x10E0, 0x2000, 0x2980,
    0x2B00, 0x2B40, 0x2A00, 0x2B90,
    0x13DC, 0x2B80, 0x11BC, 0x134C,

    0x1370, 0x12E0, 0x1240, 0x1260,
    0x12C0, 0x009E, 0x0045, 0x10BC,
    0x1394, 0x13B8, 0x11F6, 0x10F6,
    0x11B0, 0x0000, 0x0000, 0x0000,

    0x0000, 0x0815, 0x0956, 0x09DF,
    0x0BE5, 0x0A19, 0x0A48, 0x0B37,
    0x0B5D, 0x0A8B, 0x0AAE, 0x0AD2
    };

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void vLoadFM( void )
    {
    WORD  *pwTmpPtr;

    WORD wIndex;

    pwTmpPtr = (WORD *)FMCode000;
    FMCode000[0x3e] = 0x201;                                               // DSP IFR IMR ( Enable Int 0a )
    outp( gwPTBaseIO + 0xA4, 0x0 );                                             // Hold DSP

    outpd( gwPTBaseIO + 0x80, 0x020000 );                                       // Start with Internal DSP Code Memory 0
    for ( wIndex = 0; wIndex < sizeof( FMCode000 ) / 2; wIndex++ )
        {
        outpw( gwPTBaseIO + 0x84, *pwTmpPtr++ );
        }

    pwTmpPtr = (WORD *) FMCode800;

// Start with Internal DSP Code Memory 800
    outpd( gwPTBaseIO + 0x80, 0x020000 + 0x800 );
    for ( wIndex = 0; wIndex < sizeof( FMCode800 ) / 2; wIndex++ )
        {
        outpw( gwPTBaseIO + 0x84, *pwTmpPtr++ );
        }

// Start with Internal DSP Data Memory offset 1000h
    outpd( gwPTBaseIO + 0x80, 0x030000 + 0x1000 );
    for ( wIndex = 0; wIndex < 1024; wIndex++ )
        {
        outpw( gwPTBaseIO + 0x84, 0 );
        }

    outpd( gwPTBaseIO + 0x80, 0x030000 + 0x11bc );
    for ( wIndex = 0; wIndex < 36; wIndex++ )
        {
        outpw( gwPTBaseIO + 0x84, 0x00180018 );                                 // ADSR Table
        }

    pwTmpPtr = ( WORD * ) CCO;
    outpd( gwPTBaseIO + 0x80, 0x030000 + 0x13DC );
    for ( wIndex = 0; wIndex < ( sizeof( CCO ) / 2 ); wIndex++ )
        {
        outpw( gwPTBaseIO + 0x84, *pwTmpPtr++ );
        }

    pwTmpPtr = ( WORD * ) DDP;
    outpd( gwPTBaseIO + 0x80, 0x030000 + 0x1300 );
    for ( wIndex = 0; wIndex < ( sizeof( DDP ) / 2 ); wIndex++ )
        {
        outpw( gwPTBaseIO + 0x84, *pwTmpPtr++ );
        }
    outp( gwPTBaseIO + 0xA4, 0x41 );                                            // Start DSP
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void vPTSBInit( int nDspType )
    {
    WORD wTimeOut, wWait4Sync;
    BYTE bAPU, bRow;
    WORD wIndex;

//	outpw( gwPTBaseIO + 0x64, 0x0FFD );	/* GPIO Mask */
//	outpw( gwPTBaseIO + 0x68, 0x000B ); /* GPIO Direction */


// PCI Reg 40h */
    vSetLegacyAudioEnable( ENABLE );
    vSetSerialIRQEnable( DISABLE );
    vSetMPU401IRQ( DISABLE );
    vSetSBIRQ( gbIRQAudio );
    vSetSBDMA( gbDMAAudio );
    vSetAddressAliasEnable( DISABLE );
    vSetMPU401Enable( ENABLE );
    vSetGamePortEnable( ENABLE );
    vSetFMSynthEnable( ENABLE );
    vSetSBModeEnable( ENABLE );


// PCI Reg 50h[15:0] */
    vSetHPGamePortEnable( ENABLE );                       // Disable High-Performance Game Port */
    vSetISADMAPolicy( _DMA_DIST );                        // Set DMA Policy for Intel Triton */
    vSetPostedWriteEnable( DISABLE );                     // Enable AGOGO Posted Write */
    vSetSubtractiveDecodeEnable( DISABLE );               // Disable Subtractive Decoding */
    vSetMPU401BaseIO( gwIOMPU401 );
    vSetSBBaseIO( gwIOAudio );

// PCI Reg 52h[15:0] */
    vSetInternalClockMultiplierEnable( DISABLE );
    vSetClockSource( _CLK_EXTERNAL );
    vSetClockModeSelect( _CLK_MODE0 );
    vSetPowerMgmtEnable( DISABLE );
    vSetClkDivSelect( _CLK_50 );
    
    vSetHWVolumeEnable( ENABLE );
//    vSetHWVolumeReduceDebounce( ENABLE );
    vSetHWVolumeInputSelect( _HW_GPIO );

    vSetDSPInterfaceEnable( ENABLE );

    vSetDistDma( ENABLE );

//    vResetMaestro();

	vResetDirectSound(  );

	vResetCodec(  );

	//cc:I will use the DSK kernel for IIS play, so I need not change RingBus.

/* Destination Control: gwPTBaseIO + 0x34 */
    vSetDCADCLFormat( _DST_STEREO | _DST_DIRECTSOUND );
    vSetDCModemFormat( _DST_MONO | _DST_NONE );
    vSetDCDirectSoundFormat( _DST_STEREO | _DST_DAC );
    vSetDCASSPFormat( _DST_MONO | _DST_NONE );


/* Destination Control: gwPTBaseIO + 0x36 */
    vSetDCRingBusEnable( ENABLE );                                             /* Enable Ring Bug */
    vSetDCSerialBusEnable( ENABLE );                                           /* Enable CODEC Serial Bus */
    vSetDCMicFormat( _DST_MONO | _DST_NONE );
    vSetDCI2SFormat( _DST_MONO | _DST_NONE );
	// I hate noise.
	vSetDCI2SEnable( DISABLE ); 				// Enable I2S input.


/* Host Interrupt Control: gwPTBaseIO + 0x18 */
    vSetClkRunEnable( DISABLE );
    vSetHWVolumeInterruptEnable( ENABLE );
    vSetASSPInterruptEnable( DISABLE );
    vSetDirectSoundInterruptEnable( ENABLE );
    vSetMPU401InterruptEnable( DISABLE );
    vSetSBInterruptEnable( ENABLE );

    outp( gwPTBaseIO + 0xA4, 0x00 );
    outp( gwPTBaseIO + 0xA2, 0x03 );
    outp( gwPTBaseIO + 0xA6, 0x00 );

    /* Clear bytes 00h-10h in WaveCache Memory */
	if(nDspType)
		//----------------
		// Use APU 60/61
		//---------------
	    for ( bRow = 0; bRow < 0x10; bRow++ )
    	{
        	vWrWCReg( ( WORD ) ( 0x01E0 + bRow ), 0x0000 );
        }
	else
		//--------------
		// Use APU 58/59
		//--------------
		for ( bRow = 0; bRow < 0x10; bRow++ )
			vWrWCReg( ( WORD ) ( 0x01D0 + bRow ), 0x0000 );

	
    vSetRamSplit( 0x00 );
    vSetDRamEnable( ENABLE );
    vSet8BitRamEnable( DISABLE );
    vSetVirtualWaveEnable( ENABLE );

    vWrIDR( 0x02, 0x0000 );                                                    /* CRam Increment */

    vWrIDR( 0x08, 0xB004 );                                                    /* Audio Serial Configuration */
    vWrIDR( 0x09, 0x001B );                                                    /* Audio Serial Configuration */
    vWrIDR( 0x0A, 0x8000 );                                                    /* Audio Serial Configuration */
    vWrIDR( 0x0B, 0x3F37 );                                                    /* Audio Serial Configuration */

    vWrIDR( 0x0C, 0x0098 );

    vSetParallelInBase( 0x08 );
    vSetParallelOutBase( 0x05 );

    vWrIDR( 0x0D, 0x7632 );                                                    /* Audio Serial Configuration */

 // Clear Control RAM */
    for ( bAPU = 0x00; bAPU < 0x40; bAPU++ )
        {
        for ( bRow = 0; bRow < 0x0E; bRow++ )
            {
            vWrAPUReg( bAPU, bRow, 0x0000 );
            }
        }

    vSetWCEnable( ENABLE );      /* Enable WaveCache */
    vSetWCSGControl( DISABLE );  /* Disable Scatter/Gather Controls */
    vSetWCConfig( 0x00 );        /* Set WaveCache to WP configuration */
    vSetWCFMSynth( ENABLE );     /* Set 60 & 61 to FM emulation */
	if(nDspType)
	    outpw( gwPTBaseIO + 0x14, 0xA1A0 );
	else
	    outpw( gwPTBaseIO + 0x14, 0x0300 );

//    gwCodecType = wRdCReg( 0x00 );                                             /* Get Codec ID */



// APU#6:MixerType -  SoundBlaster emulation */
    vSetAPUDMA( _APU_MIXER, DISABLE );
    vSetAPUIntOnLoop( _APU_MIXER, DISABLE );
    vSetAPUEndCurve( _APU_MIXER, DISABLE );
    vSetAPUEnvelopeType( _APU_MIXER, _APU_ATFP_AMPLITUDE );
    vSetAPUEnvelopeState( _APU_MIXER, _APU_ATFP_FLG_OFF );
    vSetAPUFilterType( _APU_MIXER, _APU_FILTER_1POLE_LOPASS );
    vSetAPUFilterQ( _APU_MIXER, _APU_FILTER_MOREQ );
    vSetAPUFrequency( _APU_MIXER, 0x000000 );
    vSetAPUEffectChannels( _APU_MIXER, 0x00 );
    vSetAPUDualEffectSend( _APU_MIXER, ENABLE );
    vSetAPU6dB( _APU_MIXER, DISABLE );
    vSetAPUSubmixMode( _APU_MIXER, DISABLE );
    vSetAPUSubmixGroup( _APU_MIXER, 0x00 );
    vSetAPUPhase( _APU_MIXER, 0x5F );
    vSetAPUWave64kPage( _APU_MIXER, 0x4B );
    vSetAPUWaveStart( _APU_MIXER, 0xFDD5 );
    vSetAPUWaveEnd( _APU_MIXER, 0xFE00 );
    vSetAPUWaveLoop( _APU_MIXER, 0x0100 );
    vSetAPUEffectGain( _APU_MIXER, 0xFF );
    vSetAPUTremeloRate( _APU_MIXER, 0x07 );
    vSetAPUTremeloDepth( _APU_MIXER, 0x08 );
    vSetAPUAmplitudeNow( _APU_MIXER, 0xFF );
    vWrAPUReg( _APU_MIXER, 0x09, 0xFFFF );
    vSetAPURadiusSelect( _APU_MIXER, 0x00 );
    vSetAPUPolarPan( _APU_MIXER, 0x10 );
    vSetAPUFilterTuning( _APU_MIXER, 0x8A );
    vSetAPUDataSourceA( _APU_MIXER, 0x09 );
    vSetAPUInvertPolarityA( _APU_MIXER, DISABLE );
    vSetAPUDataSourceB( _APU_MIXER, 0x00 );
    vSetAPUInvertPolarityB( _APU_MIXER, ENABLE );

	//----------------
	// select DSP apu
	//---------------
	if(nDspType)
	{
		_APU_SYNR = 0x3C;
		_APU_SYNL = 0x3D;
	}
	else
	{
		_APU_SYNR = 0x3A;
		_APU_SYNL = 0x3B;
	}


// APU#60: Synth Right Channel -  SoundBlaster emulation */
    vSetAPUDMA( _APU_SYNR, ENABLE );
    vSetAPUIntOnLoop( _APU_SYNR, DISABLE );
    vSetAPUEndCurve( _APU_SYNR, DISABLE );
    vSetAPUEnvelopeType( _APU_SYNR, _APU_ATFP_AMPLITUDE );
    vSetAPUEnvelopeState( _APU_SYNR, _APU_ATFP_FLG_OFF );
    vSetAPUFilterType( _APU_SYNR, _APU_FILTER_1POLE_LOPASS );
    vSetAPUFilterQ( _APU_SYNR, _APU_FILTER_MOREQ );
    vSetAPUFrequency( _APU_SYNR, 0x004000 );
    vSetAPUEffectChannels( _APU_SYNR, 0x00 );
    vSetAPUDualEffectSend( _APU_SYNR, DISABLE );
    vSetAPU6dB( _APU_SYNR, DISABLE );
    vSetAPUSubmixMode( _APU_SYNR, DISABLE );
    vSetAPUSubmixGroup( _APU_SYNR, 0x00 );
    vSetAPUPhase( _APU_SYNR, 0x00 );
    vSetAPUWave64kPage( _APU_SYNR, 0x85 );
    vSetAPUWaveStart( _APU_SYNR, 0x6000 );
    vSetAPUWaveEnd( _APU_SYNR, 0x60FF );
    vSetAPUWaveLoop( _APU_SYNR, 0x0100 );
    vSetAPUEffectGain( _APU_SYNR, 0xFF );
    vSetAPUTremeloRate( _APU_SYNR, 0x00 );
    vSetAPUTremeloDepth( _APU_SYNR, 0x00 );
    vSetAPUAmplitudeNow( _APU_SYNR, 0xFF );
    vWrAPUReg( _APU_SYNR, 0x09, 0xFFFF );
    vSetAPURadiusSelect( _APU_SYNR, 0x00 );
    vSetAPUPolarPan( _APU_SYNR, 0x00 );
    vSetAPUFilterTuning( _APU_SYNR, 0x7F );
    vSetAPUDataSourceA( _APU_SYNR, 0x70 );
    vSetAPUInvertPolarityA( _APU_SYNR, ENABLE );
    vSetAPUDataSourceB( _APU_SYNR, 0x00 );
    vSetAPUInvertPolarityB( _APU_SYNR, DISABLE );



// APU#61: Synth Left Channel -  SoundBlaster emulation */
    vSetAPUDMA( _APU_SYNL, ENABLE );
    vSetAPUIntOnLoop( _APU_SYNL, DISABLE );
    vSetAPUEndCurve( _APU_SYNL, DISABLE );
    vSetAPUEnvelopeType( _APU_SYNL, _APU_ATFP_AMPLITUDE );
    vSetAPUEnvelopeState( _APU_SYNL, _APU_ATFP_FLG_OFF );
    vSetAPUFilterType( _APU_SYNL, _APU_FILTER_1POLE_LOPASS );
    vSetAPUFilterQ( _APU_SYNL, _APU_FILTER_MOREQ );
    vSetAPUFrequency( _APU_SYNL, 0x004000 );
    vSetAPUEffectChannels( _APU_SYNL, 0x00 );
    vSetAPUDualEffectSend( _APU_SYNL, DISABLE );
    vSetAPU6dB( _APU_SYNL, ENABLE );
    vSetAPUSubmixMode( _APU_SYNL, ENABLE );
    vSetAPUSubmixGroup( _APU_SYNL, 0x02 );
    vSetAPUPhase( _APU_SYNL, 0x00 );
    vSetAPUWave64kPage( _APU_SYNL, 0x85 );
    vSetAPUWaveStart( _APU_SYNL, 0x6000 );
    vSetAPUWaveEnd( _APU_SYNL, 0x60FF );
    vSetAPUWaveLoop( _APU_SYNL, 0x0100 );
    vSetAPUEffectGain( _APU_SYNL, 0xFF );
    vSetAPUTremeloRate( _APU_SYNL, 0x00 );
    vSetAPUTremeloDepth( _APU_SYNL, 0x00 );
    vSetAPUAmplitudeNow( _APU_SYNL, 0xFF );
    vWrAPUReg( _APU_SYNL, 0x09, 0xFFFF );
    vSetAPURadiusSelect( _APU_SYNL, 0x00 );
    vSetAPUPolarPan( _APU_SYNL, 0x10 );
    vSetAPUFilterTuning( _APU_SYNL, 0x7F );
    vSetAPUDataSourceA( _APU_SYNL, 0x70 );
    vSetAPUInvertPolarityA( _APU_SYNL, ENABLE );
    vSetAPUDataSourceB( _APU_SYNL, 0x00 );
    vSetAPUInvertPolarityB( _APU_SYNL, DISABLE );



// APU#62:Digi Right Channel  - SoundBlaster Emulation */
    vSetAPUDMA( _APU_DIGR, DISABLE );
    vSetAPUIntOnLoop( _APU_DIGR, DISABLE );
    vSetAPUEndCurve( _APU_DIGR, DISABLE );
    vSetAPUEnvelopeType( _APU_DIGR, _APU_ATFP_AMPLITUDE );
    vSetAPUEnvelopeState( _APU_DIGR, _APU_ATFP_FLG_OFF );
    vSetAPUFilterType( _APU_DIGR, _APU_FILTER_1POLE_LOPASS );
    vSetAPUFilterQ( _APU_DIGR, _APU_FILTER_MOREQ );
    vSetAPUFrequency( _APU_DIGR, 0x010000 );
    vSetAPUEffectChannels( _APU_DIGR, 0x00 );
    vSetAPUDualEffectSend( _APU_DIGR, DISABLE );
    vSetAPU6dB( _APU_DIGR, DISABLE );
    vSetAPUSubmixMode( _APU_DIGR, DISABLE );
    vSetAPUSubmixGroup( _APU_DIGR, 0x00 );
    vSetAPUPhase( _APU_DIGL, 0x00 );
    vSetAPUWave64kPage( _APU_DIGR, 0x7F );
    vSetAPUWaveStart( _APU_DIGR, 0x8000 );
    vSetAPUWaveEnd( _APU_DIGR, 0x8080 );
    vSetAPUWaveLoop( _APU_DIGR, 0x0080 );
    vSetAPUEffectGain( _APU_DIGR, 0x00 );
    vSetAPUTremeloRate( _APU_DIGR, 0x07 );
    vSetAPUTremeloDepth( _APU_DIGR, 0x0F );
    vSetAPUAmplitudeNow( _APU_DIGR, 0xFF );
    vWrAPUReg( _APU_DIGR, 0x09, 0xFFFF );
    vSetAPURadiusSelect( _APU_DIGR, 0x00 );
    vSetAPUPolarPan( _APU_DIGR, 0x00 );
    vSetAPUFilterTuning( _APU_DIGR, 0x7F );
    vSetAPUDataSourceA( _APU_DIGR, 0x70 );
    vSetAPUInvertPolarityA( _APU_DIGR, ENABLE );
    vSetAPUDataSourceB( _APU_DIGR, 0x00 );
    vSetAPUInvertPolarityB( _APU_DIGR, DISABLE );


// APU#63:Digi Left Channel  - SoundBlaster Emulation */
    vSetAPUDMA( _APU_DIGL, DISABLE );
    vSetAPUIntOnLoop( _APU_DIGL, DISABLE );
    vSetAPUEndCurve( _APU_DIGL, DISABLE );
    vSetAPUEnvelopeType( _APU_DIGL, _APU_ATFP_AMPLITUDE );
    vSetAPUEnvelopeState( _APU_DIGL, _APU_ATFP_FLG_OFF );
    vSetAPUFilterType( _APU_DIGL, _APU_FILTER_1POLE_LOPASS );
    vSetAPUFilterQ( _APU_DIGL, _APU_FILTER_MOREQ );
    vSetAPUFrequency( _APU_DIGL, 0x010000 );
    vSetAPUEffectChannels( _APU_DIGL, 0x00 );
    vSetAPUDualEffectSend( _APU_DIGL, DISABLE );
    vSetAPU6dB( _APU_DIGL, DISABLE );
    vSetAPUSubmixMode( _APU_DIGL, DISABLE );
    vSetAPUSubmixGroup( _APU_DIGL, 0x00 );
    vSetAPUPhase( _APU_DIGL, 0x00 );
    vSetAPUWave64kPage( _APU_DIGL, 0x7F );
    vSetAPUWaveStart( _APU_DIGL, 0x0000 );
    vSetAPUWaveEnd( _APU_DIGL, 0x0080 );
    vSetAPUWaveLoop( _APU_DIGL, 0x0080 );
    vSetAPUEffectGain( _APU_DIGL, 0x00 );
    vSetAPUTremeloRate( _APU_DIGL, 0x07 );
    vSetAPUTremeloDepth( _APU_DIGL, 0x0F );
    vSetAPUAmplitudeNow( _APU_DIGL, 0xFF );
    vWrAPUReg( _APU_DIGL, 0x09, 0xFFFF );
    vSetAPURadiusSelect( _APU_DIGL, 0x00 );
    vSetAPUPolarPan( _APU_DIGL, 0x10 );
    vSetAPUFilterTuning( _APU_DIGL, 0x7F );
    vSetAPUDataSourceA( _APU_DIGL, 0x70 );
    vSetAPUInvertPolarityA( _APU_DIGL, ENABLE );
    vSetAPUDataSourceB( _APU_DIGL, 0x00 );
    vSetAPUInvertPolarityB( _APU_DIGL, DISABLE );


 // Enable ALL APUs at same time */

    vSetAPUType( _APU_MIXER, 0x09 );

    _asm pushf
    for ( wTimeOut = 0; wTimeOut < 0x1000; wTimeOut++ )
        {
        _asm
            {
            sti
            nop
            cli
            }
        wWait4Sync = inpw( ( gwPTBaseIO & 0xff00 ) + 6 );
        if ( wWait4Sync != inpw( ( gwPTBaseIO & 0xff00 ) + 6 ) )
            break;
        }

    // outpw( gwPTBaseIO+0x02, (WORD) 0x0001);
    // outpw( gwPTBaseIO+0x00, (WORD) 0x03C0);
    // outpw( gwPTBaseIO+0x02, (WORD) 0x1 );
    // outpw( gwPTBaseIO+0x02, (WORD) 0x1 );
    // outpw( gwPTBaseIO+0x00, (WORD) 0x3c0 );
    // outpw( gwPTBaseIO+0x02, (WORD) 0x0000);
    // outpw( gwPTBaseIO+0x00, (WORD) 0x4010);
    // outpw( gwPTBaseIO+0x02, (WORD) 0x0001);
    // outpw( gwPTBaseIO+0x00, (WORD) 0x03D0);
    // outpw( gwPTBaseIO+0x02, (WORD) 0x1 );
    // outpw( gwPTBaseIO+0x02, (WORD) 0x1 );
    // outpw( gwPTBaseIO+0x00, (WORD) 0x3d0 );
    // outpw( gwPTBaseIO+0x02, (WORD) 0x0000);
    // outpw( gwPTBaseIO+0x00, (WORD) 0x4010);

    _asm
        {
        mov dx, gwPTBaseIO
        or  dl, 0x02
        mov ax, 0x0001
        out dx, ax
        and dl, 0x00
        mov ax, 0x03C0
        out dx, ax

        mov cx, 0xFFFF
  Loop0:
        or  dl, 0x02
        mov ax, 0x0001
        out dx, ax
        and dl, 0x00
        in  ax, dx
        cmp ax, 0x03C0
        je  ChkOK0
        or  dl, 2
        mov ax, 1
        out dx, ax
        and dl, 0
        mov ax, 0x03C0
        out dx, ax
        loop Loop0
  ChkOK0:
        or  dl, 0x02
        xor ax, ax
        out dx, ax
        and dl, 0
        mov ax, 0x401F
        out dx, ax
        or  dl, 2
        mov ax, 0x0001
        out dx, ax
        and dl, 0x00
        mov ax, 0x3D0
        out dx, ax

        mov cx, 0xFFFF
  LOOP1:
        or  dl, 0x02
        mov ax, 0x0001
        out dx, ax

        and dl, 0x00
        in  ax, dx
        cmp ax, 0x03D0
        je  ChkOK1
        or  dl, 0x02
        mov ax, 0x0001
        out dx, ax
        and dl, 0x00
        mov ax, 0x3D0
        out dx, ax
        loop LOOP1
  ChkOK1:
        or  dl, 0x02
        xor ax, ax
        out dx, ax
        and dl, 0x00
        mov ax, 0x401f
        out dx, ax
        popf
        }

//    vSetAPUType( _APU_SYNR, 0x01 );
//    vSetAPUType( _APU_SYNL, 0x01 );

    vSetAPUType( _APU_DIGR, 0x01 );                                            // Enable Dig Right */
    vSetAPUType( _APU_DIGL, 0x01 );                                            // Enable DIG Left */

	//----------
	// for IIS
	//----------
	//------------------------
	// APU#56:IIS Left Channel
	//------------------------
	vWrAPUReg(_APU_IISL, 0x00, 0x400F);
	vWrAPUReg(_APU_IISL, 0x01, 0x0000);
	vWrAPUReg(_APU_IISL, 0x02, 0x0010);
	vWrAPUReg(_APU_IISL, 0x03, 0x0100);
	vWrAPUReg(_APU_IISL, 0x04, 0x8500);
	vWrAPUReg(_APU_IISL, 0x05, 0x6000);
	vWrAPUReg(_APU_IISL, 0x06, 0x6100);
	vWrAPUReg(_APU_IISL, 0x07, 0x0100);
	vWrAPUReg(_APU_IISL, 0x08, 0x00FF);
	vWrAPUReg(_APU_IISL, 0x09, 0xF9FF);
	vWrAPUReg(_APU_IISL, 0x0A, 0x7F10);
	vWrAPUReg(_APU_IISL, 0x0B, 0x00F0);
	//------------------------
	// APU#57:IIS Right Channel
	//------------------------
	vWrAPUReg(_APU_IISR, 0x00, 0x400F);
	vWrAPUReg(_APU_IISR, 0x01, 0x0000);
	vWrAPUReg(_APU_IISR, 0x02, 0x0010);
	vWrAPUReg(_APU_IISR, 0x03, 0x0100);
	vWrAPUReg(_APU_IISR, 0x04, 0x8500);
	vWrAPUReg(_APU_IISR, 0x05, 0x6000);
	vWrAPUReg(_APU_IISR, 0x06, 0x6100);
	vWrAPUReg(_APU_IISR, 0x07, 0x0100);
	vWrAPUReg(_APU_IISR, 0x08, 0x00FF);
	vWrAPUReg(_APU_IISR, 0x09, 0xF9FF);
	vWrAPUReg(_APU_IISR, 0x0A, 0x7F00);
	vWrAPUReg(_APU_IISR, 0x0B, 0x00F0);


	if(nDspType)
	    vLoadFM(  );
	else
		kInitKernel(gwPTBaseIO);

    vWrCReg( 0x02, 0x0202 );                  /* Master Volume */
    vWrCReg( 0x04, 0x0202 );                  /* Headphone Volume */
    vWrCReg( 0x06, 0x0000 );                  /* Master Volume Mono */

    vWrCReg( 0x08, 0x9F1F );                  /* Master Tone Control */
    vWrCReg( 0x0A, 0x9F1F );                  /* PC Speaker Volume */
    vWrCReg( 0x0C, 0x9F1F );                  /* Phone Volume */
    vWrCReg( 0x0E, 0x9F1F );                  /* Mic Volume */
    vWrCReg( 0x10, 0x9F1F );                  /* LineIn Volume */
    vWrCReg( 0x12, 0x9F1F );                  /* CD Volume */
    vWrCReg( 0x14, 0x9F1F );                  /* Video Volume */
    vWrCReg( 0x16, 0x9F1F );                  /* Aux Volume */

    vWrCReg( 0x18, 0x0202 );                  /* PCM Out Volume */

    vWrCReg( 0x1A, 0x0000 );                  // Record Select: Microphone */
    vWrCReg( 0x1C, 0x0303 );                  // Record Gain */
    vWrCReg( 0x1E, 0x0303 );                  // Record Gain Mic */

    vWrCReg( 0x20, 0x0000 );                   // General Purpose Controls */

    vWrCReg( 0x26, 0x000F );

    }
