#include    <stdio.h>
#include    <stdlib.h>
#include    <conio.h>
#include    <dos.h>
#include    <io.h>
#include    <fcntl.h>
#include    <sys\stat.h>

//#include    "sbtype.h"
#include 	<basedef.h>
#include    "sbconfig.h"
#include	"sbdelay.h"
#include    "sbmem.h"

#include    "ptconfig.h"
#include    "m2.h"
#include    "wavcache.h"
#include    "wp.h"
#include    "apu.h"
#include    "pt101.h"
#include    "ac97.h"
#include    "codec.h"
#include    "ic8259.h"

#include	"kernel.h"
#include    "ptplay.h"
extern HWI hwi;



#define MN_44100    0xE736
#define MN_22050    0x739B
#define MN_11025    0x39CD

WORD    wInterruptFreq  = 23;

#define DMABUFFERSIZE   2048
#define MAXDMABUFFERS   2

#define CHANNEL0    0x0
#define CHANNEL1    0x1
#define CHANNEL2    0x2

BYTE    bAPURChannel = CHANNEL0,
        bAPULChannel = CHANNEL1,
        bAPUSRC = CHANNEL0,
        bAPUMixer = CHANNEL1,
        bAPUAmp = CHANNEL2;

extern  void _interrupt _far aiAudioISR( void );
extern  BYTE    bIRQTestFlag[];

WORD    wDskCurrentPos,
        wApuCurrentPos;

WORD    wDskSeg,
        wDskOff;

LPBYTE  lpDskBuffer;

WORD    wDskBufferSize = MAXDMABUFFERS * DMABUFFERSIZE,
        wApuBufferSize;

WORD    wChunkSize;
BYTE	bAPUIISL=0x38;
BYTE	bAPUIISR=0x39;


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void _interrupt _far aiMaestroISR( void )
	{
    BYTE    bIndex;
	BYTE	bVolL,
			bVolR,
			bHWVolL,
			bHWVolR,
			bSWVolL,
			bSWVolR;
	
	WORD	wTest;
	
	LPBYTE lpTmpPtr = ( (LPBYTE) 0xB8000000L );

static BYTE bState1 = FALSE,
			bState2 = FALSE;

#ifdef	_DEBUG
		
	for( bIndex=4; bIndex > 0; bIndex-- )
		{
		if( ( lpTmpPtr[bIndex<<1] < 0x30 ) || ( lpTmpPtr[bIndex<<1] > 0x39 ) )
			{
			lpTmpPtr[bIndex<<1] = 0x30;
			}
		else
			{
			if( lpTmpPtr[bIndex<<1] == 0x39 )
				{
				lpTmpPtr[bIndex<<1] = 0x30;
				}
			else 
				{
				++lpTmpPtr[bIndex<<1];
				break;
				}
			}
		}
#endif

	if( bTstHostInterruptStatusBit( 6 ) == TRUE )
		{
		vSetHostInterruptControlBit( 6 );
		bHWVolL = ( inp( gwPTBaseIO + 0x1F ) & 0xF0 ) >> 4;
		bHWVolR = inp( gwPTBaseIO + 0x1F ) & 0x0F;

		bSWVolL = ( inp( gwPTBaseIO + 0x1E ) & 0xF0 ) >> 4;
		bSWVolR = inp( gwPTBaseIO + 0x1E ) & 0x0F;

		wTest = inp( gwPTBaseIO + 0x60 );
		if( WTSTBIT( wTest, 4 ) == FALSE && WTSTBIT( wTest, 5 ) == FALSE )
			{
			if( bGetAC97MasterMute() )
				{
				vSetAC97MasterMute( DISABLE );
				}
			else
				{
				vSetAC97MasterMute( ENABLE );
				}	
			}

		bVolL = LOBYTE( wGetAC97MasterVolume() );
		bVolR = LOBYTE( wGetAC97MasterVolume() );
			
		if( bHWVolL < bSWVolL )
			{
			if( bVolL < 0x1d )
				{
				bVolL += 2;			/* Decrease Volume */
				}
			if( bVolR < 0x1d )
				{
				bVolR += 2;			/* Decrease Volume */
				}
			}
		else if( bHWVolL > bSWVolL )
			{
			if( bVolL > 0x02 )
				{
				bVolL -= 2;			/* Increase Volume */
				}
			if( bVolR > 0x02 )
				{
				bVolR -= 2;			/* Increase Volume */
				}
			}
					
		vSetAC97MasterVolume( bVolL, bVolR );
		
		}
	else if( bTstHostInterruptStatusBit( 2 ) == TRUE )
		{
	    bIRQTestFlag[0] = TRUE;
		}	

	outpw( gwPTBaseIO + 0x1A, 0xFFFF ); /* Clear ALL Interrupts */

    outpw( gwPTBaseIO + 0x02, 0x01 );
    outpw( gwPTBaseIO + 0x00, (CHANNEL0 << 4 ) + 0x05 );   /* APU0 Register 05h */

    outpw( gwPTBaseIO + 0x02, 0x00 );
    wApuCurrentPos = (WORD)( inpw( gwPTBaseIO + 0x00 ) - wDskSeg );

    outpw( gwPTBaseIO + 0x04, 0x0001 );

 /* Send Non-Specific EOI to controller #1 */
	outp( 0x20, 0x20 );

 /* Send Non-Specific EOI to controller #2 */
	outp( 0xA0, 0x20 );

	_enable(  );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vPlayPCIMono8( LPBYTE _lpFileName, DWORD _dwSampleRate )
    {
    DWORD   dwActualFreq    = ( 50000000L / 512L );
    WORD    wBinaryShift    = 0;
    WORD    wCountDown      = 1;
    WORD    wMaxCountDown   = 31;

    WORD    wIndex;

    int     iFileHandle;

    DWORD   dwPhysAddr,
            dwFreq;

    wApuBufferSize = wDskBufferSize;

    for( wIndex=0; wIndex < 0x0F; wIndex++ );
        {
        vWrAPUReg( bAPURChannel, (BYTE)wIndex, 0x0000 );
        }

    if( lpAllocateDMABuffer( MAXDMABUFFERS, DMABUFFERSIZE, &lpDskBuffer ) == NULL )
        {
        return;
        }

    iFileHandle = open( (char *)_lpFileName, O_BINARY | O_RDONLY );

    read( iFileHandle, lpDskBuffer, wDskBufferSize );

    dwPhysAddr = (DWORD)( (DWORD)(_FP_SEG( lpDskBuffer ) ) << 4 ) + (DWORD)(_FP_OFF( lpDskBuffer ) );

    vWrWCReg( 0x01FC, 0x0000 );
    vWrWCReg( 0x00, (WORD)( ( LOWORD( dwPhysAddr ) - 0x10 ) & 0xFFF8 ) | 0x00 );

    /* Calculate WP base address */
    dwPhysAddr >>= 1;           /* adjust for word size */
    dwPhysAddr |= 0x00400000L;  /* Enable bit 22 for system ram access */
    dwPhysAddr |= 0x00000000L;  /* Enable bit 23 for stereo */

    wDskSeg = LOWORD( dwPhysAddr );

    wApuBufferSize >>= 1;

    if( _dwSampleRate == 44100 )
        {
        dwFreq = MN_44100;
        }
    else
        {
        if( _dwSampleRate == 22050 )
            {
            dwFreq = MN_22050;
            }
        else
            {
            if( _dwSampleRate == 11025 )
                {
                dwFreq = MN_11025;
                }
            }
        }

    vSetAPUFrequency( bAPURChannel, LOWORD( dwFreq ) );
    vSetAPUSubmixMode( bAPURChannel, DISABLE );
    vSetAPUSubmixGroup( bAPURChannel, 0x00 );
    vSetAPU6dB( bAPURChannel, ENABLE );
    vSetAPUEffectChannels( bAPURChannel, 0x00 );
    vSetAPUDualEffectSend( bAPURChannel, DISABLE );
    vSetAPUWavePtr( bAPURChannel, dwPhysAddr, wApuBufferSize );
    vSetAPUEffectGain( bAPURChannel, 0x00 );
    vSetAPUAmplitudeNow( bAPURChannel, 0xD0 );
    vSetAPUFilterTuning( bAPURChannel, 0x8F );
    vSetAPURadiusSelect( bAPURChannel, 0x00 );
    vSetAPUPolarPan( bAPURChannel, 0x08 );
    vSetAPUBalance( bAPURChannel, 0x00 );
    vSetAPUDataSourceA( bAPURChannel, 0x00 );
    vSetAPUInvertPolarityA( bAPURChannel, DISABLE );
    vSetAPUDataSourceB( bAPURChannel, 0x00 );
    vSetAPUInvertPolarityB( bAPURChannel, DISABLE );
    vSetAPUEnvelopeType( bAPURChannel, 0x00 );
    vSetAPUEnvelopeState( bAPURChannel, 0x00 );
    vSetAPUFilterType( bAPURChannel, 0x03 );
    vSetAPUFilterQ( bAPURChannel, 0x03 );
    vSetAPUIntOnLoop( bAPURChannel, DISABLE );
    vSetAPUDMA( bAPURChannel, ENABLE );
    vSetAPUEndCurve( bAPURChannel, DISABLE );

	bIRQTestFlag[0] = 0;

    outpw( gwPTBaseIO + 0x04, 0x0001 );     /* Clear and pending WP Interrupts */
    outpw( gwPTBaseIO + 0x18, (WORD)( inpw( gwPTBaseIO + 0x18 ) | 0x0004 ) );

    while( ( wInterruptFreq < dwActualFreq ) && ( wBinaryShift < 7 ) )
        {
        wBinaryShift++;
        dwActualFreq >>= 1;
        }

    while( ( wInterruptFreq <= ( dwActualFreq / ( wCountDown + 1) ) ) && ( wCountDown < wMaxCountDown ) )
        {
        wCountDown++;
        }


    if( !wCountDown )
        {
        wBinaryShift--;
        wCountDown = wMaxCountDown;
        }

    wCountDown--;

    vSetAPUType( bAPURChannel, 0x04 );

    _disable();

    vMskIDRBit( 0x11, 0 );
    vMskIDRBit( 0x17, 0 );                  /* Disable Bob Timer Interrupts */

    vWrIDR( 0x06, (WORD)( 0x8000 | (1 << 12 ) | (wBinaryShift<<5) | wCountDown ) );

    vSetIDRBit( 0x11, 0 );
    vSetIDRBit( 0x17, 0 );                  /* Enable Bob Timer Interrupts */

    _enable();

    wApuCurrentPos = 0;
    wDskCurrentPos = 0;

    do
		{
        if( bIRQTestFlag[0] == TRUE )
            {
            bIRQTestFlag[0] = FALSE;


            if( wDskCurrentPos < wApuCurrentPos )
                {
                wChunkSize = wApuCurrentPos - wDskCurrentPos;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );
                }

            if( wDskCurrentPos > wApuCurrentPos )
                {
                wChunkSize = wDskBufferSize - wDskCurrentPos;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );

                wDskCurrentPos = 0;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wApuCurrentPos );
                }

            if( wDskCurrentPos == wApuCurrentPos )
                {
                }

            wDskCurrentPos = wApuCurrentPos;
            }
		}
    while( !kbhit() && !eof( iFileHandle ) );

    if( kbhit() )
        getch();

    close( iFileHandle );

    outpw( gwPTBaseIO + 0x18, (WORD)( inpw( gwPTBaseIO + 0x18 ) & 0xFFFB ) );

    outpw( gwPTBaseIO + 0x04, 0x0001 );

    vMskIDRBit( 0x17, 0 );              /* Disable Bob Timer Interrupts */

    vSetAPUType( bAPURChannel, 0x00 );

    vFreeDMABuffer( lpDskBuffer );
    }
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vPlayPCIStereo8( LPBYTE _lpFileName, DWORD _dwSampleRate )
    {
    DWORD   dwActualFreq    = ( 50000000L / 512L );
    WORD    wBinaryShift    = 0;
    WORD    wCountDown      = 1;
    WORD    wMaxCountDown   = 31;

    WORD    wIndex;

    int     iFileHandle;

    DWORD   dwPhysAddr,
            dwFreq;

    wApuBufferSize = wDskBufferSize;

    for( wIndex=0; wIndex < 0x0F; wIndex++ );
        {
        vWrAPUReg( bAPURChannel, (BYTE)wIndex, 0x0000 );
        vWrAPUReg( bAPULChannel, (BYTE)wIndex, 0x0000 );
        }

    if( lpAllocateDMABuffer( MAXDMABUFFERS, DMABUFFERSIZE, &lpDskBuffer ) == NULL )
        {
        return;
        }

    iFileHandle = open( (char *)_lpFileName, O_BINARY | O_RDONLY );

    read( iFileHandle, lpDskBuffer, wDskBufferSize );

    dwPhysAddr = (DWORD)( (DWORD)(_FP_SEG( lpDskBuffer ) ) << 4 ) + (DWORD)(_FP_OFF( lpDskBuffer ) );

    vWrWCReg( 0x01FC, 0x0000 );
    vWrWCReg( 0x00, (WORD)( ( LOWORD( dwPhysAddr ) - 0x10 ) & 0xFFF8 ) | 0x06 );

    /* Calculate WP base address */
    dwPhysAddr >>= 1;           /* adjust for word size */
    dwPhysAddr |= 0x00400000L;  /* Enable bit 22 for system ram access */
    dwPhysAddr |= 0x00100000L;  /* Enable bit 23 for stereo */

    wDskSeg = LOWORD( dwPhysAddr );

    wApuBufferSize >>= 1;

    if( _dwSampleRate == 44100 )
        {
        dwFreq = MN_44100;
        }
    else
        {
        if( _dwSampleRate == 22050 )
            {
            dwFreq = MN_22050;
            }
        else
            {
            if( _dwSampleRate == 11025 )
                {
                dwFreq = MN_11025;
                }
            }
        }

    vWrAPUReg( bAPURChannel, 0x00, 0x0000 );
    vWrAPUReg( bAPURChannel, 0x00, 0x0000 );

    vSetAPUFrequency( bAPURChannel, LOWORD( dwFreq ) );
    vSetAPUSubmixMode( bAPURChannel, DISABLE );
    vSetAPUSubmixGroup( bAPURChannel, 0x00 );
    vSetAPU6dB( bAPURChannel, ENABLE );
    vSetAPUEffectChannels( bAPURChannel, 0x00 );
    vSetAPUDualEffectSend( bAPURChannel, DISABLE );
    vSetAPUWavePtr( bAPURChannel, dwPhysAddr, wApuBufferSize );
    vSetAPUEffectGain( bAPURChannel, 0x00 );
    vSetAPUAmplitudeNow( bAPURChannel, 0xD0 );
    vSetAPUFilterTuning( bAPURChannel, 0x8F );
    vSetAPURadiusSelect( bAPURChannel, 0x00 );
    vSetAPUPolarPan( bAPURChannel, 0x00 );
    vSetAPUBalance( bAPURChannel, 0x00 );
    vSetAPUDataSourceA( bAPURChannel, 0x00 );
    vSetAPUInvertPolarityA( bAPURChannel, DISABLE );
    vSetAPUDataSourceB( bAPURChannel, 0x00 );
    vSetAPUInvertPolarityB( bAPURChannel, DISABLE );
    vSetAPUEnvelopeType( bAPURChannel, 0x00 );
    vSetAPUEnvelopeState( bAPURChannel, 0x00 );
    vSetAPUFilterType( bAPURChannel, 0x03 );
    vSetAPUFilterQ( bAPURChannel, 0x03 );
    vSetAPUIntOnLoop( bAPURChannel, DISABLE );
    vSetAPUDMA( bAPURChannel, ENABLE );
    vSetAPUEndCurve( bAPURChannel, DISABLE );
























    vSetAPUFrequency( bAPULChannel, LOWORD( dwFreq ) );
    vSetAPUSubmixMode( bAPULChannel, DISABLE );
    vSetAPUSubmixGroup( bAPULChannel, 0x00 );
    vSetAPU6dB( bAPULChannel, ENABLE );
    vSetAPUEffectChannels( bAPULChannel, 0x00 );
    vSetAPUDualEffectSend( bAPULChannel, DISABLE );
    vSetAPUWavePtr( bAPULChannel, dwPhysAddr, wApuBufferSize );
    vSetAPUEffectGain( bAPULChannel, 0x00 );
    vSetAPUAmplitudeNow( bAPULChannel, 0xD0 );
    vSetAPUFilterTuning( bAPULChannel, 0x8F );
    vSetAPURadiusSelect( bAPULChannel, 0x00 );
    vSetAPUPolarPan( bAPULChannel, 0x10 );
    vSetAPUBalance( bAPULChannel, 0x00 );
    vSetAPUDataSourceA( bAPULChannel, 0x00 );
    vSetAPUInvertPolarityA( bAPULChannel, DISABLE );
    vSetAPUDataSourceB( bAPULChannel, 0x00 );
    vSetAPUInvertPolarityB( bAPULChannel, DISABLE );
    vSetAPUEnvelopeType( bAPULChannel, 0x00 );
    vSetAPUEnvelopeState( bAPULChannel, 0x00 );
    vSetAPUFilterType( bAPULChannel, 0x03 );
    vSetAPUFilterQ( bAPULChannel, 0x03 );
    vSetAPUIntOnLoop( bAPULChannel, DISABLE );
    vSetAPUDMA( bAPULChannel, ENABLE );
    vSetAPUEndCurve( bAPULChannel, DISABLE );

	bIRQTestFlag[0] = 0;

    outpw( gwPTBaseIO + 0x04, 0x0001 );     /* Clear and pending WP Interrupts */
    outpw( gwPTBaseIO + 0x18, (WORD)( inpw( gwPTBaseIO + 0x18 ) | 0x0004 ) );

    while( ( wInterruptFreq < dwActualFreq ) && ( wBinaryShift < 7 ) )
        {
        wBinaryShift++;
        dwActualFreq >>= 1;
        }

    while( ( wInterruptFreq <= ( dwActualFreq / ( wCountDown + 1) ) ) && ( wCountDown < wMaxCountDown ) )
        {
        wCountDown++;
        }


    if( !wCountDown )
        {
        wBinaryShift--;
        wCountDown = wMaxCountDown;
        }

    wCountDown--;

    vSetAPUType( bAPURChannel, 0x04 );
    vSetAPUType( bAPULChannel, 0x04 );

    _disable();

    vMskIDRBit( 0x11, 0 );
    vMskIDRBit( 0x17, 0 );                  /* Disable Bob Timer Interrupts */

    vWrIDR( 0x06, (WORD)( 0x8000 | (1 << 12 ) | (wBinaryShift<<5) | wCountDown ) );

    vSetIDRBit( 0x11, 0 );
    vSetIDRBit( 0x17, 0 );                  /* Enable Bob Timer Interrupts */

    _enable();

    wApuCurrentPos = 0;
    wDskCurrentPos = 0;

    do
		{
        if( bIRQTestFlag[0] == TRUE )
            {
            bIRQTestFlag[0] = FALSE;


            if( wDskCurrentPos < wApuCurrentPos )
                {
                wChunkSize = wApuCurrentPos - wDskCurrentPos;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );
                }

            if( wDskCurrentPos > wApuCurrentPos )
                {
                wChunkSize = wDskBufferSize - wDskCurrentPos;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );

                wDskCurrentPos = 0;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wApuCurrentPos );
                }

            if( wDskCurrentPos == wApuCurrentPos )
                {
                }

            wDskCurrentPos = wApuCurrentPos;
            }
		}
    while( !kbhit() && !eof( iFileHandle ) );

    if( kbhit() )
        getch();

    close( iFileHandle );

    outpw( gwPTBaseIO + 0x18, (WORD)( inpw( gwPTBaseIO + 0x18 ) & 0xFFFB ) );

    outpw( gwPTBaseIO + 0x04, 0x0001 );

    vMskIDRBit( 0x17, 0 );              /* Disable Bob Timer Interrupts */

    vSetAPUType( bAPURChannel, 0x00 );
    vSetAPUType( bAPULChannel, 0x00 );

    vFreeDMABuffer( lpDskBuffer );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vPlayPCIStereo16( LPBYTE _lpFileName, DWORD _dwSampleRate )
    {
    DWORD   dwActualFreq    = ( 50000000L / 512L );
    WORD    wBinaryShift    = 0;
    WORD    wCountDown      = 1;
    WORD    wMaxCountDown   = 31;

    WORD    wIndex;

    int     iFileHandle;

    DWORD   dwPhysAddr,
            dwFreq;

    wApuBufferSize = wDskBufferSize;

    for( wIndex=0; wIndex < 0x0F; wIndex++ );
        {
        vWrAPUReg( bAPURChannel, (BYTE)wIndex, 0x0000 );
        vWrAPUReg( bAPULChannel, (BYTE)wIndex, 0x0000 );
        }


    if( lpAllocateDMABuffer( MAXDMABUFFERS, DMABUFFERSIZE, &lpDskBuffer ) == NULL )
        {
        return;
        }

    iFileHandle = open( (char *)_lpFileName, O_BINARY | O_RDONLY );

    read( iFileHandle, lpDskBuffer, wDskBufferSize );

    dwPhysAddr = (DWORD)( (DWORD)(_FP_SEG( lpDskBuffer ) ) << 4 ) + (DWORD)(_FP_OFF( lpDskBuffer ) );

    vWrWCReg( 0x01FC, 0x0000 );
    vWrWCReg( 0x00, (WORD)( ( LOWORD( dwPhysAddr ) - 0x10 ) & 0xFFF8 ) | 0x02 );

    /* Calculate WP base address */
    dwPhysAddr >>= 1;           /* adjust for word size */
    dwPhysAddr |= 0x00000000L;  /* Enable bit 22 for system ram access */
    dwPhysAddr |= 0x00400000L;  /* Enable bit 22 for system ram access */
    dwPhysAddr |= 0x00800000L;  /* Enable bit 23 for stereo */

    wDskSeg = LOWORD( dwPhysAddr );

    wApuBufferSize >>= 1;

    _dwSampleRate <<= 1;

    if( _dwSampleRate == 44100 )
        {
        dwFreq = MN_44100;
        }
    else
        {
        if( _dwSampleRate == 22050 )
            {
            dwFreq = MN_22050;
            }
        else
            {
            if( _dwSampleRate == 11025 )
                {
                dwFreq = MN_11025;
                }
            }
        }

    vWrAPUReg( bAPURChannel, 0x00, 0x0000 );
    vWrAPUReg( bAPULChannel, 0x00, 0x0000 );

    vSetAPUFrequency( bAPURChannel, LOWORD( dwFreq ) );
    vSetAPUSubmixMode( bAPURChannel, DISABLE );
    vSetAPUSubmixGroup( bAPURChannel, 0x00 );
    vSetAPU6dB( bAPURChannel, ENABLE );
    vSetAPUEffectChannels( bAPURChannel, 0x00 );
    vSetAPUDualEffectSend( bAPURChannel, DISABLE );
    vSetAPUWavePtr( bAPURChannel, dwPhysAddr, wApuBufferSize );
    vSetAPUEffectGain( bAPURChannel, 0x00 );
    vSetAPUAmplitudeNow( bAPURChannel, 0xD0 );
    vSetAPUFilterTuning( bAPURChannel, 0x8F );
    vSetAPURadiusSelect( bAPURChannel, 0x00 );
    vSetAPUPolarPan( bAPURChannel, 0x00 );
    vSetAPUBalance( bAPURChannel, 0x00 );
    vSetAPUDataSourceA( bAPURChannel, 0x00 );
    vSetAPUInvertPolarityA( bAPURChannel, DISABLE );
    vSetAPUDataSourceB( bAPURChannel, 0x00 );
    vSetAPUInvertPolarityB( bAPURChannel, DISABLE );
    vSetAPUEnvelopeType( bAPURChannel, 0x00 );
    vSetAPUEnvelopeState( bAPURChannel, 0x00 );
    vSetAPUFilterType( bAPURChannel, 0x03 );
    vSetAPUFilterQ( bAPURChannel, 0x03 );
    vSetAPUIntOnLoop( bAPURChannel, DISABLE );
    vSetAPUDMA( bAPURChannel, ENABLE );
    vSetAPUEndCurve( bAPURChannel, DISABLE );


    vSetAPUFrequency( bAPULChannel, LOWORD( dwFreq ) );
    vSetAPUSubmixMode( bAPULChannel, DISABLE );
    vSetAPUSubmixGroup( bAPULChannel, 0x00 );
    vSetAPU6dB( bAPULChannel, ENABLE );
    vSetAPUEffectChannels( bAPULChannel, 0x00 );
    vSetAPUDualEffectSend( bAPULChannel, DISABLE );
    vSetAPUWavePtr( bAPULChannel, dwPhysAddr, wApuBufferSize );
    vSetAPUEffectGain( bAPULChannel, 0x00 );
    vSetAPUAmplitudeNow( bAPULChannel, 0xD0 );
    vSetAPUFilterTuning( bAPULChannel, 0x8F );
    vSetAPURadiusSelect( bAPULChannel, 0x00 );
    vSetAPUPolarPan( bAPULChannel, 0x10 );
    vSetAPUBalance( bAPULChannel, 0x00 );
    vSetAPUDataSourceA( bAPULChannel, 0x00 );
    vSetAPUInvertPolarityA( bAPULChannel, DISABLE );
    vSetAPUDataSourceB( bAPULChannel, 0x00 );
    vSetAPUInvertPolarityB( bAPULChannel, DISABLE );
    vSetAPUEnvelopeType( bAPULChannel, 0x00 );
    vSetAPUEnvelopeState( bAPULChannel, 0x00 );
    vSetAPUFilterType( bAPULChannel, 0x03 );
    vSetAPUFilterQ( bAPULChannel, 0x03 );
    vSetAPUIntOnLoop( bAPULChannel, DISABLE );
    vSetAPUDMA( bAPULChannel, ENABLE );
    vSetAPUEndCurve( bAPULChannel, DISABLE );

	bIRQTestFlag[0] = 0;

    outpw( gwPTBaseIO + 0x04, 0x0001 );     /* Clear and pending WP Interrupts */
    outpw( gwPTBaseIO + 0x18, (WORD)( inpw( gwPTBaseIO + 0x18 ) | 0x0004 ) );

    while( ( wInterruptFreq < dwActualFreq ) && ( wBinaryShift < 7 ) )
        {
        wBinaryShift++;
        dwActualFreq >>= 1;
        }

    while( ( wInterruptFreq <= ( dwActualFreq / ( wCountDown + 1) ) ) && ( wCountDown < wMaxCountDown ) )
        {
        wCountDown++;
        }


    if( !wCountDown )
        {
        wBinaryShift--;
        wCountDown = wMaxCountDown;
        }

    wCountDown--;

    vSetAPUType( bAPURChannel, 0x02 );
    vSetAPUType( bAPULChannel, 0x02 );

    _disable();

    vMskIDRBit( 0x11, 0 );
    vMskIDRBit( 0x17, 0 );                  /* Disable Bob Timer Interrupts */

    vWrIDR( 0x06, (WORD)( 0x8000 | (1 << 12 ) | (wBinaryShift<<5) | wCountDown ) );

    vSetIDRBit( 0x11, 0 );
    vSetIDRBit( 0x17, 0 );                  /* Enable Bob Timer Interrupts */

    _enable();


    wApuCurrentPos = 0;
    wDskCurrentPos = 0;

    do
		{
        if( bIRQTestFlag[0] == TRUE )
            {
            bIRQTestFlag[0] = FALSE;

            if( wDskCurrentPos < wApuCurrentPos )
                {
                wChunkSize = wApuCurrentPos - wDskCurrentPos;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );
                }

            if( wDskCurrentPos > wApuCurrentPos )
                {
                wChunkSize = wDskBufferSize - wDskCurrentPos;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );

                wDskCurrentPos = 0;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wApuCurrentPos );
                }

            if( wDskCurrentPos == wApuCurrentPos )
                {
                }

            wDskCurrentPos = wApuCurrentPos;
            }
		}
    while( !kbhit() && !eof( iFileHandle ) );

    if( kbhit() )
        getch();

    close( iFileHandle );

    outpw( gwPTBaseIO + 0x18, (WORD)( inpw( gwPTBaseIO + 0x18 ) & 0xFFFB ) );

    outpw( gwPTBaseIO + 0x04, 0x0001 );

    vMskIDRBit( 0x17, 0 );              /* Disable Bob Timer Interrupts */

    vSetAPUType( bAPURChannel, 0x00 );
    vSetAPUType( bAPULChannel, 0x00 );

    vFreeDMABuffer( lpDskBuffer );

    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vPlayPCIMono16( LPBYTE _lpFileName, DWORD _dwSampleRate )
    {
    DWORD   dwActualFreq    = ( 50000000L / 512L );
    WORD    wBinaryShift    = 0;
    WORD    wCountDown      = 1;
    WORD    wMaxCountDown   = 31;

    BYTE    bInKey = 0;

    WORD    wIndex;

    int     iFileHandle;

    DWORD   dwPhysAddr,
            dwFreq;

    wApuBufferSize = wDskBufferSize;

    for( wIndex=0; wIndex < 0x0F; wIndex++ );
        {
        vWrAPUReg( bAPURChannel, (BYTE)wIndex, 0x0000 );
        }


    if( lpAllocateDMABuffer( MAXDMABUFFERS, DMABUFFERSIZE, &lpDskBuffer ) == NULL )
        {
        return;
        }

    iFileHandle = open( (char *)_lpFileName, O_BINARY | O_RDONLY );

    read( iFileHandle, lpDskBuffer, wDskBufferSize );

    dwPhysAddr = (DWORD)( (DWORD)(_FP_SEG( lpDskBuffer ) ) << 4 ) + (DWORD)(_FP_OFF( lpDskBuffer ) );

    vWrWCReg( 0x01FC, 0x0000 );
    vWrWCReg( 0x00, (WORD)( ( LOWORD( dwPhysAddr ) - 0x10 ) & 0xFFF8 ) | 0x00 );

    /* Calculate WP base address */
    dwPhysAddr >>= 1;           /* adjust for word size */
    dwPhysAddr |= 0x00400000L;  /* Enable bit 22 for system ram access */
    dwPhysAddr |= 0x00000000L;  /* Enable bit 23 for stereo */

    wDskSeg = LOWORD( dwPhysAddr );

    wApuBufferSize >>= 1;

    if( _dwSampleRate == 44100 )
        {
        dwFreq = MN_44100;
        }
    else
        {
        if( _dwSampleRate == 22050 )
            {
            dwFreq = MN_22050;
            }
        else
            {
            if( _dwSampleRate == 11025 )
                {
                dwFreq = MN_11025;
                }
            }
        }

    vWrAPUReg( bAPURChannel, 0x00, 0x0000 );
    vWrAPUReg( bAPUMixer, 0x00, 0x0000 );

    vSetAPUFrequency( bAPURChannel, LOWORD( dwFreq ) );
    vSetAPUSubmixMode( bAPURChannel, DISABLE );
    vSetAPUSubmixGroup( bAPURChannel, 0x00 );
    vSetAPU6dB( bAPURChannel, ENABLE );
    vSetAPUEffectChannels( bAPURChannel, 0x00 );
    vSetAPUDualEffectSend( bAPURChannel, DISABLE );
    vSetAPUWavePtr( bAPURChannel, dwPhysAddr, wApuBufferSize );
    vSetAPUEffectGain( bAPURChannel, 0xF0 );
    vSetAPUAmplitudeNow( bAPURChannel, 0xF0 );
    vSetAPUFilterTuning( bAPURChannel, 0x8F );
    vSetAPURadiusSelect( bAPURChannel, 0x00 );
    vSetAPUPolarPan( bAPURChannel, 0x08 );
    vSetAPUBalance( bAPURChannel, 0x00 );
    vSetAPUDataSourceA( bAPURChannel, 0x00 );
    vSetAPUInvertPolarityA( bAPURChannel, DISABLE );
    vSetAPUDataSourceB( bAPURChannel, 0x00 );
    vSetAPUInvertPolarityB( bAPURChannel, DISABLE );
    vSetAPUEnvelopeType( bAPURChannel, 0x00 );
    vSetAPUEnvelopeState( bAPURChannel, 0x00 );
    vSetAPUFilterType( bAPURChannel, 0x03 );
    vSetAPUFilterQ( bAPURChannel, 0x03 );
    vSetAPUIntOnLoop( bAPURChannel, DISABLE );
    vSetAPUDMA( bAPURChannel, ENABLE );
    vSetAPUEndCurve( bAPURChannel, DISABLE );

	bIRQTestFlag[0] = 0;

    outpw( gwPTBaseIO + 0x04, 0x0001 );     /* Clear and pending WP Interrupts */
    outpw( gwPTBaseIO + 0x18, (WORD)( inpw( gwPTBaseIO + 0x18 ) | 0x0004 ) );

    while( ( wInterruptFreq < dwActualFreq ) && ( wBinaryShift < 7 ) )
        {
        wBinaryShift++;
        dwActualFreq >>= 1;
        }

    while( ( wInterruptFreq <= ( dwActualFreq / ( wCountDown + 1) ) ) && ( wCountDown < wMaxCountDown ) )
        {
        wCountDown++;
        }


    if( !wCountDown )
        {
        wBinaryShift--;
        wCountDown = wMaxCountDown;
        }

    wCountDown--;

    vSetAPUType( bAPURChannel, 0x01 );

    _disable();

    vMskIDRBit( 0x11, 0 );
    vMskIDRBit( 0x17, 0 );                  /* Disable Bob Timer Interrupts */

    vWrIDR( 0x06, (WORD)( 0x8000 | (1 << 12 ) | (wBinaryShift<<5) | wCountDown ) );

    vSetIDRBit( 0x11, 0 );
    vSetIDRBit( 0x17, 0 );                  /* Enable Bob Timer Interrupts */

    _enable();


    wApuCurrentPos = 0;
    wDskCurrentPos = 0;

    do
		{
        if( bIRQTestFlag[0] == TRUE )
            {
            bIRQTestFlag[0] = FALSE;

            if( wDskCurrentPos < wApuCurrentPos )
                {
                wChunkSize = wApuCurrentPos - wDskCurrentPos;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );
                }

            if( wDskCurrentPos > wApuCurrentPos )
                {
                wChunkSize = wDskBufferSize - wDskCurrentPos;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );

                wDskCurrentPos = 0;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wApuCurrentPos );
                }

            if( wDskCurrentPos == wApuCurrentPos )
                {
                }

            wDskCurrentPos = wApuCurrentPos;

            if( kbhit() )
                {
                bInKey = (BYTE)getch();
                }
            }
		}
    while( ( bInKey == 0x00 ) && !eof( iFileHandle ) );

    close( iFileHandle );

    outpw( gwPTBaseIO + 0x18, (WORD)( inpw( gwPTBaseIO + 0x18 ) & 0xFFFB ) );

    outpw( gwPTBaseIO + 0x04, 0x0001 );

    vMskIDRBit( 0x17, 0 );              /* Disable Bob Timer Interrupts */

    vSetAPUType( bAPURChannel, 0x00 );
    vSetAPUType( bAPULChannel, 0x00 );

    vFreeDMABuffer( lpDskBuffer );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vPlayPCIMono16Right( LPBYTE _lpFileName, DWORD _dwSampleRate )
    {
    DWORD   dwActualFreq    = ( 50000000L / 512L );
    WORD    wBinaryShift    = 0;
    WORD    wCountDown      = 1;
    WORD    wMaxCountDown   = 31;

    BYTE    bInKey = 0;

    WORD    wIndex;

    int     iFileHandle;

    DWORD   dwPhysAddr,
            dwFreq;

    wApuBufferSize = wDskBufferSize;

    for( wIndex=0; wIndex < 0x0F; wIndex++ );
        {
        vWrAPUReg( bAPURChannel, (BYTE)wIndex, 0x0000 );
        vWrAPUReg( bAPULChannel, (BYTE)wIndex, 0x0000 );
        }


    if( lpAllocateDMABuffer( MAXDMABUFFERS, DMABUFFERSIZE, &lpDskBuffer ) == NULL )
        {
        return;
        }

    iFileHandle = open( (char *)_lpFileName, O_BINARY | O_RDONLY );

    read( iFileHandle, lpDskBuffer, wDskBufferSize );

    dwPhysAddr = (DWORD)( (DWORD)(_FP_SEG( lpDskBuffer ) ) << 4 ) + (DWORD)(_FP_OFF( lpDskBuffer ) );

    vWrWCReg( 0x01FC, 0x0000 );
    vWrWCReg( 0x00, (WORD)( ( LOWORD( dwPhysAddr ) - 0x10 ) & 0xFFF8 ) | 0x00 );

    /* Calculate WP base address */
    dwPhysAddr >>= 1;           /* adjust for word size */
    dwPhysAddr |= 0x00400000L;  /* Enable bit 22 for system ram access */
    dwPhysAddr |= 0x00000000L;  /* Enable bit 23 for stereo */

    wDskSeg = LOWORD( dwPhysAddr );

    wApuBufferSize >>= 1;

    if( _dwSampleRate == 44100 )
        {
        dwFreq = MN_44100;
        }
    else
        {
        if( _dwSampleRate == 22050 )
            {
            dwFreq = MN_22050;
            }
        else
            {
            if( _dwSampleRate == 11025 )
                {
                dwFreq = MN_11025;
                }
            }
        }

    vWrAPUReg( bAPURChannel, 0x00, 0x0000 );
    vWrAPUReg( bAPURChannel, 0x00, 0x0000 );

    vSetAPUFrequency( bAPURChannel, LOWORD( dwFreq ) );
    vSetAPUSubmixMode( bAPURChannel, DISABLE );
    vSetAPUSubmixGroup( bAPURChannel, 0x00 );
    vSetAPU6dB( bAPURChannel, ENABLE );
    vSetAPUEffectChannels( bAPURChannel, 0x00 );
    vSetAPUDualEffectSend( bAPURChannel, DISABLE );
    vSetAPUWavePtr( bAPURChannel, dwPhysAddr, wApuBufferSize );
    vSetAPUEffectGain( bAPURChannel, 0x00 );
    vSetAPUAmplitudeNow( bAPURChannel, 0xD0 );
    vSetAPUFilterTuning( bAPURChannel, 0x8F );
    vSetAPURadiusSelect( bAPURChannel, 0x00 );
    vSetAPUPolarPan( bAPURChannel, 0x00 );
    vSetAPUBalance( bAPURChannel, 0x00 );
    vSetAPUDataSourceA( bAPURChannel, 0x00 );
    vSetAPUInvertPolarityA( bAPURChannel, DISABLE );
    vSetAPUDataSourceB( bAPURChannel, 0x00 );
    vSetAPUInvertPolarityB( bAPURChannel, DISABLE );
    vSetAPUEnvelopeType( bAPURChannel, 0x00 );
    vSetAPUEnvelopeState( bAPURChannel, 0x00 );
    vSetAPUFilterType( bAPURChannel, 0x03 );
    vSetAPUFilterQ( bAPURChannel, 0x03 );
    vSetAPUIntOnLoop( bAPURChannel, DISABLE );
    vSetAPUDMA( bAPURChannel, ENABLE );
    vSetAPUEndCurve( bAPURChannel, DISABLE );

	bIRQTestFlag[0] = 0;

    outpw( gwPTBaseIO + 0x04, 0x0001 );     /* Clear and pending WP Interrupts */
    outpw( gwPTBaseIO + 0x18, (WORD)( inpw( gwPTBaseIO + 0x18 ) | 0x0004 ) );

    while( ( wInterruptFreq < dwActualFreq ) && ( wBinaryShift < 7 ) )
        {
        wBinaryShift++;
        dwActualFreq >>= 1;
        }

    while( ( wInterruptFreq <= ( dwActualFreq / ( wCountDown + 1) ) ) && ( wCountDown < wMaxCountDown ) )
        {
        wCountDown++;
        }


    if( !wCountDown )
        {
        wBinaryShift--;
        wCountDown = wMaxCountDown;
        }

    wCountDown--;

    vSetAPUType( bAPURChannel, 0x01 );

    _disable();

    vMskIDRBit( 0x11, 0 );
    vMskIDRBit( 0x17, 0 );                  /* Disable Bob Timer Interrupts */

    vWrIDR( 0x06, (WORD)( 0x8000 | (1 << 12 ) | (wBinaryShift<<5) | wCountDown ) );

    vSetIDRBit( 0x11, 0 );
    vSetIDRBit( 0x17, 0 );                  /* Enable Bob Timer Interrupts */

    _enable();


    wApuCurrentPos = 0;
    wDskCurrentPos = 0;

    do
		{
        if( bIRQTestFlag[0] == TRUE )
            {
            bIRQTestFlag[0] = FALSE;

            if( wDskCurrentPos < wApuCurrentPos )
                {
                wChunkSize = wApuCurrentPos - wDskCurrentPos;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );
                }

            if( wDskCurrentPos > wApuCurrentPos )
                {
                wChunkSize = wDskBufferSize - wDskCurrentPos;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );

                wDskCurrentPos = 0;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wApuCurrentPos );
                }

            if( wDskCurrentPos == wApuCurrentPos )
                {
                }

            wDskCurrentPos = wApuCurrentPos;

            if( kbhit() )
                {
                bInKey = (BYTE)getch();
                }
            }
		}
    while( ( bInKey == 0x00 ) && !eof( iFileHandle ) );

    close( iFileHandle );

    outpw( gwPTBaseIO + 0x18, (WORD)( inpw( gwPTBaseIO + 0x18 ) & 0xFFFB ) );

    outpw( gwPTBaseIO + 0x04, 0x0001 );

    vMskIDRBit( 0x17, 0 );              /* Disable Bob Timer Interrupts */

    vSetAPUType( bAPURChannel, 0x00 );
    vSetAPUType( bAPULChannel, 0x00 );

    vFreeDMABuffer( lpDskBuffer );
    }
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vPlayPCIMono16Left( LPBYTE _lpFileName, DWORD _dwSampleRate )
    {
    DWORD   dwActualFreq    = ( 50000000L / 512L );
    WORD    wBinaryShift    = 0;
    WORD    wCountDown      = 1;
    WORD    wMaxCountDown   = 31;

    BYTE    bInKey = 0;

    WORD    wIndex;

    int     iFileHandle;

    DWORD   dwPhysAddr,
            dwFreq;

    wApuBufferSize = wDskBufferSize;

    for( wIndex=0; wIndex < 0x0F; wIndex++ );
        {
        vWrAPUReg( bAPURChannel, (BYTE)wIndex, 0x0000 );
        vWrAPUReg( bAPULChannel, (BYTE)wIndex, 0x0000 );
        }


    if( lpAllocateDMABuffer( MAXDMABUFFERS, DMABUFFERSIZE, &lpDskBuffer ) == NULL )
        {
        return;
        }

    iFileHandle = open( (char *)_lpFileName, O_BINARY | O_RDONLY );

    read( iFileHandle, lpDskBuffer, wDskBufferSize );

    dwPhysAddr = (DWORD)( (DWORD)(_FP_SEG( lpDskBuffer ) ) << 4 ) + (DWORD)(_FP_OFF( lpDskBuffer ) );

    vWrWCReg( 0x01FC, 0x0000 );
    vWrWCReg( 0x00, (WORD)( ( LOWORD( dwPhysAddr ) - 0x10 ) & 0xFFF8 ) | 0x00 );

    /* Calculate WP base address */
    dwPhysAddr >>= 1;           /* adjust for word size */
    dwPhysAddr |= 0x00400000L;  /* Enable bit 22 for system ram access */
    dwPhysAddr |= 0x00000000L;  /* Enable bit 23 for stereo */

    wDskSeg = LOWORD( dwPhysAddr );

    wApuBufferSize >>= 1;

    if( _dwSampleRate == 44100 )
        {
        dwFreq = MN_44100;
        }
    else
        {
        if( _dwSampleRate == 22050 )
            {
            dwFreq = MN_22050;
            }
        else
            {
            if( _dwSampleRate == 11025 )
                {
                dwFreq = MN_11025;
                }
            }
        }

    vWrAPUReg( bAPURChannel, 0x00, 0x0000 );
    vWrAPUReg( bAPURChannel, 0x00, 0x0000 );

    vSetAPUFrequency( bAPURChannel, LOWORD( dwFreq ) );
    vSetAPUSubmixMode( bAPURChannel, DISABLE );
    vSetAPUSubmixGroup( bAPURChannel, 0x00 );
    vSetAPU6dB( bAPURChannel, ENABLE );
    vSetAPUEffectChannels( bAPURChannel, 0x00 );
    vSetAPUDualEffectSend( bAPURChannel, DISABLE );
    vSetAPUWavePtr( bAPURChannel, dwPhysAddr, wApuBufferSize );
    vSetAPUEffectGain( bAPURChannel, 0x00 );
    vSetAPUAmplitudeNow( bAPURChannel, 0xD0 );
    vSetAPUFilterTuning( bAPURChannel, 0x8F );
    vSetAPURadiusSelect( bAPURChannel, 0x00 );
    vSetAPUPolarPan( bAPURChannel, 0x10 );
    vSetAPUPolarPan( bAPURChannel, 0x10 );
    vSetAPUPolarPan( bAPURChannel, 0x10 );
    vSetAPUBalance( bAPURChannel, 0x00 );
    vSetAPUDataSourceA( bAPURChannel, 0x00 );
    vSetAPUInvertPolarityA( bAPURChannel, DISABLE );
    vSetAPUDataSourceB( bAPURChannel, 0x00 );
    vSetAPUInvertPolarityB( bAPURChannel, DISABLE );
    vSetAPUEnvelopeType( bAPURChannel, 0x00 );
    vSetAPUEnvelopeState( bAPURChannel, 0x00 );
    vSetAPUFilterType( bAPURChannel, 0x03 );
    vSetAPUFilterQ( bAPURChannel, 0x03 );
    vSetAPUIntOnLoop( bAPURChannel, DISABLE );
    vSetAPUDMA( bAPURChannel, ENABLE );
    vSetAPUEndCurve( bAPURChannel, DISABLE );

	bIRQTestFlag[0] = 0;

    outpw( gwPTBaseIO + 0x04, 0x0001 );     /* Clear and pending WP Interrupts */
    outpw( gwPTBaseIO + 0x18, (WORD)( inpw( gwPTBaseIO + 0x18 ) | 0x0004 ) );

    while( ( wInterruptFreq < dwActualFreq ) && ( wBinaryShift < 7 ) )
        {
        wBinaryShift++;
        dwActualFreq >>= 1;
        }

    while( ( wInterruptFreq <= ( dwActualFreq / ( wCountDown + 1) ) ) && ( wCountDown < wMaxCountDown ) )
        {
        wCountDown++;
        }


    if( !wCountDown )
        {
        wBinaryShift--;
        wCountDown = wMaxCountDown;
        }

    wCountDown--;

    vSetAPUType( bAPURChannel, 0x01 );

    _disable();

    vMskIDRBit( 0x11, 0 );
    vMskIDRBit( 0x17, 0 );                  /* Disable Bob Timer Interrupts */

    vWrIDR( 0x06, (WORD)( 0x8000 | (1 << 12 ) | (wBinaryShift<<5) | wCountDown ) );

    vSetIDRBit( 0x11, 0 );
    vSetIDRBit( 0x17, 0 );                  /* Enable Bob Timer Interrupts */

    _enable();


    wApuCurrentPos = 0;
    wDskCurrentPos = 0;

    do
		{
        if( bIRQTestFlag[0] == TRUE )
            {
            bIRQTestFlag[0] = FALSE;

            if( wDskCurrentPos < wApuCurrentPos )
                {
                wChunkSize = wApuCurrentPos - wDskCurrentPos;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );
                }

            if( wDskCurrentPos > wApuCurrentPos )
                {
                wChunkSize = wDskBufferSize - wDskCurrentPos;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );

                wDskCurrentPos = 0;
                read( iFileHandle, &lpDskBuffer[wDskCurrentPos], wApuCurrentPos );
                }

            if( wDskCurrentPos == wApuCurrentPos )
                {
                }

            wDskCurrentPos = wApuCurrentPos;

            if( kbhit() )
                {
                bInKey = (BYTE)getch();
                }
            }
		}
    while( ( bInKey == 0x00 ) && !eof( iFileHandle ) );

    close( iFileHandle );

    outpw( gwPTBaseIO + 0x18, (WORD)( inpw( gwPTBaseIO + 0x18 ) & 0xFFFB ) );

    outpw( gwPTBaseIO + 0x04, 0x0001 );

    vMskIDRBit( 0x17, 0 );              /* Disable Bob Timer Interrupts */

    vSetAPUType( bAPURChannel, 0x00 );
    vSetAPUType( bAPULChannel, 0x00 );

    vFreeDMABuffer( lpDskBuffer );
    }
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vRecordPCI( LPBYTE _lpFileName, DWORD _dwSampleRate )
    {
    DWORD   dwActualFreq    = ( 50000000L / 512L );
    WORD    wBinaryShift    = 0;
    WORD    wCountDown      = 1;
    WORD    wMaxCountDown   = 31;

    BYTE    bTimeoutFlag;

    WORD    wIndex;

    int     iFileHandle;

    DWORD   dwPhysAddr,
            dwFreq;
	
    BYTE    bInKey = 0;

    wApuBufferSize = wDskBufferSize;

    for( wIndex=0; wIndex < 0x0F; wIndex++ );
        {
        vWrAPUReg( bAPUMixer, (BYTE)wIndex, 0x0000 );
        vWrAPUReg( bAPUSRC, (BYTE)wIndex, 0x0000 );
        }

    if( lpAllocateDMABuffer( MAXDMABUFFERS, DMABUFFERSIZE, &lpDskBuffer ) == NULL )
        {
        return;
        }

    iFileHandle = open( (char *)_lpFileName, O_CREAT | O_TRUNC | O_BINARY | O_RDWR, S_IREAD | S_IWRITE | S_IFREG );

    dwPhysAddr = (DWORD)( (DWORD)(_FP_SEG( lpDskBuffer ) ) << 4 ) + (DWORD)(_FP_OFF( lpDskBuffer ) );

    vWrWCReg( 0x01FC, 0x0000 );
    vWrWCReg( 0x00, (WORD)( ( LOWORD( dwPhysAddr ) - 0x10 ) & 0xFFF8 ) | 0x00 );

    /* Calculate WP base address */
    dwPhysAddr >>= 1;           /* adjust for word size */
    dwPhysAddr |= 0x00400000L;  /* Enable bit 22 for system ram access */
    dwPhysAddr |= 0x00000000L;  /* Enable bit 23 for stereo */

    wDskSeg = LOWORD( dwPhysAddr );

    wApuBufferSize >>= 1;

    if( _dwSampleRate == 44100 )
        {
        dwFreq = MN_44100;
        }
    else
        {
        if( _dwSampleRate == 22050 )
            {
            dwFreq = MN_22050;
            }
        else
            {
            if( _dwSampleRate == 11025 )
                {
                dwFreq = MN_11025;
                }
            }
        }

    vWrAPUReg( bAPUMixer, 0x00, 0x0000 );
    vWrAPUReg( bAPUSRC, 0x00, 0x0000 );

    vSetAPUFrequency( bAPUMixer, 0x010000 );
    vSetAPUSubmixMode( bAPUMixer, ENABLE );
    vSetAPUSubmixGroup( bAPUMixer, 0x00 );
    vSetAPU6dB( bAPUMixer, ENABLE );
    vSetAPUEffectChannels( bAPUMixer, 0x00 );
    vSetAPUDualEffectSend( bAPUMixer, DISABLE );
    vSetAPUWavePtr( bAPUMixer, 0x4B0000, 0x0100 );
    vSetAPUEffectGain( bAPUMixer, 0xF0 );
    vSetAPUAmplitudeNow( bAPUMixer, 0xF0 );
    vSetAPUFilterTuning( bAPUMixer, 0x8F );
    vSetAPURadiusSelect( bAPUMixer, 0x00 );
    vSetAPUPolarPan( bAPUMixer, 0x08 );
    vSetAPUBalance( bAPUMixer, 0x00 );
    vSetAPUDataSourceA( bAPUMixer, 0x14 );
    vSetAPUInvertPolarityA( bAPUMixer, DISABLE );
    vSetAPUDataSourceB( bAPUMixer, 0x00 );
    vSetAPUInvertPolarityB( bAPUMixer, DISABLE );
    vSetAPUEnvelopeType( bAPUMixer, 0x00 );
    vSetAPUEnvelopeState( bAPUMixer, 0x00 );
    vSetAPUFilterType( bAPUMixer, 0x03 );
    vSetAPUFilterQ( bAPUMixer, 0x03 );
    vSetAPUIntOnLoop( bAPUMixer, DISABLE );
    vSetAPUDMA( bAPUMixer, DISABLE );
    vSetAPUEndCurve( bAPUMixer, DISABLE );
























    vSetAPUFrequency( bAPUAmp, 0x010000 );
    vSetAPUSubmixMode( bAPUAmp, ENABLE );
    vSetAPUSubmixGroup( bAPUAmp, 0x00 );
    vSetAPU6dB( bAPUAmp, ENABLE );
    vSetAPUEffectChannels( bAPUAmp, 0x00 );
    vSetAPUDualEffectSend( bAPUAmp, DISABLE );
    vSetAPUWavePtr( bAPUAmp, 0x4B0000, 0x0100 );
    vSetAPUEffectGain( bAPUAmp, 0xF0 );
    vSetAPUAmplitudeNow( bAPUAmp, 0xF0 );
    vSetAPUFilterTuning( bAPUAmp, 0x8F );
    vSetAPURadiusSelect( bAPUAmp, 0x00 );
    vSetAPUPolarPan( bAPUAmp, 0x08 );
    vSetAPUBalance( bAPUAmp, 0x00 );
    vSetAPUDataSourceA( bAPUAmp, bAPUMixer );
    vSetAPUInvertPolarityA( bAPUAmp, DISABLE );
    vSetAPUDataSourceB( bAPUAmp, 0x00 );
    vSetAPUInvertPolarityB( bAPUAmp, DISABLE );
    vSetAPUEnvelopeType( bAPUAmp, 0x00 );
    vSetAPUEnvelopeState( bAPUAmp, 0x00 );
    vSetAPUFilterType( bAPUAmp, 0x03 );
    vSetAPUFilterQ( bAPUAmp, 0x03 );
    vSetAPUIntOnLoop( bAPUAmp, DISABLE );
    vSetAPUDMA( bAPUAmp, DISABLE );
    vSetAPUEndCurve( bAPUAmp, DISABLE );
























    vSetAPUFrequency( bAPUSRC, dwFreq );
    vSetAPUSubmixMode( bAPUSRC, ENABLE );
    vSetAPUSubmixGroup( bAPUSRC, 0x00 );
    vSetAPU6dB( bAPUSRC, ENABLE );
    vSetAPUEffectChannels( bAPUSRC, 0x00 );
    vSetAPUDualEffectSend( bAPUSRC, DISABLE );
    vSetAPUWavePtr( bAPUSRC, dwPhysAddr, wApuBufferSize );
    vSetAPUEffectGain( bAPUSRC, 0xF0 );
    vSetAPUAmplitudeNow( bAPUSRC, 0xF0 );
    vSetAPUFilterTuning( bAPUSRC, 0x8F );
    vSetAPURadiusSelect( bAPUSRC, 0x00 );
    vSetAPUPolarPan( bAPUSRC, 0x08 );
    vSetAPUBalance( bAPUSRC, 0x00 );
    vSetAPUDataSourceA( bAPUSRC, bAPUAmp );
    vSetAPUInvertPolarityA( bAPUSRC, DISABLE );
    vSetAPUDataSourceB( bAPUSRC, 0x00 );
    vSetAPUInvertPolarityB( bAPUSRC, DISABLE );
    vSetAPUEnvelopeType( bAPUSRC, 0x00 );
    vSetAPUEnvelopeState( bAPUSRC, 0x00 );
    vSetAPUFilterType( bAPUSRC, 0x03 );
    vSetAPUFilterQ( bAPUSRC, 0x03 );
    vSetAPUIntOnLoop( bAPUSRC, DISABLE );
    vSetAPUDMA( bAPUSRC, ENABLE );
    vSetAPUEndCurve( bAPUSRC, DISABLE );


	bIRQTestFlag[0] = 0;

    outpw( gwPTBaseIO + 0x04, 0x0001 );     /* Clear and pending WP Interrupts */
    outpw( gwPTBaseIO + 0x18, inpw( gwPTBaseIO + 0x18 ) | 0x0004 );

    while( ( wInterruptFreq < dwActualFreq ) && ( wBinaryShift < 7 ) )
        {
        wBinaryShift++;
        dwActualFreq >>= 1;
        }

    while( ( wInterruptFreq <= ( dwActualFreq / ( wCountDown + 1) ) ) && ( wCountDown < wMaxCountDown ) )
        {
        wCountDown++;
        }


    if( !wCountDown )
        {
        wBinaryShift--;
        wCountDown = wMaxCountDown;
        }

    wCountDown--;

    vSetAPUType( bAPUMixer, 0x09 );
    vSetAPUType( bAPUAmp, 0x0B );
    vSetAPUType( bAPUSRC, 0x0B );

    _disable();

    vMskIDRBit( 0x11, 0 );
    vMskIDRBit( 0x17, 0 );                  /* Disable Bob Timer Interrupts */

    vWrIDR( 0x06, (WORD)( 0x8000 | (1 << 12 ) | (wBinaryShift<<5) | wCountDown ) );
    
    vSetIDRBit( 0x17, 0 );                  /* Enable Bob Timer Interrupts */
    vSetIDRBit( 0x11, 0 );

    _enable();

    wApuCurrentPos = 0;
    wDskCurrentPos = 0;

    bTimeoutFlag = FALSE;

    if( flgAutoMode )
        vSetEventWait( 0x400000, &bTimeoutFlag );

    do
		{
        if( bIRQTestFlag[0] == TRUE )
            {
            bIRQTestFlag[0] = FALSE;

            if( wDskCurrentPos < wApuCurrentPos )
                {
                wChunkSize = wApuCurrentPos - wDskCurrentPos;
                write( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );
                }

            if( wDskCurrentPos > wApuCurrentPos )
                {
                wChunkSize = wDskBufferSize - wDskCurrentPos;
                write( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );

                wDskCurrentPos = 0;
                write( iFileHandle, &lpDskBuffer[wDskCurrentPos], wApuCurrentPos );
                }

            if( wDskCurrentPos == wApuCurrentPos )
                {
                }

            wDskCurrentPos = wApuCurrentPos;

            }

        if( _kbhit() )
            {
            bInKey = (BYTE) getch();
            bTimeoutFlag = TRUE;
            }
        }
    while( bTimeoutFlag == FALSE );
	
    vClearEventWait();

    if( wDskCurrentPos < wApuCurrentPos )
        {
        wChunkSize = wApuCurrentPos - wDskCurrentPos;
        write( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );
        }

    if( wDskCurrentPos > wApuCurrentPos )
        {
        wChunkSize = wDskBufferSize - wDskCurrentPos;
        write( iFileHandle, &lpDskBuffer[wDskCurrentPos], wChunkSize );

        wDskCurrentPos = 0;
        write( iFileHandle, &lpDskBuffer[wDskCurrentPos], wApuCurrentPos );
        }

    if( wDskCurrentPos == wApuCurrentPos )
        {
        }

    close( iFileHandle );

    outpw( gwPTBaseIO + 0x18, inpw( gwPTBaseIO + 0x18 ) & 0xFFFB );
    outpw( gwPTBaseIO + 0x04, 0x0001 );

    vMskIDRBit( 0x17, 0 );      /* Disable Bob Timer Interrupts */

    vWrAPUReg( bAPUMixer,  0x00, 0x0000 );
    vWrAPUReg( bAPUSRC, 0x00, 0x0000 );

    vFreeDMABuffer( lpDskBuffer );
    }


//===============================================
// IIS
//===============================================
//+++++++++++++++++++++++++++++++++++++++++
// Call Kernel I2SInterruptHandler to find out the current IIS frequency
// If freq returned is 0; turn off the APU
//		..			is > 0; valid freq; and set the APU freq and turn it ON
//		..			is < 0; do nothing
// at the same time; need to keep check gwIISEnabled
//+++++++++++++++++++++++++++++++++++++++++
int SetI2SAPUFreq(void)
{
	PHWI phwi = &hwi;
	long dwI2SFreq;
	WORD wTemp;
	WORD wReg;
	DWORD dwDMAFreq;
	int i;

	dwI2SFreq=0;
	for(i=0; i < 10; i++)
	{
		kI2SInterruptHandler(&dwI2SFreq);
		if(dwI2SFreq >= 22050)
			break;
		vDelay(48000);
	}
	if(dwI2SFreq==0)
	{
		return FALSE;
	}

	if(dwI2SFreq==44100)		dwDMAFreq = 0xEB33;
	else if(dwI2SFreq==32000)	dwDMAFreq = 0xAAAA;
	else if(dwI2SFreq==22050)	dwDMAFreq = 0x7599;
	else						dwDMAFreq = 0x10000;
	
	wTemp = dwDMAFreq & 0xffff;
	//-----------------
	// set new value.
	wReg = wRdAPUReg(0x38,0x02) & 0x00FF;
	vWrAPUReg(0x38, 0x02,wReg | (wTemp << 8));
	vWrAPUReg(0x38, 0x03,(WORD)(dwDMAFreq >> 8));
	wReg = wRdAPUReg(0x39,0x02) & 0x00FF;
	vWrAPUReg(0x39, 0x02, wReg | (wTemp << 8));
	vWrAPUReg(0x39, 0x03, (WORD)(dwDMAFreq >> 8));

	wTemp = dwDMAFreq & 0xFFFF;


}


void vPlayIIS(void)
{
	BYTE	bTimeoutFlag;
	WORD	wIndex;
	int 	iFileHandle;
	DWORD	dwPhysAddr,
			dwFreq;
	BYTE	bInKey = 0;
	PHWI	phwi = &hwi;

	wApuBufferSize = wDskBufferSize;

	//--------------------------
	// Enable ASSP software interrupt enable.
	//--------------------------
	vSetASSPInterruptEnable( ENABLE );
	//--------------------------
	// Enable I2S input.
	//--------------------------
	vSetDCI2SEnable( ENABLE );


	////---------------
	//// active apus.
	vSetAPUType( bAPUIISL,	0x01 );
	vSetAPUType( bAPUIISR,	0x01 );

	// it need not use on M2
	//kOpenPassThru(phwi,&pClient_IIS,KCONNECT_I2S,KCONNECT_APU56);

	outpw( gwPTBaseIO + 0x04, 0x0001 ); 	/* Clear and pending WP Interrupts */
	outpw( gwPTBaseIO + 0x18, inpw( gwPTBaseIO + 0x18 ) | 0x0004 );


	wApuCurrentPos = 0;
	wDskCurrentPos = 0;

	bTimeoutFlag = FALSE;

	SetI2SAPUFreq();

	if( flgAutoMode )
		vSetEventWait( 0x400000, &bTimeoutFlag );

	do {
		   if( _kbhit())
		   {
				getch();
				bTimeoutFlag = TRUE;
		   }
		   vDisplayTime();
	} while(bTimeoutFlag == FALSE);
	vClearEventWait();

	outpw( gwPTBaseIO + 0x18, inpw( gwPTBaseIO + 0x18 ) & 0xFFFB );
	outpw( gwPTBaseIO + 0x04, 0x0001 );

	//--------------------------
	// Disable I2S input.
	//--------------------------
	vSetDCI2SEnable( DISABLE );
	//--------------------------
	// Disable ASSP software interrupt enable.
	//--------------------------
	vSetASSPInterruptEnable( DISABLE );

	// it need not use on M2
	//gwISRChannel = CHANNEL0;
	//
	//if(pClient_IIS)
	//	kClosePassThru(phwi,pClient_IIS);

	vSetAPUType( bAPUIISL,	0x00 );
	vSetAPUType( bAPUIISR,	0x00 );
}



