#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<math.h>
#include	<dos.h>
#include	<conio.h>

#include	"sbtype.h"
#include	"sbconfig.h"
#include    "ptconfig.h"

int     _ptio_choices[] = { 0x6100, 0x6400, 0xEC00, 0xF000, 0xF800, 0xFC00, -1 };

int     _ptirq_choices[] = { 2, 3, 5, 7, 9, 10, 11, 12, 14, 15, -1 };


WORD	wSlot,
		wBase;

WORD    gwPTBaseIO;				/* Maestro Base I/O Port */

BYTE	gbPTIRQ;				/* Maestro Interrupt */

WORD    gwChipType;

WORD    gwCodecType;

BYTE    flgTestDRAM;


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void vSetConfigDefaults( void )
    {
    gwPTBaseIO          = DEFAULT_IO_MAESTRO;
    gbPTIRQ             = DEFAULT_IRQ_MAESTRO;

    gwIOAudio           = DEFAULT_IO_AUDIO;
    gbDMAAudio     		= DEFAULT_DMA_AUDIO;
    gbIRQAudio          = DEFAULT_IRQ_AUDIO;

    gwIOFMSynth         = DEFAULT_IO_FMSYNTH;
    gwIOMPU401          = DEFAULT_IO_MPU401;
    gwIOJoystick        = DEFAULT_IO_JOYSTICK;

    flgTestConfiguration= ENABLE;
    flgTestPlayback		= ENABLE;
    flgTestRecording    = ENABLE;
    flgTestFMSynth      = ENABLE;
    flgTestLineIn		= ENABLE;
    flgTestCDLineIn     = ENABLE;
    flgTestAUXLineIn    = ENABLE;
    flgTestJoystick		= ENABLE;
    flgTestMPU401		= ENABLE;
    flgSwapChannels     = DISABLE;
    flgTestDRAM			= ENABLE;
	flgTestIIS			= ENABLE;
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void vSetConfigSettings( void )
    {
    FILE *fpConfigFile;

    if ( ( fpConfigFile = fopen( _PT_CONFIG_FILE_NAME, "w" ) ) != NULL )
    	{
        putw( gwPTBaseIO,           fpConfigFile );
        putw( gbPTIRQ,              fpConfigFile );

        putw( gwIOAudio,            fpConfigFile );
        putw( gbDMAAudio,           fpConfigFile );
        putw( gbIRQAudio,           fpConfigFile );

        putw( gwIOFMSynth,          fpConfigFile );
        putw( gwIOMPU401,			fpConfigFile );
        putw( gwIOJoystick,			fpConfigFile );

		putw( flgTestConfiguration,	fpConfigFile );
		putw( flgTestPlayback,		fpConfigFile );
		putw( flgTestRecording,		fpConfigFile );
        putw( flgTestFMSynth,		fpConfigFile );
        putw( flgTestLineIn,		fpConfigFile );
        putw( flgTestCDLineIn,      fpConfigFile );
        putw( flgTestAUXLineIn,     fpConfigFile );
        putw( flgTestJoystick,		fpConfigFile );
        putw( flgTestMPU401,		fpConfigFile );
        putw( flgSwapChannels,      fpConfigFile );
        putw( flgTestDRAM,          fpConfigFile );
        putw( flgTestIIS,           fpConfigFile );

        fclose( fpConfigFile );
        }

    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void vGetConfigSettings( void )
    {
	FILE *fpConfigFile;
	
    if ( ( fpConfigFile = fopen( _PT_CONFIG_FILE_NAME, "r" ) ) != NULL )
        {
        gwPTBaseIO          = (WORD)getw( fpConfigFile );
        gbPTIRQ             = (BYTE)getw( fpConfigFile );

        gwIOAudio           = (WORD)getw( fpConfigFile );
        gbDMAAudio          = (BYTE)getw( fpConfigFile );
        gbIRQAudio 			= (BYTE)getw( fpConfigFile );

        gwIOFMSynth         = (WORD)getw( fpConfigFile );
        gwIOMPU401			= (WORD)getw( fpConfigFile );
        gwIOJoystick		= (WORD)getw( fpConfigFile );

		flgTestConfiguration= (BYTE)getw( fpConfigFile );
		flgTestPlayback		= (BYTE)getw( fpConfigFile );
		flgTestRecording	= (BYTE)getw( fpConfigFile );
        flgTestFMSynth		= (BYTE)getw( fpConfigFile );
        flgTestLineIn		= (BYTE)getw( fpConfigFile );
		flgTestCDLineIn		= (BYTE)getw( fpConfigFile );
        flgTestAUXLineIn    = (BYTE)getw( fpConfigFile );
        flgTestJoystick     = (BYTE)getw( fpConfigFile );
        flgTestMPU401		= (BYTE)getw( fpConfigFile );
        flgSwapChannels     = (BYTE)getw( fpConfigFile );
        flgTestDRAM			= (BYTE)getw( fpConfigFile );
        flgTestIIS			= (BYTE)getw( fpConfigFile );	
		if(flgTestIIS > ENABLE)
			flgTestIIS = ENABLE;

	    fclose( fpConfigFile );
        }
    else
    	{
    	vSetConfigDefaults();
    	vSetConfigSettings();
    	}
    }

