#include    <stdio.h>
#include	<stdlib.h>
#include	<conio.h>

#include	"sbtype.h"
#include    "sbdelay.h"

#include    "ptconfig.h"
#include    "codec.h"
#include    "pt101.h"

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetMicAGCEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x02, 12 );
            break;

        case ENABLE:
            vSetCRegBit( 0x02, 12 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetMicAGCEnable( void )
    {
    return( bTstCRegBit( 0x02, 12 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetADCLSrc( BYTE _bSrc )
    {
    vWrCReg( 0x02, (WORD)( ( wRdCReg( 0x02 ) & 0x1FFF ) | ( (WORD) ( _bSrc ) << 13 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetADCLSrc( void )
    {
    return( (BYTE)( ( wRdCReg( 0x02 ) & 0xE000 ) >> 13 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetADCRSrc( BYTE _bSrc )
    {
    vWrCReg( 0x02, (WORD)( ( wRdCReg( 0x02 ) & 0xFF1F ) | ( (WORD) ( _bSrc ) << 5 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetADCRSrc( void )
    {
    return( (BYTE)( ( wRdCReg( 0x02 ) & 0x00E0 ) >> 5 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetADCSrc( BYTE _bLSrc, BYTE _bRSrc )
    {
    vSetADCLSrc( _bLSrc );
    vSetADCRSrc( _bRSrc );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetADCLGain( BYTE _bGain )
    {
    vWrCReg( 0x02, (WORD)( wRdCReg( 0x02 ) & 0xF0FF ) | ((WORD)(_bGain) << 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetADCLGain( void )
    {
    return( (BYTE)( ( ( wRdCReg( 0x02 ) & 0x0F00 ) >> 4 ) | ( wRdCReg( 0x02 ) & 0x000F ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetADCRGain( BYTE _bGain )
    {
    vWrCReg( 0x02, (WORD)( wRdCReg( 0x02 ) & 0xFFF0 ) | _bGain );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetADCRGain( void )
    {
    return( (BYTE)( wRdCReg( 0x02 ) & 0x000F ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetADCGain( BYTE _bLGain, BYTE _bRGain )
    {
    vSetADCLGain( _bLGain );
    vSetADCRGain( _bRGain );
    }


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX1LMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x04, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x04, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAUX1LMute( void )
    {
    return( bTstCRegBit( 0x04, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX1LGain( BYTE _bGain )
    {
    vWrCReg( 0x04, (WORD)( ( wRdCReg( 0x04 ) & 0xE1FF ) | ( (WORD)_bGain << 9 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAUX1LGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x04 ) & 0x1E00 ) >> 9 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX1RMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x04, 7 );
            break;

        case ENABLE:
            vSetCRegBit( 0x04, 7 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAUX1RMute( void )
    {
    return( bTstCRegBit( 0x04, 7 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX1RGain( BYTE _bGain )
    {
    vWrCReg( 0x04, (WORD)( ( wRdCReg( 0x04 ) & 0xFFE1 ) | ( (WORD)_bGain << 1 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAUX1RGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x04 ) & 0x001E ) >> 1 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX1Gain( BYTE _bLGain, BYTE _bRGain )
    {
    vSetAUX1LGain( _bLGain );
    vSetAUX1RGain( _bRGain );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAUX1Gain( void )
    {
    return( (WORD) ( ( bGetAUX1LGain() << 9 ) | bGetAUX1RGain() ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX2LMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x05, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x05, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAUX2LMute( void )
    {
    return( bTstCRegBit( 0x05, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX2LGain( BYTE _bGain )
    {
    vWrCReg( 0x05, (WORD)( ( wRdCReg( 0x05 ) & 0xE1FF ) | ( (WORD)_bGain << 9 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAUX2LGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x05 ) & 0x1E00 ) >> 9 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX2RMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x05, 7 );
            break;

        case ENABLE:
            vSetCRegBit( 0x05, 7 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAUX2RMute( void )
    {
    return( bTstCRegBit( 0x05, 7 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX2RGain( BYTE _bGain )
    {
    vWrCReg( 0x05, (WORD)( ( wRdCReg( 0x05 ) & 0xFFE1 ) | ( (WORD)_bGain << 1 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAUX2RGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x05 ) & 0x001E ) >> 1 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX2Gain( BYTE _bLGain, BYTE _bRGain )
    {
    vSetAUX2LGain( _bLGain );
    vSetAUX2RGain( _bRGain );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAUX2Gain( void )
    {
    return( (WORD) ( ( bGetAUX2LGain() << 9 ) | bGetAUX2RGain() ) );
    }



/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX3LMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x06, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x06, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAUX3LMute( void )
    {
    return( bTstCRegBit( 0x06, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX3LGain( BYTE _bGain )
    {
    vWrCReg( 0x06, (WORD)( ( wRdCReg( 0x06 ) & 0xE1FF ) | ( (WORD)_bGain << 9 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAUX3LGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x06 ) & 0x1E00 ) >> 9 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX3RMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x06, 7 );
            break;

        case ENABLE:
            vSetCRegBit( 0x06, 7 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAUX3RMute( void )
    {
    return( bTstCRegBit( 0x06, 7 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX3RGain( BYTE _bGain )
    {
    vWrCReg( 0x06, (WORD)( ( wRdCReg( 0x06 ) & 0xFFE1 ) | ( (WORD)_bGain << 1 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAUX3RGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x06 ) & 0x001E ) >> 1 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAUX3Gain( BYTE _bLGain, BYTE _bRGain )
    {
    vSetAUX3LGain( _bLGain );
    vSetAUX3RGain( _bRGain );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAUX3Gain( void )
    {
    return( (WORD) ( ( bGetAUX3LGain() << 9 ) | bGetAUX3RGain() ) );
    }


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetMicMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x07, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x07, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetMicMute( void )
    {
    return( bTstCRegBit( 0x07, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetMicGain( BYTE _bGain )
    {
    vWrCReg( 0x07, (WORD)( ( wRdCReg( 0x07 ) & 0xE1FF ) | ( (WORD)_bGain << 9 ) ) );
    }
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetMicGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x07 ) & 0x1E00 ) >> 9 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetMonoInMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x08, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x08, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetMonoInMute( void )
    {
    return( bTstCRegBit( 0x08, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetMonoInGain( BYTE _bGain )
    {
    vWrCReg( 0x08, (WORD)( ( wRdCReg( 0x08 ) & 0xE1FF ) | ( (WORD)_bGain << 9 ) ) );
    }
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetMonoInGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x08 ) & 0x1E00 ) >> 9 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDACLMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x09, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x09, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDACLMute( void )
    {
    return( bTstCRegBit( 0x09, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDACLGain( BYTE _bGain )
    {
    vWrCReg( 0x09, (WORD)( ( wRdCReg( 0x09 ) & 0xE1FF ) | ( (WORD)_bGain << 9 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDACLGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x09 ) & 0x1E00 ) >> 9 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDACRMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x09, 7 );
            break;

        case ENABLE:
            vSetCRegBit( 0x09, 7 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDACRMute( void )
    {
    return( bTstCRegBit( 0x09, 7 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDACRGain( BYTE _bGain )
    {
    vWrCReg( 0x09, (WORD)( ( wRdCReg( 0x09 ) & 0xFFE1 ) | ( (WORD)_bGain << 1 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDACRGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x09 ) & 0x001E ) >> 1 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetLineInLMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x1D, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x1D, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLineInLMute( void )
    {
    return( bTstCRegBit( 0x1D, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetLineInLGain( BYTE _bLevel )
    {
    vWrCReg( 0x1D, (WORD)( ( wRdCReg( 0x1D ) & 0xE1FF ) | ( (WORD)_bLevel << 9 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLineInLGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x1D ) & 0x1E00 ) >> 9 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetLineInRMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x1D, 7 );
            break;

        case ENABLE:
            vSetCRegBit( 0x1D, 7 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLineInRMute( void )
    {
    return( bTstCRegBit( 0x1D, 7 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetLineInRGain( BYTE _bLevel )
    {
    vWrCReg( 0x1D, (WORD)( ( wRdCReg( 0x1D ) & 0xFFE1 ) | (_bLevel << 1 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLineInRGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x1D ) & 0x001E ) >> 1 ) );
    }


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetLineInGain( BYTE _bLGain, BYTE _bRGain )
    {
    vSetLineInLGain( _bLGain );
    vSetLineInRGain( _bRGain );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetLineInGain( void )
    {
    return( (WORD)( ( bGetLineInLGain() << 9 ) | bGetLineInRGain() ) );
    }

/*****************************************************************************/
/* Set LOUT L Channel Mute State                                          */
/*                                                                           */
/*****************************************************************************/
void    vSetLOUT1LMute( BYTE _bState )
    {
    switch( _bState )
        {
        case FALSE:
            vMskCRegBit( 0x1E, 15 );
            break;

        case TRUE:
            vSetCRegBit( 0x1E, 15 );
            break;
        }
    }

/*****************************************************************************/
/* Get LOUT L Channel Mute State                                          */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLOUT1LMute( void )
    {
    return( bTstCRegBit( 0x1E, 15 ) );
    }

/*****************************************************************************/
/* Set LOUT L Channel Select                                              */
/*                                                                           */
/*****************************************************************************/
void    vSetLOUT1LChannel( BYTE _bChannel )
    {
    switch( _bChannel )
        {
        case 0: /* R Channel */
            vMskCRegBit( 0x1E, 14 );
            break;

        case 1: /* L Channel */
            vSetCRegBit( 0x1E, 14 );
            break;
        }
    }

/*****************************************************************************/
/* Get LOUT L Channel Select                                              */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLOUT1LChannel( void )
    {
    return( bTstCRegBit( 0x1E, 14 ) );
    }

/*****************************************************************************/
/* Set LOUT L Channel Gain Level                                   */
/*                                                                           */
/*****************************************************************************/
void    vSetLOUT1LGain( BYTE _bLevel )
    {
    vWrCReg( 0x1E, (WORD)( ( wRdCReg( 0x1E ) & 0xE0FF ) | ((WORD)_bLevel) << 8 ) );
    }

/*****************************************************************************/
/* Get LOUT L Channel Gain Level                                   */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLOUT1LGain( void )
    {
    return( (BYTE)( ( wRdCReg( 0x1E ) & 0x1F00 ) >> 8 ) );
    }


/*****************************************************************************/
/* Set LOUT R Channel Mute State                                         */
/*                                                                           */
/*****************************************************************************/
void    vSetLOUT1RMute( BYTE _bState )
    {
    switch( _bState )
        {
        case FALSE:
            vMskCRegBit( 0x1E, 7 );
            break;

        case TRUE:
            vSetCRegBit( 0x1E, 7 );
            break;
        }
    }

/*****************************************************************************/
/* Get LOUT R Channel Mute State                                         */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLOUT1RMute( void )
    {
    return( bTstCRegBit( 0x1E, 7 ) );
    }

/*****************************************************************************/
/* Set LOUT R Channel Select                                             */
/*                                                                           */
/*****************************************************************************/
void    vSetLOUT1RChannel( BYTE _bChannel )
    {
    switch( _bChannel )
        {
        case 0: /* R Channel */
            vMskCRegBit( 0x1E, 6 );
            break;

        case 1: /* L Channel */
            vSetCRegBit( 0x1E, 6 );
            break;
        }
    }

/*****************************************************************************/
/* Get LOUT R Channel Select                                             */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLOUT1RChannel( void )
    {
    return( bTstCRegBit( 0x1E, 6 ) );
    }

/*****************************************************************************/
/* Set LOUT R Channel Gain Level                                  */
/*                                                                           */
/*****************************************************************************/
void    vSetLOUT1RGain( BYTE _bLevel )
    {
    vWrCReg( 0x1E, (WORD)( ( wRdCReg( 0x1E ) & 0xFFE0 ) | _bLevel ) );
    }

/*****************************************************************************/
/* Get LOUT R Channel Gain Level                                  */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLOUT1RGain( void )
    {
    return( (BYTE)( wRdCReg( 0x1E ) & 0x001F ) );
    }



/*****************************************************************************/
/* Set LOUT L Channel Mute State                                          */
/*                                                                           */
/*****************************************************************************/
void    vSetLOUT2LMute( BYTE _bState )
    {
    switch( _bState )
        {
        case FALSE:
            vMskCRegBit( 0x1F, 15 );
            break;

        case TRUE:
            vSetCRegBit( 0x1F, 15 );
            break;
        }
    }

/*****************************************************************************/
/* Get LOUT L Channel Mute State                                          */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLOUT2LMute( void )
    {
    return( bTstCRegBit( 0x1F, 15 ) );
    }

/*****************************************************************************/
/* Set LOUT L Channel Select                                              */
/*                                                                           */
/*****************************************************************************/
void    vSetLOUT2LChannel( BYTE _bChannel )
    {
    switch( _bChannel )
        {
        case 0: /* L Channel */
            vMskCRegBit( 0x1F, 14 );
            break;

        case 1: /* R Channel */
            vSetCRegBit( 0x1F, 14 );
            break;
        }
    }

/*****************************************************************************/
/* Get LOUT L Channel Select                                              */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLOUT2LChannel( void )
    {
    return( bTstCRegBit( 0x1F, 14 ) );
    }

/*****************************************************************************/
/* Set LOUT R Channel Mute State                                         */
/*                                                                           */
/*****************************************************************************/
void    vSetLOUT2RMute( BYTE _bState )
    {
    switch( _bState )
        {
        case FALSE:
            vMskCRegBit( 0x1F, 7 );
            break;

        case TRUE:
            vSetCRegBit( 0x1F, 7 );
            break;
        }
    }

/*****************************************************************************/
/* Get LOUT L Channel Mute State                                          */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLOUT2RMute( void )
    {
    return( bTstCRegBit( 0x1F, 7 ) );
    }

/*****************************************************************************/
/* Set LOUT L Channel Select                                              */
/*                                                                           */
/*****************************************************************************/
void    vSetLOUT2RChannel( BYTE _bChannel )
    {
    switch( _bChannel )
        {
        case 0: /* R Channel */
            vMskCRegBit( 0x1F, 6 );
            break;

        case 1: /* L Channel */
            vSetCRegBit( 0x1F, 6 );
            break;
        }
    }

/*****************************************************************************/
/* Get LOUT L Channel Select                                              */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLOUT2RChannel( void )
    {
    return( bTstCRegBit( 0x1F, 6 ) );
    }




