#include	<stdio.h>
#include	<stdlib.h>

#include	"sbtype.h"
#include	"io32bit.h"

#include    "pciio.h"

#define DEVICE_ENABLE		0x80000000

#define	PCI_CONFIG_INDEX    (WORD)0x0CF8
#define PCI_CONFIG_DATA     (WORD)0x0CFC

DWORD   gdwPCISlot;             /* Maestro PCI 32-Bit Slot Number */
BYTE    gbPCIBios = FALSE;
WORD    gwDevFuncNum;

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vWrPCIRegIndex( DWORD _dwPCIRegIndex )
	{
	outpd( PCI_CONFIG_INDEX, _dwPCIRegIndex );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
DWORD	dwRdPCIRegIndex( void )
	{
	return( (DWORD)inpd( PCI_CONFIG_INDEX ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vWrPCIRegData( DWORD _dwPCIRegData )
	{
	outpd( PCI_CONFIG_DATA, _dwPCIRegData );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
DWORD	dwRdPCIRegData( void )
	{
	return( (DWORD)inpd( PCI_CONFIG_DATA ) );
	}
	

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vWrPCIReg( DWORD _dwPCIRegIndex, DWORD _dwPCIRegData )
	{
    if( gbPCIBios )
        {
        vWrConfWord( gwDevFuncNum, (WORD)_dwPCIRegIndex, LOWORD( _dwPCIRegData ) );
        vWrConfWord( gwDevFuncNum, (WORD)_dwPCIRegIndex + 2, HIWORD( _dwPCIRegData ) );

//        vWrConfDWord( gwDevFuncNum, (WORD)_dwPCIRegIndex, _dwPCIRegData );
        }
    else
        {
        vWrPCIRegIndex( gdwPCISlot | _dwPCIRegIndex );
        vWrPCIRegData( _dwPCIRegData );
        }
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
DWORD	dwRdPCIReg( DWORD _dwPCIRegIndex )
	{
    if( gbPCIBios )
        {
//        return( dwRdConfDWord( gwDevFuncNum, (WORD)_dwPCIRegIndex ) );
        return( MAKELONG( wRdConfWord( gwDevFuncNum, _dwPCIRegIndex ), wRdConfWord( gwDevFuncNum, _dwPCIRegIndex + 2 ) ) );
        }
    else
        {
        vWrPCIRegIndex( gdwPCISlot | _dwPCIRegIndex );
        return( (DWORD)dwRdPCIRegData() );
        }
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetPCIRegBit( DWORD _dwPCIRegIndex, BYTE _bPCIRegBit )
    {
    vWrPCIReg( _dwPCIRegIndex, DWSETBIT( dwRdPCIReg( _dwPCIRegIndex ), _bPCIRegBit ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vMskPCIRegBit( DWORD _dwPCIRegIndex, BYTE _bPCIRegBit )
    {
    vWrPCIReg( _dwPCIRegIndex, DWMSKBIT( dwRdPCIReg( _dwPCIRegIndex ), _bPCIRegBit ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bTstPCIRegBit( DWORD _dwPCIRegIndex, BYTE _bPCIRegBit )
    {
    return( (BYTE)( DWTSTBIT( dwRdPCIReg( _dwPCIRegIndex ), _bPCIRegBit ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
DWORD	dwGetPCIDevID( WORD _wSlotNumber )
	{
	DWORD	dwRetVal;
	
	dwRetVal = dwRdPCIReg( _wSlotNumber << 11 );
	
	return( dwRetVal );
	}
	

