#include	<stdio.h>
#include    <stdlib.h>
#include    <dos.h>

#include	"sbtype.h"
#include	"ptconfig.h"

#include	"pcibios.h"




/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
int iGetPCIBios( void )
    {
    WORD    wRetVal = 0;

	union REGS x86Regs;
	
    x86Regs.x.ax = 0xB101;

    int86( 0x1A, &x86Regs, &x86Regs );

	if( x86Regs.h.ah == 0 )
		{
        wRetVal = (WORD)x86Regs.x.ax;
		}
		
    return( wRetVal );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
int	iFindPCIDevice( WORD _wDeviceID, WORD _wVendorID )
	{
    WORD	wDevFuncNum = 0xFFFF;

	union REGS x86Regs;
	
    x86Regs.x.ax = 0xB102;
    x86Regs.x.cx = _wDeviceID;
    x86Regs.x.dx = _wVendorID;
    x86Regs.x.si = 0x0000;
    
    int86( 0x1A, &x86Regs, &x86Regs );

	if( x86Regs.h.ah == 0 )
		{
		wDevFuncNum = (WORD)x86Regs.x.bx;
		}
		
	return( wDevFuncNum );
	}


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
int iSetPCIInterruptRouting( WORD _wDevFuncNum, BYTE _bInterruptPin, BYTE _bIRQLine )
    {
    union REGS x86Regs;
    struct SREGS x86SRegs;

    x86Regs.x.ax = 0xB10F;
    x86Regs.x.bx = _wDevFuncNum;
    x86Regs.h.cl = _bInterruptPin;
    x86Regs.h.ch = _bIRQLine;
    x86SRegs.ds  = 0xF000;

    int86x( 0x1A, &x86Regs, &x86Regs, &x86SRegs );

    x86Regs.h.al = x86Regs.h.ah;

    return( x86Regs.x.ax );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
int iGetPCIInterruptRouting( PROUTINGHEADER _pRoutingTableHeader )
    {
    union REGS x86Regs;
    struct SREGS x86SRegs;

    x86Regs.x.ax = 0xB10E;
    x86Regs.x.bx = 0x0000;
    x86SRegs.ds  = 0xF000;

    x86SRegs.es  = _FP_SEG( _pRoutingTableHeader );
    x86Regs.x.di = _FP_OFF( _pRoutingTableHeader );

    int86x( 0x1A, &x86Regs, &x86Regs, &x86SRegs );

    x86Regs.h.al = x86Regs.h.ah;

    return( x86Regs.x.bx );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
DWORD   dwRdPCISlot( BYTE _bSlot )
    {
    union REGS x86Regs;
    struct SREGS x86SRegs;

    x86Regs.x.ax = 0xD804;
    x86Regs.h.cl = _bSlot;

    int86x( 0x1A, &x86Regs, &x86Regs, &x86SRegs );

    x86Regs.h.al = x86Regs.h.ah;

    return( (DWORD)( MAKEDWORD( x86Regs.x.di, x86Regs.x.si ) ) );
    }

