#include    <stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<math.h>
#include	<dos.h>
#include	<conio.h>

#include	"sbtype.h"
#include    "sbconfig.h"
#include    "sbdelay.h"
#include	"sbscreen.h"

#include    "ptconfig.h"
#include	"io32bit.h"
#include	"wavcache.h"
#include    "pciio.h"
#include    "cram.h"
#include    "apu.h"
#include    "codec.h"
#include    "pciio.h"
#include    "pcibios.h"

#include    "m2.h"


#define DEVICE_ENABLE		0x80000000


#define	PT_HOST_IRQ_CTRL	( gwPTBaseIO + 0x18 )
#define	PT_HOST_IRQ_STAT	( gwPTBaseIO + 0x1A )

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
int     GetAGOGOSlot( void )
	{
	int		iRetVal = FALSE;
	
    DWORD   dwSlot;

    BYTE	bSlotIndex;

    DWORD   dwSlotID;

    for( bSlotIndex=0; (bSlotIndex <= 31) && (iRetVal == FALSE); bSlotIndex++ )
	    {

        dwSlot = DEVICE_ENABLE | ( bSlotIndex << 11 );

        dwSlotID = dwRdPCIReg( dwSlot | 0x00000000 );

        if( dwSlotID == MAKEDWORD( PCI_VENDOR_ID, PCI_DEVICE_ID ) );
			{
            vDisplayDebugMessage("PCI Bridge Disabled\n");

            gwPTBaseIO = (WORD)( dwRdPCIReg( dwSlot | 0x10 ) & 0xFF00 );
            gdwPCISlot = dwSlot;
            iRetVal = TRUE;
			}
		
        dwSlotID = dwRdPCIReg( dwSlot | 0x00000100 );

        if( dwSlotID == MAKEDWORD( PCI_VENDOR_ID, PCI_DEVICE_ID ) )
			{
            vDisplayDebugMessage("PCI bridge not supported\n");

            dwSlot |= 0x00000100;

            gwPTBaseIO = (WORD)( dwRdPCIReg( dwSlot | 0x10 ) & 0xFF00 );
            gdwPCISlot = dwSlot;
			
			iRetVal = TRUE;
			}
			
	    }

    return( iRetVal );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetPlatformBaseIO( void )
	{
    return( (WORD)( dwRdPCIReg( 0x10 ) & 0xFF00 ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetPlatformBaseIO( WORD _wPCIBaseIO )
	{
	vDisplayDebugMessage( "PCI 10[15:1] = %04X - Base I/O Address\n", _wPCIBaseIO );
	
    vWrPCIReg( 0x10, _wPCIBaseIO & 0xFF00 );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wGetPlatformIRQ( void )
	{
    return( (BYTE)( dwRdPCIReg( 0x3C ) & 0x000F ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetPlatformIRQ( BYTE _bPCIIRQ )
	{
	vDisplayDebugMessage( "PCI 3C[3:0] = %02X - Interrupt Pin\n", _bPCIIRQ );
	
    vWrPCIReg( 0x3C, ( dwRdPCIReg( 0x3C ) & 0xFF00 ) | _bPCIIRQ );
	}



/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetLegacyAudioEnable( BYTE _bState )
	{
    switch( _bState )
        {
        case DISABLE:
        	vDisplayDebugMessage( "PCI 40[15] = 1 - Legacy Audio Disabled\n");
            vSetPCIRegBit( 0x40, 15 );
            break;

        case ENABLE:
        	vDisplayDebugMessage( "PCI 40[15] = 0 - Legacy Audio Enabled\n");
            vMskPCIRegBit( 0x40, 15 );
            break;
        }
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetLegacyAudioEnable( void )
	{
    return( bTstPCIRegBit( 0x40, 15 ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetSerialIRQEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
        	vDisplayDebugMessage( "PCI 40[14] = 1 - Serial IRQ Disabled\n");
            vMskPCIRegBit( 0x40, 14 );
            break;

        case ENABLE:
        	vDisplayDebugMessage( "PCI 40[14] = 1 - Serial IRQ Enabled\n");
            vSetPCIRegBit( 0x40, 14 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetSerialIRQEnable( void )
    {
    return( bTstPCIRegBit( 0x40, 14 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetMIDIIRQ( BYTE _bMIDIIRQ )
    {
    switch( _bMIDIIRQ )
    	{
    	default:
    		break;
    	}
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetMIDIIRQ( void )
    {
    BYTE    bRetVal;

    return( bRetVal );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetSBIRQ( BYTE _bSBIRQ )
	{
    switch(_bSBIRQ )
        {
        case 5:
			vDisplayDebugMessage( "PCI 40[10:8] = 000 - SBIRQ5\n");
            vMskPCIRegBit( 0x40, 10 );
            vMskPCIRegBit( 0x40,  9 );
            vMskPCIRegBit( 0x40,  8 );
            break;

        case 7:
			vDisplayDebugMessage( "PCI 40[10:8] = 001 - SBIRQ7\n");
            vMskPCIRegBit( 0x40, 10 );
            vMskPCIRegBit( 0x40,  9 );
            vSetPCIRegBit( 0x40,  8 );
            break;

        case 9:
			vDisplayDebugMessage( "PCI 40[10:8] = 010 - SBIRQ9\n");
            vMskPCIRegBit( 0x40, 10 );
            vSetPCIRegBit( 0x40,  9 );
            vMskPCIRegBit( 0x40,  8 );
            break;

        case 10:
			vDisplayDebugMessage( "PCI 40[10:8] = 011 - SBIRQ10\n");
            vMskPCIRegBit( 0x40, 10 );
            vSetPCIRegBit( 0x40,  9 );
            vSetPCIRegBit( 0x40,  8 );
            break;
        }
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetSBIRQ( void )
	{       
	BYTE	bRetVal;
	
    switch( ( dwRdPCIReg( 0x40 ) & 0x0700 ) >> 8 )
		{
		case 0:
			bRetVal = 5;
			break;

		case 1:
			bRetVal = 7;
			break;

		case 2:
			bRetVal = 9;
			break;

		case 3:
			bRetVal = 10;
			break;
		}

	return( bRetVal );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetSBDMA( BYTE _bSBDMA )
    {
    switch( _bSBDMA )
        {
        case 0:
			vDisplayDebugMessage( "PCI 40[7:6] = 00 - SBDMA0\n");
            vMskPCIRegBit( 0x40, 7 );
            vMskPCIRegBit( 0x40, 6 );
            break;

        case 1:
			vDisplayDebugMessage( "PCI 40[7:6] = 01 - SBDMA0\n");
            vMskPCIRegBit( 0x40, 7 );
            vSetPCIRegBit( 0x40, 6 );
            break;

        case 3:
			vDisplayDebugMessage( "PCI 40[7:6] = 11 - SBDMA0\n");
            vSetPCIRegBit( 0x40, 7 );
            vSetPCIRegBit( 0x40, 6 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetSBDMA( void )
    {
    BYTE	bRetVal;
    
    switch( ( dwRdPCIReg( 0x40 ) & 0x00C0 ) >> 6 )
        {
        case 0:
            bRetVal = 0;
            break;
        case 1:
            bRetVal = 1;
            break;
        case 3:
            bRetVal = 3;
            break;
        }

    return( bRetVal );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAddressAliasEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
			vDisplayDebugMessage( "PCI 40[5] = 0 - I/O Address Alias Disabled\n");
            vMskPCIRegBit( 0x40, 5 );
            break;

        case ENABLE:
			vDisplayDebugMessage( "PCI 40[5] = 1 - I/O Address Alias Enabled\n");
            vSetPCIRegBit( 0x40, 5 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAddressAliasEnable( void )
    {
    return( bTstPCIRegBit( 0x40, 5 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetMPU401IRQ( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
			vDisplayDebugMessage( "PCI 40[4] = 0 - MPU401 IRQ Disabled\n");
            vMskPCIRegBit( 0x40, 4 );
            break;

        case ENABLE:
			vDisplayDebugMessage( "PCI 40[4] = 1 - MPU401 IRQ Enabled\n");
            vSetPCIRegBit( 0x40, 4 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetMPU401IRQ( void )
    {
    return( bTstPCIRegBit( 0x40, 4 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetMPU401Enable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
			vDisplayDebugMessage( "PCI 40[3] = 0 - MPU401 I/O Disabled\n");
            vMskPCIRegBit( 0x40, 3 );
            break;

        case ENABLE:
			vDisplayDebugMessage( "PCI 40[3] = 1 - MPU401 I/O Enabled\n");
            vSetPCIRegBit( 0x40, 3 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetMPU401Enable( void )
    {
    return( bTstPCIRegBit( 0x40, 3 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetGamePortEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
			vDisplayDebugMessage( "PCI 40[2] = 0 - Game Port Disabled\n");
            vMskPCIRegBit( 0x40, 2 );
            break;

        case ENABLE:
			vDisplayDebugMessage( "PCI 40[2] = 1 - Game Port Enabled\n");
            vSetPCIRegBit( 0x40, 2 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetGamePortEnable( void )
    {
    return( bTstPCIRegBit( 0x40, 2 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetFMSynthEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
			vDisplayDebugMessage( "PCI 40[1] = 0 - FM Synthesizer I/O Disabled\n");
            vMskPCIRegBit( 0x40, 1 );
            break;

        case ENABLE:
			vDisplayDebugMessage( "PCI 40[1] = 1 - FM Synthesizer I/O Enabled\n");
            vSetPCIRegBit( 0x40, 1 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetFMSynthEnable( void )
    {
    return( bTstPCIRegBit( 0x40, 1 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetSBModeEnable( BYTE _bState )
    {
    switch(_bState )
        {
        case DISABLE:
			vDisplayDebugMessage( "PCI 40[0] = 0 - SB Mode Disabled\n");
            vMskPCIRegBit( 0x40, 0 );
            break;

        case ENABLE:
			vDisplayDebugMessage( "PCI 40[0] = 1 - SB Mode Enabled\n");
            vSetPCIRegBit( 0x40, 0 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetSBModeEnable( void )
    {
    return( bTstPCIRegBit( 0x40, 0 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetHPGamePortEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
			vDisplayDebugMessage( "PCI 50[12] = 0 - HP Game Port Disabled\n");
            vMskPCIRegBit( 0x50, 12 );
            break;

        case ENABLE:
			vDisplayDebugMessage( "PCI 50[12] = 1 - HP Game Port Enabled\n");
            vSetPCIRegBit( 0x50, 12 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetHPGamePortEnable( void )
    {
    return( bTstPCIRegBit( 0x50, 12 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetISADMAPolicy( BYTE _bPolicy )
    {
	vDisplayDebugMessage( "PCI 50[11:9] = %02X - ISA DMA Polucy\n", _bPolicy );
    vWrPCIReg( 0x50, ( dwRdPCIReg( 0x50 ) & 0xFFFFF8FF ) | ( (DWORD)(_bPolicy) << 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetISADMAPolicy( void )
    {
    return( (BYTE)( ( dwRdPCIReg( 0x50 ) & 0x00000700 ) >> 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetPostedWriteEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
			vDisplayDebugMessage( "PCI 50[7] = 0 - Posted Write Disabled\n");
            vMskPCIRegBit( 0x50, 7 );
            break;

        case ENABLE:
			vDisplayDebugMessage( "PCI 50[7] = 1 - Posted Write Enabled\n");
            vSetPCIRegBit( 0x50, 7 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetPostedWriteEnable( void )
    {
    return( bTstPCIRegBit( 0x50, 7 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetMPU401BaseIO( WORD _wMPU401BaseIO )
	{
    switch( _wMPU401BaseIO )
        {
        case 0x0300:
            vSetPCIRegBit( 0x50, 3 );
            vMskPCIRegBit( 0x50, 4 );
            break;

        case 0x0310:
            break;

        case 0x0320:
            vMskPCIRegBit( 0x50, 3 );
            vSetPCIRegBit( 0x50, 4 );
            break;

        case 0x0330:
            vMskPCIRegBit( 0x50, 3 );
            vMskPCIRegBit( 0x50, 4 );
            break;

        case 0x0340:
            vSetPCIRegBit( 0x50, 3 );
            vSetPCIRegBit( 0x50, 4 );
            break;
        }
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wGetMPU401BaseIO( void )
	{
	WORD	wRetVal;
	
    switch( ( dwRdPCIReg( 0x50 ) & 0x00000018 ) >> 3 )
		{
		case 0:
            wRetVal = 0x0330;
			break;

		case 1:
            wRetVal = 0x0300;
			break;

		case 2:
			wRetVal = 0x0320;
			break;

		case 3:
            wRetVal = 0x0340;
			break;
		}

	return( wRetVal );
	}
	
/*****************************************************************************/
/* vSetSBBaseIO - Set SoundBlaster(tm) Base I/O Address                      */
/*                                                                           */
/*****************************************************************************/
void    vSetSBBaseIO( WORD _wSBBaseIO )
	{
    switch( _wSBBaseIO )
        {
        case 0x0220:
            vMskPCIRegBit( 0x50, 2 );
            break;

        case 0x0240:
            vSetPCIRegBit( 0x50, 2 );
            break;

        default:
            break;
        }
	}
	
/*****************************************************************************/
/* wGetSBBaseIO - Get SoundBlaster(tm) Base I/O Address                      */
/*                                                                           */
/*****************************************************************************/
WORD	wGetSBBaseIO( void )
	{
	WORD	wRetVal;
	
    switch( bTstPCIRegBit( 0x50, 2 ) )
        {
        case DISABLE:
            wRetVal = 0x0220;
            break;

        case ENABLE:
            wRetVal = 0x0240;
            break;
        }
	
	return( wRetVal );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetSubtractiveDecodeEnable( BYTE _bState )
	{
    switch( _bState )
        {
        case DISABLE:
            vMskPCIRegBit( 0x50, 1 );
            break;

        case ENABLE:
            vSetPCIRegBit( 0x50, 1 );
            break;
        }
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetSubtractiveDecodeEnable( void )
	{
	return( bTstPCIRegBit( 0x50, 1 ) );
	}
	


/*****************************************************************************/
/* vSetIntelIRQ - Enable Intel Interrupt Type                             */
/*                                                                           */
/*****************************************************************************/
void    vSetInternalClockMultiplierEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskPCIRegBit( 0x52, 15 );
            break;

        case ENABLE:
            vSetPCIRegBit( 0x52, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetInternalClockMultiplierEnable( void )
    {
    return( bTstPCIRegBit( 0x52, 15 ) );
    }

/*****************************************************************************/
/* vSetPowerMgmt - Enable Power Management                                */
/*                                                                           */
/*****************************************************************************/
void    vSetClockSource( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskPCIRegBit( 0x52, 14 );
            break;
        case ENABLE:
            vSetPCIRegBit( 0x52, 14 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetClockSource( void )
    {
    return( bTstPCIRegBit( 0x52, 14 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetClockModeSelect( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskPCIRegBit( 0x52, 13 );
            break;

        case ENABLE:
            vSetPCIRegBit( 0x52, 13 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetClockModeSelect( void )
    {
    return( bTstPCIRegBit( 0x52, 13 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetPowerMgmtEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskPCIRegBit( 0x52, 11 );
            break;
        case ENABLE:
            vSetPCIRegBit( 0x52, 11 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetPowerMgmtEnable( void )
    {
    return( bTstPCIRegBit( 0x52, 11 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetClkDivSelect( BYTE _bClkDiv )
    {
    vWrPCIReg( 0x52, ( dwRdPCIReg( 0x52) & 0xF9FF ) | ( (DWORD)( _bClkDiv ) << 9) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetClkDivSelect( void )
    {
    return( (BYTE)( ( dwRdPCIReg( 0x52 ) & 0x0600 ) >> 9) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetHWVolumeEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskPCIRegBit( 0x52, 7 );
            break;

        case ENABLE:
            vSetPCIRegBit( 0x52, 7 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetHWVolumeEnable( void )
    {
    return( bTstPCIRegBit( 0x52, 7 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetHWVolumeReduceDebounce( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskPCIRegBit( 0x52, 6 );
            break;
        case ENABLE:
            vSetPCIRegBit( 0x52, 6 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetHWVolumeReduceDebounce( void )
    {
    return( bTstPCIRegBit( 0x52, 6 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetHWVolumeInputSelect( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskPCIRegBit( 0x52, 5 );
            break;
        case ENABLE:
            vSetPCIRegBit( 0x52, 5 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetHWVolumeInputSelect( void )
    {
    return( bTstPCIRegBit( 0x52, 5 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDSPInterfaceEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskPCIRegBit( 0x52, 4 );
            break;
        case ENABLE:
            vSetPCIRegBit( 0x52, 4 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDSPInterfaceEnable( void )
    {
    return( bTstPCIRegBit( 0x50, 20 ) );
    }


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDistDmaAddress( WORD _wDistAddr )
    {
    vWrPCIReg( 0x60, ( dwRdPCIReg( 0x60 ) & 0x0000000F ) | ( _wDistAddr << 4 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetDistDmaAddress( void )
    {
    return( (WORD)( ( dwRdPCIReg( 0x60 ) & 0xFFFFFFF0 ) >> 4 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDistDma( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskPCIRegBit( 0x60, 0 );
            break;

        case ENABLE:
            vSetPCIRegBit( 0x60, 0 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDistDma( void )
    {
    return( bTstPCIRegBit( 0x60, 0 ) );
    }


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetHostInterruptControlBit( BYTE _bCtrlBit )
	{
	outpw( PT_HOST_IRQ_CTRL, WSETBIT( inpw( PT_HOST_IRQ_CTRL ), _bCtrlBit ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vMskHostInterruptControlBit( BYTE _bCtrlBit )	
	{
	outpw( PT_HOST_IRQ_CTRL, WMSKBIT( inpw( PT_HOST_IRQ_CTRL ), _bCtrlBit ) );
	}
		

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bTstHostInterruptControlBit( BYTE _bCtrlBit )
	{
	return( (BYTE)WTSTBIT( inpw( PT_HOST_IRQ_CTRL ), _bCtrlBit ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetHostInterruptStatusBit( BYTE _bStatBit )
	{
	outpw( PT_HOST_IRQ_STAT, WMSKBIT( inpw( PT_HOST_IRQ_STAT ), _bStatBit ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bTstHostInterruptStatusBit( BYTE _bStatBit )
	{
	return( (BYTE)WTSTBIT( inpw( PT_HOST_IRQ_STAT ), _bStatBit ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vResetMaestro( void )
	{

//  outpw( gwPTBaseIO + 0x18, 0x8000 );
//  vDelay( _M1_RST_TIMEOUT );
//  outpw( gwPTBaseIO + 0x18, 0x0000 );
//  vDelay( _M1_RST_TIMEOUT );
    

	vSetHostInterruptControlBit( 15 );
    vDelay( _M1_RST_TIMEOUT );
	vMskHostInterruptControlBit( 15 );
    vDelay( _M1_RST_TIMEOUT );
    
    }
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vResetDirectSound( void )
	{
    outpw( gwPTBaseIO + 0x18, 0x2000 );
    vDelay( _WP_RST_TIMEOUT );;
    outpw( gwPTBaseIO + 0x18, 0x0000 );
    vDelay( _WP_RST_TIMEOUT );;
/*
	vSetHostInterruptControlBit( 13 );
    vDelay( _WP_RST_TIMEOUT );;
	vMskHostInterruptControlBit( 13 );
    vDelay( _WP_RST_TIMEOUT );;
*/
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetClkRunEnable( BYTE _bState )
	{
	switch( _bState )
		{
		case DISABLE:
            vMskHostInterruptControlBit( 8 );
			break;

		case ENABLE:
            vSetHostInterruptControlBit( 8 );
			break;
		}
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetClkRunEnable( void )
    {
    return( bTstHostInterruptControlBit( 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetHWVolumeInterruptEnable( BYTE _bState )
	{
	switch( _bState )
		{
		case DISABLE:
			vMskHostInterruptControlBit( 6 );
			break;

		case ENABLE:
			vSetHostInterruptControlBit( 6 );
			break;
		}
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetHWVolumeInterruptEnable( void )
    {
    return( bTstHostInterruptControlBit( 6 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetASSPInterruptEnable( BYTE _bState )
	{
	switch( _bState )
		{
		case DISABLE:
			vMskHostInterruptControlBit( 4 );
			break;

		case ENABLE:
			vSetHostInterruptControlBit( 4 );
			break;
		}
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetASSPInterruptEnable( void )
    {
    return( bTstHostInterruptControlBit( 4 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDirectSoundInterruptEnable( BYTE _bState )
	{
	switch( _bState )
		{
		case DISABLE:
			vMskHostInterruptControlBit( 2 );
			break;

		case ENABLE:
			vSetHostInterruptControlBit( 2 );
			break;
		}
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDirectSoundInterruptEnable( void )
    {
    return( bTstHostInterruptControlBit( 2 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetMPU401InterruptEnable( BYTE _bState )
	{
	switch( _bState )
		{
		case DISABLE:
			vMskHostInterruptControlBit( 1 );
			break;

		case ENABLE:
			vSetHostInterruptControlBit( 1 );
			break;
		}
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetMPU401InterruptEnable( void )
    {
    return( bTstHostInterruptControlBit( 1 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetSBInterruptEnable( BYTE _bState )
	{
	switch( _bState )
		{
		case DISABLE:
			vMskHostInterruptControlBit( 0 );
			break;

		case ENABLE:
			vSetHostInterruptControlBit( 0 );
			break;
		}
	}		

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetSBInterruptEnable( void )
    {
    return( bTstHostInterruptControlBit( 0 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetASSPInterruptStatus( void )
	{
	return( bTstHostInterruptStatusBit( 4 ) );
	}
	
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetISDNInterruptStatus( void )
	{
	return( bTstHostInterruptStatusBit( 3 ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetDirectSoundInterruptStatus( void )
	{
	return( bTstHostInterruptStatusBit( 2 ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetMPU401InterruptStatus( void )
	{
	return( bTstHostInterruptStatusBit( 1 ) );
	}
    
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetSBInterruptStatus( void )
	{
	return( bTstHostInterruptStatusBit( 0 ) );
	}
    
    
