/******************************************************************************
 *                                                                            *
 *                       (C) 1997-1997 ESS Technology, Inc.                   *
 *                                                                            *
 * This source code, its compiled object code, and its associated data sets   *
 * are copyright (C) 1997-1997 ESS Technology, Inc. This source code and its  *
 * associated data sets are trade secrets of ESS Technology, Inc.             *
 *                                                                            *
 ******************************************************************************/

/*---------------------------------------------------------------------------
 *              Copyright (C) 1997-1997, ESS Technology, Inc.
 *---------------------------------------------------------------------------
 * FILENAME: kernel.h
 *---------------------------------------------------------------------------
 * DESCRIPTION: Header file for Maestro 2/2+ host kernel
 *---------------------------------------------------------------------------
 * AUTHOR:  Henry Tang
 *---------------------------------------------------------------------------
 * HISTORY:
 *    09/03/97  HT  Created.
 *---------------------------------------------------------------------------
 */

//#define DMA_FIX
//#define WAVECACHE_FIX


//
// client IDs
//
// FM client is a special case
//

#define CLIENT_AC3                      0
#define CLIENT_POS3D                    1
#define CLIENT_SPKVIRT                  2
#define CLIENT_SPKVIRT_CRL              3
#define CLIENT_SRC                      4
#define NUMBER_OF_CLIENTS               (CLIENT_SRC + 1)

#define CLIENT_FM                       NUMBER_OF_CLIENTS


// WARNING! DANGER! WARNING! DANGER! WARNING! DANGER! WARNING! DANGER!
//
// If you modify any memory map and/or definitions below be sure to reflect
// the changes in the DSP version found in KERNEL.INC.
//
// WARNING! DANGER! WARNING! DANGER! WARNING! DANGER! WARNING! DANGER!


//
// DSP memory map
//

#define CODE_MEMORY_BEGIN               0x0000
#define CODE_MEMORY_END                 0x0BFF
#define CODE_MEMORY_UNIT_LENGTH         0x0040
#define CODE_MEMORY_LENGTH              (CODE_MEMORY_END - CODE_MEMORY_BEGIN + 1)
#if (CODE_MEMORY_LENGTH % CODE_MEMORY_UNIT_LENGTH)
#error Assumption about code memory unit length failed.
#endif

#define DATA_MEMORY_BEGIN               0x1000
#define DATA_MEMORY_END                 0x17FF
#define DATA_MEMORY_UNIT_LENGTH         0x0080
#define DATA_MEMORY_LENGTH              (DATA_MEMORY_END - DATA_MEMORY_BEGIN + 1)
#if (DATA_MEMORY_LENGTH % DATA_MEMORY_UNIT_LENGTH)
#error Assumption about data memory unit length failed.
#endif


//
// Kernel code memory definition
//

#define KCODE_VECTORS_BEGIN             0x0000
#define KCODE_VECTORS_END               0x002F


//
// Kernel data memory definition
//

#define KDATA_BASE_ADDR                 0x1300

#define KDATA_DMA0_WORD0                (KDATA_BASE_ADDR + 0x0000)
#define KDATA_DMA0_WORD1                (KDATA_BASE_ADDR + 0x0001)
#define KDATA_DMA0_WORD2                (KDATA_BASE_ADDR + 0x0002)
#define KDATA_DMA0_WORD3                (KDATA_BASE_ADDR + 0x0003)
#define KDATA_DMA0_WORD4                (KDATA_BASE_ADDR + 0x0004)
#define KDATA_DMA0_WORD5                (KDATA_BASE_ADDR + 0x0005)
#define KDATA_DMA0_WORD6                (KDATA_BASE_ADDR + 0x0006)
#define KDATA_DMA0_WORD7                (KDATA_BASE_ADDR + 0x0007)
#define KDATA_DMA0_WORD8                (KDATA_BASE_ADDR + 0x0008)
#define KDATA_DMA0_WORD9                (KDATA_BASE_ADDR + 0x0009)
#define KDATA_DMA0_WORDA                (KDATA_BASE_ADDR + 0x000A)
#define KDATA_DMA0_WORDB                (KDATA_BASE_ADDR + 0x000B)
#define KDATA_DMA0_WORDC                (KDATA_BASE_ADDR + 0x000C)
#define KDATA_DMA0_WORDD                (KDATA_BASE_ADDR + 0x000D)
#define KDATA_DMA0_WORDE                (KDATA_BASE_ADDR + 0x000E)
#define KDATA_DMA0_WORDF                (KDATA_BASE_ADDR + 0x000F)

#define KDATA_DMA1_WORD0                (KDATA_BASE_ADDR + 0x0010)
#define KDATA_DMA1_WORD1                (KDATA_BASE_ADDR + 0x0011)
#define KDATA_DMA1_WORD2                (KDATA_BASE_ADDR + 0x0012)
#define KDATA_DMA1_WORD3                (KDATA_BASE_ADDR + 0x0013)
#define KDATA_DMA1_WORD4                (KDATA_BASE_ADDR + 0x0014)
#define KDATA_DMA1_WORD5                (KDATA_BASE_ADDR + 0x0015)
#define KDATA_DMA1_WORD6                (KDATA_BASE_ADDR + 0x0016)
#define KDATA_DMA1_WORD7                (KDATA_BASE_ADDR + 0x0017)
#define KDATA_DMA1_WORD8                (KDATA_BASE_ADDR + 0x0018)
#define KDATA_DMA1_WORD9                (KDATA_BASE_ADDR + 0x0019)
#define KDATA_DMA1_WORDA                (KDATA_BASE_ADDR + 0x001A)
#define KDATA_DMA1_WORDB                (KDATA_BASE_ADDR + 0x001B)
#define KDATA_DMA1_WORDC                (KDATA_BASE_ADDR + 0x001C)
#define KDATA_DMA1_WORDD                (KDATA_BASE_ADDR + 0x001D)
#define KDATA_DMA1_WORDE                (KDATA_BASE_ADDR + 0x001E)
#define KDATA_DMA1_WORDF                (KDATA_BASE_ADDR + 0x001F)

#define KDATA_TASK0                     (KDATA_BASE_ADDR + 0x0020)
#define KDATA_TASK1                     (KDATA_BASE_ADDR + 0x0021)
#define KDATA_TASK2                     (KDATA_BASE_ADDR + 0x0022)
#define KDATA_TASK3                     (KDATA_BASE_ADDR + 0x0023)
#define KDATA_TASK4                     (KDATA_BASE_ADDR + 0x0024)
#define KDATA_TASK5                     (KDATA_BASE_ADDR + 0x0025)
#define KDATA_TASK6                     (KDATA_BASE_ADDR + 0x0026)
#define KDATA_TASK_ENDMARK              (KDATA_BASE_ADDR + 0x0027)

#define KDATA_I2S_TIME_STAMP_LAST       (KDATA_BASE_ADDR + 0x0028)
#define KDATA_I2S_TIME_STAMP_DELTA      (KDATA_BASE_ADDR + 0x0029)
#define KDATA_I2S_BUF_BEGIN             (KDATA_BASE_ADDR + 0x002A)
#define KDATA_I2S_BUF_END_PLUS_1        (KDATA_BASE_ADDR + 0x002B)
#define KDATA_I2S_BUF_HEAD              (KDATA_BASE_ADDR + 0x002C)
#define KDATA_I2S_BUF_TAIL              (KDATA_BASE_ADDR + 0x002D)

#define KDATA_INSTANCE0_AC3             (KDATA_BASE_ADDR + 0x002E)
#define KDATA_INSTANCE_AC3_ENDMARK      (KDATA_BASE_ADDR + 0x002F)

#define KDATA_INSTANCE0_POS3D           (KDATA_BASE_ADDR + 0x0030)
#define KDATA_INSTANCE1_POS3D           (KDATA_BASE_ADDR + 0x0031)
#define KDATA_INSTANCE2_POS3D           (KDATA_BASE_ADDR + 0x0032)
#define KDATA_INSTANCE3_POS3D           (KDATA_BASE_ADDR + 0x0033)
#define KDATA_INSTANCE4_POS3D           (KDATA_BASE_ADDR + 0x0034)
#define KDATA_INSTANCE5_POS3D           (KDATA_BASE_ADDR + 0x0035)
#define KDATA_INSTANCE6_POS3D           (KDATA_BASE_ADDR + 0x0036)
#define KDATA_INSTANCE7_POS3D           (KDATA_BASE_ADDR + 0x0037)
#define KDATA_INSTANCE8_POS3D           (KDATA_BASE_ADDR + 0x0038)
#define KDATA_INSTANCE_POS3D_ENDMARK    (KDATA_BASE_ADDR + 0x0039)

#define KDATA_INSTANCE0_SPKVIRT         (KDATA_BASE_ADDR + 0x003A)
#define KDATA_INSTANCE_SPKVIRT_ENDMARK  (KDATA_BASE_ADDR + 0x003B)

#define KDATA_INSTANCE0_SRC             (KDATA_BASE_ADDR + 0x003C)
#define KDATA_INSTANCE1_SRC             (KDATA_BASE_ADDR + 0x003D)
#define KDATA_INSTANCE2_SRC             (KDATA_BASE_ADDR + 0x003E)
#define KDATA_INSTANCE3_SRC             (KDATA_BASE_ADDR + 0x003F)
#define KDATA_INSTANCE4_SRC             (KDATA_BASE_ADDR + 0x0040)
#define KDATA_INSTANCE5_SRC             (KDATA_BASE_ADDR + 0x0041)
#define KDATA_INSTANCE6_SRC             (KDATA_BASE_ADDR + 0x0042)
#define KDATA_INSTANCE7_SRC             (KDATA_BASE_ADDR + 0x0043)
#define KDATA_INSTANCE_SRC_ENDMARK      (KDATA_BASE_ADDR + 0x0044)

#define KDATA_CURRENT_TASK              (KDATA_BASE_ADDR + 0x0045)
#define KDATA_TASK_SWITCH               (KDATA_BASE_ADDR + 0x0046)

#define KDATA_CURRENT_DMA               (KDATA_BASE_ADDR + 0x0047)
#define KDATA_DMA_SWITCH                (KDATA_BASE_ADDR + 0x0048)
#define KDATA_DMA_ACTIVE                (KDATA_BASE_ADDR + 0x0049)

#define KDATA_ADC_REQUEST               (KDATA_BASE_ADDR + 0x004A)

#define KDATA_TIMER_COUNT_RELOAD        (KDATA_BASE_ADDR + 0x004B)
#define KDATA_TIMER_COUNT_CURRENT       (KDATA_BASE_ADDR + 0x004C)

#define KDATA_HALT_SYNCH_CLIENT         (KDATA_BASE_ADDR + 0x004D)
#define KDATA_HALT_SYNCH_DMA            (KDATA_BASE_ADDR + 0x004E)
#define KDATA_HALT_ACKNOWLEDGE          (KDATA_BASE_ADDR + 0x0050)

#define KDATA_DMA_XFER0                 (KDATA_BASE_ADDR + 0x0051)
#define KDATA_DMA_XFER1                 (KDATA_BASE_ADDR + 0x0052)
#define KDATA_DMA_XFER2                 (KDATA_BASE_ADDR + 0x0053)
#define KDATA_DMA_XFER3                 (KDATA_BASE_ADDR + 0x0054)
#define KDATA_DMA_XFER4                 (KDATA_BASE_ADDR + 0x0055)
#define KDATA_DMA_XFER5                 (KDATA_BASE_ADDR + 0x0056)
#define KDATA_DMA_XFER6                 (KDATA_BASE_ADDR + 0x0057)
#define KDATA_DMA_XFER7                 (KDATA_BASE_ADDR + 0x0058)
#define KDATA_DMA_XFER8                 (KDATA_BASE_ADDR + 0x0059)
#define KDATA_DMA_XFER_ENDMARK          (KDATA_BASE_ADDR + 0x005A)

#define KDATA_DAC_XFER0                 (KDATA_BASE_ADDR + 0x005B)
#define KDATA_DAC_XFER1                 (KDATA_BASE_ADDR + 0x005C)
#define KDATA_DAC_XFER2                 (KDATA_BASE_ADDR + 0x005D)
#define KDATA_DAC_XFER3                 (KDATA_BASE_ADDR + 0x005E)
#define KDATA_DAC_XFER4                 (KDATA_BASE_ADDR + 0x005F)
#define KDATA_DAC_XFER5                 (KDATA_BASE_ADDR + 0x0060)
#define KDATA_DAC_XFER6                 (KDATA_BASE_ADDR + 0x0061)
#define KDATA_DAC_XFER7                 (KDATA_BASE_ADDR + 0x0062)
#define KDATA_DAC_XFER_ENDMARK          (KDATA_BASE_ADDR + 0x0063)

#define KDATA_ADC_XFER0                 (KDATA_BASE_ADDR + 0x0064)
#define KDATA_ADC_XFER_ENDMARK          (KDATA_BASE_ADDR + 0x0065)

#define KDATA_PIO_XFER0                 (KDATA_BASE_ADDR + 0x0066)
#define KDATA_PIO_XFER_ENDMARK          (KDATA_BASE_ADDR + 0x0067)

#define KDATA_MODEM_BUF_BEGIN           (KDATA_BASE_ADDR + 0x0068)
#define KDATA_MODEM_BUF_END_PLUS_1      (KDATA_BASE_ADDR + 0x0069)
#define KDATA_MODEM_BUF_HEAD            (KDATA_BASE_ADDR + 0x006A)
#define KDATA_MODEM_BUF_TAIL            (KDATA_BASE_ADDR + 0x006B)

#define KDATA_I2S_DSP2HOST_REQ_CNT      (KDATA_BASE_ADDR + 0x006C)

#define KDATA_KERNEL_ISR_CBSR1          (KDATA_BASE_ADDR + 0x0075)
#define KDATA_KERNEL_ISR_CBER1          (KDATA_BASE_ADDR + 0x0076)
#define KDATA_KERNEL_ISR_CBCR           (KDATA_BASE_ADDR + 0x0077)
#define KDATA_KERNEL_ISR_AR1            (KDATA_BASE_ADDR + 0x0078)
#define KDATA_KERNEL_ISR_BRCR           (KDATA_BASE_ADDR + 0x0079)
#define KDATA_KERNEL_ISR_PASR           (KDATA_BASE_ADDR + 0x007A)
#define KDATA_KERNEL_ISR_PAER           (KDATA_BASE_ADDR + 0x007B)

#define KDATA_CLIENT_SCRATCH0           (KDATA_BASE_ADDR + 0x007C)
#define KDATA_CLIENT_SCRATCH1           (KDATA_BASE_ADDR + 0x007D)
#define KDATA_KERNEL_SCRATCH            (KDATA_BASE_ADDR + 0x007E)
#define KDATA_KERNEL_ISR_SCRATCH        (KDATA_BASE_ADDR + 0x007F)

#ifdef WAVECACHE_FIX
#if (KDATA_HALT_SYNCH_CLIENT - (KDATA_BASE_ADDR + 0x004D))
#error Synchronization data MUST overlap APU 41/42 wave cache memory!
#endif
#endif
#if (DATA_MEMORY_UNIT_LENGTH - 0x0080)
#error Assumption about DATA_MEMORY_UNIT_LENGTH size failed.
#endif


//
// I2S buffer definition
//

#define KDATA_I2S_BUFFER_ADDR           (KDATA_BASE_ADDR + DATA_MEMORY_UNIT_LENGTH)
#define KDATA_I2S_BUFFER_LENGTH         (DATA_MEMORY_UNIT_LENGTH / 2)


//
// Modem buffer definition
//

#define KDATA_MODEM_BUFFER_ADDR         (KDATA_I2S_BUFFER_ADDR + KDATA_I2S_BUFFER_LENGTH)
#define KDATA_MODEM_BUFFER_LENGTH       (DATA_MEMORY_UNIT_LENGTH / 2)


//
// Client data memory definition
//

#define CDATA_INSTANCE_READY            0x00

#define CDATA_HOST_SRC_ADDRL            0x01
#define CDATA_HOST_SRC_ADDRH            0x02
#define CDATA_HOST_SRC_END_PLUS_1L      0x03
#define CDATA_HOST_SRC_END_PLUS_1H      0x04
#define CDATA_HOST_SRC_CURRENTL         0x05
#define CDATA_HOST_SRC_CURRENTH         0x06

#define CDATA_APU_BLOCK_COUNTL          0x07
#define CDATA_APU_BLOCK_COUNTH          0x08

#define CDATA_IN_BUF_BEGIN              0x09
#define CDATA_IN_BUF_END_PLUS_1         0x0A
#define CDATA_IN_BUF_HEAD               0x0B
#define CDATA_IN_BUF_TAIL               0x0C

#define CDATA_OUT_BUF_BEGIN             0x0D
#define CDATA_OUT_BUF_END_PLUS_1        0x0E
#define CDATA_OUT_BUF_HEAD              0x0F
#define CDATA_OUT_BUF_TAIL              0x10

#define CDATA_DMA_CONTROL               0x11
#define CDATA_RESERVED                  0x12

#define CDATA_HEADER_LEN                0x13


//
// DMA control definition
//

#define DMACONTROL_BLOCK_MASK           0x0007
#define  DMAC_BLOCK0_SELECTOR           0x0000
#define  DMAC_BLOCK1_SELECTOR           0x0001
#define  DMAC_BLOCK2_SELECTOR           0x0002
#define  DMAC_BLOCK3_SELECTOR           0x0003
#define  DMAC_BLOCK4_SELECTOR           0x0004
#define  DMAC_BLOCK5_SELECTOR           0x0005
#define  DMAC_BLOCK6_SELECTOR           0x0006
#define  DMAC_BLOCK7_SELECTOR           0x0007
#define DMACONTROL_AUTOREPEAT           0x0010
#define DMACONTROL_STOPPED              0x0020
#define DMACONTROL_DIRECTION            0x4000


//
// DSP to Host interrupt request definition
//

#define DSP2HOST_REQ_PIORECORD          0x01
#define DSP2HOST_REQ_I2SRATE            0x02
#define DSP2HOST_REQ_TIMER              0x04


// WARNING! DANGER! WARNING! DANGER! WARNING! DANGER! WARNING! DANGER!
//
// If you modify any memory map and/or definitions above be sure to reflect
// the changes in the DSP version found in KERNEL.INC.
//
// WARNING! DANGER! WARNING! DANGER! WARNING! DANGER! WARNING! DANGER!


#define F_FREE                          0x00
#define F_USED                          0x01
#define F_END                           -1


//
// Kernel/client memory allocation
//

#define NUM_UNITS_KERNEL_CODE           8
#define NUM_UNITS_KERNEL_DATA           2

#define NUM_UNITS( BYTES, UNITLEN )    ((((BYTES+1)>>1) + (UNITLEN-1)) / UNITLEN)


//
// Maximum instances
//

#define MAX_TASKS                       (KDATA_TASK_ENDMARK - KDATA_TASK0)

#define MAX_INSTANCE_AC3                (KDATA_INSTANCE_AC3_ENDMARK - KDATA_INSTANCE0_AC3)
#define MAX_INSTANCE_POS3D              (KDATA_INSTANCE_POS3D_ENDMARK - KDATA_INSTANCE0_POS3D)
#define MAX_INSTANCE_SPKVIRT            (KDATA_INSTANCE_SPKVIRT_ENDMARK - KDATA_INSTANCE0_SPKVIRT)
#define MAX_INSTANCE_SRC                (KDATA_INSTANCE_SRC_ENDMARK - KDATA_INSTANCE0_SRC)

#define MAX_VIRTUAL_DMA_CHANNELS        (KDATA_DMA_XFER_ENDMARK - KDATA_DMA_XFER0)
#define MAX_VIRTUAL_PIO_CHANNELS        (KDATA_PIO_XFER_ENDMARK - KDATA_PIO_XFER0)

#define MAX_VIRTUAL_DAC_CHANNELS        (KDATA_DAC_XFER_ENDMARK - KDATA_DAC_XFER0)
#define MAX_VIRTUAL_ADC_CHANNELS        (KDATA_ADC_XFER_ENDMARK - KDATA_ADC_XFER0)


//
// Hardware instance flags
//

#define HWI_FLAG_UNLOADED               0x00000001
#define HWI_FLAG_I2S_SECONDPASS         0x00000002
#define HWI_FLAG_FM_LOADED              0x00000004
#define HWI_FLAG_SUSPENDED              0x00000008


//
// Client input/output buffer connectivity
//

#define KCONNECT_NONE                   0
#define KCONNECT_INTERNEL               1
#define KCONNECT_HOST                   2
#define KCONNECT_CODEC                  3


//
// Open/Close flags
//

#define KOPENCLOSE_SYNCHRONOUS          0x0001


//
// DSP timeout
//

#define DSP_TIMEOUT                     10000


//
// DMA transfer alteration flags
//

#define KALTER_AUTOREPEAT               0x0001
#define KALTER_POSITION                 0x0002


//
// DSP hardware
//

#define DSP_PORT_MEMORY_INDEX           0x80
#define DSP_PORT_MEMORY_TYPE            0x82
#define DSP_PORT_MEMORY_DATA            0x84
#define DSP_PORT_CONTROL_REG_B          0xA4

#define MEMTYPE_INTERNAL_CODE           0x0002
#define MEMTYPE_INTERNAL_DATA           0x0003
#define MEMTYPE_MASK                    0x0003

#define REGB_ENABLE_RESET               0x01
#define REGB_STOP_CLOCK                 0x10

#define DP_SHIFT_COUNT                  7

#define DMA_BLOCK_LENGTH                32


//
// kernel binary image storage
//

typedef struct tagKERNEL_BIN
{

   PWORD        pwBinCode ;
   DWORD        dwLengthCode ;

} KERNEL_BIN, *PKERNEL_BIN ;


//
// client binary image storage
//

typedef struct tagCLIENT_BIN
{

   DWORD        dwCodeAddress ;

   PWORD        pwBinVect ;
   PWORD        pwBinCode ;
   PWORD        pwBinData ;

   DWORD        dwLengthVect ;
   DWORD        dwLengthCode ;
   DWORD        dwLengthData ;

} CLIENT_BIN, *PCLIENT_BIN ;


//
// FM client binary image storage
//

typedef struct tagFMCLIENT_BIN
{

   DWORD        dwCodeAddress ;
   DWORD        dwData2Address ;

   PWORD        pwBinVect ;
   PWORD        pwBinCode ;
   PWORD        pwBinData ;
   PWORD        pwBinData2 ;

   DWORD        dwLengthVect ;
   DWORD        dwLengthCode ;
   DWORD        dwLengthData ;
   DWORD        dwLengthData2 ;

} FMCLIENT_BIN, *PFMCLIENT_BIN ;


//
// client
//

typedef struct tagCLIENT
{

   // kernel use only

   PCLIENT_BIN  pClient_Bin ;
   DWORD        dwReferenceCount ;
   DWORD        dwMaxReference ;
   DWORD        dwInstanceListArea ;
   DWORD        dwDspCodeNumUnits ;
   PBYTE        pbDspCodeMapPtr ;

   // client use

   DWORD        dwDspCodeClientArea ;

} CLIENT, *PCLIENT ;


//
// client instance
//

typedef struct tagCLIENT_INST
{

   // kernel use only

   DWORD        dwClient ;
   DWORD        dwHostSrcBufferAddr ;
   DWORD        dwHostSrcBufferLen ;
   DWORD        dwHostDstBufferAddr ;
   DWORD        dwHostDstBufferLen ;
   DWORD        dwHostDstCurrent ;
   DWORD        dwDSPOutBufferAddr ;
   DWORD        dwDSPOutBufferLen ;
   DWORD        dwDSPInConnection ;
   DWORD        dwDSPOutConnection ;
   DWORD        dwDspDataNumUnits ;
   PBYTE        pbDspDataMapPtr ;

   // client use

   DWORD        dwDspDataClientArea ;
   DWORD        dwDspCodeClientArea ;

} CLIENT_INST, *PCLIENT_INST ;


//
// Hardware instance
//

typedef struct tagHWI
{

   DWORD        dwBaseIO ;
   DWORD        dwFlags ;

   PWORD        pwSuspendBuffer ;

   DWORD        dwI2SRateLast ;
   DWORD        dwI2SDeltaCounter ;
   DWORD        dwI2SDeltaSum ;

   // client table

   CLIENT       asClientTable[ NUMBER_OF_CLIENTS ] ;

   // resource lists

   WORD         awTaskList            [ MAX_TASKS + 1 ] ;

   WORD         awInstanceAC3List     [ MAX_INSTANCE_AC3 + 1 ] ;
   WORD         awInstancePos3DList   [ MAX_INSTANCE_POS3D + 1 ] ;
   WORD         awInstanceSpkVirtList [ MAX_INSTANCE_SPKVIRT + 1 ] ;
   WORD         awInstanceSRCList     [ MAX_INSTANCE_SRC + 1 ] ;

   WORD         awVirtualDMAList      [ MAX_VIRTUAL_DMA_CHANNELS + 1 ] ;
   WORD         awVirtualPIOList      [ MAX_VIRTUAL_PIO_CHANNELS + 1 ] ;

   WORD         awVirtualDACList      [ MAX_VIRTUAL_DAC_CHANNELS + 1 ] ;
   WORD         awVirtualADCList      [ MAX_VIRTUAL_ADC_CHANNELS + 1 ] ;

   // memory maps

   BYTE         abCodeMemoryMap[ (CODE_MEMORY_LENGTH / CODE_MEMORY_UNIT_LENGTH) + 1 ] ;
   BYTE         abDataMemoryMap[ (DATA_MEMORY_LENGTH / DATA_MEMORY_UNIT_LENGTH) + 1 ] ;

} HWI, *PHWI ;


//
// function return codes
//

typedef DWORD   KRETURN ;

#define KRETURN_SUCCESS                 0
#define KRETURN_ERROR_GENERIC           1
#define KRETURN_ERROR_BUSY              2
#define KRETURN_ERROR_UNLOADED          3


//
// external function prototypes
//

WORD kDspReadWord
(
   DWORD        dwBaseIO,
   DWORD        dwMemType,
   DWORD        dwMemAddr
) ;

VOID kDspWriteWord
(
   DWORD        dwBaseIO,
   DWORD        dwMemType,
   DWORD        dwMemAddr,
   WORD         wMemData
) ;

VOID kDspReadWords
(
   DWORD        dwBaseIO,
   DWORD        dwMemType,
   DWORD        dwMemAddr,
   DWORD        dwMemLen,
   PWORD        pwHostAddr
) ;

VOID kDspWriteWords
(
   DWORD        dwBaseIO,
   DWORD        dwMemType,
   DWORD        dwMemAddr,
   DWORD        dwMemLen,
   PWORD        pwHostAddr
) ;

VOID kDspWriteZeros
(
   DWORD        dwBaseIO,
   DWORD        dwMemType,
   DWORD        dwMemAddr,
   DWORD        dwMemLen
) ;

VOID kPIOInterruptHandler
(
   PCLIENT_INST pClient_Inst
) ;

void kI2SInterruptHandler
(
   PDWORD       pdwI2SRate
) ;

KRETURN kQueryPosition
(
   PCLIENT_INST pClient_Inst,
   DWORD        dwQueryOutput,
   PDWORD       pdwPosition
) ;

KRETURN kResetApuBlockCount
(
   PCLIENT_INST pClient_Inst
) ;

KRETURN kGetApuBlockCount
(
   PCLIENT_INST pClient_Inst,
   PDWORD       pdwBlockCount
) ;

KRETURN kInitKernel
(
   DWORD        dwBaseIO
) ;

KRETURN kTermKernel
(
   DWORD        dwBaseIO
) ;

KRETURN kSuspendKernel
(
) ;

KRETURN kResumeKernel
(
) ;

KRETURN kOpenInstance
(
   DWORD        dwClient,
   DWORD        dwFlags,
   DWORD        dwLen,
   PCLIENT_INST *ppClient_Inst
) ;

KRETURN kCloseInstance
(
   PCLIENT_INST pClient_Inst,
   DWORD        dwFlags
) ;

KRETURN kSetInstanceReady
(
   PCLIENT_INST pClient_Inst
) ;

KRETURN kSetInstanceNotReady
(
   PCLIENT_INST pClient_Inst
) ;

KRETURN kStartTransfer
(
   PCLIENT_INST pClient_Inst,
   DWORD        dwAutoRepeat,
   DWORD        dwHostSrcBufferAddr,
   DWORD        dwHostSrcBufferLen,
   DWORD        dwHostDstBufferAddr,
   DWORD        dwHostDstBufferLen,
   DWORD        dwDSPInBufferAddr,
   DWORD        dwDSPInBufferLen,
   DWORD        dwDSPOutBufferAddr,
   DWORD        dwDSPOutBufferLen,
   DWORD        dwDSPInConnection,
   DWORD        dwDSPOutConnection
) ;

KRETURN kStopTransfer
(
   PCLIENT_INST pClient_Inst
) ;

KRETURN kAlterTransfer
(
   PCLIENT_INST pClient_Inst,
   DWORD        dwFlags,
   DWORD        dwAutoRepeat,
   DWORD        dwPosition
) ;

KRETURN kQueryIdle
(
   PDWORD       pdwIdle
) ;

KRETURN kSetTimer
(
   DWORD        dwTimeInterval
) ;

//
// external data declarations
//

extern KERNEL_BIN gsKernelVectCode ;

extern CLIENT_BIN gasAC3VectCode[] ;
extern CLIENT_BIN gasPos3DVectCode[] ;
extern CLIENT_BIN gasSpkVirtVectCode[] ;
extern CLIENT_BIN gasSpkVirtVectCode_CRL[] ;
extern CLIENT_BIN gasSRCVectCode[] ;

extern FMCLIENT_BIN gsFMVectCode ;

//
// critical enter/leave
//

#define CRITENTER       _asm pushfd \
                        _asm cli

#define CRITLEAVE       _asm popfd

//---------------------------------------------------------------------------
//  End of File: kernel.h
//---------------------------------------------------------------------------

/******************************************************************************
 *                                                                            *
 *                       (C) 1997-1997 ESS Technology, Inc.                   *
 *                                                                            *
 ******************************************************************************/
