.MODEL	SMALL,C
.386P

.CODE

    PUBLIC  C dwSetBit
    PUBLIC  C dwMskBit
    PUBLIC  C dwTstBit

	PUBLIC	C outpd
	PUBLIC	C inpd
    PUBLIC  C vWrConfByte
    PUBLIC  C bRdConfByte
    PUBLIC  C vWrConfWord
    PUBLIC  C wRdConfWord


;******************************************************************************
;*                                                                            *
;*                                                                            *
;******************************************************************************
dwSetBit    PROC    FAR C, _a:DWORD, _b:BYTE

            MOV     EAX, 00000001h
            MOV     CL, [_b]
            SHL     EAX, CL

            MOV     EDX, [_a]
            OR      EAX, EDX

            MOV     EDX, EAX
            SHR     EDX, 10h

            POP     BP
            RETF

dwSetBit    ENDP

;******************************************************************************
;*                                                                            *
;*                                                                            *
;******************************************************************************
dwMskBit    PROC    FAR C, _a:DWORD, _b:BYTE

            MOV     EAX, 00000001h
            MOV     CL, [_b]
            SHL     EAX, CL

            NOT     EAX

            MOV     EDX, [_a]
            AND     EAX, EDX

            MOV     EDX, EAX
            SHR     EDX, 10h

            POP     BP
            RETF

dwMskBit    ENDP

;******************************************************************************
;*                                                                            *
;*                                                                            *
;******************************************************************************
dwTstBit    PROC    FAR C, _a:DWORD, _b:BYTE

            MOV     EAX, 00000001h
            MOV     CL, [_b]
            SHL     EAX, CL

            NOT     EAX

            MOV     EDX, [_a]
            AND     EAX, EDX

            MOV     EDX, EAX
            SHR     EDX, 10h

            POP     BP
            RETF

dwTstBit    ENDP

;******************************************************************************
;*                                                                            *
;*                                                                            *
;******************************************************************************

;******************************************************************************
;*                                                                            *
;*                                                                            *
;******************************************************************************
outpd		PROC	FAR	C ,_wRegIndex:WORD, _dwRegData:DWORD

            mov     DX, [_wRegIndex]
            mov     EAX, [_dwRegData]
			OUT		DX, EAX

			POP		BP
			RETF
			
outpd		ENDP

;******************************************************************************
;*                                                                            *
;*                                                                            *
;******************************************************************************
inpd		PROC	FAR C ,_wRegIndex:WORD

            MOV     DX, [_wRegIndex]
			IN		EAX, DX
			
            MOV     EDX, EAX
			SHR		EDX, 10h
			
			POP		BP
			
			RETF
			
inpd		ENDP


;******************************************************************************
;*                                                                            *
;*                                                                            *
;******************************************************************************
vWrConfByte PROC    FAR C, _wDevFuncNum:WORD, _wRegIndex:WORD, _bRegData:BYTE

            push    di
            push    cx
            push    bx

            mov     ax, 0B10Bh
            mov     bx, [_wDevFuncNum]
            mov     di, [_wRegIndex]
            mov     cl, [_bRegData]
            int     1Ah
            jnc     vWrConfByte1
            xchg    al, ah              ;Error code in al
vWrConfByte1:

            pop     bx
            pop     cx
            pop     di

            pop     bp
            retf

vWrConfByte ENDP

;******************************************************************************
;*                                                                            *
;*                                                                            *
;******************************************************************************
bRdConfByte PROC    FAR C, _wDevFuncNum:WORD, _wRegIndex:WORD

            push    di
            push    cx
            push    bx

            mov     ax, 0B108h
            mov     bx, [_wDevFuncNum]
            mov     di, [_wRegIndex]
            int     1Ah
            jc      bRdConfByte1        ;Error

            mov     al, cl
            jmp     bRdConfByte2
bRdConfByte1:
            xchg    al, ah

bRdConfByte2:
            pop     bx
            pop     cx
            pop     di

            pop     bp
            retf

bRdConfByte ENDP

;******************************************************************************
;*                                                                            *
;*                                                                            *
;******************************************************************************
vWrConfWord PROC    FAR C, _wDevFuncNum:WORD, _wRegIndex:WORD, _wRegData:WORD

            push    di
            push    cx
            push    bx

            mov     ax, 0B10Ch
            mov     bx, [_wDevFuncNum]
            mov     di, [_wRegIndex]
            mov     cx, [_wRegData]
            int     1Ah
            jnc     vWrConfWord1
            xchg    al, ah              ;Error code in al

vWrConfWord1:

            pop     bx
            pop     cx
            pop     di

            pop     bp
            retf

vWrConfWord ENDP

;******************************************************************************
;*                                                                            *
;*                                                                            *
;******************************************************************************
wRdConfWord PROC    FAR C, _wDevFuncNum:WORD, _wRegIndex:WORD

            push    di
            push    cx
            push    bx

            mov     ax, 0B109h
            mov     bx, [_wDevFuncNum]
            mov     di, [_wRegIndex]
            int     1Ah
            jc      wRdConfByte1        ;Error
            mov     ax, cx
            jmp     wRdConfByte2
wRdConfByte1:
            xchg    al, ah

wRdConfByte2:

            pop     bx
            pop     cx
            pop     di

            pop     bp
            retf

wRdConfWord ENDP

;******************************************************************************
;*                                                                            *
;*                                                                            *
;******************************************************************************
vWrConfDWord PROC    FAR C, _wDevFuncNum:WORD, _wRegIndex:WORD, _dwRegData:DWORD

            push    di
            push    cx
            push    bx

            mov     ax,  0B10Dh
            mov     bx,  [_wDevFuncNum]
            mov     di,  [_wRegIndex]
            mov     ecx, [_dwRegData]
            int     1Ah
            jnc     vWrConfDWord1
            xchg    al, ah              ;Error code in al


vWrConfDWord1:

            pop     bx
            pop     cx
            pop     di

            pop     bp
            retf

vWrConfDWord ENDP

;******************************************************************************
;*                                                                            *
;*                                                                            *
;******************************************************************************
dwRdConfDWord PROC    FAR C, _wDevFuncNum:WORD, _wRegIndex:WORD

            push    di
            push    cx
            push    bx

            mov     ax,  0B10Ah
            mov     bx,  [_wDevFuncNum]
            mov     di,  [_wRegIndex]
            int     1Ah
            jc      dwRdConfDWord1        ;Error
            mov     ax, cx
            mov     edx, ecx
            shr     edx, 10h

            jmp     dwRdConfDWord2
dwRdConfDWord1:
            xchg    al, ah

dwRdConfDWord2:

            pop     bx
            pop     cx
            pop     di

            pop     bp
            retf

dwRdConfDWord ENDP

            END

            END

