#include    <stdio.h>
#include    <stdlib.h>
#include    <io.h>
#include    <dos.h>
#include	<conio.h>

#include    "sbtype.h"
#include    "ic8259.h"

WORD	wOldPIC1Msk[ 0xFF ],
		wOldPIC2Msk[ 0xFF ],
		wNewPIC1Msk[ 0xFF ],
		wNewPIC2Msk[ 0xFF ];

BYTE	bIRQTestFlag[ 0xFF ];

void (__cdecl __interrupt __far *lpOldIRQHandler[ 0xFF ])();

WORD	_irq_VECT[16]	=	{	0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77	};
WORD	_irq_MMSK[16]   =   {   0xFE, 0xFD, 0xFB, 0xF7, 0xEF, 0xDF, 0xBF, 0x7F, 0xFB, 0xFB, 0xFB, 0xFB, 0xFB, 0xFB, 0xFB, 0xFB  };
WORD	_irq_SMSK[16]   =   {   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFD, 0xFB, 0xF7, 0xEF, 0xDF, 0xBF, 0x7F  };


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wGetISR( void )
	{
	WORD	wISR;
	
    outp( 0x20, 0x0A );
	
    outp( 0xA0, 0x0A );
    wISR = (WORD)( ( inp( 0xA0 ) << 8 ) | inp( 0x20 ) );
	
	return( wISR );
	}

/*****************************************************************************/
/* vInstallISR - Install User Defined Interrupt-Service-Routine              */
/*                                                                           */
/*****************************************************************************/
void vInstallISR( BYTE _bIRQ, void (__cdecl __interrupt __far *_vISRPtr)( void ))
	{
	_disable();

	lpOldIRQHandler[ _bIRQ ] = _dos_getvect( _irq_VECT[ _bIRQ ] );

	_dos_setvect( _irq_VECT[ _bIRQ ], _vISRPtr );

    wOldPIC1Msk[0] = inp( 0x21 );
    wOldPIC2Msk[0] = inp( 0xA1 );

    outp( 0x21, inp( 0x21 ) & _irq_MMSK[_bIRQ] );
    outp( 0xA1, inp( 0xA1 ) & _irq_SMSK[_bIRQ] );

    outp( 0x20, 0x20 );
    outp( 0xA0, 0x20 );

	_enable();
	}


/*****************************************************************************/
/* vRemoveISR - Remove User Defined Interrupt-Service-Routine                */
/*                                                                           */
/*****************************************************************************/
void vRemoveISR( BYTE _bIRQ )
	{
	_disable();

    outp( 0x21, inp( 0x21 ) | (~_irq_MMSK[_bIRQ] ) );
    outp( 0xA1, inp( 0xA1 ) | (~_irq_SMSK[_bIRQ] ) );

    outp( 0x21, wOldPIC1Msk[0] );
    outp( 0xA1, wOldPIC2Msk[0] );

    _dos_setvect( _irq_VECT[_bIRQ], lpOldIRQHandler[_bIRQ] );

	outp( 0x20, 0x20 );
	outp( 0xA0, 0x20 );

	_enable();
	}



