#define	_DMA_CHANNEL0		0x00
#define	_DMA_CHANNEL1		0x01
#define	_DMA_CHANNEL2		0x02
#define	_DMA_CHANNEL3		0x03

#define	_DMA_CHANNEL4		0x00
#define	_DMA_CHANNEL5		0x01
#define	_DMA_CHANNEL6		0x02
#define	_DMA_CHANNEL7		0x03
                
/*****************************************************************************/
/* DMA Transfer Types                                                        */
/*****************************************************************************/
#define	_DMA_VERIFY		0x00
#define	_DMA_WRITE		0x04
#define	_DMA_READ		0x08

/*****************************************************************************/
/* DMA Transfer Types                                                        */
/*****************************************************************************/
#define	_DMA_NON_AI		0x00
#define	_DMA_AI			0x10

/*****************************************************************************/
/* DMA Direction Flags                                                       */
/*****************************************************************************/
#define	_DMA_DEC		0x20
#define	_DMA_INC		0x00

/*****************************************************************************/
/* DMA Transfer Modes                                                        */
/*****************************************************************************/
#define	_DMA_DEMAND		0x00
#define	_DMA_SINGLE		0x40
#define	_DMA_BLOCK		0x80
#define	_DMA_CASCADE	0xC0


extern	WORD    abDMACommandReg[];
extern	WORD    abDMAAddrFlipFlopReg[8];
extern	WORD    abDMAPageReg[8];
extern	WORD    abDMABufferSizeReg[8];
extern	WORD    abDMAAddressReg[8];
extern	WORD    abDMAModeReg[8];
extern	WORD    abDMATerminalCountReg[8];
extern	WORD    abDMASingleBitMaskReg[8];


/*****************************************************************************/
/* Function Declarations                                                     */
/*****************************************************************************/
void	vClrDMAFlipFlop( BYTE _bDMAChannel );

void	vMskDMAChannel( BYTE _bDMAChannel );
void	vClrDMAChannel( BYTE _bDMAChannel );

void	vSetDMAPage( BYTE _bDMAChannel, BYTE _bMemPage );
BYTE	bGetDMAPage( BYTE _bDMAChannel );

void	vSetDMAAddress( BYTE _bDMAChannel, LPBYTE _lpBufferPtr );
LPBYTE	lpGetDMAAddress( BYTE _bDMAChannel, LPBYTE *_lpBufferPtr );

void	vSetDMABufferSize( BYTE _bDMAChannel, WORD _wBufferSize );
BYTE	bGetDMABufferSize( BYTE _bDMAChannel );

void	vSetDMAMode( BYTE _bDMAChannel, BYTE _bModeFlags );

void	vSetDMATransfer( BYTE _bDMAChannel, LPBYTE _lpBufferPtr, WORD _wBufferSize, BYTE _bModeFlags );

BYTE	bGetDMARequestPending( void );
BYTE	bGetDMATerminalCount( void );

