#include    <stdio.h>
#include    <stdlib.h>
#include    <io.h>
#include    <dos.h>
#include	<conio.h>

#include	"sbtype.h"
#include    "sbmem.h"
#include	"sbscreen.h"
#include    "ic8237.h"

WORD    abDMACommandReg[8]			=   {   0x08, 0x08, 0x08, 0x08, 0xD0, 0xD0, 0xD0, 0xD0  };
WORD    abDMAAddrFlipFlopReg[8]		=   {   0x0C, 0x0C, 0x0C, 0x0C, 0xD8, 0xD8, 0xD8, 0xD8  };
WORD    abDMAPageReg[8]				=   {   0x87, 0x83, 0x81, 0x82, 0x8F, 0x8B, 0x89, 0x8A  };
WORD    abDMABufferSizeReg[8]		=   {   0x01, 0x03, 0x05, 0x07, 0xC2, 0xC6, 0xCA, 0xCE  };
WORD    abDMAAddressReg[8]			=   {   0x00, 0x02, 0x04, 0x06, 0xC0, 0xC4, 0xC8, 0xCC  };
WORD    abDMAModeReg[8]				=   {   0x0B, 0x0B, 0x0B, 0x0B, 0xD6, 0xD6, 0xD6, 0xD6  };
WORD    abDMATerminalCountReg[8]	=   {   0x08, 0x08, 0x08, 0x08, 0xD0, 0xD0, 0xD0, 0xD0  };
WORD    abDMASingleBitMaskReg[8]	=   {   0x0A, 0x0A, 0x0A, 0x0A, 0xD4, 0xD4, 0xD4, 0xD4  };


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vClrDMAFlipFlop( BYTE _bDMAChannel )
	{
	outp( abDMAAddrFlipFlopReg[ _bDMAChannel ], 0x00 );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vMskDMAChannel( BYTE _bDMAChannel )
	{
    vDisplayDebugMessage("vMskDMAChannel = Channel:%02X\n", _bDMAChannel );

	outp( abDMASingleBitMaskReg[ _bDMAChannel ], 0x04 | ( _bDMAChannel & 0x03 ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vClrDMAChannel( BYTE _bDMAChannel )
	{
    vDisplayDebugMessage("vClrDMAChannel = Channel:%02X\n", _bDMAChannel );

	outp( abDMASingleBitMaskReg[ _bDMAChannel ], ( _bDMAChannel & 0x03 ) );
	}
	
/*****************************************************************************/
/* vSetDMAMode - Set DMA Transfer Mode                                       */
/*                                                                           */
/*****************************************************************************/
void	vSetDMAMode( BYTE _bDMAChannel, BYTE _bModeFlags )
	{
    vDisplayDebugMessage("vSetDMAMode = Channel:%02X ModeFlags:%02X\n", _bDMAChannel, _bModeFlags );

	outp( abDMAModeReg[ _bDMAChannel ], _bModeFlags | ( _bDMAChannel & 0x03 ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetDMAPage( BYTE _bDMAChannel, BYTE _bMemPage )
	{
    vDisplayDebugMessage("vSetDMAPage = Channel:%02X Page:%02X\n", _bDMAChannel, _bMemPage );

	outp( abDMAPageReg[ _bDMAChannel ], _bMemPage );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetDMAPage( BYTE _bDMAChannel )
	{
    vDisplayDebugMessage("vGetDMAPage = Channel:%02X\n", _bDMAChannel );

	return( (BYTE) inp( abDMAPageReg[ _bDMAChannel ] ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetDMAAddress( BYTE _bDMAChannel, LPBYTE _lpBufferPtr )
	{
	WORD	wTmpSeg,
			wTmpOff;
	
    vDisplayDebugMessage("vSetDMAOffset = Channel:%02X Address:%04X:%04X\n", _bDMAChannel, _FP_SEG( _lpBufferPtr ), _FP_OFF( _lpBufferPtr ) );;

	vClrDMAFlipFlop( _bDMAChannel );

	wTmpSeg = (WORD)_FP_SEG( _lpBufferPtr );
	wTmpOff = (WORD)_FP_OFF( _lpBufferPtr );
	
	wTmpOff += ( wTmpSeg << 4 );
	
	if( _bDMAChannel > 4 )
		{
		wTmpOff = wTmpOff >> 1;
		}
		
	wTmpOff &= 0x0FFFFL;
			
	vClrDMAFlipFlop( _bDMAChannel );

	outp( abDMAAddressReg[ _bDMAChannel ], LOBYTE( wTmpOff ) );
	outp( abDMAAddressReg[ _bDMAChannel ], HIBYTE( wTmpOff ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
LPBYTE	lpGetDMAAddress( BYTE _bDMAChannel, LPBYTE *_lpBufferPtr )
	{
	WORD	wTmpSeg,
			wTmpOff;
	
    vDisplayDebugMessage("vGetDMAOffset = Channel:%02X\n", _bDMAChannel );

	vClrDMAFlipFlop( _bDMAChannel );

    wTmpOff = (WORD) ( inp( abDMAAddressReg[ _bDMAChannel ] ) + ( inp( abDMAAddressReg[ _bDMAChannel ] ) << 8 ) );
    wTmpSeg = (BYTE)inp( abDMAPageReg[ _bDMAChannel ] );
	
	*_lpBufferPtr = _MK_FP( wTmpSeg, wTmpOff );
	return( *_lpBufferPtr );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetDMABufferSize( BYTE _bDMAChannel, WORD _wBufferSize )
	{
    vDisplayDebugMessage("vSetDMABufferSize = Channel:%02X Size:%04X\n", _bDMAChannel, _wBufferSize );
	vClrDMAFlipFlop( _bDMAChannel );
    
	
	outp( abDMABufferSizeReg[ _bDMAChannel ], LOBYTE( _wBufferSize ) );
	outp( abDMABufferSizeReg[ _bDMAChannel ], HIBYTE( _wBufferSize ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wGetDMABufferSize( BYTE _bDMAChannel )
	{
    vDisplayDebugMessage("wGetDMABufferSize = Channel:%02X\n", _bDMAChannel );

	vClrDMAFlipFlop( _bDMAChannel );

	return( (WORD) ( inp( abDMABufferSizeReg[ _bDMAChannel ] ) + ( inp( abDMABufferSizeReg[ _bDMAChannel ] << 8 ) ) ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetDMATransfer( BYTE _bDMAChannel, LPBYTE _lpBufferPtr, WORD _wBufferSize, BYTE _bModeFlags )
	{
	vMskDMAChannel( _bDMAChannel );

	vSetDMAAddress( _bDMAChannel, _lpBufferPtr );
	
	vSetDMAPage( _bDMAChannel, bGetPage( _lpBufferPtr ) );

    if( _bDMAChannel > 4 )
    	{
    	_wBufferSize = ( ( _wBufferSize + 1 ) >> 1 );
    	}

	vSetDMABufferSize( _bDMAChannel, _wBufferSize - 1 );

	vSetDMAMode( _bDMAChannel, _bModeFlags );

	vClrDMAChannel( _bDMAChannel );
	}


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetDMARequestPending( void )
	{
	return( (BYTE) ( ( inp( abDMATerminalCountReg[ 4 ] ) & 0xF0 ) | ( inp( abDMATerminalCountReg[ 4 ] ) & 0xF0 ) >> 4 ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetDMATerminalCount( void )
	{
	return( (BYTE)( ( ( inp( abDMATerminalCountReg[ 4 ] ) & 0x0F ) << 4 ) | ( inp( abDMATerminalCountReg[ 0 ] ) ) & 0x0F ) );
	}

