#include	<stdio.h>
#include	<stdlib.h>

#include	"sbtype.h"
#include	"ptconfig.h"

#include	"wp.h"
#include	"cram.h"

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetCRamInc( int _iCRamInc )
	{
    vWrIDR( IDR2_CRAM_INCREMENT, (WORD)(_iCRamInc ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wGetCRamInc( void )
	{
	return( wRdIDR( IDR2_CRAM_INCREMENT ) );
	}
		
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vWrCRamIndex( WORD _wRegIndex )
	{
	vWrIDR( IDR1_CRAM_POINTER, _wRegIndex );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wRdCRamIndex( void )
	{
	return( wRdIDR( IDR1_CRAM_POINTER ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vWrCRamData( WORD _wRegData )
	{
	vWrIDR( IDR0_DATA_PORT, _wRegData );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wRdCRamData( void )
	{
	return( wRdIDR( IDR0_DATA_PORT ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vWrCRam( WORD _wRegIndex, WORD _wRegData )
	{
	vWrCRamIndex( _wRegIndex );
	vWrCRamData( _wRegData );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wRdCRam( WORD _wRegIndex )
	{
	vWrCRamIndex( _wRegIndex );
	return( wRdCRamData() );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetCRamBit( WORD _wRegIndex, BYTE _bRegBit )
	{
	vWrCRam( _wRegIndex, WSETBIT( wRdCRam( _wRegIndex ), _bRegBit ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vMskCRamBit( WORD _wRegIndex, BYTE _bRegBit )
	{
	vWrCRam( _wRegIndex, WMSKBIT( wRdCRam( _wRegIndex ), _bRegBit ) );
	}	
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bTstCRamBit( WORD _wRegIndex, BYTE _bRegBit )
	{
	return( (BYTE)( WTSTBIT( wRdCRam( _wRegIndex ), _bRegBit ) ) );
	}	
	
	
