#include    <stdio.h>
#include	<stdlib.h>
#include	<conio.h>

#include	"sbtype.h"
#include    "sbdelay.h"

#include    "io32bit.h"
#include    "ptconfig.h"
#include    "ac97.h"
#include    "pt101.h"

#include    "codec.h"

#define IO_PT_CODEC_CMD     ( gwPTBaseIO + 0x30 )
#define IO_PT_CODEC_STATUS  ( gwPTBaseIO + 0x30 )
#define IO_PT_CODEC_DATA    ( gwPTBaseIO + 0x32 )
#define IO_PT_CODEC_FORMATA  ( gwPTBaseIO + 0x34 )
#define IO_PT_CODEC_FORMATB  ( gwPTBaseIO + 0x36 )


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetCRegRWStatus( void )
    {
    return( (BYTE)( ( ( inp( IO_PT_CODEC_STATUS ) & 0x01 ) == 0x01 ) ? TRUE : FALSE ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vWrCRegIndex( BYTE _bRegIndex )
	{
    outpw( IO_PT_CODEC_CMD, (WORD)_bRegIndex );
    }
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bRdCRegIndex( void )
	{
    return( (BYTE)inp( IO_PT_CODEC_CMD ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vWrCRegData( WORD _wRegData )
	{
    outpw( IO_PT_CODEC_DATA, _wRegData );
    }
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wRdCRegData( void )
	{
    return( (WORD)inpw( IO_PT_CODEC_DATA ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vWrCReg( BYTE _bRegIndex, WORD _wRegData )
	{
    WORD	wTimeout = _CODEC_RW_TIMEOUT;
    
    while( bGetCRegRWStatus() == TRUE )
        {
        vDisplayDebugMessage( "Waiting for Codec Read\n" );
        }

    vWrCRegData( _wRegData );

    while( --wTimeout );

    vWrCRegIndex( _bRegIndex );
    }
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wRdCReg( BYTE _bRegIndex )
	{
    WORD	wTimeout = _CODEC_RW_TIMEOUT;

    while( bGetCRegRWStatus() == TRUE )
        {
        vDisplayDebugMessage( "Waiting for Codec Write\n" );
        }

    vWrCRegIndex( (BYTE)( _bRegIndex | 0x80 ) );

    while( --wTimeout );

    return( wRdCRegData( ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetCRegBit( BYTE _bRegIndex, BYTE _bRegBit )
    {
    vWrCReg( _bRegIndex, WSETBIT( wRdCReg( _bRegIndex ), _bRegBit ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vMskCRegBit( BYTE _bRegIndex, BYTE _bRegBit )
    {
    vWrCReg( _bRegIndex, WMSKBIT( wRdCReg( _bRegIndex ), _bRegBit ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bTstCRegBit( BYTE _bRegIndex, BYTE _bRegBit )
    {
    return( (BYTE)( WTSTBIT( wRdCReg( _bRegIndex ), _bRegBit ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vWrDCReg( DWORD _dwRegData )
    {
    outpd( IO_PT_CODEC_FORMATA, _dwRegData );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
DWORD dwRdDCReg( void )
    {
    return( inpd( IO_PT_CODEC_FORMATA ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDCRegBit( BYTE _bRegBit )
    {
    vWrDCReg( (DWORD)( DWSETBIT( dwRdDCReg(), _bRegBit ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vMskDCRegBit( BYTE _bRegBit )
    {
    vWrDCReg( (DWORD)( DWSETBIT( dwRdDCReg(), _bRegBit ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bTstDCRegBit( BYTE _bRegBit )
    {
    return( (BYTE)( DWTSTBIT( dwRdDCReg(), _bRegBit ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDCRingBusEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskDCRegBit( 29 );
            break;

        case ENABLE:
            vSetDCRegBit( 29 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDCRingBusEnable( void )
    {
    return( bTstDCRegBit( 29 ) );
    }


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDCSerialBusEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskDCRegBit( 28 );
            break;

        case ENABLE:
            vSetDCRegBit( 28 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDCSerialBusEnable( void )
    {
    return( bTstDCRegBit( 28 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vResetCodec( void )
    {
    outpw(gwPTBaseIO + 0x36, 0x2000 );
//    vSetDCRegBit( 20 );

    vDelay( _CODEC_RST_TIMEOUT );

    outpw(gwPTBaseIO + 0x36, 0x0000 );
//    vMskDCRegBit( 20 );

    vDelay( _CODEC_RST_TIMEOUT );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDCMicFormat( BYTE _bDCFormat )
    {
    vWrDCReg( (DWORD)( ( dwRdDCReg() & 0xFF0FFFFF ) | ( (DWORD)( _bDCFormat ) << 20 ) ) );
    }
        
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDCMicFormat( void )
    {
    return( (BYTE)( ( dwRdDCReg() & 0x00F00000 ) >> 20 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDCI2SFormat( BYTE _bDCFormat )
    {
    vWrDCReg( (DWORD)( ( dwRdDCReg() & 0xFFF0FFFF ) | ( (DWORD)( _bDCFormat ) << 16 ) ) );
    }
        
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDCI2SFormat( void )
    {
    return( (BYTE)( ( dwRdDCReg() & 0x000F0000 ) >> 16 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDCI2SEnable( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskDCRegBit( 31 );
            break;

        case ENABLE:
            vSetDCRegBit( 31 );
            break;
        }
    }
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDCADCLFormat( BYTE _bDCFormat )
    {
    vWrDCReg( (DWORD)( ( dwRdDCReg() & 0xFFFF0FFF ) | ( (DWORD)( _bDCFormat ) << 12 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDCADCLFormat( void )
    {
    return( (BYTE)( ( dwRdDCReg() & 0x0000F000 ) >> 12 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDCModemFormat( BYTE _bDCFormat )
    {
    vWrDCReg( (DWORD)( ( dwRdDCReg() & 0xFFFFF0FF ) | ( (DWORD)( _bDCFormat ) << 8 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDCModemFormat( void )
    {
    return( (BYTE)( ( dwRdDCReg() & 0x00000F00 ) >> 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDCDirectSoundFormat( BYTE _bDCFormat )
    {
    vWrDCReg( (DWORD)( ( dwRdDCReg() & 0xFFFFFF0F ) | ( (DWORD)( _bDCFormat ) << 4 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDCDirectSoundFormat( void )
    {
    return( (BYTE)( ( dwRdDCReg() & 0x000000F0 ) >> 4 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetDCASSPFormat( BYTE _bDCFormat )
    {
    vWrDCReg( (DWORD)( ( dwRdDCReg() & 0xFFFFFFF0 ) | _bDCFormat ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetDCASSPFormat( void )
    {
    return( (BYTE)( dwRdDCReg() & 0x0000000F ) );
    }



/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetLineInVolume( BYTE _bLLevel, BYTE _bRLevel )
    {
    if( gwCodecType == _ID_PT101 )
        {
        if( _bLLevel > 0 )
            {
            vSetLineInLMute( DISABLE );
            vSetLineInLGain( _bLLevel );
            }
        else
            {
            vSetLineInLMute( ENABLE );
            vSetLineInLGain( _bLLevel );
            }

        if( _bRLevel > 0 )
            {
            vSetLineInRMute( DISABLE );
            vSetLineInRGain( _bRLevel );
            }
        else
            {
            vSetLineInRMute( ENABLE );
            vSetLineInRGain( _bRLevel );
            }
        }
    else
        {
        if( ( _bLLevel == 0x1F ) && ( _bRLevel == 0x1F ) )
            {
            vSetAC97LineInMute( ENABLE );
            }
        else
            {
            vSetAC97LineInMute( DISABLE );
            }

        vSetAC97LineInVolume( _bLLevel, _bRLevel );
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetLineInVolume( void )
	{
	WORD	wRetVal;
	
	if( gwCodecType == _ID_PT101 )
		{
		wRetVal = (WORD)( ( bGetLineInLGain() << 8 ) | bGetLineInRGain() );
		}
	else
		{
		wRetVal = wGetAC97LineInVolume();
		}	

	return( wRetVal );	
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetCDVolume( BYTE _bLLevel, BYTE _bRLevel )
	{
    if( gwCodecType == _ID_PT101 )
        {
            if( _bLLevel > 0 )
                {
                vSetAUX1LMute( DISABLE );
                }
            else
                {
                vSetAUX1LMute( ENABLE );
                }

            if( _bRLevel > 0 )
                {
                vSetAUX1RMute( DISABLE );
                }
            else
                {
                vSetAUX1RMute( ENABLE );
                }

        vSetAUX1Gain( _bLLevel, _bRLevel );
        }
    else
        {
        if( ( _bLLevel == 0 ) && ( _bRLevel == 0 ) )
            {
            vSetAC97CDMute( ENABLE );
            }
        else
            {
            vSetAC97CDMute( DISABLE );
            }

        vSetAC97CDVolume( _bLLevel, _bRLevel );
        }
    }   

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetCDVolume( void )
	{
	WORD	wRetVal;
	
	if( gwCodecType == _ID_PT101 )
		{
		wRetVal = (WORD)( ( bGetAUX1LGain() << 8 ) | bGetAUX1RGain() );
		}
	else
		{
		wRetVal = wGetAC97CDVolume();
		}	
		
	return( wRetVal );	
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetMicVolume( BYTE _bLLevel, BYTE _bRLevel )
	{
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetMicVolume( void )
	{
	}
	

