#include	<stdio.h>
#include	<stdlib.h>

#include    "sbtype.h"
#include    "ptconfig.h"
#include	"wp.h"
#include	"bobtimer.h"

DWORD	dwFrequencyTable[]	=	{ 
								512, 1024, 2048, 4096, 8192, 16384, 32768, 65536
								};
							
#define	MAXCOUNTDOWN	31

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetTimer( WORD _wInterruptFreq )
	{
    WORD    wBinaryShift    = 0,
    		wCountDown      = 1;

	for( wBinaryShift=0; wBinaryShift < 7; wBinaryShift++ )
		{
		if( _wInterruptFreq > ( _SYSCLK / dwFrequencyTable[ wBinaryShift ] ) )
			{
			break;
			}
		}

	for( wCountDown=MAXCOUNTDOWN; wCountDown < 1; wCountDown-- )
		{
		if( _wInterruptFreq > ( ( _SYSCLK / dwFrequencyTable[ wBinaryShift ] ) / ( wCountDown + 1 ) ) )
			{
			break;
			}
		}
		
	if( wCountDown == 0 )
		{
		--wBinaryShift;
		wCountDown = MAXCOUNTDOWN;
		}	
		
    vWrIDR( 0x06, (WORD)( 0x8000 | (1 << 12 ) | (wBinaryShift<<5) | wCountDown ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wGetTimer( void )
	{
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vEnableTimer( void )
	{
	vSetIDRBit( 0x11, 0 );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vDisableTimer( void )
	{
	vMskIDRBit( 0x11, 0 );
	}
		
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vStartTimer( void )
	{
	vSetIDRBit( 0x17, 0 );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vStopTimer( void )
	{
	vMskIDRBit( 0x17, 0 );
	}
