/* APU Modes */
#define	_APU_OFF			0x00
#define	_APU_16BITLINEAR	0x01	/* 16-Bit Linear Sample Player */
#define	_APU_16BITSTEREO	0x02	/* 16-Bit Stereo Sample Player */
#define	_APU_8BITLINEAR		0x03	/* 8-Bit Linear Sample Player */
#define	_APU_8BITSTEREO		0x04	/* 8-Bit Stereo Sample Player */
#define	_APU_8BITDIFF		0x05	/* 8-Bit Differential Sample Playrer */
#define	_APU_DIGITALDELAY	0x06	/* Digital Delay Line */
#define	_APU_DUALTAP		0x07	/* Dual Tap Reader */
#define	_APU_CORRELATOR		0x08	/* Correlator */
#define	_APU_INPUTMIXER		0x09	/* Input Mixer */
#define	_APU_WAVETABLE		0x0A	/* Wave Table Mode */
#define	_APU_SRCONVERTOR	0x0B	/* Sample Rate Convertor */
#define	_APU_16BITPINGPONG	0x0C	/* 16-Bit Ping-Pong Sample Player */

#define	_APU_RESERVED1		0x0D	/* Reserved 1 */
#define	_APU_RESERVED2		0x0E	/* Reserved 2 */
#define	_APU_RESERVED3		0x0F	/* Reserved 3 */

/* APU Filtey Q Control */
#define _APU_FILTER_LESSQ           0x00
#define _APU_FILTER_MOREQ           0x03

/* APU Filter Control */
#define	_APU_FILTER_2POLE_LOPASS	0x00
#define	_APU_FILTER_2POLE_BANDPASS	0x01
#define	_APU_FILTER_2POLE_HIPASS	0x02
#define	_APU_FILTER_1POLE_LOPASS	0x03
#define	_APU_FILTER_1POLE_HIPASS	0x04
#define	_APU_FILTER_OFF				0x05

/* Polar Pan Control */
#define	_APU_PAN_CENTER_CIRCLE		0x00
#define	_APU_PAN_MIDDLE_RADIUS		0x01
#define	_APU_PAN_OUTSIDE_RADIUS		0x02
#define	_APU_PAN_

/* APU ATFP Type */
#define	_APU_ATFP_AMPLITUDE			0x00
#define	_APU_ATFP_TREMELO			0x01
#define	_APU_ATFP_FILTER			0x02
#define	_APU_ATFP_PAN				0x03

/* APU ATFP Flags */
#define	_APU_ATFP_FLG_OFF			0x00
#define	_APU_ATFP_FLG_WAIT			0x01
#define	_APU_ATFP_FLG_DONE			0x02
#define	_APU_ATFP_FLG_INPROCESS		0x03

#define vSetAPUBalance( a, b )  vSetAPUPhase( a, b )
#define	bGetAPUBalance( a, b )	bGetAPUPhase( a, b )

void    vWrAPURegIndex( WORD _wRegIndex );
WORD    wRdAPURegIndex( void );

void    vWrAPURegData( WORD _wRegData );
WORD    wRdAPURegData( void );

void    vWrAPUReg( BYTE _bChannel, BYTE _bRegIndex, WORD _wRegData );
WORD    wRdAPUReg( BYTE _bChannel, BYTE _bRegIndex );

void    vSetAPURegBit( BYTE _bChannel, BYTE _bRegIndex, BYTE _bRegBit );
void    vMskAPURegBit( BYTE _bChannel, BYTE _bRegIndex, BYTE _bRegBit );
BYTE    bTstAPURegBit( BYTE _bChannel, BYTE _bRegIndex, BYTE _bRegBit );
void    vSetAPUType( BYTE _bChannel, BYTE _bType );

BYTE    bGetAPUType( BYTE _bChannel );

void	vSetAPUDMA( BYTE _bChannel, BYTE _bState );
BYTE	bGetAPUDMA( BYTE _bChannel );

void	vSetAPUEndCurve( BYTE _bChannel, BYTE _bState );
BYTE	bGetAPUEndCurve( BYTE _bChannel );

void	vSetAPUIntOnLoop( BYTE _bChannel, BYTE _bState );
BYTE	bGetAPUIntOnLoop( BYTE _bChannel );

void	vSetAPUDualEffectSend( BYTE _bChannel, BYTE _bState );
BYTE	bGetAPUDualEffectSend( BYTE _bChannel );

void    vSetAPUSubmixMode( BYTE _bChannel, BYTE _bState );
BYTE    bGetAPUSubmixMode( BYTE _bChannel );

void    vSetAPUInvertPolarityA( BYTE _bChannel, BYTE _bState );
BYTE	bGetAPUInvertPolarityA( BYTE _bChannel );

void    vSetAPUInvertPolarityB( BYTE _bChannel, BYTE _bState );
BYTE	bGetAPUInvertPolarityB( BYTE _bChannel );

void    vSetAPU6dB( BYTE _bChannel, BYTE _bState );
BYTE	bGetAPU6dB( BYTE _bChannel );

void    vSetAPUEffectChannels( BYTE _bChannel, BYTE _bEffectChannels );
BYTE    bGetAPUEffectChannels( BYTE _bChannel );

void    vSetAPUEnvelopeType( BYTE _bChannel, BYTE _bEnvelopeType );
BYTE    bGetAPUEnvelopeType( BYTE _bChannel );

void    vSetAPUEnvelopeState( BYTE _bChannel, BYTE _bState );
BYTE    bGetAPUEnvelopeState( BYTE _bChannel );

void    vSetAPUTremeloRate( BYTE _bChannel, BYTE _bTremeloRate );
BYTE    bGetAPUTremeloRate( BYTE _bChannel );

void    vSetAPUTremeloDepth( BYTE _bChannel, BYTE _bTremeloDepth );
BYTE    bGetAPUTremeloDepth( BYTE _bChannel );

void    vSetAPUFilterType( BYTE _bChannel, BYTE _bFilterType );
BYTE    bGetAPUFilterType( BYTE _bChannel );

void    vSetAPUFilterQ( BYTE _bChannel, BYTE _bFilterQ );
BYTE    bGetAPUFilterQ( BYTE _bChannel );

void    vSetAPUFilterTuning( BYTE _bChannel, BYTE _bFilterTuning );
BYTE    bGetAPUFilterTuning( BYTE _bChannel );

void    vSetAPUPhase( BYTE _bChannel, BYTE _bPhase );
BYTE    bGetAPUPhase( BYTE _bChannel );

void    vSetAPUSubmixGroup( BYTE _bChannel, BYTE _bSubmixGroup );
BYTE    bGetAPUSubmixGroup( BYTE _bChannel );

void    vSetAPUFrequency( BYTE _bChannel, DWORD _dwFrequency );
DWORD   dwGetAPUFrequency( BYTE _bChannel );

void    vSetAPUWave64kPage( BYTE _bChannel, BYTE _b64kPage );
BYTE    bGetAPUWave64kPage( BYTE _bChannel );

void    vSetAPUWaveStart( BYTE _bChannel, WORD _wWaveStart );
WORD    wGetAPUWaveStart( BYTE _bChannel );

void    vSetAPUWaveEnd( BYTE _bChannel, WORD _wWaveEnd );
WORD    wGetAPUWaveEnd( BYTE _bChannel );

void    vSetAPUWaveLoop( BYTE _bChannel, WORD _wWaveLoop );
WORD    wGetAPUWaveLoop( BYTE _bChannel );

void	vSetAPUWavePtr( BYTE _bChannel, DWORD _dwWaveStart, WORD _wWaveLength );
DWORD	dwGetAPUWavePtr( BYTE _bChannel );

void    vSetAPUVibratoRate( BYTE _bChannel, BYTE _bVibratoRate );
BYTE    bGetAPUVibratoRate( BYTE _bChannel );

void    vSetAPUVibratoDepth( BYTE _bChannel, BYTE _bVibratoDepth );
BYTE    bGetAPUVibratoDepth( BYTE _bChannel );

void    vSetAPUVibratoPhase( BYTE _bChannel, BYTE _bVibratoPhase );
BYTE    bGetAPUVibratoPhase( BYTE _bChannel );

void    vSetAPURadiusSelect( BYTE _bChannel, BYTE _bRadiusSelect );
BYTE    bGetAPURadiusSelect( BYTE _bChannel );

void    vSetAPUPolarPan( BYTE _bChannel, BYTE _bPolarPan );
BYTE    bGetAPUPolarPan( BYTE _bChannel );

void    vSetAPUEffectGain( BYTE _bChannel, BYTE _bEffectGain );
BYTE    bGetAPUEffectGain( BYTE _bChannel );

void    vSetAPUStepSize( BYTE _bChannel, WORD _wStepSize );
WORD    wGetAPUStepSize( BYTE _bChannel );

void    vSetAPUDataSourceA( BYTE _bChannel, BYTE _bDataSourceA );
BYTE    bGetAPUDataSourceA( BYTE _bChannel );

void    vSetAPUDataSourceB( BYTE _bChannel, BYTE _bDataSourceB );
BYTE    bGetAPUDataSourceB( BYTE _bChannel );

void    vSetAPUAmplitudeNow( BYTE _bChannel, BYTE _bAmplitude );
BYTE    bGetAPUAmplitudeNow( BYTE _bChannel );


