#include    <stdio.h>
#include	<stdlib.h>


#include    "sbtype.h"
#include    "sbscreen.h"
#include	"wp.h"
#include	"cram.h"
#include	"apu.h"


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vWrAPURegIndex( WORD _wRegIndex )
	{
    vWrIDR( IDR1_CRAM_POINTER, _wRegIndex );

    while( wRdAPURegIndex() != _wRegIndex )
        {
        vDisplayDebugMessage("Waiting for APU index register\n");
        }

	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wRdAPURegIndex( void )
	{
	return( wRdIDR( IDR1_CRAM_POINTER ) ); 
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vWrAPURegData( WORD _wRegData )
	{
    WORD    wIndex=0;

    while( wRdAPURegData() != _wRegData )
        {
        vDisplayDebugMessage("%04X\r", wIndex++ );
        vWrIDR( IDR0_DATA_PORT, _wRegData );
        }
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wRdAPURegData( void )
	{
	return( wRdIDR( IDR0_DATA_PORT ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vWrAPUReg( BYTE _bChannel, BYTE _bRegIndex, WORD _wRegData )
	{
	vWrAPURegIndex( (WORD)( ( _bChannel << 4 ) + _bRegIndex ) );
	vWrAPURegData( _wRegData );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wRdAPUReg( BYTE _bChannel, BYTE _bRegIndex )
	{
	vWrAPURegIndex( (WORD)( ( _bChannel << 4 ) + _bRegIndex ) );
	return( wRdAPURegData() );
	}
			

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPURegBit( BYTE _bChannel, BYTE _bRegIndex, BYTE _bRegBit )
	{
	vWrAPUReg( _bChannel, _bRegIndex, WSETBIT( wRdAPUReg( _bChannel, _bRegIndex ), _bRegBit ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vMskAPURegBit( BYTE _bChannel, BYTE _bRegIndex, BYTE _bRegBit )
	{
	vWrAPUReg( _bChannel, _bRegIndex, WMSKBIT( wRdAPUReg( _bChannel, _bRegIndex ), _bRegBit ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bTstAPURegBit( BYTE _bChannel, BYTE _bRegIndex, BYTE _bRegBit )
	{
	return( (BYTE)( WTSTBIT( wRdAPUReg( _bChannel, _bRegIndex ), _bRegBit ) ) );
	}
	


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUType( BYTE _bChannel, BYTE _bType )
    {
    vWrAPUReg( _bChannel, 0x00, ( wRdAPUReg( _bChannel, 0x00 ) & 0xFF0F ) | ( _bType << 4 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAPUType( BYTE _bChannel )
    {
    return( (BYTE)( ( wRdAPUReg( _bChannel, 0x00 ) & 0x00F0 ) >> 4 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUDMA( BYTE _bChannel, BYTE _bState )
	{
	switch( _bState )
		{
		case DISABLE:
			vMskAPURegBit( _bChannel, 0x00, 14 );
			break;
			
		case ENABLE:
			vSetAPURegBit( _bChannel, 0x00, 14 );
			break;
		}	
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUDMA( BYTE _bChannel )
	{
	return( bTstAPURegBit( _bChannel, 0x00, 14 ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUEndCurve( BYTE _bChannel, BYTE _bState )
	{
	switch( _bState )
		{
		case DISABLE:
			vMskAPURegBit( _bChannel, 0x00, 12 );
			break;
			
		case ENABLE:	
			vSetAPURegBit( _bChannel, 0x00, 12 );
			break;
		}	
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUEndCurve( BYTE _bChannel )
	{
	return( bTstAPURegBit( _bChannel, 0x00, 12 ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUIntOnLoop( BYTE _bChannel, BYTE _bState )
	{
	switch( _bState )
		{
		case DISABLE:
			vMskAPURegBit( _bChannel, 0x00, 13 );
			break;
			
		case ENABLE:
			vSetAPURegBit( _bChannel, 0x00, 13 );
			break;
		}	
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUIntOnLoop( BYTE _bChannel )
	{
	return( bTstAPURegBit( _bChannel, 0x00, 13 ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUDualEffectSend( BYTE _bChannel, BYTE _bState )
	{
	switch( _bState )
		{
		case DISABLE:
			vMskAPURegBit( _bChannel, 0x02, 5 );
			break;

		case ENABLE:
			vSetAPURegBit( _bChannel, 0x02, 5 );
			break;
		}
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUDualEffectSend( BYTE _bChannel )
	{
	return( bTstAPURegBit( _bChannel, 0x02, 5 ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUSubmixMode( BYTE _bChannel, BYTE _bState )
	{
	switch( _bState )
		{
		case DISABLE:
			vMskAPURegBit( _bChannel, 0x02, 3 );
			break;

		case ENABLE:
			vSetAPURegBit( _bChannel, 0x02, 3 );
			break;
		}	
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAPUSubmixMode( BYTE _bChannel )
	{
	return( bTstAPURegBit( _bChannel, 0x02, 3 ) );
	}
		
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUSubmixGroup( BYTE _bChannel, BYTE _bSubmixGroup )
	{
	vWrAPUReg( _bChannel, 0x02, (WORD)( ( wRdAPUReg( _bChannel, 0x02 ) & 0xFFF8 ) | _bSubmixGroup ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUSubmixGroup( BYTE _bChannel )
	{
	return( (BYTE)( wRdAPUReg( _bChannel, 0x02 ) & 0x0007 )	);
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUInvertPolarityA( BYTE _bChannel, BYTE _bState )
    {
    switch( _bState )
    	{
    	case DISABLE:
    		vMskAPURegBit( _bChannel, 0x0B, 7 );
    		break;
    		
    	case ENABLE:
		    vSetAPURegBit( _bChannel, 0x0B, 7 );
		    break;
		}    
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUInvertPolarityA( BYTE _bChannel )
    {
    return( bTstAPURegBit( _bChannel, 0x0B, 7 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUInvertPolarityB( BYTE _bChannel, BYTE _bState )
    {
    switch( _bState )
    	{
    	case DISABLE:
    		vMskAPURegBit( _bChannel, 0x0B, 15 );
    		break;
    		
    	case ENABLE:
		    vSetAPURegBit( _bChannel, 0x0B, 15 );
		    break;
		}    
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUInvertPolarityB( BYTE _bChannel )
    {       
    return( bTstAPURegBit( _bChannel, 0x0B, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPU6dB( BYTE _bChannel, BYTE _bState )
    {
    switch( _bState )
    	{
    	case DISABLE:
    		vMskAPURegBit( _bChannel, 0x02, 4 );
    		break;

    	case ENABLE:
		    vSetAPURegBit( _bChannel, 0x02, 4 );
		    break;
		}    
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPU6dB( BYTE _bChannel )
    {
    return( bTstAPURegBit( _bChannel, 0x02, 4 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUEffectChannels( BYTE _bChannel, BYTE _bEffectChannels )
	{
	vWrAPUReg( _bChannel, 0x02, (WORD)( ( wRdAPUReg( _bChannel, 0x02 ) & 0xFF3F ) | ( _bEffectChannels << 6 ) ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUEffectChannels( BYTE _bChannel )
	{
    return( (BYTE)( ( wRdAPUReg( _bChannel, 0x02 ) & 0x00C0 ) >> 6 ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUEnvelopeType( BYTE _bChannel, BYTE _bEnvelopeType )
    {
    vWrAPUReg( _bChannel, 0x00, ( wRdAPUReg( _bChannel, 0x00 ) & 0xFCFF ) | ( (WORD)_bEnvelopeType << 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAPUEnvelopeType( BYTE _bChannel )
    {
    return( (BYTE)( ( wRdAPUReg( _bChannel, 0x00 ) & 0x0300 ) >> 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUEnvelopeState( BYTE _bChannel, BYTE _bState )
    {
    vWrAPUReg( _bChannel, 0x00, (WORD)( ( wRdAPUReg( _bChannel, 0x00 ) & 0xF3FF ) | ( (WORD)_bState << 10 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAPUEnvelopeState( BYTE _bChannel )
    {
	return( (BYTE)( ( wRdAPUReg( _bChannel, 0x00 ) & 0x0C00 ) >> 10 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUTremeloRate( BYTE _bChannel, BYTE _bTremeloRate )
    {
    vWrAPUReg( _bChannel, 0x08, (WORD)( ( wRdAPUReg( _bChannel, 0x08 ) & 0x0FFF ) | ( (WORD)_bTremeloRate << 12 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAPUTremeloRate( BYTE _bChannel )
    {
    return( (BYTE)( ( wRdAPUReg( _bChannel, 0x08 ) & 0xF000 ) >> 12 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUTremeloDepth( BYTE _bChannel, BYTE _bTremeloDepth )
    {
    vWrAPUReg( _bChannel, 0x08, (WORD)( ( wRdAPUReg( _bChannel, 0x08 ) & 0xF0FF ) | (WORD)_bTremeloDepth << 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAPUTremeloDepth( BYTE _bChannel )
    {
    return( (BYTE)( ( wRdAPUReg( _bChannel, 0x08 ) & 0x000F ) >> 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUFilterType( BYTE _bChannel, BYTE _bFilterType )
    {
    vWrAPUReg( _bChannel, 0x00, (WORD)( ( wRdAPUReg( _bChannel, 0x00 ) & 0xFFF3 ) | ( _bFilterType << 2 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAPUFilterType( BYTE _bChannel )
    {
    return( (BYTE)( ( wRdAPUReg( _bChannel, 0x00 ) & 0x000C ) >> 2 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUFilterQ( BYTE _bChannel, BYTE _bFilterQ )
    {
    vWrAPUReg( _bChannel, 0x00, (WORD)( ( wRdAPUReg( _bChannel, 0x00 ) & 0xFFFC ) | _bFilterQ ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAPUFilterQ( BYTE _bChannel )
    {
    return( (BYTE)( wRdAPUReg( _bChannel, 0x00 ) & 0x0003 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUFilterTuning( BYTE _bChannel, BYTE _bFilterTuning )
	{
    vWrAPUReg( _bChannel, 0x0A, (WORD)( ( wRdAPUReg( _bChannel, 0x0A ) & 0x00FF ) | ( (WORD)_bFilterTuning << 8 ) ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUFilterTuning( BYTE _bChannel )
	{
    return( (BYTE)( ( wRdAPUReg( _bChannel, 0x0A ) & 0xFF00 ) >> 8 ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUPhase( BYTE _bChannel, BYTE _bPhase )
	{
	vWrAPUReg( _bChannel, 0x04, (WORD)( ( wRdAPUReg( _bChannel, 0x04 ) & 0xFF00 ) | _bPhase ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUPhase( BYTE _bChannel )
	{
	return( (BYTE)( wRdAPUReg( _bChannel, 0x04 ) & 0x00FF ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUFrequency( BYTE _bChannel, DWORD _dwFrequency )
    {
    vWrAPUReg( _bChannel, 0x02, (WORD)( ( wRdAPUReg( _bChannel, 0x02 ) & 0x00FF ) | (WORD)( LOBYTE( _dwFrequency ) << 8 ) ) );
    vWrAPUReg( _bChannel, 0x03, (WORD)( _dwFrequency >> 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
DWORD	dwGetAPUFrequency( BYTE _bChannel )
    {
    return( (DWORD)( ( (DWORD)( HIBYTE( wRdAPUReg( _bChannel, 0x02 ) ) ) << 16 ) | wRdAPUReg( _bChannel, 0x03 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUWave64kPage( BYTE _bChannel, BYTE _b64kPage )
    {
    vWrAPUReg( _bChannel, 0x04, (WORD)( (WORD)( wRdAPUReg( _bChannel, 0x04 ) & 0x00FF ) | ( (WORD)( _b64kPage ) << 8 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUWave64kPage( BYTE _bChannel )
    {
    return( HIBYTE( wRdAPUReg( _bChannel, 0x04 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUWaveStart( BYTE _bChannel, WORD _wWaveStart )
    {
    vWrAPUReg( _bChannel, 0x05, _wWaveStart );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAPUWaveStart( BYTE _bChannel )
    {
    return( wRdAPUReg( _bChannel, 0x05 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUWaveEnd( BYTE _bChannel, WORD _wWaveEnd )
    {
    vWrAPUReg( _bChannel, 0x06, _wWaveEnd );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAPUWaveEnd( BYTE _bChannel )
    {
    return( wRdAPUReg( _bChannel, 0x06 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUWaveLoop( BYTE _bChannel, WORD _wWaveLoop )
    {
    vWrAPUReg( _bChannel, 0x07, _wWaveLoop );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAPUWaveLoop( BYTE _bChannel )
    {
    return( wRdAPUReg( _bChannel, 0x07 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUWavePtr( BYTE _bChannel, DWORD _dwWaveStart, WORD _wWaveLength )
	{
	vSetAPUWave64kPage( _bChannel, LOBYTE( HIWORD( _dwWaveStart ) ) );
    vSetAPUWaveStart( _bChannel, LOWORD( _dwWaveStart ) );
	vSetAPUWaveEnd( _bChannel, LOWORD( _dwWaveStart ) + _wWaveLength );
    vSetAPUWaveLoop( _bChannel, _wWaveLength );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
DWORD	dwGetAPUWavePtr( BYTE _bChannel )
	{
	return( (DWORD)( MAKELP( wGetAPUWaveStart( _bChannel ), bGetAPUWave64kPage( _bChannel ) ) ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUVibratoRate( BYTE _bChannel, BYTE _bVibratoRate )
	{
    vWrAPUReg( _bChannel, 0x0B, (WORD)( wRdAPUReg( _bChannel, 0x0B ) & 0xFFF0 ) | _bVibratoRate );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUVibratoRate( BYTE _bChannel )
	{
    return( (BYTE)( wRdAPUReg( _bChannel, 0x0B ) & 0x000F ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUVibratoDepth( BYTE _bChannel, BYTE _bVibratoDepth )
	{
    vWrAPUReg( _bChannel, 0x0B, ( wRdAPUReg( _bChannel, 0x0B ) & 0xFF0F ) | ( _bVibratoDepth << 4 ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUVibratoDepth( BYTE _bChannel )
	{
    return( (BYTE)( ( wRdAPUReg( _bChannel, 0x0B ) & 0x00F0 ) >> 4 ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUVibratoPhase( BYTE _bChannel, BYTE _bVibratoPhase )
	{
	vWrAPUReg( _bChannel, 0x0B, ( wRdAPUReg( _bChannel, 0x0B ) & 0x00FF ) | ( (WORD)( _bVibratoPhase ) << 8 ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUVibratoPhase( BYTE _bChannel )
	{
	return( (BYTE)( ( wRdAPUReg( _bChannel, 0x0B ) & 0xFF00 ) >> 8 ) );
	}

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPURadiusSelect( BYTE _bChannel, BYTE _bRadiusSelect )
	{
	vWrAPUReg( _bChannel, 0x0A, ( wRdAPUReg( _bChannel, 0x0A ) & 0xFF3F ) | ( _bRadiusSelect << 6 ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPURadiusSelect( BYTE _bChannel )
	{
	return( (BYTE)( ( wRdAPUReg( _bChannel, 0x0A ) & 0x00C0 ) >> 6 ) );
	}
		
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUPolarPan( BYTE _bChannel, BYTE _bPolarPan )
	{
	vWrAPUReg( _bChannel, 0x0A, (WORD)( ( wRdAPUReg( _bChannel, 0x0A ) & 0xFFC0 ) | _bPolarPan ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE	bGetAPUPolarPan( BYTE _bChannel )
	{
	return( (BYTE)( wRdAPUReg( _bChannel, 0x0A ) & 0x003F ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUEffectGain( BYTE _bChannel, BYTE _bEffectGain )
	{
    vWrAPUReg( _bChannel, 0x08, (WORD)( ( wRdAPUReg( _bChannel, 0x08 ) & 0xFF00 ) |  (WORD)_bEffectGain ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAPUEffectGain( BYTE _bChannel )
	{
    return( LOBYTE( wRdAPUReg( _bChannel, 0x08 ) ) );
	}
	
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void	vSetAPUStepSize( BYTE _bChannel, WORD _wStepSize )
	{
	vWrAPUReg( _bChannel, 0x03, _wStepSize & 0x0FFF );
	}
	
/*****************************************************************************/
/* wGetAPUStepSize                                                           */
/*                                                                           */
/*****************************************************************************/
WORD	wGetAPUStepSize( BYTE _bChannel )
	{
	return( wRdAPUReg( _bChannel, 0x03 ) & 0x0FFF );
	}
			
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUDataSourceA( BYTE _bChannel, BYTE _bDataSourceA )
    {
    vWrAPUReg( _bChannel, 0x0B, (WORD)( ( wRdAPUReg( _bChannel, 0x0B ) & 0xFF80 ) | _bDataSourceA ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAPUDataSourceA( BYTE _bChannel )
    {
    return( (BYTE)( wRdAPUReg( _bChannel, 0x0B ) & 0x007F ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUDataSourceB( BYTE _bChannel, BYTE _bDataSourceB )
    {
    vWrAPUReg( _bChannel, 0x0B, (WORD)( ( wRdAPUReg( _bChannel, 0x0B ) & 0x80FF ) | ( (WORD)(_bDataSourceB) << 8 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAPUDataSourceB( BYTE _bChannel )
    {
    return( (BYTE)( ( wRdAPUReg( _bChannel, 0x0B ) & 0x7F00 ) >> 8 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAPUAmplitudeNow( BYTE _bChannel, BYTE _bAmplitude )
    {
    vWrAPUReg( _bChannel, 0x09, (WORD)( ( wRdAPUReg( _bChannel, 0x09 ) & 0x00FF ) | ( ( (WORD)_bAmplitude << 8 ) ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAPUAmplitudeNow( BYTE _bChannel )
    {
    return( HIBYTE( wRdAPUReg( _bChannel, 0x09 ) ) );
    }

