#include    <stdio.h>
#include    <stdlib.h>

#include	"sbtype.h"
#include    "ptconfig.h"
#include    "codec.h"

#include    "ac97.h"


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vResetAC97( void )
    {
    vWrCReg( 0x00, 0x00 );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97MasterMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x02, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x02, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAC97MasterMute( void )
    {
    return( bTstCRegBit( 0x02, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97MasterVolume( BYTE _bLLevel, BYTE _bRLevel )
    {
    vWrCReg( 0x02, (WORD)( ( wRdCReg( 0x02 ) & 0x8000 ) | ( (WORD)_bLLevel << 8 ) | _bRLevel ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAC97MasterVolume( void )
    {
    return( (WORD)( wRdCReg( 0x02 ) & 0x7FFF ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97HeadphoneMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x02, 15 );
            break;
        case ENABLE:
            vSetCRegBit( 0x02, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAC97HeadphoneMute( void )
    {
    return( bTstCRegBit( 0x02, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97HeadphoneVolume( BYTE _bLLevel, BYTE _bRLevel )
    {
    vWrCReg( 0x02, (WORD)( ( wRdCReg( 0x04 ) & 0x8000 ) | ( (WORD)_bLLevel << 8 ) | _bRLevel ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAC97HeadphoneVolume( void )
    {
    return( (WORD)( wRdCReg( 0x04 ) & 0x7FFF ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97BassLevel( BYTE _bLevel )
    {
    vWrCReg( 0x08, (WORD)( ( wRdCReg( 0x08 ) & 0xF0FF ) | ( (WORD)_bLevel << 8 ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAC97BassLevel( void )
    {
    return( (BYTE)( HIBYTE( wRdCReg( 0x08 ) ) & 0x0F ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97TrebleLevel( BYTE _bLevel )
    {
    vWrCReg( 0x08, (WORD)( ( wRdCReg( 0x08 ) & 0xFFF0 ) | _bLevel ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAC97TrebleLevel( void )
    {
    return( (BYTE)( wRdCReg( 0x08 ) & 0x0F ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97PCSpeakerMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x0A, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x0A, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAC97PCSpeakerMute( void )
    {
    return( bTstCRegBit( 0x0A, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97PCSpeakerVolume( BYTE _bLevel )
    {
    vWrCReg( 0x0A, (WORD)( ( wRdCReg( 0x0A ) & 0xFFF0 ) | (BYTE)( _bLevel & 0x0F ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAC97PCSpeakerVolume( void )
    {
    return( (BYTE)( wRdCReg( 0x0A ) & 0x000F ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97PhoneVolume( BYTE _bLevel )
    {
    vWrCReg( 0x0C, (WORD)( ( wRdCReg( 0x0C ) & 0xFFF0 ) | (_bLevel & 0x0F ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAC97PhoneVolume( void )
    {
    return( (BYTE)( wRdCReg( 0x0C ) & 0x0F ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97MicVolume( BYTE _bLevel )
    {
    vWrCReg( 0x0E, (WORD)( ( wRdCReg( 0x0E ) & 0xFFF0 ) | ( _bLevel & 0x0F ) ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAC97MicVolume( void )
    {
    return( (BYTE)( wRdCReg( 0x0E ) & 0x0F ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97LineInMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x10, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x10, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAC97LineInMute( void )
    {
    return( bTstCRegBit( 0x10, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97LineInVolume( BYTE _bLLevel, BYTE _bRLevel )
    {
    vWrCReg( 0x10, (WORD)( ( wRdCReg( 0x10 ) & 0x8000 ) | ( (WORD)_bLLevel << 8 ) | _bRLevel ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAC97LineInVolume( void )
    {
    return( (WORD)( wRdCReg( 0x10 ) & 0x7FFF ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97CDMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x12, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x12, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAC97CDMute( void )
    {
    return( bTstCRegBit( 0x12, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97CDVolume( BYTE _bLLevel, BYTE _bRLevel )
    {
    vWrCReg( 0x12, (WORD)( ( wRdCReg( 0x12 ) & 0x8000 ) | ( (WORD)_bLLevel << 8 ) | _bRLevel ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAC97CDVolume( void )
    {
    return( (WORD)( wRdCReg( 0x10 ) & 0x7FFF ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97VideoMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x14, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x14, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAC97VideoMute( void )
    {
    return( bTstCRegBit( 0x14, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97VideoVolume( BYTE _bLLevel, BYTE _bRLevel )
    {
    vWrCReg( 0x14, (WORD)( ( wRdCReg( 0x14 ) & 0x8000 ) | ( (WORD)_bLLevel << 8 ) | _bRLevel ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAC97VideoVolume( void )
    {
    return( (WORD)( wRdCReg( 0x14 ) & 0x7FFF ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97AuxMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x16, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x16, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAC97AuxMute( void )
    {
    return( bTstCRegBit( 0x16, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97AuxVolume( BYTE _bLLevel, BYTE _bRLevel )
    {
    vWrCReg( 0x16, (WORD)( ( wRdCReg( 0x16 ) & 0x8000 ) | ( (WORD)_bLLevel << 8 ) | _bRLevel ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAC97AuxVolume( void )
    {
    return( (WORD)( wRdCReg( 0x16 ) & 0x7FFF ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97PCMOutMute( BYTE _bState )
    {
    switch( _bState )
        {
        case DISABLE:
            vMskCRegBit( 0x18, 15 );
            break;

        case ENABLE:
            vSetCRegBit( 0x18, 15 );
            break;
        }
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
BYTE    bGetAC97PCMOutMute( void )
    {
    return( bTstCRegBit( 0x18, 15 ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
void    vSetAC97PCMOutVolume( BYTE _bLLevel, BYTE _bRLevel )
    {
    vWrCReg( 0x18, (WORD)( ( wRdCReg( 0x18 ) & 0x8000 ) | ( (WORD)_bLLevel << 8 ) | _bRLevel ) );
    }

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
WORD    wGetAC97PCMOutVolume( void )
    {
    return( (WORD)( wRdCReg( 0x18 ) & 0x7FFF ) );
    }

