/*  itstime.c is part of Statnet */
/* Statnet is protected under the GNU Public License (GPL2). */
/* Author: Jeroen Baekelandt (jeroenb@igwe.vub.ac.be)       */
/* 27DEC95: Scot E. Wilcoxon (sewilco@fieldday.mn.org)      */

#include "netwatch.h"
#include "curs.h"
#include <ncurses.h>
#include <signal.h>
#include <unistd.h>

#define MAXREFRESH 15
#define ROUTERSTATSMAX 60

void makeaddr (char naddr[], char ascii[]);

void
dispdata (int errnum)
{

  int xleft = 1;		/* Offset for Local Info */
  int xright;
  int y;
  static int refreshscr = 0;
  static int routerstats = 0;
  static time_t routertime;
  static unsigned long int oldrouteruse;
  unsigned long int sec;
  unsigned long int use;
  double fuse;
  extern unsigned long int routeruse;
  
  int lcnt = 0;
  int rcnt = 0;
  static char ttt[260];
  static char thost[60];
  int yact;
  int mid;
  unsigned char *pc;
  extern int llockout;
  extern int rlockout;
  extern int lydisp;
  extern int rydisp;
  extern int localkey;
  extern int localupdate;
  extern int remoteupdate;
  extern int refreshloc;
  extern int refreshrem;
  extern int poschange;
  time_t mnew;
  extern int dispopt;		/* TXRC IPPROTO OTHER */
  int updaterest = 0;
  time_t colred, colyel, colgreen, testt;
  extern HOSTINFO *lfirst;
  extern HOSTINFO *rfirst;
  HOSTINFO *current;

  mnew = time (0);
  colred = mnew - 60;		/* 1 min */
  colyel = mnew - 300;		/* 5 min */
  colgreen = mnew - 1800;	/* 30 min */
  mid = COLS / 2;
  xright = mid + 1;
  if (rewrite_labels)
    {				/* if rewrite_labels */

      clrportion (1, 1, 4, COLS - 1);
      mvprintw (0, (COLS / 2) - 6, "NETWORK WATCH");
      mvprintw (1, COLS - (COLS) / 3, "REMOTE NETWORK");
      mvprintw (1, (COLS - 22) / 4, "LOCAL NETWORK");
      switch (dispopt)
	{
	case DISP_TX_RC:
	  mvprintw (2, (xright + 5), "HOST          (PKTS)     X      R");
	  mvprintw (2, (xleft + 5), "HOST          (PKTS)     X      R");
	  break;
	case DISP_IPPROTO:
	  mvprintw (2, (xright + 5), "HOST             IP      SERVICE");
	  mvprintw (2, (xleft + 5), "HOST             IP      SERVICE");
	  break;
	case DISP_DEST2:
	case DISP_DEST1:
	  mvprintw (2, (xright + 5), "HOST                TALKING TO");
	  mvprintw (2, (xleft + 5), "HOST                TALKING TO");
	  break;
	case DISP_ACCT:
	  mvprintw (2, (xright + 5), "HOST  (BYTES)    X          R ");
	  mvprintw (2, (xleft + 5), "HOST  (BYTES)    X          R ");
	  break;
	}
      refresh ();
      rewrite_labels = 0;
    }
  if (localkey)
    {
      attron (COLOR_PAIR (2));
      mvprintw (3, 1, "KEY");
      attron (COLOR_PAIR (4));
      mvprintw (3, 76, "   ");
    }
  else
    {
      attron (COLOR_PAIR (4));
      mvprintw (3, 1, "   ");
      attron (COLOR_PAIR (2));
      mvprintw (3, 76, "KEY");
      attron (COLOR_PAIR (4));
    }
  if (llockout)
    mvprintw (0, 62, "LX");
  else
    {
      mvaddch (0, 62, ACS_HLINE);
      addch (ACS_HLINE);
    }
  if (rlockout)
    mvprintw (0, 65, "RX");
  else
    {
      mvaddch (0, 65, ACS_HLINE);
      addch (ACS_HLINE);
    }
  if (poschange)
    mvprintw (0, 68, "P");
  else
    mvaddch (0, 68, ACS_HLINE);
  mvprintw (0, 70, "LINE %3d ", rydisp);
  mvprintw (0, 2, "LINE %3d ", lydisp);
  if (poschange)
    lcnt = 0;
  routerstats++;
  if (routerstats==ROUTERSTATSMAX)
  {
  	sec = mnew - routertime;
  	use = routeruse - oldrouteruse;
  	routertime = mnew;
  	oldrouteruse = routeruse;
  	/* CALC STATS for ROUTER 
  		use = # of bytes thru router in "sec" seconds
  	*/
  	fuse = (double)use/sec* 0.008;
  	if (fuse>1.0)
	  	mvprintw(LINES-1,mid-15," ROUTER %10.2g kbits/sec ",fuse);
	else
	  	mvprintw(LINES-1,mid-15," ROUTER %10.2g bits/sec ",fuse*1000.0);
  	routerstats = 0;
  }
  	
  refreshscr++;
  if (refreshscr > MAXREFRESH)
    {
      poschange = 1;
      refreshscr = 0;
    }
  if (poschange)
    {
      refreshloc = refreshrem = TRUE;
    }
  if (refreshloc)
    clrportion (4, 1, LINES - 1, mid);
  if (refreshrem)
    clrportion (4, xleft, LINES - 1, COLS - 1);

  if (!llockout && (localupdate || refreshloc))
    {
      mvprintw (3, 25, " ");
      lcnt = 0;
      current = lfirst->flink;
      while (current != lfirst)
	{
/*              y = current->disprow; */
	  y = lcnt;
	  lcnt++;
	  yact = y - lydisp;
	  if (yact >= 0 && yact < LINES - 5)
	    {
	      yact += 4;
	      if (refreshloc || updaterest || current->update)
		{
		  strncpy (thost, current->name, 23);
		  thost[23] = 0;
		  testt = current->tstamp;
		  if (testt > colred)
		    attron (COLOR_PAIR (1));
		  else if (testt > colyel)
		    attron (COLOR_PAIR (2));
		  else if (testt > colgreen)
		    attron (COLOR_PAIR (3));
		  else
		    attron (COLOR_PAIR (4));
		  switch (dispopt)
		    {
		    case DISP_TX_RC:
		      sprintf (ttt, "%-24s %6d %6d", thost,
			       current->pktcntsend, current->pktcntrec);
		      break;
		    case DISP_IPPROTO:
		      thost[16] = 0;
		      sprintf (ttt, "%-16s %8s %10s   ", thost,
			       current->ip_pr, current->servicename);
		      break;
		    case DISP_DEST1:
		      pc = (unsigned char *) current->othaddr;
		      sprintf (ttt, "%-24s %u.%u.%u.%u        ", thost,
			       pc[0], pc[1], pc[2], pc[3]);
		      break;
		    case DISP_DEST2:
		      pc = (unsigned char *) current->othaddr;
		      makeaddr (current->addr, thost);
		      sprintf (ttt, "%-24s %u.%u.%u.%u        ", thost,
			       pc[0], pc[1], pc[2], pc[3]);
		      break;
		    case DISP_ACCT:
		      thost[16] = 0;
		      sprintf (ttt, "%-16s %10lu %10lu", thost,
			current->sendbytes,current->recbytes);
		      break;
		    }
		  ttt[38] = 0;
		  mvprintw (yact, xleft, ttt);
		  attron (COLOR_PAIR (4));
		  if (current->update)
		    {
		      if (current->update == 1)
			updaterest = 1;
		      current->update = 0;
		    }
		}
	    }
	  else
	    {
	      if (yact < 0)
		mvprintw (3, 25, "^");
	      else
		mvprintw (3, 25, "V");
	    }
	  current = current->flink;
	}

      localupdate = 0;
    }
  if (!rlockout && (remoteupdate || refreshrem))
    {
/*   rcnt++;
   mvprintw(11,10,"%2d",rcnt);  */
      mvprintw (3, 68, " ");
      rcnt = 0;
      current = rfirst->flink;
      while (current != rfirst)
	{
/*              y = current->disprow; */
	  y = rcnt;
	  rcnt++;
	  yact = y - rydisp;
	  if (yact >= 0 && yact < LINES - 5)
	    {
	      yact += 4;
	      if (refreshrem || updaterest || current->update)
		{
		  strncpy (thost, current->name, 23);
		  thost[23] = 0;
		  testt = current->tstamp;
		  if (testt > colred)
		    attron (COLOR_PAIR (1));
		  else if (testt > colyel)
		    attron (COLOR_PAIR (2));
		  else if (testt > colgreen)
		    attron (COLOR_PAIR (3));
		  else
		    attron (COLOR_PAIR (4));
		  switch (dispopt)
		    {
		    case DISP_TX_RC:
		      sprintf (ttt, "%-24s %6d %6d", thost,
			       current->pktcntsend, current->pktcntrec);
		      break;
		    case DISP_IPPROTO:
		      thost[16] = 0;
		      sprintf (ttt, "%-16s %8s %10s    ", thost,
			       current->ip_pr, current->servicename);
		      break;
		    case DISP_DEST1:
		      pc = (unsigned char *) current->othaddr;
		      thost[22] = 0;
		      sprintf (ttt, "%-22s %u.%u.%u.%u        ", thost,
			       pc[0], pc[1], pc[2], pc[3]);
		      break;
		    case DISP_DEST2:
		      pc = (unsigned char *) current->othaddr;
		      makeaddr (current->addr, thost);
		      thost[22] = 0;
		      sprintf (ttt, "%-22s %u.%u.%u.%u        ", thost,
			       pc[0], pc[1], pc[2], pc[3]);
		      break;
		    case DISP_ACCT:
		      thost[16] = 0;
		      sprintf (ttt, "%-16s %10lu %10lu", thost,
			current->sendbytes,current->recbytes);
		      break;
		    }
		  ttt[38] = 0;
		  mvprintw (yact, xright, ttt);
		  attron (COLOR_PAIR (4));
		  if (current->update)
		    {
		      if (current->update == 1)
			updaterest = 1;
		      current->update = 0;
		    }
		}
	    }
	  else
	    {
	      if (yact < 0)
		mvprintw (3, 68, "^");
	      else
		mvprintw (3, 68, "V");
	    }
	  current = current->flink;
	}
      remoteupdate = 0;
    }
  poschange = 0;
  refresh ();
  signal (SIGALRM, dispdata);
  alarm (1);
}
