/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)ring.h	5.2 (Berkeley) 3/1/91
 *	$Id: ring.h,v 1.19 2002/08/11 19:44:44 dholland Exp $
 */

struct datasink_c {
   int (*write)(const char *buf, int len);
   int (*writeurg)(const char *buf, int len);
};

struct datasource_c {
   int (*read)(char *buf, int len);
};

/* Structure for a ring buffer. (Opaque) */
struct ringbuf;


/////// consume end functions

// manual consume
int ringbuf_gets(struct ringbuf *, char *buf, int max);
int ringbuf_getch(struct ringbuf *, int *ch);
void ringbuf_ungetch(struct ringbuf *, int ch);
int ringbuf_full_count(struct ringbuf *);

// automatic consume
int ringbuf_flush(struct ringbuf *);


/////// supply end functions

// manual supply
void ringbuf_putch(struct ringbuf *, char c);
void ringbuf_write(struct ringbuf *, const char *buffer, int ct);
void ringbuf_printf(struct ringbuf *, const char *format, ...);
int ringbuf_empty_count(struct ringbuf *);

// automatic supply
int ringbuf_read_source(struct ringbuf *);


/////// other functions

void ringbuf_clear_mark(struct ringbuf *);
void ringbuf_set_mark(struct ringbuf *);

struct ringbuf *ringbuf_create(int size, const struct datasink_c *sink, 
			       const struct datasource_c *src);

// returns the old sink
const struct datasink_c *ringbuf_setsink(struct ringbuf *,
					 const struct datasink_c *);


/////// data

extern const struct datasink_c *const netsink;
extern const struct datasink_c *const ttysink;
extern const struct datasink_c *const nullsink;

extern const struct datasource_c *const netsrc;
extern const struct datasource_c *const ttysrc;

#define	NETADD(c)	{ ringbuf_putch(netoring, c); }
#define	NET2ADD(c1,c2)	{ NETADD(c1); NETADD(c2); }

