/*
 * Copyright (c) 2000, 2001
 *	The President and Fellows of Harvard College.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef CARRAY_H
#define CARRAY_H

/*
 * Resizeable array of void pointers.
 *
 * Functions:
 *     array_create  - allocate a new array object. Returns NULL if out
 *                     of memory.
 *     array_preallocate - allocate enough space for at least NUM elements,
 *                     without changing the visible size of the array. Can 
 *                     be used to prevent anticipated calls to setsize from
 *                     failing. Returns an error code.
 *     array_getnum  - return the size of the array.
 *     array_getguy  - return the specified element from the array.
 *     array_setsize - alter the size of the array. If shrunk, excess 
 *                     elements are dropped. If expanded, the new elements
 *                     are *not* initialized. Returns an error number on
 *                     failure.
 *     array_setguy  - set the specified element in the array to the passed
 *                     pointer. The element must be within range.
 *     array_add     - add one pointer to the end of the array, increasing 
 *                     the size. Returns an error number on failure.
 *     array_remove  - remove one pointer from anywhere in the array. The
 *                     portion of the array after the index is moved down,
 *                     collapsing the resulting hole.
 *     array_destroy - dispose of an array. If not empty, the contents are
 *                     lost.
 */

struct array;  /* Opaque. */

struct array *array_create(void);
int           array_preallocate(struct array *, int nguys);
int           array_getnum(struct array *);
void         *array_getguy(struct array *, int index);
int           array_setsize(struct array *, int nguys);
void          array_setguy(struct array *, int index, void *ptr);
int           array_add(struct array *, void *guy);
void          array_remove(struct array *, int index);
void          array_destroy(struct array *);

#endif /* CARRAY_H */
