#include <stdio.h>

struct sockaddr_in;
struct timeval;
struct tsp;

#define ON		1
#define OFF		0

#define BAD_STATUS	(-1)
#define GOOD		1
#define UNREACHABLE	2
#define NONSTDTIME	3
#define HOSTDOWN	0x7fffffff

#define	SECHR	(60*60)
#define	SECDAY	(24*SECHR)

/*
 * Best expected round trip for a measurement.
 * This is essentially the number of milliseconds per CPU tick (CLK_TCK?).
 * All delays shorter than this are usually reported as 0.
 */
#define MIN_ROUND ((1000-1)/CLK_TCK)


extern int sock_raw;
extern int trace;
extern FILE *fd;

/* byteorder.c */
void	 bytehostorder(struct tsp *);
void	 bytenetorder(struct tsp *);

/* packetio.c */
int send_tsp(int sock, const struct tsp *msg, struct sockaddr_in *addr);
int receive_tsp(int sock, struct tsp *msg, struct sockaddr_in *from);

/* measure.c */
int	 measure(u_long, u_long, char *, struct sockaddr_in *, int);
void	 mstotvround(struct timeval *, long);
void	 timevaladd(struct timeval *, const struct timeval *);
void	 timevalsub(struct timeval *, const struct timeval *, 
		    const struct timeval *);

/* cksum.c */
int	 in_cksum(const u_short *, int);
