#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <protocols/timed.h>
#include <string.h>
#include <syslog.h>
#include "timedlib.h"

int
receive_tsp(int sock, struct tsp *msg, struct sockaddr_in *from)
{
	struct sockaddr_in altfrom;
	socklen_t fromlen;
	size_t packetsize;
	int cc;

	if (from==NULL) {
	   from = &altfrom;
	}

	fromlen = sizeof(struct sockaddr_in);
	cc = recvfrom(sock, msg, sizeof(struct tsp), 0,
		      (struct sockaddr*) from, &fromlen);
	if (cc < 0) {
		syslog(LOG_ERR, "recvfrom: %m");
		exit(1);
	}

	if (fromlen != sizeof(struct sockaddr)) {
		syslog(LOG_NOTICE, "Received packet with return address "
		       "of odd length %lu", (unsigned long) fromlen);
		return -1;
	}

	/*
	 * Because struct tsp is defined in terms of MAXHOSTNAMELEN,
	 * and MAXHOSTNAMELEN is different on every system, we can't
	 * expect incoming packets to be the right size. Only reject
	 * them if they're completely missing a name.
	 */
	packetsize = cc;
	if (packetsize <= sizeof(struct tsp) - sizeof(msg->tsp_name)) {
		syslog(LOG_NOTICE, "Received short packet (%d bytes) from %s",
		       cc, inet_ntoa(from->sin_addr));
		return -1;
	}
	if (packetsize < sizeof(struct tsp)) {
		memset(((char *)msg)+packetsize, 0, 
		       sizeof(struct tsp) - packetsize);
	}

	if (memchr(msg->tsp_name, 0, sizeof(msg->tsp_name))==NULL) {
		syslog(LOG_NOTICE, "Received packet with invalid hostname "
		       "string from %s", inet_ntoa(from->sin_addr));
		return -1;
	}

	if (msg->tsp_type >= TSPTYPENUMBER) {
		fprintf(fd, "Received packet with bad type %u from %s\n",
			msg->tsp_type, inet_ntoa(from->sin_addr));
		return -1;
	}

	bytehostorder(msg);

	return 0;
}

int
send_tsp(int sock, const struct tsp *msg, struct sockaddr_in *addr)
{
	struct tsp outbound;
	int cc;

	/* How inefficient... shucks */
	memcpy(&outbound, msg, sizeof(struct tsp));

	/* ensure null termination */
	outbound.tsp_name[sizeof(outbound.tsp_name)-1] = 0;

	bytenetorder(&outbound);
	cc = sendto(sock, &outbound, sizeof(struct tsp), 0,
		    (struct sockaddr *) addr, sizeof(struct sockaddr_in));
	if (cc < 0) {
		return -1;
	}
	return 0;
}
