void buffer_init(void);

int buffer_ptyobuf_hasstuff(void);
int buffer_netobuf_hasstuff(void);
int buffer_netobuf_nearly_full(size_t k);
int buffer_ptyobuf_nearly_full(size_t k);
size_t buffer_ptyobuf_nchars(void);
size_t buffer_netobuf_nchars(void);

size_t buffer_netobuf_mustsend(void);
void buffer_netobuf_mark(void);

const char *buffer_get_netibuf(int nchars);
const char *buffer_get_ptyobuf(int nchars);
const char *buffer_get_netobuf(int nchars);

void buffer_netobuf_seturg(void);
void buffer_netobuf_clearurg(void);

int buffer_read_netibuf_oob(int fd);
int buffer_read_netibuf(int fd);
int buffer_netibuf_getc(void);

int buffer_write_ptyobuf(int fd);
int buffer_write_netobuf(int fd);
void buffer_netobuf_putc(int c);
void buffer_ptyobuf_putc(int c);

/* printf into netobuf */
void netoprintf(const char *fmt, ...) __attribute((format (printf, 1, 2))); 
void buffer_netobuf_append(const char *ptr, size_t len);

void buffer_ptyobuf_purge(void);
void buffer_netobuf_rewind(size_t nchars);

