/*
 * Copyright (c) 1995 Akihiro Tominaga and the WIDE Project.
 * All rights reserved.
 *
 * Permission to use, copy and distribute this software in source and
 * binary forms is hereby granted provided that the above copyright
 * notice and this permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions thereof.
 * Furthermore, any supporting documentation, advertising materials,
 * and all other materials related to such a distribution and use must
 * acknowledge that the software was developed by Akihiro Tominaga and
 * the WIDE Project. The names of the author and the WIDE Project may
 * not be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#ifndef SERVER_DB
#define SERVER_DB                   "/etc/dhcpdb.server"
#endif
#ifndef TRUE
#define TRUE    1
#endif
#ifndef NBPFILTER
#define NBPFILTER 10
#endif

#define HOPSTHRESHOLD             4

#define ETHERHL       sizeof(struct ether_header)  /* ethernet header length */
#define IPHL          sizeof(struct ip)            /* IP header length */
#define UDPHL         sizeof(struct udphdr)        /* UDP header length */
#define BOOTPLEN      300
#define WORD          4                            /* word alignment in bits */
#define	QWOFF         2                 /* to make dhcp long to 4w alignment */

/* struct definition */
struct if_info {
  int fd;
  char name[sizeof "enxx"];
  unsigned int htype;
  unsigned char hlen;
  char haddr[6];
  struct in_addr *ipaddr;
  struct in_addr *subnetmask;
  int buf_size;
  char *buf;
  struct if_info *next;				/* Null terminate */
};

struct msg
{
  struct ether_header *ether;
  struct ip *ip;
  struct udphdr *udp;
  struct dhcp *dhcp;
};

extern u_short dhcps_port;      /* DHCP server port (network byte order) */
extern u_short dhcpc_port;

#ifndef sun
extern struct bpf_hdr *rbpf;        /* pointer to bpf header */
#endif
extern struct msg rcv;
