/*
 * Copyright (c) 1995 Akihiro Tominaga and the WIDE Project.
 * All rights reserved.
 *
 * Permission to use, copy and distribute this software in source and
 * binary forms is hereby granted provided that the above copyright
 * notice and this permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions thereof.
 * Furthermore, any supporting documentation, advertising materials,
 * and all other materials related to such a distribution and use must
 * acknowledge that the software was developed by Akihiro Tominaga and
 * the WIDE Project. The names of the author and the WIDE Project may
 * not be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

struct dhcp_clienttype {
  u_char   client_id_type;
  u_char   client_id_len;
  char     *client_id_value;
  u_char   class_id_len;
  char     *class_id_value;
};


struct dhcp_reqspec {
  int    select_offer;       /* for getparam */
  int    ck_ipdup;           /* for getparam */
  int    wait_usec;          /* for getparam */
  int    lease;              /* for getparam, reuseparam, extend */
  int    extend_phase;       /* specify whether renewing or rebinding state */
  char   *dhcp_errmsg;       /* for release and decline */
  struct in_addr  ipaddr;    /* for reuseparam, verify, extend, release */
  struct in_addr  srvaddr;   /* for extend, release, decline */
};
#define DHCPOFFER_SELECT_FIRST   0   /* default */
#define DHCPOFFER_SELECT_LONG    1
#define DHCP_CHKADDR_ON          0   /* default */
#define DHCP_CHKADDR_OFF         1


struct dhcp_optlist {
  u_char  len;
  char    list[0xff];
};
#define dhcp_optlist_clr(LISTP)    bzero((LISTP), sizeof(struct dhcp_optlist))
#define dhcp_optlist_add(OPT, LISTP)\
{\
   if ((LISTP)->len < 0xff)\
     ((LISTP)->list)[((LISTP)->len)++] = (OPT);\
}


#define MAXTAGNUM     CLIENT_ID
#define OPTMAPSIZE    (MAXTAGNUM / 8 + 1)
struct dhcp_optmap {
  u_char bitmap[OPTMAPSIZE];
};

#define dhcp_optmap_isset(OPT, MAPP)\
  (((MAPP)->bitmap)[(OPT)/8] & (1<<((OPT)%8)))

extern int dhcp_log;          /* 0 means ON, 1 means OFF */
#define  dhcp_syslog_on()     (dhcp_log = 0)
#define  dhcp_syslog_off()    (dhcp_log = 1)
#define  Syslog               if (dhcp_log == 0) syslog


extern int dhcp_errno;
#define  SUCCESS      0          /* succeed */
#define  ENAK         1          /* got NAK */ 
#define  ENOREPLY     2          /* timeout before get any reply */
#define  EIPDUP       3		 /* there is already other host */	
#define  EMISC        4          /* some system-call/library function error */


struct chaddr {
  u_char htype,
         hlen;
  char   haddr[6];
};


struct netif_info {
  int fd;
  int rbufsize;
  char *rbuf;
};

struct dhcp_if {
  char name[sizeof "xir0"];
  struct chaddr haddr;
  struct dhcp_clienttype *cltype;
  struct netif_info *fordhcp;
  struct netif_info *forarp;
};


struct in_addrs {
  u_char num;
  struct in_addr  *addr;
};


struct shorts {
  u_char   num;
  u_short  *value;
};


struct dhcp_param {
  char    *sname,                 /* server host name */
          *file,                  /* boot file name */
          *hostname,              /* host name */
          *merit_dump,            /* merit dump file */
          *dns_domain,            /* DNS domain name */
          *root_path,             /* Root Path */
          *extensions_path,       /* Extensions Path */
          *nis_domain,            /* NIS domain name */
          *nb_scope,              /* NetBIOS scope */
          *errmsg;                /* Message option */
  u_int   ip_forward        :1,   /* boolean */
          nonlocal_srcroute :1,   /* boolean */
          all_subnet_local  :1,   /* boolean */
          mask_discover     :1,   /* boolean */
          mask_supplier     :1,   /* boolean */
          router_discover   :1,   /* boolean */
          trailer           :1,   /* boolean */
          ether_encap       :1,   /* boolean */
          keepalive_garba   :1,   /* boolean */
          nb_nodetype       :4;   /* NetBIOS node type */
#define BNODE 0x1
#define PNODE 0x2
#define MNODE 0x4
#define HNODE 0x8
  u_char  default_ip_ttl,      /* time to live (1 - 255) */
          default_tcp_ttl;
  u_short bootsize,            /* bootfile size in 16 bits */
          max_dgram_size,      /* max dgram reassembly */
          if_mtu;              /* interface mtu */
  long    time_offset;         /* 32 bits integer(network byte order)
				    offset from UTC */
  u_long  lease_origin,        /* time that begin the lease */
          lease_duration,      /* lease duration */
          dhcp_t1,
          dhcp_t2,
          mtu_aging_timeout,   /* unsigned 32 bits integer */
          arp_cache_timeout,
          keepalive_inter;
  struct shorts   *mtu_plateau_table;  /* array of 16 bits int */
  struct in_addr  ciaddr,
                  yiaddr,              /* IP address */
                  siaddr,              /* (tftp) server */
                  giaddr,
                  *server_id,          /* DHCP server identifier */
                  *subnet_mask,
                  *swap_server,
                  *brdcast_addr,
                  *router_solicit;
  struct in_addrs *router,
                  *time_server,
                  *name_server,
                  *dns_server,         /* DNS server */
                  *log_server,
                  *cookie_server,
                  *lpr_server,
                  *impress_server,
                  *rls_server,         /* Resource Location Server */
                  *policy_filter,   
                  *static_route,
                  *nis_server,
                  *ntp_server,
                  *nbn_server,         /* NetBIOS name server */
                  *nbdd_server,        /* NetBIOS dgram distrib server */
                  *xfont_server,       /* X font erver */
                  *xdisplay_manager;   /* X display manager */
};


/* get short/long with the word alignment handling */
#define   GETHS(PTR)  (*((u_char *)PTR)*256 + *(((u_char *)PTR)+1))
#define   GETHL(PTR)  (*((u_char *)PTR)*256*256*256 +\
		       *(((u_char *)PTR)+1)*256*256 +\
		       *(((u_char *)PTR)+2)*256 + *(((u_char *)PTR)+3))


/* function declaration */
struct dhcp_if *dhcp_init();
struct dhcp_param *dhcp_getparam();
struct dhcp_param *dhcp_reuseparam();
struct dhcp_param *dhcp_verify();
struct dhcp_param *dhcp_extend();
void  dhcp_release();
void  dhcp_decline();
