/*
 * Copyright (c) 1995 Akihiro Tominaga and the WIDE Project.
 * All rights reserved.
 *
 * Permission to use, copy and distribute this software in source and
 * binary forms is hereby granted provided that the above copyright
 * notice and this permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions thereof.
 * Furthermore, any supporting documentation, advertising materials,
 * and all other materials related to such a distribution and use must
 * acknowledge that the software was developed by Akihiro Tominaga and
 * the WIDE Project. The names of the author and the WIDE Project may
 * not be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <strings.h>
#include <fcntl.h>
#include <netdb.h>
#include <signal.h>
#include <errno.h>
#include <syslog.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#ifdef sun
#include <sys/stropts.h>
#endif
#include <net/if.h>
#ifdef sun
#include <net/nit.h>
#include <net/nit_if.h>
#include <net/nit_pf.h>
#include <net/packetfilt.h>
#endif
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <arpa/inet.h>

#include "dhcp.h"
#include "dhcpc.h"
#include "common.h"
#include "dhcpc_subr.h"

extern struct dhcp_param *_param;

int check_reply();

struct dhcp_param *verify_extend();


struct dhcp_param *
dhcp_verify(intf, optlist, reqspec, optmap)
  struct dhcp_if *intf;
  struct dhcp_optlist *optlist;
  struct dhcp_reqspec *reqspec;
  struct dhcp_optmap *optmap;
{
  time_t curr_epoch;
  struct dhcp_param *result;

  alarm(0);
  if (time(&curr_epoch) == -1) {
    Syslog(LOG_WARNING, "time() error in dhcp_verify: %m");
    dhcp_errno = EMISC;
    return(NULL);
  }

  /* make a skeleton of DHCPREQEUST */
  if (make_request(intf, optlist, reqspec, VERIFYING) != 0) {
    return(NULL);
  }

  reqspec->extend_phase = 0;
  sndmsg.dhcp->secs = htons(curr_epoch - init_epoch);
  result = verify_extend(intf, reqspec, NULL, optmap);
  if (result != NULL) {
    if (_param != NULL) {
      clean_param(_param);
      free(_param);
    }
  }
  signal(SIGALRM, SIG_IGN);
  _param = result;

  return(_param);
}
