/*
 * Copyright (c) 1995 Akihiro Tominaga and the WIDE Project.
 * All rights reserved.
 *
 * Permission to use, copy and distribute this software in source and
 * binary forms is hereby granted provided that the above copyright
 * notice and this permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions thereof.
 * Furthermore, any supporting documentation, advertising materials,
 * and all other materials related to such a distribution and use must
 * acknowledge that the software was developed by Akihiro Tominaga and
 * the WIDE Project. The names of the author and the WIDE Project may
 * not be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

struct interface {
  int fd;
  char *rbuf;
  int rbufsize;
  struct if_info *ifinfo;
};

struct interface dhcpif;
struct interface arpif;

/*
 * following are included in dhcpc_subr.c
 */
int   initialize();
int   dhcp_decline();
int   dhcp_release();
int   clean_param();
int   merge_param();
int   dhcp_msgtoparam();
int   arp_check();
int   arp_reply();
int   *nvttostr();
int   send_unicast();
int   make_request();
char  *pickup_opt();
void  reset_if();
void  set_declinfo();
void  set_relinfo();
void  make_discover();

/*
 * flushroutes() is included in flushroute.c
 */
extern int  flushroutes();

/*
 * getmac() is included in getmac.c
 */
#if !defined(sony_news) && !defined(__FreeBSD__) && !defined(__osf__)
extern int  getmac();
#endif
