/* $Header: /vol/dwb/src/mumail-2.4b/RCS/config.h,v 1.2 1994/03/31 17:58:48 dwb Exp $ */
/*
 * $Log: config.h,v $
 * Revision 1.2  1994/03/31  17:58:48  dwb
 *  MuMail 2.4 Beta
 *
 * Revision 1.1  1993/11/15  18:52:44  dwb
 * Initial revision
 *
 *
 */

/*---------------------------------------------------------------------------+
| This file is part of Mumail, 
| Copyright (c) 1992-1993 by Muhammad M. Saggaf.
| Copyright (c) 1994 by David W. Boyd. All rights reserved
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------+
| Doesn't this config file look pretty? It does! I stole err... `borrowed'
| this comment style from Joaquim Jorge <jorgej@cs.rpi.edu>.
+---------------------------------------------------------------------------*/

#ifndef MUMAIL_CONFIG_H
#define MUMAIL_CONFIG_H

/*---------------------------------------------------------------------------+
| Leave these alone
+---------------------------------------------------------------------------*/

#define YES  1
#define Yes  YES
#define yes  YES
#define NO   0
#define No   NO
#define no   NO

/*---------------------------------------------------------------------------+
| Whether your system has the strstr library function.
+---------------------------------------------------------------------------*/

#define HAVE_STRSTR           YES

/*---------------------------------------------------------------------------+
| Whether your system's strstr is slow. If so, Mumail will use its own 
| strstr. This affects mainly folder loading time. It's reported that 
| strstr on Suns is slow. Also, on linux using Mumail's strstr instead
| of the system's decreases folder loading time a bit. You might try both
| versions. The only file you'll have to recompile is MuGeneric.c.
+---------------------------------------------------------------------------*/

#define HAVE_SLOW_STRSTR      YES

#define HAVE_STRCASECMP       YES

/*---------------------------------------------------------------------------+
| Whether your system has the strerror library function.
+---------------------------------------------------------------------------*/

#define HAVE_STRERROR         NO

/*---------------------------------------------------------------------------+
| Whether your system has the stdarg variable argument convention
+---------------------------------------------------------------------------*/

#define HAVE_STDARG           NO

/*---------------------------------------------------------------------------+
| Whether your system has the strftime library function.
+---------------------------------------------------------------------------*/

#define HAVE_STRFTIME         YES

/*---------------------------------------------------------------------------+
| Whether your system has the truncate(2) system function.
+---------------------------------------------------------------------------*/

#define HAVE_TRUNCATE         YES

/*---------------------------------------------------------------------------+
| Whether you want to compile and use the File Chooser, which allows
| you to pick folders by clicking on them rather than typing their
| names. I cannot think of any reason why you don't wan to compile it
| other than if you have trouble with its compilation. In this case,
| you can take it out by simply changing YES below to NO.
+---------------------------------------------------------------------------*/

#define USE_FILE_CHOOSER      YES

/*---------------------------------------------------------------------------+
| Whether your system have regexp or not. This is only needed for the 
| file chooser. If you set this to NO, regex will be used instead. 
| Note: If your system has the include file regexp.h, you have regexp. 
| If your system has regex.h, you have regex.
+---------------------------------------------------------------------------*/

#define HAVE_REGEXP           YES

/*---------------------------------------------------------------------------+
| Leave those alone for the time being, I'll explain them some more in
| the next version. Just a short note, you might want to set the latter
| one to YES if you want the globbing feature enabled in the file chooser.
+---------------------------------------------------------------------------*/

#define USE_REG_IN_FC         YES
#define USE_GLOB_IN_FC        NO

/*---------------------------------------------------------------------------+
| Whether you want Mumail to have a pretty 3D look. The only reason
| you wouldn't want that is if you're unable to compile the frame
| widget. In this this case, disable this option. Otherwise, you must
| really have a poor taste :-) or have a monochrome monitor. The frames
| are invisible on a monochrome monitor, but they might be visible on
| on a grey-scale one.
+---------------------------------------------------------------------------*/

#define USE_3D_FRAME          YES

/*---------------------------------------------------------------------------+
| Your mail delivery agent (sendmail) program.
+---------------------------------------------------------------------------*/

/* moved to the resources */

/*---------------------------------------------------------------------------+
| The external editor (not necessary since Mumail has its own (very good?)
| editor). I like to use Emacs sometimes without starting a new window, so
| my external program is emacsclient. Refer to Emacs' FAQ to learn how to 
| use emacsclient (in a nutshell, type ``M-x server-start'' in an existing
| Emacs' window, then invoke emacsclient from outside, like from Mumail).
+---------------------------------------------------------------------------*/

/* moved to the resources */

#ifdef CRAY
/* I'd like to know about this! :-) */
#endif

/*---------------------------------------------------------------------------+
| Leave those alone.
+---------------------------------------------------------------------------*/

#ifndef IN_IMAKEFILE

#if !HAVE_STRSTR
extern char* strstr();
#endif

#if !HAVE_STRCASECMP
extern int strcasecmp();
extern int strncasecmp();
#endif

#if !HAVE_STRERROR
#ifdef __STDC
extern char* strerror(int err);
#else
extern char* strerror();
#endif
#endif

#if !HAVE_STRFTIME
extern char* strftime();
#endif

#if !HAVE_TRUNCATE
extern int truncate();
#endif

#endif /* IN_IMAKEFILE */

#endif /* MUMAIL_CONFIG_H */
